---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: Поставщик шаблонов
  icon: pattern_provider
  position: 210
categories:
- devices
item_ids:
- ae2:pattern_provider
- ae2:cable_pattern_provider
---

# Поставщик шаблонов

<Row gap="20">
<BlockImage id="pattern_provider" scale="8" />
<BlockImage id="pattern_provider" p:push_direction="up" scale="8" />
<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/blocks/cable_pattern_provider.snbt" />
</GameScene>
</Row>

Поставщики шаблонов - это основной способ взаимодействия вашей системы [автокрафта](../ae2-mechanics/autocrafting.md) с миром. Они подталкивают ингредиенты в
свои [шаблоны](patterns.md) в соседние инвентари, и в них можно вставлять предметы, чтобы включить их в сеть. Часто
канал можно сэкономить, направив выход машины обратно в соседний поставщик паттернов (часто тот, который вытолкнул ингредиенты)
вместо того, чтобы использовать <ItemLink id="import_bus" /> для втягивания выхода машины в сеть.

Следует отметить, что, поскольку они берут ингредиенты непосредственно из [хранилища крафта](crafting_cpu_multiblock.md#crafting-storage) в процессе крафта, они никогда не содержат ингредиенты в своем инвентаре.
никогда не содержат ингредиенты в своем инвентаре, поэтому вы не можете получить их из них. Необходимо, чтобы поставщик переместил
в другой инвентарь (например, в бочку), а затем передавать ингредиенты из него.

Поставщики шаблонов имеют особое взаимодействие с интерфейсами [подсетей](../ae2-mechanics/subnetworks.md): если интерфейс не модифицирован (в слотах запроса ничего нет)
поставщик полностью пропустит интерфейс и направит его непосредственно в [хранилище](../ae2-mechanics/import-export-storage.md) этой подсети,
Пропуская интерфейс и не заполняя его партиями рецептов, и, что более важно, не вставляя следующую партию до тех пор, пока не освободится место в хранилище.

Поддерживается параллельная работа нескольких поставщиков шаблонов с одинаковыми шаблонами.

Поставщики шаблонов будут пытаться распределять свои партии по всем лицам, таким образом, параллельно используя все подключенные машины

## Варианты

Поставщики бывают трех вариантов: нормальные, направленные и плоские/[подчсти](../ae2-mechanics/cable-subparts.md). Это влияет на то, в какие стороны они будут толкать
ингредиенты, получать от них предметы и обеспечивать сетевое соединение.

* Обычные поставщики передают ингредиенты во все стороны, получают предметы со всех сторон и, как и большинство машин AE2, действуют как кабель, обеспечивающий сетевое соединение со всеми сторонами.
    как кабель, обеспечивающий сетевое соединение со всеми сторонами.

* Направленные поставщики деталей создаются с помощью <ItemLink id="certus_quartz_wrench" /> на обычном поставщике деталей, чтобы изменить его направление.
    направление. Они подают компоненты только на выбранную сторону, принимают входные сигналы со всех сторон и специально не обеспечивают сетевого
    подключение к сети на выбранной стороне. Это позволяет им толкать к машинам AE2 без подключения к сети, если вы хотите сделать подсеть.

* Плоские поставщики представляют собой [кабельную подчасть](../ae2-mechanics/cable-subparts.md), и поэтому их можно разместить несколько на одном кабеле, что позволяет создавать компактные установки.
    Они действуют аналогично выбранной стороне на поставщике направленных шаблонов, предоставляя шаблоны, принимая входные сигналы и **не** обеспечивая сетевое подключение.
    не обеспечивают сетевого подключения.

Поставщики шаблонов можно менять местами с обычными на плоские.

## Настройки

Поставщики шаблонов имеют различные режимы работы:

* **Режим блокировки** не позволяет поставщику проталкивать новую партию ингредиентов, если в машине уже есть
    если в машине уже есть ингредиенты.
* **Режим блокировки** может заблокировать поставщика при различных условиях использования красного камня или до тех пор, пока результат
    пока результат предыдущего крафта не будет вставлен в данный конкретный поставщик.
* Поставщик может быть показан или скрыт на <ItemLink id="pattern_access_terminal" />.

## Приоритет

Приоритеты могут быть установлены нажатием на гаечный ключ в правом верхнем углу графического интерфейса. В случае наличия нескольких [шаблонов](patterns.md)
для одного и того же элемента, поставщики шаблонов с более высоким приоритетом будут использоваться вместо поставщиков шаблонов с более низким приоритетом,
за исключением случаев, когда в сети отсутствуют компоненты для шаблона с более высоким приоритетом.

## Рецепты

<RecipeFor id="pattern_provider" />

<RecipeFor id="cable_pattern_provider" />
