---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: МЭ шина хранения
  icon: storage_bus
  position: 220
categories:
- devices
item_ids:
- ae2:storage_bus
---

# Шина хранения
<GameScene zoom="8" background="transparent">
<ImportStructure src="../assets/blocks/storage_bus.snbt" />
</GameScene>

Вы когда-нибудь хотели *сохранить* свой монстр-сундук вместо того, чтобы заменить его на что-то разумное? Представляем вашему вниманию шину хранения!

Шина хранения превращает инвентарь, к которому она прикасается, в [хранилище сети](../ae2-mechanics/import-export-storage.md).
Для этого сеть видит содержимое этого хранилища, а также получает и извлекает из него данные
для выполнения [устройствами](../ae2-mechanics/devices.md) операций по загрузке и выгрузке из сетевого хранилища.

В связи с тем, что в AE2 используется философия возникающей механики через взаимодействие функций [устройств](../ae2-mechanics/devices.md), вам не
обязательно использовать шину для хранения данных. Используя [подсети](../ae2-mechanics/subnetworks.md)
чтобы сделать шину хранения (или несколько шин хранения) *единственным* хранилищем в сети, вы можете использовать ее в качестве источника или направления
для передачи элементов. (см. ["подсети"](../example-setups/pipe-subnet.md))

Это [кабельная подчасть](../ae2-mechanics/cable-subparts.md).

## Фильтрация

По умолчанию шина будет хранить все. Элементы, вставленные в слоты фильтра, будут действовать как белый список, позволяя хранить только
разрешая хранить только эти конкретные элементы. У шины много слотов, поэтому ее можно использовать как большой фильтр, если вы используете ее для
переноса предметов.

Предметы можно перетаскивать в слоты из JEI/REI, даже если у вас на самом деле нет ни одного такого предмета.

## Приоритет

Приоритеты могут быть установлены нажатием на гаечный ключ в правом верхнем углу графического интерфейса.
Объекты, входящие в сеть, будут начинаться с хранилища с наивысшим приоритетом в качестве
первым пунктом назначения. В случае если два хранилища имеют одинаковый приоритет,
если в одном из них уже находится элемент, то он предпочтет это хранилище любому другому.
другому. Любые отфильтрованные хранилища будут рассматриваться как уже содержащие данный элемент
если они находятся в той же группе приоритетов, что и другие хранилища. Элементы, удаляемые из хранилища, будут
будут удаляться из хранилища с наименьшим приоритетом. Такая система приоритетов означает, что при вставке и удалении элементов
из сетевого хранилища, хранилища с более высоким приоритетом будут заполняться, а хранилища с более низким приоритетом - опустошаться.

## Настройки

* Шина может быть разделена (отфильтрована) на то, что в данный момент находится в соседнем инвентаре
* Сети может быть запрещено или разрешено видеть в соседнем инвентаре предметы, которые шина не может извлечь.
    (например, шина хранения не может извлекать элементы из среднего входного слота <ItemLink id="inscriber" />)
* Шина может фильтровать как вставку и извлечение, так и только вставку.
* Шина может быть двунаправленной, только для вставки или только для извлечения.

## Улучшения

Шина хранения поддерживает следующие [улучшения](upgrade_cards.md):

* <ItemLink id="capacity_card" /> увеличивает количество слотов для фильтров.
* <ItemLink id="fuzzy_card" /> позволяет шине фильтровать по уровню урона и/или игнорировать NBT предметов
* <ItemLink id="inverter_card" /> переключает фильтр с белого списка на черный
* <ItemLink id="void_card" /> аннулирует вложенные предметы, если инвентарь переполнен. Будьте осторожны при разбиении!

## Рецепт

<RecipeFor id="storage_bus" />
