---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: Энергия
  icon: energy_cell
---

# Энергия

Для работы вашей сети требуется энергия. В сетях имеется запас энергии, который [устройства](../ae2-mechanics/devices.md) напрямую берут из, и
<ItemLink id="vibration_chamber" />, <ItemLink id="energy_acceptor" /> (и <ItemLink id="controller" />) дополняют. Вы можете
посмотреть энергетическую статистику сети, щелкнув ПКМ в любом ее месте с помощью <ItemLink id="network_tool" /> или щелкнув ПКМ по контроллеру сети, если таковой имеется. Такое хранение и распределение энергии по сети означает, что
нет ограничений на скорость передачи энергии, поэтому устройства могут потреблять произвольно большое количество энергии, а 
приемники энергии могут принимать энергию с функционально неограниченной скоростью, ограниченной только объемом хранилища энергии.

## Прием энергии

<Row>
  <BlockImage id="energy_acceptor" scale="4" />

  <GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/blocks/cable_energy_acceptor.snbt" />
  </GameScene>

  <BlockImage id="controller" p:state="online" scale="4" />

  <BlockImage id="vibration_chamber" p:active="true" scale="4" />
</Row>

AE2 не использует энергию Forge Energy (на Forge) или TechReborn Energy (на Fabric) для внутренних целей. Вместо этого она преобразует их в
свою собственную единицу измерения, AE. Это преобразование является односторонним. Энергия может быть преобразована <ItemLink id="energy_acceptor" /> и
<ItemLink id="controller" />, хотя грани контроллера лучше использовать для большего количества [каналов](../ae2-mechanics/channels.md).
Он также может быть сгенерирован <ItemLink id="vibration_chamber" />, но AE2 предназначен
для использования с другими техническими модами, которые лучше генерируют энергию.

Все это означает, что при создании инфраструктуры энергораспределения базы лучше всего рассматривать сеть AE2 как одну большую многоблочную структуру. 

Коэффициенты для преобразования Forge Energy и Techreborn Energy составляют

*   2 FE = 1 AE (Forge)
*   1 E  = 2 AE (Fabric)

## Хранение энергии

<Row>
  <BlockImage id="energy_cell" scale="4" p:fullness="4" />

  <BlockImage id="dense_energy_cell" scale="4" p:fullness="4" />

  <BlockImage id="creative_energy_cell" scale="4" />
</Row>

По достаточно очевидным причинам сеть не может получать или расходовать в игровом процессе больше энергии, чем она может накопить. Если сеть
может хранить только 800 АЕ, то когда ее [устройства](../ae2-mechanics/devices.md) запрашивают энергию, они смогут использовать только до 800 АЕ (при условии, что хранилище заполнено)
а устройство, принимающее энергию, сможет передать в сеть не более 800 АЕ (при условии, что хранилище пусто).

Это частая причина странного поведения, когда человек создает небольшую сеть, состоящую только из приемника энергии, накопителя, терминала и
некоторыми устройствами и пытается сбросить в сеть булыжник из своего инвентаря. Загрузка этого булыжника за один раз
требует больше энергии, чем есть в сети, поэтому не все булыжники будут загружены, энергия в сети закончится
и сеть перезагружается.

**Эта проблема может быть решена путем добавления энергетических элементов.**

Сети поставляются с бесплатным буфером энергии на 800 АЕ.

<ItemLink id="controller" /> имеют небольшой запас внутренней энергии, 8 000 АЕ

<ItemLink id="energy_cell" /> может хранить 200 тыс. AE, и для большинства случаев достаточно одного, который легко справится со скачками напряжения
при обычном использовании сети.

<ItemLink id="dense_energy_cell" /> может хранить 1,6 М АЕ и используется в тех случаях, когда необходимо обеспечить работу сети за счет накопленной энергии или
для работы с огромным мгновенным потреблением энергии большими [пространственным хранилищем](spatial-io.md).

<ItemLink id="creative_energy_cell" /> это креативный предмет для тестирования, предоставляющий НЕОГРАНИЧЕННОЕ КОЛИЧЕСТВО ЭНЕРГИИ или что-то в этом роде.
