---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: Автокрафт
  icon: pattern_provider
---

# Автокрафт

### Большой

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/autocraft_setup_greebles.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Автокрафт - одна из основных функций AE2. Вместо того чтобы вручную изготавливать нужное количество каждого суб-ингредиента
и вкалывать, как какой-то *плебей*, вы можете попросить вашу МЭ-систему сделать это за вас. Или автоматически создавать предметы и экспортировать их куда-то.
Или автоматически поддерживать определенное количество предметов на складе за счет умного поведения. Это также работает с жидкостями, и, если у вас есть
некоторые дополнения для создания дополнительных типов материалов, таких как газы меканизма, то и с этими материалами они прекрасно работают. Это очень здорово.

Это довольно сложная тема, так что присоединяйтесь и поехали.

Установка автокрафта состоит из трех элементов: предмета, посылающего запрос на крафтинг, процессора крафтинга и устройства <ItemLink id="pattern_provider" />.

1.  Нечто создает запрос на крафт. Это можете быть вы в терминале, щелкающие на что-то, что может быть создано автокрафтом,
или шина экспорта, или интерфейс с картой изготовления, запрашивающий один из предметов, настроенных на экспорт/склад.

*   (**ВАЖНО:** используйте все, что у вас привязано к "подбор блока" (обычно это СКМ), чтобы запросить крафты того, что у вас уже есть на складе; это может конфликтовать с модами сортировки инвентаря)

2.  МЭ система рассчитывает требуемые ингредиенты и необходимые шаги для выполнения запроса и сохраняет их в процессоре автокрафта.

3.  <ItemLink id="pattern_provider" /> с соответствующим [шаблоном](../items-blocks-machines/patterns.md) перемещает ингредиенты, указанные в шаблоне, в любой соседний инвентарь.
В случае использования шаблона крафта ("шаблон крафта") это будет шаблон под <ItemLink id="molecular_assembler" />.
    В случае рецепта, не относящегося к созданию ("шаблон обработки"), это будет какой-либо другой блок, механизм или сложная установка, управляемая редстоуном.

4.  Результат работы возвращается в систему тем или иным способом, будь то шина импорта, интерфейс или заталкивание результата в поставщик шаблона.
    **Обратите внимание, что предмет должен попасть в систему, вы не можете просто передать результат в сундук с <ItemLink id="storage_bus" /> на нём.**

5.  Если этот крафт является необходимым условием для другого крафта в запросе, то предметы хранятся в процессоре и затем используются при самом создании.

# Шаблоны

<ItemImage id="crafting_pattern" scale="4" />

Шаблоны создаются в <ItemLink id="pattern_encoding_terminal" /> из пустых шаблонов.

Существует несколько различных типов шаблонов для разных вещей:

*   <ItemLink id="crafting_pattern" /> кодируют рецепты, созданные таблицей крафта. Они могут быть помещены непосредственно в <ItemLink id="molecular_assembler" /> чтобы он начал создавать продукт, 
когда ему даны ингредиенты, но в основном они используются в <ItemLink id="pattern_provider" /> рядом с молекулярным сборщиком.
    В этом случае интерфейсы ведут себя особым образом и передают соответствующий шаблон вместе с ингредиентами соседним сборщикам.
    Поскольку сборщики автоматически выбрасывают результаты крафта в соседние инвентари, то для автоматизации создания шаблонов достаточно иметь сборщик на МЭ интерфейсе.

***

*   <ItemLink id="smithing_table_pattern" /> очень похожи на шаблоны крафта, но в них закодированы рецепты кузнечной таблицы. Они также автоматизированы МЭ интерфейсом и молекулярным сборщиком и функционируют точно так же.
    Фактически, шаблоны крафта, кузнечного дела и камнерезного дела могут быть
использованы в одной и той же установке.

***

*   <ItemLink id="stonecutting_pattern" /> очень похожи на шаблоны крафта, но в них закодированы рецепты камнерезов. Они также автоматизированы 
интерфейсом и молекулярным сборщиком и функционируют точно так же. Фактически, в одной установке могут быть использованы схемы крафта, кузнечного и камнерезного производства

***

*   <ItemLink id="processing_pattern" /> - вот откуда берется большая гибкость в автокрафте. Они являются наиболее обобщенным типом, 
говорящим: "Если МЭ интерфейс помещает эти ингредиенты в соседние хранилища, то система МЭ получит их в какой-то момент времени
    ближайшем или отдаленном будущем". С их помощью вы будете автокрафтить практически любые модифицированные механизмы, печи и т.п. Поскольку они имеют 
общее назначение и не заботятся о том, что происходит между вводом ингредиентов и получением результата, вы можете делать очень забавные вещи, например, 
вводить ингредиенты в целую сложную производственную цепочку, которая будет сортировать материал, получать другие ингредиенты из бесконечно производимых, 
МЭ-систему не волнует, пока она получает результат, указанный в шаблоне. На самом деле, ей даже неважно, имеют ли ингредиенты какое-либо отношение к результату. 
Вы можете сказать ей: "1 доска вишневого дерева = 1 звезда незера" и получить ферма визеров убивает визера при получении вишневых досок, и это сработает.

Несколько <ItemLink id="pattern_provider" /> с идентичными шаблонами поддерживаются и работают параллельно. Кроме того, в шаблоне может быть указано,
например, 8 булыжника = 8 камней вместо 1 булыжника = 1 камень, и поставщик будет вставлять 8 булыжников в
плавильную установку каждую операцию.

## Наиболее общая форма понятия " шаблон"

На самом деле существует еще более "общая" форма " шаблона", чем шаблон обработки. Карта <ItemLink id="level_emitter" /> с картой изготовления может быть настроена на испускание 
сигнала красного камня, чтобы изготовить что-либо.
Этот "шаблон" не определяет ингредиенты и даже не заботится о них.
Все, что там написано, это "Если вы излучаете красный камень с этого излучателя уровня, то МЭ система получит этот предмет в какой-то момент в
ближайшем или отдаленном будущем". Обычно это используется для активации и деактивации бесконечных ферм, которые не требуют ввода ингредиентов,
или для активации системы, обрабатывающей рецепты с рекурсией (которые стандартный автокафт не понимает), например, "1 булыжник = 2 булыжника".
если у вас есть механизм, дублирующий булыжник.

# Процессор крафта

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/crafting_cpus.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Процессоры крафта управляют запросами/заданиями на крафт. Они хранят промежуточные ингредиенты, пока выполняются многоэтапные задачи по изготовлению предметов
и влияют на то, насколько большими могут быть эти задачи и, в некоторой степени, на скорость их выполнения. Они являются многоблочными и
должны быть в виде прямоугольной призмы.

Из чего состоят процессоры крафта:

*   [Хранилища для изготовления](../items-blocks-machines/crafting_cpu_multiblock.md), выпускаются во всех стандартных размерах ячеек (1k, 4k, 16k, 64k, 256k). В них хранятся ингредиенты и
промежуточные ингредиенты, участвующие в процессе изготовления, поэтому для того, чтобы процессор мог обрабатывать задачи 
изготовления с большим количеством ингредиентов, требуется более емкое или более объемное хранилище
*   <ItemLink id="crafting_accelerator" />, они заставляют систему отправлять больше партий ингредиентов от МЭ интерфейса.
Это позволит, например, интерфейсу, окруженному 6 молекулярными сборщиками, отправлять ингредиенты (и, соответственно, использовать) не одному, а сразу всем 6.
*   <ItemLink id="crafting_monitor" />, отображает задачу, которую выполняет процессор в данный момент. Они могут быть раскрашены с помощью функции <ItemLink id="color_applicator" />
*   <ItemLink id="crafting_unit" />, они просто заполняют пространство, чтобы сделать процессор прямоугольной призмой.

Каждый процессор крафта обрабатывает 1 запрос или задачу, поэтому если вы хотите запросить одновременно вычислительный процессор и 256 гладких камней, вам потребуется 2 процессорных мультиблока.

Они могут быть настроены на обработку запросов от игроков, автоматики (экспортных шин и интерфейсов) или того и другого.

# Поставщик шаблонов

<Row>
<BlockImage id="pattern_provider" scale="4" />

<BlockImage id="pattern_provider" p:push_direction="up" scale="4" />

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/blocks/cable_pattern_provider.snbt" />
</GameScene>
</Row>

<ItemLink id="pattern_provider" /> являются основным способом взаимодействия системы автокрафта с миром. Они перемещают ингредиенты в
свои [шаблоны](../items-blocks-machines/patterns.md) и соседние инвентари, и в них можно вставлять предметы, чтобы включить их в сеть. Часто
можно сэкономить канал, направив выход машины обратно в соседний интерфейс (часто в тот, который подталкивал ингредиенты)
вместо того чтобы использовать <ItemLink id="import_bus" />.

Следует отметить, что поскольку они получают ингредиенты непосредственно из [хранилища крафта](../items-blocks-machines/crafting_cpu_multiblock.md#crafting-storage) в процессоре крафта, они никогда не содержат ингредиенты в инвентаре, поэтому их нельзя выдать. Необходимо, чтобы интерфейс переместил
в другой инвентарь (например, в бочку), а затем передавать ингредиенты из него.

Также следует отметить, что интерфейс должен выводить ВСЕ ингредиенты сразу, он не может выводить половинные партии. Это полезно
для использования.

Поставщики шаблонов имеют особое взаимодействие с интерфейсами в [подсетей](../ae2-mechanics/subnetworks.md): если интерфейс не модифицирован (в слотах запроса ничего нет)
поставщик полностью пропустит интерфейс и направит его непосредственно в [хранилище](../ae2-mechanics/import-export-storage.md),
пропуская интерфейс и не заполняя его партиями рецептов, и, что более важно, не вставляя следующую партию, пока не освободится место в хранилище.

Поддерживается параллельная работа нескольких интерфейсов с идентичными шаблонами.

Интерфейсы будут пытаться распределять свои партии по всем лицам, тем самым параллельно используя все подключенные механизмы.

## Варианты

Интерфейсы бывают трех видов: обычные, направленные и плоские. Это влияет на то, с какой стороны они будут толкать
ингредиенты, получать от них предметы и обеспечивать сетевое соединение.

*   Обычные интерфейсы рассылают ингредиенты во все стороны, принимают входные сигналы со всех сторон и, как большинство машин AE2, действуют как кабель, обеспечивающий подключение к сети со всех сторон.

*   Интерфейсы направленного действия изготавливаются с использованием <ItemLink id="certus_quartz_wrench" /> на обычный интерфейс, чтобы изменить его
    направление. Они только проталкивают ингредиенты на выбранную сторону, принимают входные данные со всех сторон и специально не обеспечивают сетевого
    подключение к сети на выбранной стороне. Это позволяет им толкать к машинам AE2 без подключения к сети, если вы хотите сделать подсеть.

*   Плоские интерфейсы - это [кабельная подчасть](../ae2-mechanics/cable-subparts.md), aпоэтому на одном кабеле можно разместить несколько устройств, что позволяет создавать компактные установки.
    Они действуют аналогично выбранной стороне на интерфейсе, предоставляя шаблоны, принимая входные данные и не
    обеспечивая сетевое соединение на своей стороне.

Интерфейсы могут меняться местами между обычными и плоскими в сетке для создания шаблонов.

## Настройки

Интерфейсы имеют различные режимы:

*   Режим **Блокировка** не позволяет интерфейсу проталкивать новую партию ингредиентов, если в механизме уже имеются
    ингредиенты.
*   **Заключение** может заблокировать интерфейс при различных условиях использования красного камня или до тех пор, пока результат
     предыдущего крафта не будет вставлен в данный конкретный интерфейс.
*   Интерфейс может быть показан или скрыт на <ItemLink id="pattern_access_terminal" />.

## Приоритет

Приоритеты можно нстроить, нажав на гаечный ключ в правом верхнем углу графического интерфейса. В случае использования нескольких [шаблонов](../items-blocks-machines/patterns.md)
для одного и того же изделия шаблоны интерфейсов с более высоким приоритетом будут использоваться чаще, чем шаблоны интерфейсов с более низким приоритетом,
за исключением случаев, когда в сети отсутствуют компоненты для шаблонов с более высоким приоритетом.

# Молекулярные сборщики

<BlockImage id="molecular_assembler" scale="4" />

<ItemLink id="molecular_assembler" /> принимает вводимые в него элементы и выполняет операцию, заданную соседним элементом <ItemLink id="pattern_provider" />,
или вставленным <ItemLink id="crafting_pattern" />, <ItemLink id="smithing_table_pattern" />, или <ItemLink id="stonecutting_pattern" />,
затем перемещает результат в соседние инвентари.

Основное их использование - рядом с <ItemLink id="pattern_provider" />. Интерфейсы имеют особое поведение в этом случае,
и будут посылать информацию о соответствующем шаблоне вместе с ингредиентами соседним сборщикам. Поскольку сборщики автоматически выбрасывают результаты
крафта в соседние инвентари (и, соответственно, в слоты возврата интерфейса), то для автоматизации создания деталей достаточно иметь сборщик на интерфейсе
это все, что необходимо для автоматизации создания новых предметов.

<GameScene zoom="4" background="transparent">
<ImportStructure src="../assets/assemblies/assembler_tower.snbt" />
<IsometricCamera yaw="195" pitch="30" />
</GameScene>