---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: Импорт, экспорт и хранение
---

# Импорт, экспорт и хранение

**Ваша МЭ система и мир**

Важным понятием в AE2 является идея сетевого хранилища. Это место, в котором хранится содержимое сети,
обычно [ячейки хранения](../items-blocks-machines/storage_cells.md) или любой инвентарь, к которому подключена <ItemLink id="storage_bus" />. 
Большинство AE2 [устройств](../ae2-mechanics/devices.md) так или иначе взаимодействуют с ним.

Например,

*   <ItemLink id="import_bus" /> перемещают в хранилища
*   <ItemLink id="export_bus" /> извлекают из хранилища
*   <ItemLink id="interface" /> перемещают как из хранилища, так и в хранилище
*   [Терминалы](../items-blocks-machines/terminals.md) как при вставке или извлечении предметов, так и при пополнении слотов для крафта, происходит загрузка и выгрузка данных из сетевого хранилища
*   <ItemLink id="storage_bus" /> на самом деле не толкают или тянут из хранилища, они толкают или тянут из подключенного инвентаря
    чтобы использовать его в качестве сетевого хранилища (поэтому на самом деле другие устройства обращаются к нему или извлекают из него)

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/import_export_storage.snbt" />

  <BoxAnnotation color="#dddddd" min="8 1 1" max="9 1.3 2">
        Шины импорта переносят вещи из инвентаря, на который они указывают, в сетевое хранилище
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="8 2 1" max="9 3 1.3">
        Размещение чего-либо в терминале из инвентаря считается импортом в сеть
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="7 0 1" max="8 1 2">
       Интерфейсы будут импортировать из своих внутренних запасов, если этот слот не настроен на хранение чего-либо, или в этом слоте
        находится больше предметов, чем настроено для складирования, поэтому в него можно заталкивать предметы для размещения в сети
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="6 0 1" max="7 1 2">
        МЭ интерфейс импортирует из своего внутреннего инвентаря слоты возврата, поэтому в них можно заталкивать вещи для размещения в сети
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4 1 1" max="5 2 2">
        Накопители обеспечивают работу вставленных ячеек в качестве хранилища
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3 1 1" max="4 1.3 2">
        Шины хранения используют инвентарь, на который они указывают, в качестве хранилища
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 1 1" max="2 1.3 2">
        Шины экспорта отправляют вещи из хранилища в инвентарь, на который они указывают
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 2 1" max="2 3 1.3">
        Вытаскивание чего-либо из терминала считается экспортом в сеть
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 1 1" max="1 2 2">
        Интерфейсы будут экспортировать в свои внутренние хранилища, если этот слот настроен на хранение чего-либо,
        так что вещи могут быть извлечены из них для извлечения из сети
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Действия/события, связанные с загрузкой в сетевое хранилище и извлечением из него, важно учитывать при проектировании систем автоматизации
и логистических систем.

## Приоритет хранения

Приоритеты можно установить, нажав на гаечный ключ в правом верхнем углу некоторых графических интерфейсов.
Объекты, входящие в сеть, будут начинаться с хранилища с наивысшим приоритетом, как с первого места назначения.
в случае, если два хранилища имеют одинаковый приоритет,
если в одном из них уже содержится элемент, то он предпочтет это хранилище любому
другому. Любые ячейки, включенные в белый список, будут рассматриваться как уже содержащие данный элемент
если они находятся в той же группе приоритетов, что и другие хранилища. Элементы, удаляемые из хранилища,
будут удаляться из хранилища с наименьшим приоритетом. Такая система приоритетов означает, что при вставке и удалении элементов
из сетевого хранилища, хранилища с более высоким приоритетом будут заполняться, а хранилища с более низким приоритетом - опустошаться.
