---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: Терминалы
  icon: crafting_terminal
  position: 210
categories:
- devices
item_ids:
- ae2:terminal
- ae2:crafting_terminal
- ae2:pattern_encoding_terminal
- ae2:pattern_access_terminal
---

# Терминалы

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/terminals.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

В то время как <ItemLink id="pattern_provider" />, <ItemLink id="import_bus" />, <ItemLink id="storage_bus" /> и так далее представляют собой основной метод взаимодействия с миром сети AE2, терминалы - основной метод взаимодействия с вами. Существует несколько вариантов с различными функциями.

Терминалы наследуют цвет [кабеля](cables.md) на который они установлены.

Это [кабельная подчасть](../ae2-mechanics/cable-subparts.md).

## Размещение терминалов

Поскольку терминал часто является первой [подчастью](../ae2-mechanics/cable-subparts.md) которое кто-то может установить, часто бывает ошибкой установить терминал задом наперёд. Вот пример того, что нужно делать и чего не нужно делать:

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/terminal_placement.snbt" />
  <IsometricCamera yaw="195" pitch="30" />

  <LineAnnotation color="#ff3333" from="2.5 .5 .5" to="4.5 2.5 .5" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#ff3333" from="2.5 2.5 .5" to="4.5 .5 .5" alwaysOnTop={true} thickness="0.05"/>

  <LineAnnotation color="#33ff33" from="-.5 2.5 .5" to="1 .5 .5" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#33ff33" from="1 .5 .5" to="1.5 1 .5" alwaysOnTop={true} thickness="0.05"/>
</GameScene>

Теперь у вас по-прежнему есть терминал и приемщик энергии, за исключением того, что терминал развернут правильно и фактически подключен к сети, и всё это помещается в более компактное пространство.

<a name="terminal-ui"></a>

# Терминал

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

Ваш базовый терминал, который позволяет вам просматривать и получать доступ к содержимому [хранилища сети](../ae2-mechanics/import-export-storage.md)
и запрашивать предметы из вашей настройки [автокрафта](../ae2-mechanics/autocrafting.md).

## Пользовательский интерфейс

Пользовательский интерфейс базового терминала состоит из нескольких разделов

Центральная секция предоставляет доступ к сетевому хранилищу. В него можно помещать и извлекать различные предметы. Здесь есть несколько
сочетаний клавиш и кнопок мыши:

* Левая кнопка мыши захватывает стопку, правая - половину стопки.
* Если предмет, жидкость или т.п. может быть автоматически [создано](../ae2-mechanics/autocrafting.md),
    все, что вы привязали к "подбор блока" (обычно это средний клик), вызывает пользовательский интерфейс для указания количества, которое нужно создать.
* Удерживая shift, можно "заморозить" отображаемые предметы на месте, не позволяя им перестраиваться при изменении количества или появлении новых предметов.
* Щелчок правой кнопкой мыши по ведру или другому контейнеру с жидкостью приведет к появлению жидкости,
щелчок левой кнопкой мыши по жидкости в терминале приведет к ее изъятию.

В левой части расположены кнопки настроек:

* Сортировать по различным атрибутам, таким как название, мод и количество.
* Просмотр хранимых предметов, предметов, которые можно изготовить, или и тех, и других
* Просмотр предметов, жидкостей или того и другого.
* Изменить порядок сортировки
* Открыть окно подробных настроек терминала
* Изменить высоту пользовательского интерфейса терминала

Справа расположены слоты для <ItemLink id="view_cell" />

В правом верхнем углу центральной секции (кнопка с молотком) отображается статус [автокрафта](../ae2-mechanics/autocrafting.md),
пользовательский интерфейс, позволяющий видеть прогресс выполнения автокрафтов и работу каждого [процессора](crafting_cpu_multiblock.md).

## Рецепт

<RecipeFor id="terminal" />

<a name="crafting-terminal-ui"></a>

# Терминал изготовления

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/crafting_terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

Терминал изготовления аналогичен обычному терминалу со всеми теми же настройками и разделами, но с добавленной крафтовой сеткой, которая будет автоматически
пополняться из [хранилища сети](../ae2-mechanics/import-export-storage.md). Будьте осторожны при нажатии Shift+Клик на результат!

Рекомендуется как можно скорее улучшить ваш терминал до терминала изготовления.

## Пользовательский интерфейс

У терминала изготовления тот же интерфейс, что и у обычного терминала, но с добавленной крафтовой сеткой посередине.

Есть две дополнительные кнопки, чтобы очистить крафтовую сетку в хранилище сети или ваш инвентарь.

## Рецепт

<RecipeFor id="crafting_terminal" />

<a name="pattern-encoding-terminal-ui"></a>

# Терминал шаблонов

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/pattern_encoding_terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

Терминал шаблонов похож на обычный терминал, со всеми теми же настройками и разделами, но с добавленным интерфейсом
[шаблонов](patterns.md). Внешне он похож на пользовательский интерфейс терминала кодирования, но эта сетка кодирования на самом деле не выполняет
крафт.

В дополнение к терминалу крафта у вас должен быть один такой терминал.

## Пользовательский интерфейс

Терминал крафта имеет тот же пользовательский интерфейс, что и обычный терминал, и дополнен интерфейсом кодирования [шаблонов](patterns.md).

Интерфейс кодирования шаблонов состоит из нескольких секций:

Слот для вставки <ItemLink id="blank_pattern" />

Большая стрелка для кодирования шаблона.

Слот для кодированных шаблонов. Чтобы отредактировать уже закодированный шаблон, поместите его в этот слот и нажмите на стрелку "кодировать".

4 вкладки справа для переключения типа кодируемой детали

* Ремесло
* Обработка
* Кузнечное дело
* Камнерезное дело

Центральный пользовательский интерфейс меняется в зависимости от типа кодируемой детали:

* В режиме ремесла:
    * щелкните левой кнопкой мыши или перетащите из JEI/REI ингредиенты для формирования рецепта. Щелкните правой кнопкой мыши, чтобы удалить ингредиент.
    * Включение замены позволяет создавать палки из любого типа досок. Это следует использовать только
        только в случае крайней необходимости.
    * Замена жидкостей позволяет использовать хранящиеся жидкости вместо ведер с жидкостями.
    * Вы также можете напрямую кодировать деталь с экрана рецептов JEI/REI.

* В режиме обработки:
    * щелкните левой кнопкой мыши или правой кнопкой мыши на ингредиентах или перетащите их из JEI/REI, чтобы указать входы и выходы рецепта.
    * Если вы держите стопку, щелчок левой кнопкой мыши помещает всю стопку, щелчок правой кнопкой мыши помещает один элемент. Щелкните левой кнопкой мыши на существующем стеке ингредиентов, чтобы
        удаляет всю стопку, а щелчок правой кнопкой мыши уменьшает стопку на 1. То, что вы привязали к "блоку выбора" (обычно это средний щелчок)
        позволяет задать точное количество предмета или жидкости.
    * Слоты вывода содержат основной вывод и место для вторичных выводов, о которых может узнать алгоритм автосоздания.
    * Слоты ввода и вывода прокручиваются, поэтому можно иметь 81 различный ингредиент и 26 вторичных выходов.
    * Можно также напрямую кодировать шаблон с экрана рецептов JEI/REI.

* Пользовательские интерфейсы режимов кузнечного и камнерезного дела работают аналогично кузнечному столу и камнерезному станку соответственно.

## Рецепт

<RecipeFor id="pattern_encoding_terminal" />

<a name="pattern-access-terminal-ui"></a>

# Терминал интерфейсов

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/pattern_access_terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

Терминал интерфейсов служит для решения конкретной проблемы: в плотной башне из <ItemLink id="pattern_provider" />
и <ItemLink id="molecular_assembler" />, невозможно физически получить доступ к поставщикам, чтобы вставить новые шаблоны. Кроме того,
возможно, вы ленивы и не хотите идти через всю базу, чтобы вставить [шаблон](patterns.md). Терминал интерфейсов
позволяет получить доступ ко всем провайдерам шаблонов в сети.

## Интерфейс

Этот терминал имеет отличный от всех остальных терминалов пользовательский интерфейс.

В нем есть настройки высоты терминала и того, какие поставщики шаблонов показывать.

Поставщики шаблонов в терминале сортируются по тому, к каким блокам они подключены, или по тому, какое имя вы им присвоили (в наковальне или
с помощью <ItemLink id="name_press" />).

## Рецепт

<RecipeFor id="pattern_access_terminal" />