/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.offlineencryptor.velocity;

import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.crypto.EncryptionUtils;
import com.velocitypowered.proxy.protocol.packet.EncryptionRequestPacket;
import com.velocitypowered.proxy.protocol.packet.EncryptionResponsePacket;
import com.velocitypowered.proxy.protocol.packet.ServerLoginPacket;
import io.github.lumine1909.offlineencryptor.NetworkProcessor;
import io.github.lumine1909.offlineencryptor.PacketInterceptor;
import io.github.lumine1909.offlineencryptor.velocity.OfflineEncryptor;
import io.github.lumine1909.reflexion.Field;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class VelocityPacketInterceptor
extends PacketInterceptor<ServerLoginPacket, EncryptionResponsePacket> {
    private static final Field<Boolean> field$authenticate = Field.of(EncryptionRequestPacket.class, "shouldAuthenticate", Boolean.TYPE);
    private final MinecraftConnection connection;
    private byte[] verify;

    protected VelocityPacketInterceptor(Channel channel, NetworkProcessor<ServerLoginPacket> processor) {
        super(channel, processor);
        this.connection = (MinecraftConnection)channel.pipeline().get("handler");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ServerLoginPacket) {
            ServerLoginPacket packet = (ServerLoginPacket)msg;
            this.processC2SHello(ctx, packet);
        } else if (msg instanceof EncryptionResponsePacket) {
            EncryptionResponsePacket packet = (EncryptionResponsePacket)msg;
            this.processC2SResponse(ctx, packet);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    @Override
    protected void processC2SHello(ChannelHandlerContext ctx, ServerLoginPacket packet) {
        this.username = packet.getUsername();
        this.processor.getCache().put(this.username, packet);
        EncryptionRequestPacket request = this.generateEncryptionRequest();
        this.verify = Arrays.copyOf(request.getVerifyToken(), 4);
        this.connection.write((Object)request);
    }

    private EncryptionRequestPacket generateEncryptionRequest() {
        byte[] verify = new byte[4];
        ThreadLocalRandom.current().nextBytes(verify);
        EncryptionRequestPacket request = new EncryptionRequestPacket();
        request.setPublicKey(OfflineEncryptor.plugin.getServer().getServerKeyPair().getPublic().getEncoded());
        request.setVerifyToken(verify);
        field$authenticate.set(request, false);
        return request;
    }

    @Override
    protected void processC2SResponse(ChannelHandlerContext ctx, EncryptionResponsePacket packet) {
        try {
            KeyPair serverKeyPair = OfflineEncryptor.plugin.getServer().getServerKeyPair();
            byte[] decryptedVerifyToken = EncryptionUtils.decryptRsa((KeyPair)serverKeyPair, (byte[])packet.getVerifyToken());
            if (!MessageDigest.isEqual(this.verify, decryptedVerifyToken)) {
                throw new IllegalStateException("Unable to successfully decrypt the verification token.");
            }
            byte[] decryptedSharedSecret = EncryptionUtils.decryptRsa((KeyPair)serverKeyPair, (byte[])packet.getSharedSecret());
            this.connection.enableEncryption(decryptedSharedSecret);
            this.channel.eventLoop().schedule(() -> {
                this.processor.uninject(this.channel);
                ctx.fireChannelRead(this.processor.getCache().remove(this.username));
            }, 500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new IllegalStateException("Protocol error", e);
        }
    }
}

