/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.offlineencryptor;

import io.github.lumine1909.offlineencryptor.NetworkProcessor;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;

public abstract class PacketInterceptor<C2SHandshake, C2SHello, C2SResponse>
extends ChannelDuplexHandler {
    private static final int PROTOCOL_1_20_5 = 766;
    protected final Channel channel;
    protected final NetworkProcessor<C2SHello> processor;
    protected boolean enabled = true;
    protected String username;

    protected PacketInterceptor(Channel channel, NetworkProcessor<C2SHello> processor) {
        this.channel = channel;
        this.processor = processor;
    }

    protected boolean validateVersion(int protocolVersion) {
        if (protocolVersion < 766) {
            this.processor.uninject(this.channel);
            this.enabled = false;
            return false;
        }
        return true;
    }

    protected abstract void processC2SHandshake(ChannelHandlerContext var1, C2SHandshake var2);

    protected abstract void processC2SHello(ChannelHandlerContext var1, C2SHello var2);

    protected abstract void processC2SResponse(ChannelHandlerContext var1, C2SResponse var2);
}

