/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.offlineencryptor;

import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.UserConnection;
import io.github.lumine1909.reflexion.Field;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.Optional;

public interface ViaVersionUtil {
    public static ViaVersionUtil create(boolean isVelocity, boolean hasVia) {
        if (!hasVia) {
            return new Dummy();
        }
        if (isVelocity) {
            return new Velocity();
        }
        return new Paper();
    }

    default public int getProtocolVersion(Channel channel) {
        return this.getConnection(channel).map(UserConnection::getProtocolInfo).map(ProtocolInfo::getProtocolVersion).orElse(-1);
    }

    public Optional<UserConnection> getConnection(Channel var1);

    default public boolean hasVia() {
        return true;
    }

    public static class Dummy
    implements ViaVersionUtil {
        @Override
        public int getProtocolVersion(Channel channel) {
            return 0x66CCFF;
        }

        @Override
        public Optional<UserConnection> getConnection(Channel channel) {
            return Optional.empty();
        }

        @Override
        public boolean hasVia() {
            return false;
        }
    }

    public static class Velocity
    implements ViaVersionUtil {
        private final Field<UserConnection> field$UserConnection = Field.of("com.viaversion.viaversion.velocity.handlers.VelocityEncodeHandler", "info", UserConnection.class);

        @Override
        public Optional<UserConnection> getConnection(Channel channel) {
            ChannelHandler viaEncoder = channel.pipeline().get("via-encoder");
            try {
                return Optional.of(this.field$UserConnection.get(viaEncoder));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
    }

    public static class Paper
    implements ViaVersionUtil {
        private final Field<UserConnection> field$UserConnection = Field.of("com.viaversion.viaversion.bukkit.handlers.BukkitEncodeHandler", "connection", UserConnection.class);

        @Override
        public Optional<UserConnection> getConnection(Channel channel) {
            ChannelHandler viaEncoder = channel.pipeline().get("via-encoder");
            try {
                return Optional.of(this.field$UserConnection.get(viaEncoder));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
    }
}

