/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.offlineencryptor.paper;

import io.github.lumine1909.offlineencryptor.NetworkProcessor;
import io.github.lumine1909.offlineencryptor.PacketInterceptor;
import io.github.lumine1909.offlineencryptor.ViaVersionUtil;
import io.github.lumine1909.reflexion.Field;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.security.PrivateKey;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.crypto.SecretKey;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ClientboundHelloPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.util.CryptException;
import org.bukkit.Bukkit;

public class PaperPacketInterceptor
extends PacketInterceptor<ClientIntentionPacket, ServerboundHelloPacket, ServerboundKeyPacket> {
    private static final Field<byte[]> field$challenge = Field.of(ServerLoginPacketListenerImpl.class, "challenge", byte[].class);
    private static final Function<ServerLoginPacketListenerImpl, ClientboundHelloPacket> HELLO_PACKET_FACTORY = listener -> new ClientboundHelloPacket("", MinecraftServer.getServer().getKeyPair().getPublic().getEncoded(), field$challenge.get(listener), false);
    private static final MinecraftServer server = MinecraftServer.getServer();
    private static final ViaVersionUtil viaUtil = ViaVersionUtil.create(false, Bukkit.getPluginManager().getPlugin("ViaVersion") != null);
    private final Connection connection;

    protected PaperPacketInterceptor(Channel channel, NetworkProcessor<ServerboundHelloPacket> processor) {
        super(channel, processor);
        this.connection = (Connection)channel.pipeline().get("packet_handler");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ClientIntentionPacket packet;
        if (!this.enabled) {
            super.channelRead(ctx, msg);
            return;
        }
        if (msg instanceof ClientIntentionPacket) {
            packet = (ClientIntentionPacket)msg;
            this.processC2SHandshake(ctx, packet);
        }
        if (msg instanceof ServerboundHelloPacket) {
            packet = (ServerboundHelloPacket)msg;
            if (!this.validateVersion(viaUtil.getProtocolVersion(this.channel))) {
                super.channelRead(ctx, msg);
                return;
            }
            this.processC2SHello(ctx, (ServerboundHelloPacket)packet);
        } else if (msg instanceof ServerboundKeyPacket) {
            ServerboundKeyPacket packet2 = (ServerboundKeyPacket)msg;
            this.processC2SResponse(ctx, packet2);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    @Override
    protected void processC2SHandshake(ChannelHandlerContext ctx, ClientIntentionPacket packet) {
        if (!viaUtil.hasVia()) {
            this.validateVersion(packet.protocolVersion());
        }
    }

    @Override
    protected void processC2SHello(ChannelHandlerContext ctx, ServerboundHelloPacket packet) {
        this.username = packet.name();
        ServerLoginPacketListenerImpl login = (ServerLoginPacketListenerImpl)this.connection.getPacketListener();
        this.processor.getCache().put(this.username, packet);
        this.connection.send((Packet)HELLO_PACKET_FACTORY.apply(login));
    }

    @Override
    protected void processC2SResponse(ChannelHandlerContext ctx, ServerboundKeyPacket packet) {
        ServerLoginPacketListenerImpl login = (ServerLoginPacketListenerImpl)this.connection.getPacketListener();
        try {
            PrivateKey privateKey = server.getKeyPair().getPrivate();
            if (!packet.isChallengeValid(field$challenge.get(login), privateKey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretKey = packet.getSecretKey(privateKey);
            this.connection.setEncryptionKey(secretKey);
            this.channel.eventLoop().schedule(() -> {
                this.processor.uninject(this.channel);
                ctx.fireChannelRead(this.processor.getCache().remove(this.username));
            }, 500L, TimeUnit.MILLISECONDS);
        }
        catch (CryptException e) {
            throw new IllegalStateException("Protocol error", e);
        }
    }
}

