/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.reflexion;

import io.github.lumine1909.reflexion.Field;
import io.github.lumine1909.reflexion.Method;
import io.github.lumine1909.reflexion.UnsafeUtil;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;

public record Class<T>(java.lang.Class<T> javaClass) {
    public static <T> Optional<Class<T>> forName(String name) {
        try {
            java.lang.Class<?> clazz = java.lang.Class.forName(name);
            return Optional.of(new Class(clazz));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<Class<T>> forName(String name, boolean initialize, ClassLoader loader) {
        try {
            java.lang.Class<?> clazz = java.lang.Class.forName(name, initialize, loader);
            return Optional.of(new Class(clazz));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static <T> Class<T> of(java.lang.Class<T> clazz) {
        return new Class<T>(clazz);
    }

    public <S> Optional<Field<S>> getField(String name, Class<S> type) {
        return this.getField(name, type.javaClass);
    }

    public <S> Optional<Field<S>> getField(String name, java.lang.Class<S> type) {
        try {
            java.lang.reflect.Field field = this.javaClass.getDeclaredField(name);
            if (field.getType() != type) {
                return Optional.empty();
            }
            return Optional.of(new Field(field));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public <S> Optional<Method<S>> getMethod(String name, Class<S> returnType, Class<?> ... parameterTypes) {
        return this.getMethod(name, returnType.javaClass, (java.lang.Class[])Arrays.stream(parameterTypes).map(c -> c.javaClass).toArray(java.lang.Class[]::new));
    }

    public <S> Optional<Method<S>> getMethod(String name, java.lang.Class<S> returnType, java.lang.Class<?> ... parameterTypes) {
        try {
            java.lang.reflect.Method method = this.javaClass.getDeclaredMethod(name, parameterTypes);
            MethodHandle methodHandle = UnsafeUtil.IMPL_LOOKUP.unreflect(method);
            if (!returnType.isAssignableFrom(method.getReturnType())) {
                return Optional.empty();
            }
            return Optional.of(new Method(method, Modifier.isStatic(method.getModifiers()), methodHandle));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

