/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax;

import com.mojang.text2speech.Narrator;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class CrashLogger {
    private static final String CRASH_LOG_FILE = "crash_report.log";

    public static void logCrash(Exception e, String additionalInfo) {
        try (FileWriter fileWriter = new FileWriter(CRASH_LOG_FILE, true);
             PrintWriter printWriter = new PrintWriter(fileWriter);){
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            printWriter.println("---- Crash Report ----");
            printWriter.println("Timestamp: " + timestamp);
            printWriter.println("Additional Info: " + additionalInfo);
            printWriter.println("Exception: " + e.toString());
            for (StackTraceElement element : e.getStackTrace()) {
                printWriter.println("\tat " + element);
            }
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                printWriter.println("Caused by: " + cause.toString());
                for (StackTraceElement element : cause.getStackTrace()) {
                    printWriter.println("\tat " + element);
                }
            }
            printWriter.println("----------------------");
            printWriter.println();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    public static void log(String message, Throwable throwable) {
        Narrator.LOGGER.error(message, throwable);
    }

    public static void logCrash(Throwable t, String additionalInfo) {
        try (FileWriter fileWriter = new FileWriter(CRASH_LOG_FILE, true);
             PrintWriter printWriter = new PrintWriter(fileWriter);){
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            printWriter.println("---- Crash Report ----");
            printWriter.println("Timestamp: " + timestamp);
            printWriter.println("Additional Info: " + additionalInfo);
            printWriter.println("Throwable: " + t.toString());
            for (StackTraceElement element : t.getStackTrace()) {
                printWriter.println("\tat " + element);
            }
            for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                printWriter.println("Caused by: " + cause.toString());
                for (StackTraceElement element : cause.getStackTrace()) {
                    printWriter.println("\tat " + element);
                }
            }
            printWriter.println("----------------------");
            printWriter.println();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }
}

