/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax;

import com.mojang.brigadier.CommandDispatcher;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.abandon.ColonyAbandonmentManager;
import net.machiavelli.minecolonytax.commands.RecipeDisableTestCommand;
import net.machiavelli.minecolonytax.event.RaidKillTracker;
import net.machiavelli.minecolonytax.network.NetworkHandler;
import net.machiavelli.minecolonytax.recipe.ModRecipeSerializers;
import net.machiavelli.minecolonytax.vassalization.VassalManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="minecolonytax")
public class MineColonyTax {
    public static final String MOD_ID = "minecolonytax";
    public static final Logger LOGGER = LogManager.getLogger();

    public MineColonyTax() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TaxConfig.CONFIG, "warntax/minecolonytax.toml");
        ModRecipeSerializers.RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(RaidKillTracker.class);
        LOGGER.error("MANUALLY REGISTERED RaidKillTracker event handler!");
        LOGGER.info("MineColonyTax mod initialized with COMMON config type - no serverconfig creation");
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            NetworkHandler.register();
            LOGGER.info("MineColonyTax setup complete");
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        RecipeDisableTestCommand.register((CommandDispatcher<CommandSourceStack>)event.getServer().m_129892_().m_82094_());
        LOGGER.info("Server starting - initializing TaxManager with configured interval of {} minutes", (Object)TaxConfig.getTaxIntervalInMinutes());
        TaxManager.initialize(event.getServer());
        LOGGER.info("TaxManager initialization complete");
        LOGGER.error("\ud83d\udea8 AUTOMATIC NULL OWNER PROTECTION: Fixing ALL null owners immediately on startup...");
        try {
            ColonyAbandonmentManager.emergencyFixAllNullOwners();
            LOGGER.info("\u2705 IMMEDIATE null owner fix completed");
        }
        catch (Exception e) {
            LOGGER.error("\ud83d\udca5 IMMEDIATE null owner fix failed", (Throwable)e);
        }
        event.getServer().execute(() -> {
            try {
                Thread.sleep(1000L);
                ColonyAbandonmentManager.emergencyFixAllNullOwners();
                ColonyAbandonmentManager.cleanupAllColoniesAbandonedEntries();
                LOGGER.info("\u2705 DELAYED null owner fix completed");
            }
            catch (Exception e) {
                LOGGER.error("\ud83d\udca5 DELAYED null owner fix failed", (Throwable)e);
            }
        });
        event.getServer().execute(() -> {
            try {
                Thread.sleep(3000L);
                ColonyAbandonmentManager.emergencyFixAllNullOwners();
                LOGGER.info("\u2705 FINAL null owner verification completed - ALL colonies should be safe now");
            }
            catch (Exception e) {
                LOGGER.error("\ud83d\udca5 FINAL null owner verification failed", (Throwable)e);
            }
        });
        VassalManager.initialize(event.getServer());
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        try {
            VassalManager.shutdown();
            LOGGER.info("VassalManager shutdown complete");
        }
        catch (Throwable t) {
            LOGGER.warn("Error during VassalManager shutdown: {}", (Object)t.toString());
        }
    }
}

