/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import dev.ftb.mods.ftbteams.FTBTeamsAPIImpl;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.data.HistoryManager;
import net.machiavelli.minecolonytax.data.PlayerWarDataManager;
import net.machiavelli.minecolonytax.data.WarData;
import net.machiavelli.minecolonytax.event.WarEconomyHandler;
import net.machiavelli.minecolonytax.event.WarEventHandler;
import net.machiavelli.minecolonytax.event.WarVictoryEvent;
import net.machiavelli.minecolonytax.integration.SDMShopIntegration;
import net.machiavelli.minecolonytax.militia.CitizenMilitiaManager;
import net.machiavelli.minecolonytax.raid.GuardResistanceHandler;
import net.machiavelli.minecolonytax.requirements.BuildingRequirementsManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WarSystem {
    private static final Logger WARSYSTEM_LOGGER = LogManager.getLogger(WarSystem.class);
    public static final Map<Integer, Object> pendingWarRequests = new ConcurrentHashMap<Integer, Object>();
    private static final Map<Integer, Long> extortionImmunity = new ConcurrentHashMap<Integer, Long>();
    public static final boolean FTB_TEAMS_INSTALLED = WarSystem.isFTBTeamsLoaded();
    public static final TeamManager FTB_TEAM_MANAGER = FTB_TEAMS_INSTALLED ? FTBTeamsAPIImpl.INSTANCE.getManager() : null;
    public static final Map<Integer, WarData> ACTIVE_WARS = new ConcurrentHashMap<Integer, WarData>();
    private static final Component JOIN_MSG = Component.m_237113_((String)"[Join War]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wnt joinwar")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to join the war!").m_130938_(style -> style.m_131140_(ChatFormatting.AQUA)))));
    private static final Component LEAVE_MSG = Component.m_237113_((String)"[Leave War]").m_130938_(style -> style.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wnt leavewar")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to leave the war!").m_130940_(ChatFormatting.AQUA))));
    public static final long WAR_PHASE_DURATION_SECONDS = 60L;

    private static boolean isOfficerOrFriendly(IColony colony, UUID playerUUID) {
        if (colony == null || playerUUID == null) {
            return false;
        }
        Rank rank = colony.getPermissions().getRank(playerUUID);
        if (rank == null) {
            return false;
        }
        return rank.isColonyManager() || !rank.isHostile();
    }

    private static boolean isFTBTeamsLoaded() {
        try {
            Class.forName("dev.ftb.mods.ftbteams.api.TeamManager");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void initiateWar(ServerPlayer attacker, UUID defender, Team attackerTeam, Team defenderTeam, IColony colony, IColony attackerColony) {
        UUID attackerTeamID = FTB_TEAMS_INSTALLED && attackerTeam != null ? attackerTeam.getId() : attacker.m_20148_();
        UUID defenderTeamID = FTB_TEAMS_INSTALLED && defenderTeam != null ? defenderTeam.getId() : colony.getPermissions().getOwner();
        ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237113_((String)("War for " + colony.getName())), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        bossEvent.m_142711_(1.0f);
        bossEvent.m_8321_(true);
        long now = System.currentTimeMillis();
        WarData data = new WarData(attacker.m_20148_(), defender, attackerTeamID, defenderTeamID, now, bossEvent, colony, attackerColony);
        int playerLives = (Integer)TaxConfig.PLAYER_LIVES_IN_WAR.get();
        data.getAttackerLives().put(attacker.m_20148_(), playerLives);
        data.getDefenderLives().put(colony.getPermissions().getOwner(), playerLives);
        WarSystem.assignWarParticipantRanks(attacker.m_20148_(), colony, attackerColony, true);
        if (attackerColony != null) {
            IPermissions attackerPerms = attackerColony.getPermissions();
            System.out.println("[DEBUG] Adding attacker colony members from " + attackerColony.getName());
            attackerPerms.getPlayers().forEach((uuid, player) -> {
                Rank rank;
                if (!uuid.equals(attacker.m_20148_()) && (rank = attackerPerms.getRank(uuid)) != null && (rank.equals((Object)attackerPerms.getRankOfficer()) || rank.equals((Object)attackerPerms.getRankFriend()))) {
                    ServerPlayer p;
                    MinecraftServer server;
                    data.getAttackerLives().put((UUID)uuid, playerLives);
                    System.out.println("[DEBUG] Added attacker colony member " + uuid + " with rank " + rank.getName());
                    WarSystem.assignWarParticipantRanks(uuid, colony, attackerColony, true);
                    if (colony.getWorld() != null && (server = colony.getWorld().m_7654_()) != null && (p = server.m_6846_().m_11259_(uuid)) != null && p.m_6084_()) {
                        MutableComponent warNotification = Component.m_237113_((String)"\u2694\ufe0f WAR DECLARED \u2694\ufe0f").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\nYour colony (" + attackerColony.getName() + ") is attacking " + colony.getName() + "!")).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)("\nAs an " + rank.getName() + ", you are eligible to join as an ATTACKER!")).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"\nClick below to join the war:").m_130940_(ChatFormatting.AQUA));
                        p.m_213846_((Component)warNotification);
                        p.m_213846_(JOIN_MSG);
                    }
                }
            });
        }
        IPermissions defenderPerms = colony.getPermissions();
        System.out.println("[DEBUG] Adding defender colony members from " + colony.getName());
        defenderPerms.getPlayers().forEach((uuid, player) -> {
            Rank rank;
            if (!uuid.equals(colony.getPermissions().getOwner()) && (rank = defenderPerms.getRank(uuid)) != null && (rank.equals((Object)defenderPerms.getRankOfficer()) || rank.equals((Object)defenderPerms.getRankFriend()))) {
                ServerPlayer p;
                MinecraftServer server;
                data.getDefenderLives().put((UUID)uuid, playerLives);
                System.out.println("[DEBUG] Added defender colony member " + uuid + " with rank " + rank.getName());
                WarSystem.assignWarParticipantRanks(uuid, colony, attackerColony, false);
                if (colony.getWorld() != null && (server = colony.getWorld().m_7654_()) != null && (p = server.m_6846_().m_11259_(uuid)) != null && p.m_6084_()) {
                    MutableComponent warNotification = Component.m_237113_((String)"\ud83d\udee1\ufe0f COLONY UNDER ATTACK \ud83d\udee1\ufe0f").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\nYour colony (" + colony.getName() + ") is being attacked!")).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)("\nAs an " + rank.getName() + ", you are eligible to join as a DEFENDER!")).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"\nClick below to join the defense:").m_130940_(ChatFormatting.AQUA));
                    p.m_213846_((Component)warNotification);
                    p.m_213846_(JOIN_MSG);
                }
            }
        });
        if (FTB_TEAMS_INSTALLED && FTB_TEAM_MANAGER != null) {
            System.out.println("[DEBUG] FTB Teams detected, adding team members as additional participants");
            if (attackerTeam != null) {
                attackerTeam.getMembers().forEach(uuid -> {
                    if (!data.getAttackerLives().containsKey(uuid)) {
                        ServerPlayer p;
                        data.getAttackerLives().put((UUID)uuid, playerLives);
                        System.out.println("[DEBUG] Added FTB team member to attackers: " + uuid);
                        WarSystem.assignWarParticipantRanks(uuid, colony, attackerColony, true);
                        if (colony.getWorld() != null && colony.getWorld().m_7654_() != null && (p = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid)) != null && p.m_6084_()) {
                            MutableComponent teamWarNotification = Component.m_237113_((String)"\u2694\ufe0f TEAM WAR DECLARED \u2694\ufe0f").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\nYour team is attacking " + colony.getName() + "!")).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\nAs a team member, you are eligible to join as an ATTACKER!").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"\nClick below to join the war:").m_130940_(ChatFormatting.AQUA));
                            p.m_213846_((Component)teamWarNotification);
                            p.m_213846_(JOIN_MSG);
                        }
                    }
                });
            }
            if (defenderTeam != null) {
                defenderTeam.getMembers().forEach(uuid -> {
                    if (!data.getDefenderLives().containsKey(uuid)) {
                        ServerPlayer p;
                        data.getDefenderLives().put((UUID)uuid, playerLives);
                        System.out.println("[DEBUG] Added FTB team member to defenders: " + uuid);
                        WarSystem.assignWarParticipantRanks(uuid, colony, attackerColony, false);
                        if (colony.getWorld() != null && colony.getWorld().m_7654_() != null && (p = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid)) != null && p.m_6084_()) {
                            MutableComponent teamDefenseNotification = Component.m_237113_((String)"\ud83d\udee1\ufe0f TEAM COLONY UNDER ATTACK \ud83d\udee1\ufe0f").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\nYour team's colony (" + colony.getName() + ") is being attacked!")).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\nAs a team member, you are eligible to join as a DEFENDER!").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"\nClick below to join the defense:").m_130940_(ChatFormatting.AQUA));
                            p.m_213846_((Component)teamDefenseNotification);
                            p.m_213846_(JOIN_MSG);
                        }
                    }
                });
            }
        }
        data.initialAttackerTotalLives = data.getAttackerLives().values().stream().mapToInt(Integer::intValue).sum();
        data.initialDefenderTotalLives = data.getDefenderLives().values().stream().mapToInt(Integer::intValue).sum();
        ACTIVE_WARS.put(colony.getID(), data);
    }

    public static void setWarInteractionPermissions(IColony colony, boolean allowed) {
        if (!((Boolean)TaxConfig.ENABLE_WAR_ACTIONS.get()).booleanValue()) {
            return;
        }
        IPermissions perms = colony.getPermissions();
        Rank hostile = perms.getRankHostile();
        for (Action a : TaxConfig.getWarActions()) {
            perms.setPermission(hostile, a, allowed);
        }
    }

    private static void assignWarParticipantRanks(UUID playerUUID, IColony defenderColony, IColony attackerColony, boolean isAttacker) {
        if (!((Boolean)TaxConfig.ENABLE_WAR_ACTIONS.get()).booleanValue()) {
            return;
        }
        try {
            if (isAttacker) {
                IPermissions defenderPerms = defenderColony.getPermissions();
                defenderPerms.setPlayerRank(playerUUID, defenderPerms.getRankHostile(), defenderColony.getWorld());
                System.out.println("[DEBUG] Assigned hostile rank to attacker " + playerUUID + " on defender colony " + defenderColony.getName());
            } else if (attackerColony != null) {
                IPermissions attackerPerms = attackerColony.getPermissions();
                attackerPerms.setPlayerRank(playerUUID, attackerPerms.getRankHostile(), attackerColony.getWorld());
                System.out.println("[DEBUG] Assigned hostile rank to defender " + playerUUID + " on attacker colony " + attackerColony.getName());
            }
        }
        catch (Exception e) {
            WARSYSTEM_LOGGER.error("Failed to assign war participant ranks for player " + playerUUID, (Throwable)e);
        }
    }

    public static void setRaidInteractionPermissions(IColony colony, boolean allowed) {
        if (!((Boolean)TaxConfig.ENABLE_WAR_ACTIONS.get()).booleanValue()) {
            return;
        }
        IPermissions perms = colony.getPermissions();
        Rank hostile = perms.getRankHostile();
        for (Action a : TaxConfig.getRaidActions()) {
            perms.setPermission(hostile, a, allowed);
        }
    }

    public static void updateBossBar(WarData war) {
        long now = System.currentTimeMillis();
        if (now < war.getJoinPhaseEndTime()) {
            long remainingMillis = war.getJoinPhaseEndTime() - now;
            String timeStr = String.format("%02d:%02d", remainingMillis / 60000L, remainingMillis / 1000L % 60L);
            String joinText = Component.m_237110_((String)"war.siege.status", (Object[])new Object[]{war.getColony().getName(), timeStr}).getString();
            war.bossEvent.m_6456_((Component)Component.m_237113_((String)joinText));
            long joinDuration = (long)((Integer)TaxConfig.JOIN_PHASE_DURATION_MINUTES.get() * 60) * 1000L;
            war.bossEvent.m_142711_((float)remainingMillis / (float)joinDuration);
            if (war.alliesBossEvent != null) {
                war.alliesBossEvent.m_6456_((Component)Component.m_237113_((String)joinText));
                war.alliesBossEvent.m_142711_((float)remainingMillis / (float)joinDuration);
            }
        } else {
            long elapsedSeconds = (now - war.warStartTime) / 1000L;
            long warDurationSeconds = (long)((Integer)TaxConfig.WAR_DURATION_MINUTES.get()).intValue() * 60L;
            long remainingSeconds = Math.max(0L, warDurationSeconds - elapsedSeconds);
            int attackerLives = war.getAttackerLives().values().stream().mapToInt(Integer::intValue).sum();
            int defenderLives = war.getDefenderLives().values().stream().mapToInt(Integer::intValue).sum();
            String timeStr = String.format("%02d:%02d", remainingSeconds / 60L, remainingSeconds % 60L);
            String warText = "\u00a76\u00a7lWar for " + war.getColony().getName() + " - Time Remaining: " + timeStr + " | Attackers: " + attackerLives + " | Defenders: " + defenderLives;
            war.bossEvent.m_6456_((Component)Component.m_237113_((String)warText));
            war.bossEvent.m_142711_((float)remainingSeconds / (float)warDurationSeconds);
            if (war.alliesBossEvent != null) {
                war.alliesBossEvent.m_7706_();
                war.alliesBossEvent.m_8321_(false);
            }
        }
    }

    public static void finalizeWarStart(WarData war) {
        int attackerPlayerCount = war.getAttackerLives().size();
        int defenderPlayerCount = war.getDefenderLives().size();
        if (attackerPlayerCount == 0 || defenderPlayerCount == 0) {
            if (war.getColony().getWorld() != null && war.getColony().getWorld().m_7654_() != null) {
                war.getColony().getWorld().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)"War cancelled due to lack of participants.").m_130938_(style -> style.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))), false);
            }
            WarSystem.endWar(war.getColony());
            return;
        }
        if (Math.abs(attackerPlayerCount - defenderPlayerCount) > 1) {
            if (war.getColony().getWorld() != null && war.getColony().getWorld().m_7654_() != null) {
                war.getColony().getWorld().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("Join phase ratio condition not met! Teams must be balanced (difference <= 1). Current: Attacker=" + attackerPlayerCount + ", Defender=" + defenderPlayerCount)).m_130938_(style -> style.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))), false);
            }
            return;
        }
        war.bossEvent.m_7706_();
        war.getAttackerLives().keySet().forEach(uuid -> {
            ServerPlayer p;
            if (war.getColony().getWorld() != null && war.getColony().getWorld().m_7654_() != null && (p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid)) != null) {
                war.bossEvent.m_6543_(p);
            }
        });
        war.getDefenderLives().keySet().forEach(uuid -> {
            ServerPlayer p;
            if (war.getColony().getWorld() != null && war.getColony().getWorld().m_7654_() != null && (p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid)) != null) {
                war.bossEvent.m_6543_(p);
            }
        });
        if (war.alliesBossEvent != null) {
            war.alliesBossEvent.m_7706_();
            war.alliesBossEvent.m_8321_(false);
        }
        war.getAttackerLives().keySet().forEach(uuid -> {
            ServerPlayer p;
            if (war.getColony().getWorld() != null && war.getColony().getWorld().m_7654_() != null && (p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid)) != null) {
                WarSystem.assignWarGroup(p);
            }
        });
        war.getDefenderLives().keySet().forEach(uuid -> {
            ServerPlayer p;
            if (war.getColony().getWorld() != null && war.getColony().getWorld().m_7654_() != null && (p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid)) != null) {
                WarSystem.assignWarGroup(p);
            }
        });
        war.warStartTime = System.currentTimeMillis();
        war.setStatus(WarData.WarStatus.INWAR);
        WarSystem.updateBossBar(war);
        WarSystem.applyGuardGlow(war.getColony());
        if (war.getAttackerColony() != null) {
            WarSystem.applyGuardGlow(war.getAttackerColony());
        }
        WarSystem.applyWarGlowToParticipants(war);
        GuardResistanceHandler.applyResistanceToGuardsForWar(war.getColony());
        if (war.getAttackerColony() != null) {
            GuardResistanceHandler.applyResistanceToGuardsForWar(war.getAttackerColony());
        }
        WarSystem.initializeWarMilitiaSystem(war);
        WarSystem.activateWarMilitia(war);
        if (war.getColony().getWorld() != null && war.getColony().getWorld().m_7654_() != null) {
            String attackerColonyName = war.getAttackerColony() != null ? war.getAttackerColony().getName() : "Attacking Forces";
            String defenderColonyName = war.getColony().getName();
            MutableComponent warBeginMsg = Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"war.begin.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237110_((String)"war.begin.body", (Object[])new Object[]{attackerColonyName, defenderColonyName}).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
            ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_((Component)warBeginMsg, false);
        }
        long warDurationMillis = (long)((Integer)TaxConfig.WAR_DURATION_MINUTES.get() * 60) * 1000L;
        WarSystem.scheduleTimerWarnings(war, warDurationMillis);
    }

    private static void assignWarGroup(ServerPlayer player) {
        if (player == null || player.m_20194_() == null) {
            return;
        }
        if (((Boolean)TaxConfig.ENABLE_LP_GROUP_SWITCHING.get()).booleanValue()) {
            String command = "lp user " + player.m_7755_().getString() + " parent set war";
            player.m_20194_().m_129892_().m_230957_(player.m_20203_(), command);
        }
    }

    public static void resetWarGroup(ServerPlayer player) {
        if (player == null || player.m_20194_() == null) {
            return;
        }
        if (((Boolean)TaxConfig.ENABLE_LP_GROUP_SWITCHING.get()).booleanValue()) {
            String command = "lp user " + player.m_7755_().getString() + " parent set default";
            player.m_20194_().m_129892_().m_230957_(player.m_20203_(), command);
        }
    }

    public static void checkForVictory(WarData war) {
        boolean defendersWin;
        boolean hasDefenders;
        boolean allAttackersDead = war.getAttackerLives().values().stream().allMatch(lives -> lives <= 0);
        boolean allDefendersDead = war.getDefenderLives().values().stream().allMatch(lives -> lives <= 0);
        boolean allDefenderGuardsDead = war.getRemainingDefenderGuards() <= 0;
        boolean allAttackerGuardsDead = war.getRemainingAttackerGuards() <= 0;
        boolean hasAttackers = !war.getAttackerLives().isEmpty();
        boolean bl = hasDefenders = !war.getDefenderLives().isEmpty();
        if (!hasAttackers && !hasDefenders) {
            return;
        }
        boolean attackersWin = hasDefenders && allDefendersDead || !hasDefenders && allDefenderGuardsDead;
        boolean bl2 = defendersWin = hasAttackers && allAttackersDead || !hasAttackers && allAttackerGuardsDead;
        if (!attackersWin && !defendersWin) {
            return;
        }
        if (war.getColony().getWorld() == null || war.getColony().getWorld().m_7654_() == null) {
            return;
        }
        System.out.println("[DEBUG] War victory detected - Attackers win: " + attackersWin + ", Defenders win: " + defendersWin);
        System.out.println("[DEBUG] All attackers dead: " + allAttackersDead + ", All defenders dead: " + allDefendersDead);
        System.out.println("[DEBUG] Attacker guards: " + war.getRemainingAttackerGuards() + ", Defender guards: " + war.getRemainingDefenderGuards());
        if (defendersWin) {
            String defenderColonyName = war.getColony().getName();
            String attackerColonyName = war.getAttackerColony() != null ? war.getAttackerColony().getName() : "The Attackers";
            MutableComponent victoryMsg = Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"war.defenders.win.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237110_((String)"war.defenders.win.body", (Object[])new Object[]{defenderColonyName, attackerColonyName}).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
            war.getColony().getWorld().m_7654_().m_6846_().m_240416_((Component)victoryMsg, false);
            for (UUID defenderUUID : war.getDefenderLives().keySet()) {
                ServerPlayer defender = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(defenderUUID);
                if (defender == null) continue;
            }
            WarSystem.applyWarEconomyTransfers(war, false);
        } else if (attackersWin) {
            String defenderColonyName = war.getColony().getName();
            String attackerColonyName = war.getAttackerColony() != null ? war.getAttackerColony().getName() : "The Attackers";
            MutableComponent conquestMsg = Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"war.attackers.win.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237110_((String)"war.attackers.win.body", (Object[])new Object[]{attackerColonyName, defenderColonyName}).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
            war.getColony().getWorld().m_7654_().m_6846_().m_240416_((Component)conquestMsg, false);
            for (UUID attackerUUID : war.getAttackerLives().keySet()) {
                ServerPlayer attackerPlayer = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(attackerUUID);
                if (attackerPlayer == null) continue;
                PlayerWarDataManager.incrementWarsWon(attackerPlayer);
                MinecraftForge.EVENT_BUS.post((Event)new WarVictoryEvent(attackerPlayer));
            }
            WarSystem.applyWarEconomyTransfers(war, true);
            if (((Boolean)TaxConfig.ENABLE_COLONY_TRANSFER.get()).booleanValue()) {
                WarSystem.transferOwnership(war.getColony(), war.getAttacker());
            }
        }
        WarSystem.endWar(war.getColony());
    }

    private static void applyStalematePenalties(WarData war) {
        int freezeHours;
        double stalematePenalty = TaxConfig.getWarStalematePercentage();
        if (stalematePenalty > 0.0) {
            long attackerDeducted = 0L;
            long defenderDeducted = 0L;
            if (war.getAttackerTeamID() != null) {
                attackerDeducted = WarEconomyHandler.deductTeamBalanceWithReport(war.getAttackerTeamID(), stalematePenalty);
            } else {
                for (UUID uuid : war.getAttackerLives().keySet()) {
                    attackerDeducted += WarEconomyHandler.deductTeamBalanceWithReport(uuid, stalematePenalty);
                }
            }
            if (war.getDefenderTeamID() != null) {
                defenderDeducted = WarEconomyHandler.deductTeamBalanceWithReport(war.getDefenderTeamID(), stalematePenalty);
            } else {
                for (UUID uuid : war.getDefenderLives().keySet()) {
                    defenderDeducted += WarEconomyHandler.deductTeamBalanceWithReport(uuid, stalematePenalty);
                }
            }
            war.setPenaltyReport("Stalemate penalties applied: " + stalematePenalty * 100.0 + "% deducted from all participants (Attackers lost: " + attackerDeducted + ", Defenders lost: " + defenderDeducted + ")");
            if (war.getColony().getWorld() != null && war.getColony().getWorld().m_7654_() != null) {
                MutableComponent ecoMsg = Component.m_237113_((String)"War Stalemate: Both sides have been penalized economically!").m_130940_(ChatFormatting.GOLD);
                war.getColony().getWorld().m_7654_().m_6846_().m_240416_((Component)ecoMsg, false);
            }
        }
        if ((freezeHours = TaxConfig.getWarTaxFreezeHours()) > 0) {
            TaxManager.freezeColonyTax(war.getColony().getID(), freezeHours);
            if (war.getAttackerColony() != null) {
                TaxManager.freezeColonyTax(war.getAttackerColony().getID(), freezeHours);
            }
            if (war.getColony().getWorld() != null && war.getColony().getWorld().m_7654_() != null) {
                String freezeMsg = "Tax generation frozen for " + freezeHours + " hours due to war stalemate!";
                MutableComponent notification = Component.m_237113_((String)freezeMsg).m_130940_(ChatFormatting.GOLD);
                war.getColony().getWorld().m_7654_().m_6846_().m_240416_((Component)notification, false);
            }
        }
    }

    private static void applyWarEconomyTransfers(WarData war, boolean attackersWon) {
        String winnerColonyName;
        double transferPercentage;
        if (war.getColony().getWorld() == null || war.getColony().getWorld().m_7654_() == null) {
            return;
        }
        double d = transferPercentage = attackersWon ? TaxConfig.getWarVictoryPercentage() : TaxConfig.getWarDefeatPercentage();
        if (transferPercentage <= 0.0) {
            return;
        }
        IColony winnerColony = attackersWon ? war.getAttackerColony() : war.getColony();
        IColony loserColony = attackersWon ? war.getColony() : war.getAttackerColony();
        UUID winnerTeamID = attackersWon ? war.getAttackerTeamID() : war.getDefenderTeamID();
        UUID loserTeamID = attackersWon ? war.getDefenderTeamID() : war.getAttackerTeamID();
        long totalTransferred = 0L;
        if (TaxConfig.isSDMShopConversionEnabled()) {
            if (winnerTeamID != null && loserTeamID != null) {
                Map<UUID, Integer> winningParticipants = attackersWon ? war.getAttackerLives() : war.getDefenderLives();
                IColony winningColony = attackersWon ? war.getAttackerColony() : war.getColony();
                Map<UUID, Integer> losingParticipants = attackersWon ? war.getDefenderLives() : war.getAttackerLives();
                UUID singleWinnerUUID = WarSystem.selectSingleWarWinner(winningColony, winningParticipants.keySet());
                ServerPlayer singleWinner = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(singleWinnerUUID);
                long totalCollected = 0L;
                ArrayList<CallSite> transactionDetails = new ArrayList<CallSite>();
                for (UUID loserUUID : losingParticipants.keySet()) {
                    long loserBalance;
                    long transferAmount;
                    ServerPlayer loser = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(loserUUID);
                    if (loser == null || (transferAmount = Math.max(1L, (long)((double)(loserBalance = SDMShopIntegration.getMoney(loser)) * transferPercentage))) <= 0L || loserBalance < transferAmount) continue;
                    SDMShopIntegration.setMoney(loser, loserBalance - transferAmount);
                    totalCollected += transferAmount;
                    loser.m_213846_((Component)Component.m_237113_((String)"\u2694\ufe0f WAR DEFEAT PENALTY \u2694\ufe0f").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\nYou lost $" + transferAmount + " due to war defeat!")).m_130940_(ChatFormatting.RED)));
                    transactionDetails.add((CallSite)((Object)(loser.m_7755_().getString() + " lost $" + transferAmount)));
                }
                if (totalCollected > 0L && singleWinner != null) {
                    long currentBalance = SDMShopIntegration.getMoney(singleWinner);
                    SDMShopIntegration.setMoney(singleWinner, currentBalance + totalCollected);
                    singleWinner.m_213846_((Component)Component.m_237113_((String)"\ud83c\udfc6 WAR VICTORY REWARD \ud83c\udfc6").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\nYou received $" + totalCollected + " as war reparations!")).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD})));
                    MutableComponent transactionSummary = Component.m_237113_((String)"\ud83d\udcb0 WAR ECONOMY TRANSACTIONS \ud83d\udcb0").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + String.join((CharSequence)"\n", transactionDetails))).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("\nTotal awarded to " + singleWinner.m_7755_().getString() + ": $" + totalCollected)).m_130940_(ChatFormatting.GREEN));
                    WarSystem.sendMessageToWarParticipants(war, (Component)transactionSummary);
                }
                totalTransferred = totalCollected;
            } else {
                Map<UUID, Integer> winningParticipants = attackersWon ? war.getAttackerLives() : war.getDefenderLives();
                IColony winningColony = attackersWon ? war.getAttackerColony() : war.getColony();
                UUID loserUUID = attackersWon ? war.getColony().getPermissions().getOwner() : war.getAttacker();
                UUID singleWinnerUUID = WarSystem.selectSingleWarWinner(winningColony, winningParticipants.keySet());
                ServerPlayer singleWinner = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(singleWinnerUUID);
                ServerPlayer loser = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(loserUUID);
                if (singleWinner != null && loser != null) {
                    totalTransferred = (long)WarEconomyHandler.transferBalanceToPlayer(loserUUID, singleWinnerUUID, transferPercentage);
                    MutableComponent individualTransferMsg = Component.m_237113_((String)"\ud83d\udcb0 WAR VICTORY TRANSFER \ud83d\udcb0").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + loser.m_7755_().getString() + " lost $" + totalTransferred)).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)("\nAwarded to " + singleWinner.m_7755_().getString())).m_130940_(ChatFormatting.GREEN));
                    WarSystem.sendMessageToWarParticipants(war, (Component)individualTransferMsg);
                }
            }
        } else {
            int reparationsAmount = 0;
            if (loserColony != null && winnerColony != null) {
                int loserColonyTax = TaxManager.getStoredTaxForColony(loserColony);
                reparationsAmount = (int)((double)loserColonyTax * transferPercentage);
                if (reparationsAmount <= 0) {
                    int expectedTaxRevenue = 0;
                    for (IBuilding building : winnerColony.getBuildingManager().getBuildings().values()) {
                        String buildingType = building.getBuildingDisplayName();
                        double baseTax = TaxConfig.getBaseTaxForBuilding(buildingType);
                        double upgradeTax = TaxConfig.getUpgradeTaxForBuilding(buildingType) * (double)building.getBuildingLevel();
                        expectedTaxRevenue += (int)(baseTax + upgradeTax);
                    }
                    reparationsAmount = (int)((double)expectedTaxRevenue * transferPercentage);
                    if (reparationsAmount <= 0 && !winnerColony.getBuildingManager().getBuildings().isEmpty()) {
                        reparationsAmount = TaxConfig.getDebtLimit() / 10;
                    }
                }
                if (reparationsAmount > 0) {
                    if (loserColonyTax - reparationsAmount < -TaxConfig.getDebtLimit()) {
                        reparationsAmount = loserColonyTax + TaxConfig.getDebtLimit();
                    }
                    if (loserColony != null) {
                        TaxManager.payTaxDebt(loserColony, -reparationsAmount);
                    }
                    if (winnerColony != null) {
                        TaxManager.payTaxDebt(winnerColony, reparationsAmount);
                    }
                    totalTransferred = reparationsAmount;
                    MutableComponent colonyTaxTransferMsg = Component.m_237113_((String)"\ud83c\udfdb\ufe0f COLONY TAX REPARATIONS \ud83c\udfdb\ufe0f").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + loserColony.getName() + " colony tax reduced by " + reparationsAmount)).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)("\n" + winnerColony.getName() + " colony tax increased by " + reparationsAmount)).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)("\nLoser colony tax: " + TaxManager.getStoredTaxForColony(loserColony))).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("\nWinner colony tax: " + TaxManager.getStoredTaxForColony(winnerColony))).m_130940_(ChatFormatting.GRAY));
                    WarSystem.sendMessageToWarParticipants(war, (Component)colonyTaxTransferMsg);
                }
            } else {
                long amountTransferred = 0L;
                ArrayList<UUID> losers = new ArrayList<UUID>(attackersWon ? war.getDefenderLives().keySet() : war.getAttackerLives().keySet());
                Map<UUID, Integer> winningParticipants = attackersWon ? war.getAttackerLives() : war.getDefenderLives();
                IColony winningColony = attackersWon ? war.getAttackerColony() : war.getColony();
                UUID singleWinnerUUID = WarSystem.selectSingleWarWinner(winningColony, winningParticipants.keySet());
                ServerPlayer singleWinner = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(singleWinnerUUID);
                if (singleWinner != null) {
                    ArrayList<CallSite> transactionDetails = new ArrayList<CallSite>();
                    for (UUID loserUUID : losers) {
                        ServerPlayer loser = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(loserUUID);
                        if (loser == null) continue;
                        long transferred = (long)WarEconomyHandler.transferBalanceToPlayer(loserUUID, singleWinner.m_20148_(), transferPercentage);
                        amountTransferred += transferred;
                        transactionDetails.add((CallSite)((Object)(loser.m_7755_().getString() + " lost " + transferred + " coins")));
                    }
                    if (amountTransferred > 0L) {
                        MutableComponent inventoryTransferMsg = Component.m_237113_((String)"\ud83d\udcb0 WAR INVENTORY TRANSFERS \ud83d\udcb0").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + String.join((CharSequence)"\n", transactionDetails))).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("\nTotal awarded to " + singleWinner.m_7755_().getString() + ": " + amountTransferred + " coins")).m_130940_(ChatFormatting.GREEN));
                        WarSystem.sendMessageToWarParticipants(war, (Component)inventoryTransferMsg);
                    }
                }
                totalTransferred = amountTransferred;
            }
        }
        String string = attackersWon ? (war.getAttackerColony() != null ? war.getAttackerColony().getName() : "attackers") : (winnerColonyName = war.getColony().getName());
        String loserColonyName = attackersWon ? war.getColony().getName() : (war.getAttackerColony() != null ? war.getAttackerColony().getName() : "attackers");
        war.setPenaltyReport("War reparations: " + totalTransferred + " transferred from " + loserColonyName + " to " + winnerColonyName);
        if (totalTransferred > 0L) {
            MutableComponent ecoMsg = Component.m_237113_((String)"\ud83c\udfc6 WAR ECONOMIC RESULT \ud83c\udfc6").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + loserColonyName)).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)" has paid ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)String.valueOf(totalTransferred)).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" in war reparations to ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)winnerColonyName).m_130940_(ChatFormatting.GREEN));
            WarSystem.sendMessageToWarParticipants(war, (Component)ecoMsg);
        }
    }

    private static UUID selectSingleWarWinner(IColony winningColony, Set<UUID> participants) {
        UUID owner = winningColony.getPermissions().getOwner();
        if (participants.contains(owner)) {
            return owner;
        }
        for (UUID participantUUID : participants) {
            Rank rank = winningColony.getPermissions().getRank(participantUUID);
            if (rank == null || !rank.isColonyManager()) continue;
            return participantUUID;
        }
        if (!participants.isEmpty()) {
            return participants.iterator().next();
        }
        return owner;
    }

    private static void sendMessageToWarParticipants(WarData war, Component message) {
        HashSet<UUID> allParticipants = new HashSet<UUID>();
        allParticipants.addAll(war.getAttackerLives().keySet());
        allParticipants.addAll(war.getDefenderLives().keySet());
        for (UUID participantUUID : allParticipants) {
            ServerPlayer participant = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(participantUUID);
            if (participant == null) continue;
            participant.m_213846_(message);
        }
    }

    public static void transferOwnership(IColony colony, UUID newOwnerUUID) {
        if (colony.getWorld() == null || colony.getWorld().m_7654_() == null) {
            return;
        }
        ServerPlayer newOwner = colony.getWorld().m_7654_().m_6846_().m_11259_(newOwnerUUID);
        if (newOwner == null) {
            return;
        }
        if (colony.getPermissions().setOwner((Player)newOwner)) {
            colony.markDirty();
            MutableComponent msg = Component.m_237113_((String)(colony.getName() + " conquered by " + newOwner.m_7755_().getString())).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED).m_131136_(Boolean.valueOf(true)));
            colony.getWorld().m_7654_().m_6846_().m_240416_((Component)msg, false);
        } else {
            WARSYSTEM_LOGGER.error("Ownership transfer failed for colony {}", (Object)colony.getID());
        }
    }

    public static void endWar(IColony colony) {
        WarData warData = ACTIVE_WARS.get(colony.getID());
        if (warData != null) {
            GuardResistanceHandler.removeResistanceFromGuardsForWar(warData.getColony());
            if (warData.getAttackerColony() != null) {
                GuardResistanceHandler.removeResistanceFromGuardsForWar(warData.getAttackerColony());
            }
            WarSystem.cleanupWarMilitiaSystem(warData);
        }
        WarSystem.setWarInteractionPermissions(colony, false);
        if (warData != null && warData.getAttackerColony() != null) {
            WarSystem.setWarInteractionPermissions(warData.getAttackerColony(), false);
        }
        if ((warData = ACTIVE_WARS.remove(colony.getID())) != null) {
            Object outcome;
            if (warData.timerTask != null) {
                warData.timerTask.cancel();
                warData.timerTask = null;
            }
            if (warData.bossEvent != null) {
                warData.bossEvent.m_7706_();
                warData.bossEvent.m_8321_(false);
            }
            if (colony.getWorld() != null && colony.getWorld().m_7654_() != null) {
                colony.getPermissions().getPlayers().forEach((uuid, pdata) -> {
                    ServerPlayer p = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid);
                    if (p != null) {
                        p.m_21195_(MobEffects.f_19619_);
                    }
                });
                if (colony.getCitizenManager() != null) {
                    colony.getCitizenManager().getCitizens().forEach(citizen -> citizen.getEntity().ifPresent(entity -> entity.m_21195_(MobEffects.f_19619_)));
                }
                warData.getAttackerLives().keySet().forEach(uuid -> {
                    ServerPlayer p = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid);
                    if (p != null) {
                        WarSystem.resetWarGroup(p);
                    }
                });
                warData.getDefenderLives().keySet().forEach(uuid -> {
                    ServerPlayer p = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid);
                    if (p != null) {
                        WarSystem.resetWarGroup(p);
                    }
                });
                HashSet<UUID> allParticipants = new HashSet<UUID>();
                if (warData.getAttackerLives() != null) {
                    allParticipants.addAll(warData.getAttackerLives().keySet());
                }
                if (warData.getDefenderLives() != null) {
                    allParticipants.addAll(warData.getDefenderLives().keySet());
                }
                for (UUID participantUUID : allParticipants) {
                    boolean hasValidPersonalSpawn;
                    ServerPlayer p2 = colony.getWorld().m_7654_().m_6846_().m_11259_(participantUUID);
                    if (p2 == null || p2.f_8941_.m_9290_() != GameType.SPECTATOR) continue;
                    WarInventoryHandler.restoreInventory(p2);
                    BlockPos respawnPos = p2.m_8961_();
                    float respawnAngle = p2.m_8962_();
                    ServerLevel respawnLevel = p2.f_8924_.m_129880_(p2.m_8963_());
                    boolean bl = hasValidPersonalSpawn = respawnPos != null && respawnLevel != null && p2.m_8964_();
                    if (hasValidPersonalSpawn) {
                        p2.m_8999_(respawnLevel, (double)respawnPos.m_123341_() + 0.5, (double)respawnPos.m_123342_() + 0.1, (double)respawnPos.m_123343_() + 0.5, respawnAngle, 0.0f);
                        WARSYSTEM_LOGGER.info("Player {} teleported to personal respawn point: {} in dimension {}", (Object)p2.m_7755_().getString(), (Object)respawnPos, (Object)respawnLevel.m_46472_().m_135782_());
                    } else {
                        BlockPos currentPos = p2.m_20183_();
                        ServerLevel currentLevel = (ServerLevel)p2.m_9236_();
                        int topY = currentLevel.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, currentPos.m_123341_(), currentPos.m_123343_());
                        p2.m_8999_(currentLevel, (double)currentPos.m_123341_() + 0.5, (double)topY + 1.0, (double)currentPos.m_123343_() + 0.5, p2.m_146908_(), p2.m_146909_());
                        WARSYSTEM_LOGGER.info("Player {} has no valid personal respawn, teleported to surface at current X/Z: {} in dimension {}", (Object)p2.m_7755_().getString(), (Object)new BlockPos(currentPos.m_123341_(), topY, currentPos.m_123343_()), (Object)currentLevel.m_46472_().m_135782_());
                    }
                    p2.m_143403_(GameType.SURVIVAL);
                    p2.m_213846_((Component)Component.m_237115_((String)"war.end.inventory.restored").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true))));
                }
            }
            UUID winnerUuid = colony.getPermissions().getOwner();
            String winnerName = "Unknown";
            if (colony.getWorld() != null && colony.getWorld().m_7654_() != null) {
                winnerName = Optional.ofNullable(colony.getWorld().m_7654_().m_6846_().m_11259_(winnerUuid)).map(p -> p.m_7755_().getString()).orElse(winnerUuid.toString());
            }
            long amountTransferred = 0L;
            if (warData.getPenaltyReport().isEmpty()) {
                outcome = "Stalemate";
                if (colony.getWorld() != null && colony.getWorld().m_7654_() != null) {
                    for (UUID uuid2 : warData.getAttackerLives().keySet()) {
                        ServerPlayer player = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid2);
                        if (player == null) continue;
                        PlayerWarDataManager.incrementWarStalemates(player);
                    }
                    for (UUID uuid2 : warData.getDefenderLives().keySet()) {
                        ServerPlayer player = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid2);
                        if (player == null) continue;
                        PlayerWarDataManager.incrementWarStalemates(player);
                    }
                }
            } else if (warData.getPenaltyReport().contains("TOTAL VICTORY")) {
                Map<UUID, Integer> winnerLivesMap;
                boolean isDefenderVictory = warData.getRemainingDefenderGuards() > 0;
                Map<UUID, Integer> map = winnerLivesMap = isDefenderVictory ? warData.getDefenderLives() : warData.getAttackerLives();
                if (colony.getWorld() != null && colony.getWorld().m_7654_() != null) {
                    for (UUID uuid3 : winnerLivesMap.keySet()) {
                        ServerPlayer player = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid3);
                        if (player == null) continue;
                        PlayerWarDataManager.incrementWarsWon(player);
                    }
                }
                if (!((Boolean)TaxConfig.ENABLE_COLONY_TRANSFER.get()).booleanValue()) {
                    IColony loserColonyActual = isDefenderVictory ? warData.getAttackerColony() : warData.getColony();
                    int colonyBalance = 0;
                    if (loserColonyActual != null) {
                        colonyBalance = TaxManager.getStoredTaxForColony(loserColonyActual);
                    }
                    long transferAmount = Math.max(1000, colonyBalance * 3 / 4);
                    if (loserColonyActual != null) {
                        TaxManager.deductColonyTax(loserColonyActual, TaxConfig.getWarDefeatPercentage());
                    }
                    amountTransferred = transferAmount;
                    outcome = "Victory! Colony funds transferred: " + transferAmount;
                    WARSYSTEM_LOGGER.info("[MineColonyTax] War victory funds transfer: {} from colony {}", (Object)transferAmount, (Object)(loserColonyActual != null ? loserColonyActual.getName() : "Unknown"));
                } else {
                    outcome = "Complete Victory! Colony ownership transferred.";
                    WARSYSTEM_LOGGER.info("[MineColonyTax] War victory colony transfer for colony {}", (Object)colony.getName());
                }
            } else {
                outcome = warData.getPenaltyReport();
            }
            String attackerName = warData.getAttackerColony() != null ? warData.getAttackerColony().getName() : "Unknown Attacker";
            String eventString = String.format("[WAR] Colony '%s' was attacked by '%s'. Outcome: %s. Amount Transferred: %d", colony.getName(), attackerName, outcome, amountTransferred);
            HistoryManager.getColonyHistory(colony.getID()).addEvent(eventString);
            HistoryManager.saveHistory();
            WARSYSTEM_LOGGER.info("War ended for colony {}", (Object)colony.getName());
        }
    }

    public static void handleTimeExpiry(WarData war) {
        String reportOutcome;
        double defenderNormalizedStrength;
        double epsilon;
        if (war.getColony().getWorld() == null || war.getColony().getWorld().m_7654_() == null) {
            return;
        }
        Map<UUID, Integer> disconnectedPlayers = WarEventHandler.getDisconnectedWarParticipants();
        for (UUID uuid2 : new ArrayList<UUID>(war.getAttackerLives().keySet())) {
            if (!disconnectedPlayers.containsKey(uuid2) || disconnectedPlayers.get(uuid2) != 1) continue;
            war.getAttackerLives().put(uuid2, 0);
            WARSYSTEM_LOGGER.info("[MineColonyTax] Setting disconnected attacker {} to 0 lives on war expiry", (Object)uuid2);
        }
        for (UUID uuid2 : new ArrayList<UUID>(war.getDefenderLives().keySet())) {
            if (!disconnectedPlayers.containsKey(uuid2) || disconnectedPlayers.get(uuid2) != 2) continue;
            war.getDefenderLives().put(uuid2, 0);
            WARSYSTEM_LOGGER.info("[MineColonyTax] Setting disconnected defender {} to 0 lives on war expiry", (Object)uuid2);
        }
        int attackerTotalLives = war.getAttackerLives().values().stream().mapToInt(Integer::intValue).sum();
        int defenderTotalLives = war.getDefenderLives().values().stream().mapToInt(Integer::intValue).sum();
        String attackerColonyName = war.getAttackerColony() != null ? war.getAttackerColony().getName() : "The Attackers";
        String defenderColonyName = war.getColony().getName();
        MutableComponent timeExpiredMsgBase = Component.m_237115_((String)"war.time.expired.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
        if (attackerTotalLives == 0 && war.getRemainingAttackerGuards() == 0) {
            MutableComponent defenderVictoryMsg = Component.m_237115_((String)"war.time.expired.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.defenders.part1").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)defenderColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.time.expired.defenders.part2").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
            WarSystem.broadcastComponent((Component)defenderVictoryMsg);
            for (UUID defUUID : war.getDefenderLives().keySet()) {
                ServerPlayer p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(defUUID);
                if (p == null) continue;
                PlayerWarDataManager.incrementWarsWon(p);
            }
            WarSystem.handleVictoryRewards(war, true);
            WarSystem.endWar(war.getColony());
            return;
        }
        if (defenderTotalLives == 0 && war.getRemainingDefenderGuards() == 0) {
            MutableComponent attackerVictoryMsg = Component.m_237115_((String)"war.time.expired.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.attackers.part1").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)attackerColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.time.expired.attackers.part2").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
            WarSystem.broadcastComponent((Component)attackerVictoryMsg);
            for (UUID atkUUID : war.getAttackerLives().keySet()) {
                ServerPlayer p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(atkUUID);
                if (p == null) continue;
                PlayerWarDataManager.incrementWarsWon(p);
            }
            WarSystem.handleVictoryRewards(war, false);
            WarSystem.endWar(war.getColony());
            return;
        }
        if (attackerTotalLives == war.initialAttackerTotalLives && defenderTotalLives == war.initialDefenderTotalLives && war.getRemainingAttackerGuards() == war.initialAttackerGuards && war.getRemainingDefenderGuards() == war.initialDefenderGuards) {
            MutableComponent stalemateNoLossesMsg = Component.m_237115_((String)"war.time.expired.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.stalemate.timeout.part1").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)attackerColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.stalemate.timeout.part2").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)defenderColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.stalemate.timeout.part3").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.stalemate.timeout.penalties").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
            WarSystem.broadcastComponent((Component)stalemateNoLossesMsg);
            war.getAttackerLives().keySet().forEach(uuid -> WarEconomyHandler.deductTeamBalanceWithReport(uuid, 0.25));
            war.getDefenderLives().keySet().forEach(uuid -> WarEconomyHandler.deductTeamBalanceWithReport(uuid, 0.25));
            TaxManager.deductColonyTax(war.getColony(), TaxConfig.getWarStalematePercentage());
            if (war.getAttackerColony() != null) {
                TaxManager.deductColonyTax(war.getAttackerColony(), TaxConfig.getWarStalematePercentage());
            }
            war.setPenaltyReport("Stalemate (Timeout - No Losses): Both sides lose " + TaxConfig.getWarStalematePercentage() * 100.0 + "% of their balances and colony revenue is reduced by " + TaxConfig.getWarStalematePercentage() * 100.0 + "%.");
            WarSystem.endWar(war.getColony());
            return;
        }
        double attackerNormalizedStrength = (double)(attackerTotalLives + war.getRemainingAttackerGuards()) / (double)(war.initialAttackerTotalLives + war.initialAttackerGuards);
        if (attackerNormalizedStrength + (epsilon = 0.01) < (defenderNormalizedStrength = (double)(defenderTotalLives + war.getRemainingDefenderGuards()) / (double)(war.initialDefenderTotalLives + war.initialDefenderGuards))) {
            reportOutcome = "Strategic Victory: Defenders win! Attackers lost proportionally more strength.";
            MutableComponent strategicMsg = Component.m_237115_((String)"war.time.expired.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.strategic.defender.victory.part1").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)defenderColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.strategic.defender.victory.part2").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.strategic.defender.victory.part3").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)attackerColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.strategic.defender.victory.part4").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
            WarEconomyHandler.transferTeamBalanceToSinglePlayer(war.getAttackerTeamID(), war.getDefender(), TaxConfig.getWarStalematePercentage());
            if (war.getAttackerColony() != null) {
                TaxManager.deductColonyTax(war.getAttackerColony(), TaxConfig.getWarStalematePercentage());
            }
            WarSystem.broadcastComponent((Component)strategicMsg);
            for (UUID defUUID : war.getDefenderLives().keySet()) {
                ServerPlayer p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(defUUID);
                if (p == null) continue;
                PlayerWarDataManager.incrementWarsWon(p);
            }
        } else if (defenderNormalizedStrength + epsilon < attackerNormalizedStrength) {
            reportOutcome = "Strategic Victory: Attackers win! Defenders lost proportionally more strength.";
            MutableComponent strategicMsg = Component.m_237115_((String)"war.time.expired.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.strategic.attacker.victory.part1").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)attackerColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.strategic.attacker.victory.part2").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.strategic.attacker.victory.part3").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)defenderColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.strategic.attacker.victory.part4").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
            WarEconomyHandler.transferTeamBalanceToSinglePlayer(war.getDefenderTeamID(), war.getAttacker(), TaxConfig.getWarStalematePercentage());
            TaxManager.deductColonyTax(war.getColony(), TaxConfig.getWarStalematePercentage());
            WarSystem.broadcastComponent((Component)strategicMsg);
            for (UUID atkUUID : war.getAttackerLives().keySet()) {
                ServerPlayer p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(atkUUID);
                if (p == null) continue;
                PlayerWarDataManager.incrementWarsWon(p);
            }
        } else {
            reportOutcome = "Stalemate (Timeout - Proportional Losses): Both sides fought hard but neither gained a clear advantage. Penalties apply.";
            MutableComponent strategicMsg = Component.m_237115_((String)"war.time.expired.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.stalemate.proportional.part1").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)attackerColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.stalemate.proportional.part2").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)defenderColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.stalemate.proportional.part3").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.stalemate.proportional.penalties").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
            war.getAttackerLives().keySet().forEach(uuid -> WarEconomyHandler.deductTeamBalanceWithReport(uuid, TaxConfig.getWarStalematePercentage()));
            war.getDefenderLives().keySet().forEach(uuid -> WarEconomyHandler.deductTeamBalanceWithReport(uuid, TaxConfig.getWarStalematePercentage()));
            TaxManager.deductColonyTax(war.getColony(), TaxConfig.getWarStalematePercentage());
            if (war.getAttackerColony() != null) {
                TaxManager.deductColonyTax(war.getAttackerColony(), TaxConfig.getWarStalematePercentage());
            }
            WarSystem.broadcastComponent((Component)strategicMsg);
        }
        war.setPenaltyReport(reportOutcome);
        WarSystem.endWar(war.getColony());
    }

    private static void broadcastComponent(Component message) {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_(message, false);
    }

    public static void handleGuardKilled(WarData war, boolean isDefenderGuard) {
        if (isDefenderGuard) {
            --war.remainingDefenderGuards;
            MutableComponent message = Component.m_237110_((String)"war.guard.killed.defender", (Object[])new Object[]{war.getRemainingDefenderGuards()}).m_130938_(style -> style.m_131140_(ChatFormatting.RED));
            WarSystem.notifyWarParticipants(war, (Component)message);
        } else {
            --war.remainingAttackerGuards;
            MutableComponent message = Component.m_237110_((String)"war.guard.killed.attacker", (Object[])new Object[]{war.getRemainingAttackerGuards()}).m_130938_(style -> style.m_131140_(ChatFormatting.BLUE));
            WarSystem.notifyWarParticipants(war, (Component)message);
        }
        WarSystem.checkForVictory(war);
    }

    private static void notifyWarParticipants(WarData war, Component notification) {
        if (war.getColony().getWorld() == null || war.getColony().getWorld().m_7654_() == null) {
            return;
        }
        war.getAttackerLives().keySet().forEach(uuid -> {
            ServerPlayer player = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid);
            if (player != null) {
                player.m_213846_(notification);
            }
        });
        war.getDefenderLives().keySet().forEach(uuid -> {
            ServerPlayer player = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid);
            if (player != null) {
                player.m_213846_(notification);
            }
        });
    }

    private static void notifyWarParticipants(WarData war, String message, ChatFormatting color) {
        MutableComponent notification = Component.m_237113_((String)message).m_130938_(style -> style.m_131140_(color));
        WarSystem.notifyWarParticipants(war, (Component)notification);
    }

    private static void handleVictoryRewards(WarData war, boolean defendersWon) {
        IColony loserColony;
        Map<UUID, Integer> winnerLives = defendersWon ? war.getDefenderLives() : war.getAttackerLives();
        IColony iColony = loserColony = defendersWon ? war.getAttackerColony() : war.getColony();
        if (((Boolean)TaxConfig.ENABLE_COLONY_TRANSFER.get()).booleanValue() && !defendersWon) {
            WarSystem.transferOwnership(war.getColony(), war.getAttacker());
            war.setPenaltyReport("TOTAL VICTORY - Colony transferred to attackers!");
        } else {
            if (loserColony == null) {
                war.setPenaltyReport("TOTAL VICTORY - Loser colony not found for economic penalties.");
                return;
            }
            int colonyBalance = TaxManager.getStoredTaxForColony(loserColony);
            double victoryPercentage = (Double)TaxConfig.WAR_VICTORY_PERCENTAGE.get();
            double defeatPercentage = (Double)TaxConfig.WAR_DEFEAT_PERCENTAGE.get();
            long transferAmount = Math.max(100L, (long)((double)colonyBalance * victoryPercentage));
            TaxManager.deductColonyTax(loserColony, defeatPercentage);
            if (!winnerLives.isEmpty() && war.getColony().getWorld() != null && war.getColony().getWorld().m_7654_() != null) {
                int sharePerPlayer = winnerLives.size() > 0 ? (int)(transferAmount / (long)winnerLives.size()) : 0;
                for (UUID uuid : winnerLives.keySet()) {
                    ServerPlayer player = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid);
                    if (player == null) continue;
                    player.m_213846_((Component)Component.m_237113_((String)("You received " + sharePerPlayer + " as war spoils!")).m_130940_(ChatFormatting.GOLD));
                }
            }
            war.setPenaltyReport("TOTAL VICTORY - " + transferAmount + " transferred from " + loserColony.getName() + "!");
        }
    }

    public static Map<UUID, Integer> getLivesForPlayer(WarData war, ServerPlayer player) {
        Rank playerRank;
        System.out.println("[DEBUG] getLivesForPlayer called for player " + player.m_7755_().getString() + " (" + player.m_20148_() + ")");
        System.out.println("[DEBUG] FTB_TEAMS_INSTALLED: " + FTB_TEAMS_INSTALLED);
        System.out.println("[DEBUG] Attacker lives: " + war.getAttackerLives());
        System.out.println("[DEBUG] Defender lives: " + war.getDefenderLives());
        UUID playerUUID = player.m_20148_();
        System.out.println("[DEBUG] Checking if attacker lives contains player UUID: " + war.getAttackerLives().containsKey(playerUUID));
        System.out.println("[DEBUG] Checking if defender lives contains player UUID: " + war.getDefenderLives().containsKey(playerUUID));
        if (war.getAttackerLives().containsKey(playerUUID)) {
            System.out.println("[DEBUG] Player found in attacker lives, returning attacker lives");
            return war.getAttackerLives();
        }
        if (war.getDefenderLives().containsKey(playerUUID)) {
            System.out.println("[DEBUG] Player found in defender lives, returning defender lives");
            return war.getDefenderLives();
        }
        if (war.getAttackerAllies().contains(playerUUID)) {
            System.out.println("[DEBUG] Player found in attacker allies, returning attacker lives");
            return war.getAttackerLives();
        }
        if (war.getDefenderAllies().contains(playerUUID)) {
            System.out.println("[DEBUG] Player found in defender allies, returning defender lives");
            return war.getDefenderLives();
        }
        if (FTB_TEAMS_INSTALLED && FTB_TEAM_MANAGER != null) {
            Optional teamOpt = FTB_TEAM_MANAGER.getPlayerTeamForPlayerID(playerUUID);
            System.out.println("[DEBUG] Player team found: " + teamOpt.isPresent());
            if (teamOpt.isPresent()) {
                Team team = (Team)teamOpt.get();
                System.out.println("[DEBUG] Player team ID: " + team.getId());
                System.out.println("[DEBUG] War attacker team ID: " + war.getAttackerTeamID());
                System.out.println("[DEBUG] War defender team ID: " + war.getDefenderTeamID());
                if (team.getId().equals(war.getAttackerTeamID())) {
                    System.out.println("[DEBUG] Player is on attacker team, returning attacker lives");
                    return war.getAttackerLives();
                }
                if (team.getId().equals(war.getDefenderTeamID())) {
                    System.out.println("[DEBUG] Player is on defender team, returning defender lives");
                    return war.getDefenderLives();
                }
                Team atkTeam = FTB_TEAM_MANAGER.getTeamByID(war.getAttackerTeamID()).orElse(null);
                if (atkTeam != null && atkTeam.isPartyTeam() && ((PartyTeam)atkTeam).getMembers().contains(playerUUID)) {
                    System.out.println("[DEBUG] Player is allied to attacker team, returning attacker lives");
                    return war.getAttackerLives();
                }
                Team defTeam = FTB_TEAM_MANAGER.getTeamByID(war.getDefenderTeamID()).orElse(null);
                if (defTeam != null && defTeam.isPartyTeam() && ((PartyTeam)defTeam).getMembers().contains(playerUUID)) {
                    System.out.println("[DEBUG] Player is allied to defender team, returning defender lives");
                    return war.getDefenderLives();
                }
                System.out.println("[DEBUG] Player team not participating in war, checking Minecolonies membership");
            } else {
                System.out.println("[DEBUG] Player has no FTB team, checking Minecolonies membership");
            }
        }
        IColony attackerColony = war.getAttackerColony();
        IColony defenderColony = war.getColony();
        System.out.println("[DEBUG] Checking Minecolonies membership - Attacker colony: " + (attackerColony != null ? attackerColony.getName() : "null"));
        System.out.println("[DEBUG] Checking Minecolonies membership - Defender colony: " + (defenderColony != null ? defenderColony.getName() : "null"));
        if (attackerColony != null) {
            IPermissions attackerPerms = attackerColony.getPermissions();
            System.out.println("[DEBUG] Player in attacker colony players list: " + attackerPerms.getPlayers().containsKey(playerUUID));
            if (attackerPerms.getPlayers().containsKey(playerUUID)) {
                playerRank = attackerPerms.getRank(playerUUID);
                System.out.println("[DEBUG] Player rank in attacker colony: " + (playerRank != null ? playerRank.getName() : "null"));
                if (playerRank != null && (playerRank.equals((Object)attackerPerms.getRankOwner()) || playerRank.equals((Object)attackerPerms.getRankOfficer()) || playerRank.equals((Object)attackerPerms.getRankFriend()))) {
                    System.out.println("[DEBUG] Player is in attacker colony with rank " + playerRank.getName() + ", returning attacker lives");
                    return war.getAttackerLives();
                }
            }
        }
        if (defenderColony != null) {
            IPermissions defenderPerms = defenderColony.getPermissions();
            System.out.println("[DEBUG] Player in defender colony players list: " + defenderPerms.getPlayers().containsKey(playerUUID));
            if (defenderPerms.getPlayers().containsKey(playerUUID)) {
                playerRank = defenderPerms.getRank(playerUUID);
                System.out.println("[DEBUG] Player rank in defender colony: " + (playerRank != null ? playerRank.getName() : "null"));
                if (playerRank != null && (playerRank.equals((Object)defenderPerms.getRankOwner()) || playerRank.equals((Object)defenderPerms.getRankOfficer()) || playerRank.equals((Object)defenderPerms.getRankFriend()))) {
                    System.out.println("[DEBUG] Player is in defender colony with rank " + playerRank.getName() + ", returning defender lives");
                    return war.getDefenderLives();
                }
            }
        }
        System.out.println("[DEBUG] Player not participating in war, returning empty map");
        return new HashMap<UUID, Integer>();
    }

    public static WarData getActiveWarForPlayer(ServerPlayer player) {
        for (WarData war : ACTIVE_WARS.values()) {
            IPermissions defenderPerms;
            Rank playerRank;
            IPermissions attackerPerms;
            Optional teamOpt;
            if (war.getAttackerLives().containsKey(player.m_20148_()) || war.getDefenderLives().containsKey(player.m_20148_())) {
                return war;
            }
            if (war.getAttackerAllies().contains(player.m_20148_()) || war.getDefenderAllies().contains(player.m_20148_())) {
                return war;
            }
            if (FTB_TEAMS_INSTALLED && FTB_TEAM_MANAGER != null && (teamOpt = FTB_TEAM_MANAGER.getTeamForPlayerID(player.m_20148_())).isPresent()) {
                Team team = (Team)teamOpt.get();
                if (team.getId().equals(war.getAttackerTeamID()) || team.getId().equals(war.getDefenderTeamID())) {
                    return war;
                }
                Team atkTeam = FTB_TEAM_MANAGER.getTeamByID(war.getAttackerTeamID()).orElse(null);
                if (atkTeam != null && atkTeam.isPartyTeam() && ((PartyTeam)atkTeam).getMembers().contains(player.m_20148_())) {
                    return war;
                }
                Team defTeam = FTB_TEAM_MANAGER.getTeamByID(war.getDefenderTeamID()).orElse(null);
                if (defTeam != null && defTeam.isPartyTeam() && ((PartyTeam)defTeam).getMembers().contains(player.m_20148_())) {
                    return war;
                }
            }
            IColony attackerColony = war.getAttackerColony();
            IColony defenderColony = war.getColony();
            if (attackerColony != null && (attackerPerms = attackerColony.getPermissions()).getPlayers().containsKey(player.m_20148_()) && (playerRank = attackerPerms.getRank(player.m_20148_())) != null && (playerRank.equals((Object)attackerPerms.getRankOwner()) || playerRank.equals((Object)attackerPerms.getRankOfficer()) || playerRank.equals((Object)attackerPerms.getRankFriend()))) {
                return war;
            }
            if (defenderColony == null || !(defenderPerms = defenderColony.getPermissions()).getPlayers().containsKey(player.m_20148_()) || (playerRank = defenderPerms.getRank(player.m_20148_())) == null || !playerRank.equals((Object)defenderPerms.getRankOwner()) && !playerRank.equals((Object)defenderPerms.getRankOfficer()) && !playerRank.equals((Object)defenderPerms.getRankFriend())) continue;
            return war;
        }
        return null;
    }

    public static void scheduleTimerWarnings(final WarData war, long warDurationMillis) {
        Timer warningTimer = new Timer();
        long quarter = warDurationMillis / 4L;
        for (int i = 1; i <= 3; ++i) {
            long delay = quarter * (long)i;
            if (delay <= 0L) continue;
            warningTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!ACTIVE_WARS.containsKey(war.getColony().getID()) || war.getColony().getWorld() == null || war.getColony().getWorld().m_7654_() == null || war.bossEvent == null) {
                        this.cancel();
                        return;
                    }
                    if (war.getStatus() != WarData.WarStatus.INWAR) {
                        this.cancel();
                        return;
                    }
                    long elapsedSeconds = (System.currentTimeMillis() - war.warStartTime) / 1000L;
                    long warDurationSeconds = (long)((Integer)TaxConfig.WAR_DURATION_MINUTES.get()).intValue() * 60L;
                    long remaining = Math.max(0L, warDurationSeconds - elapsedSeconds);
                    String bossText = String.format("War: Attacker Lives: %d | Defender Lives: %d | Time: %02d:%02d", war.getAttackerLives().values().stream().mapToInt(Integer::intValue).sum(), war.getDefenderLives().values().stream().mapToInt(Integer::intValue).sum(), remaining / 60L, remaining % 60L);
                    MutableComponent newName = Component.m_237113_((String)bossText);
                    float newProgress = (float)remaining / (float)warDurationSeconds;
                    war.bossEvent.m_6456_((Component)newName);
                    war.bossEvent.m_142711_(newProgress);
                    war.bossEvent.m_8321_(true);
                    if (remaining <= 0L) {
                        WarSystem.handleTimeExpiry(war);
                        this.cancel();
                    }
                }
            }, delay);
        }
    }

    private static void applyWarGlowToParticipants(WarData war) {
        if (war.getColony().getWorld() == null || war.getColony().getWorld().m_7654_() == null) {
            return;
        }
        war.getAttackerLives().keySet().forEach(uuid -> {
            ServerPlayer p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid);
            if (p != null) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 999999, 0, false, false));
            }
        });
        war.getDefenderLives().keySet().forEach(uuid -> {
            ServerPlayer p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid);
            if (p != null) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 999999, 0, false, false));
            }
        });
    }

    public static void applyGuardGlow(IColony colony) {
        if (colony.getCitizenManager() == null) {
            return;
        }
        colony.getCitizenManager().getCitizens().stream().filter(citizen -> citizen.getJob() != null && citizen.getJob().isGuard()).forEach(citizen -> citizen.getEntity().ifPresent(entity -> entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 999999, 0, false, false))));
    }

    private static void broadcast(String message, ChatFormatting color) {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        MutableComponent msg = Component.m_237113_((String)message).m_130948_(Style.f_131099_.m_131140_(color).m_131136_(Boolean.valueOf(true)));
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_((Component)msg, false);
    }

    public static void onPlayerKilledInWar(ServerPlayer killer, ServerPlayer killed, WarData war) {
        if (killer != null && killed != null && war != null) {
            PlayerWarDataManager.incrementPlayersKilledInWar(killer);
        }
    }

    public static void startJoinPhase(IColony colony, ServerPlayer attacker, ServerPlayer owner) {
        Team attackerTeam = FTB_TEAMS_INSTALLED && FTB_TEAM_MANAGER != null ? (Team)FTB_TEAM_MANAGER.getTeamForPlayerID(attacker.m_20148_()).orElse(null) : null;
        Team defenderTeam = FTB_TEAMS_INSTALLED && FTB_TEAM_MANAGER != null ? (Team)FTB_TEAM_MANAGER.getTeamForPlayerID(owner.m_20148_()).orElse(null) : null;
        IColony attackerColony = IColonyManager.getInstance().getColonies(attacker.m_9236_()).stream().filter(c -> c.getPermissions().getOwner().equals(attacker.m_20148_())).findFirst().orElse(null);
        if (attackerColony == null) {
            attacker.m_213846_((Component)Component.m_237113_((String)"You must own a colony to declare war.").m_130938_(style -> style.m_131140_(ChatFormatting.RED)));
            return;
        }
        WarSystem.initiateWar(attacker, owner.m_20148_(), attackerTeam, defenderTeam, colony, attackerColony);
        final WarData war = WarSystem.getActiveWarForPlayer(owner);
        int configuredMinutes = (Integer)TaxConfig.JOIN_PHASE_DURATION_MINUTES.get();
        WARSYSTEM_LOGGER.info("[DEBUG] JOIN_PHASE_DURATION_MINUTES config value: {} minutes", (Object)configuredMinutes);
        WARSYSTEM_LOGGER.info("[DEBUG] Config spec: {}", (Object)TaxConfig.CONFIG.getClass().getName());
        WARSYSTEM_LOGGER.info("[DEBUG] Config default value: {}", TaxConfig.JOIN_PHASE_DURATION_MINUTES.getDefault());
        WARSYSTEM_LOGGER.info("[DEBUG] Config is loaded: {}", (Object)TaxConfig.CONFIG.isLoaded());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            String timeRemaining = configuredMinutes + " minutes";
            ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_((Component)Component.m_237110_((String)"war.join.phase.declared", (Object[])new Object[]{colony.getName(), timeRemaining}), false);
        }
        WARSYSTEM_LOGGER.info("Join phase started for colony {}. Waiting for participants for {} seconds.", (Object)colony.getName(), (Object)(configuredMinutes * 60));
        if (war == null) {
            return;
        }
        long joinDurationMillis = (long)((Integer)TaxConfig.JOIN_PHASE_DURATION_MINUTES.get() * 60) * 1000L;
        war.setJoinPhaseEndTime(System.currentTimeMillis() + joinDurationMillis);
        war.alliesBossEvent = new ServerBossEvent((Component)Component.m_237113_((String)("Joining War - " + colony.getName())), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);
        war.alliesBossEvent.m_142711_(1.0f);
        war.alliesBossEvent.m_8321_(true);
        if (colony.getWorld() != null && colony.getWorld().m_7654_() != null) {
            ServerPlayer p;
            ServerPlayer ownerPlayer = colony.getWorld().m_7654_().m_6846_().m_11259_(war.getColony().getPermissions().getOwner());
            if (ownerPlayer != null) {
                war.bossEvent.m_6543_(ownerPlayer);
            }
            for (UUID uuid : war.getAttackerLives().keySet()) {
                p = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid);
                if (p == null) continue;
                war.bossEvent.m_6543_(p);
            }
            for (UUID uuid : war.getDefenderLives().keySet()) {
                p = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid);
                if (p == null) continue;
                war.bossEvent.m_6543_(p);
            }
        }
        MutableComponent joinAnnouncement = Component.m_237119_().m_7220_(JOIN_MSG).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_(LEAVE_MSG);
        if (FTB_TEAMS_INSTALLED && FTB_TEAM_MANAGER != null) {
            if (attackerTeam != null) {
                WarSystem.sendNotificationToColonyParticipants(attackerColony, (Component)joinAnnouncement);
            }
            if (defenderTeam != null) {
                WarSystem.sendNotificationToColonyParticipants(colony, (Component)joinAnnouncement);
            }
        } else {
            WarSystem.sendNotificationToColonyParticipants(attackerColony, (Component)joinAnnouncement);
            WarSystem.sendNotificationToColonyParticipants(colony, (Component)joinAnnouncement);
        }
        long remainingMillis = war.getJoinPhaseEndTime() - System.currentTimeMillis();
        remainingMillis = Math.max(0L, remainingMillis);
        MutableComponent joinPhaseInfo = Component.m_237110_((String)"war.siege.status", (Object[])new Object[]{colony.getName(), String.format("%02d:%02d", remainingMillis / 60000L, remainingMillis / 1000L % 60L)}).m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)));
        if (FTB_TEAMS_INSTALLED && FTB_TEAM_MANAGER != null) {
            if (attackerTeam != null) {
                WarSystem.sendNotificationToColonyParticipants(attackerColony, (Component)joinPhaseInfo);
            }
            if (defenderTeam != null) {
                WarSystem.sendNotificationToColonyParticipants(colony, (Component)joinPhaseInfo);
            }
        } else {
            WarSystem.sendNotificationToColonyParticipants(attackerColony, (Component)joinPhaseInfo);
            WarSystem.sendNotificationToColonyParticipants(colony, (Component)joinPhaseInfo);
        }
        if (joinDurationMillis >= 6000L) {
            new Timer().schedule(new TimerTask(){
                int secondsLeft = 6;

                @Override
                public void run() {
                    try {
                        if (war == null || war.getColony() == null || !war.isJoinPhaseActive()) {
                            this.cancel();
                            return;
                        }
                        HashSet<UUID> allParticipants = new HashSet<UUID>();
                        allParticipants.addAll(war.getAttackerLives().keySet());
                        allParticipants.addAll(war.getDefenderLives().keySet());
                        if (!allParticipants.isEmpty()) {
                            for (UUID uuid : allParticipants) {
                                ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
                                if (player == null) continue;
                                player.m_5496_((SoundEvent)SoundEvents.f_12210_.get(), 1.0f, 1.0f);
                            }
                        }
                        WarSystem.notifyWarParticipants(war, (Component)Component.m_237113_((String)("\u23f1 " + this.secondsLeft + (this.secondsLeft == 1 ? " second" : " seconds") + " until war starts!")).m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true))));
                        --this.secondsLeft;
                        if (this.secondsLeft < 0) {
                            this.cancel();
                        }
                    }
                    catch (Exception ex) {
                        WARSYSTEM_LOGGER.error("Error in countdown timer: " + ex.getMessage(), (Throwable)ex);
                        this.cancel();
                    }
                }
            }, Math.max(0L, joinDurationMillis - 6000L), 1000L);
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (war == null || war.getColony() == null) {
                    this.cancel();
                    return;
                }
                war.setStatus(WarData.WarStatus.INWAR);
                war.warStartTime = System.currentTimeMillis();
                WarSystem.finalizeWarStart(war);
                WarSystem.setWarInteractionPermissions(war.getColony(), true);
                if (war.getAttackerColony() != null) {
                    WarSystem.setWarInteractionPermissions(war.getAttackerColony(), true);
                }
                WarSystem.startWarCountdown(war);
            }
        }, joinDurationMillis);
        war.setAccepted(true);
    }

    private static void sendNotificationToColonyParticipants(IColony colony, Component message) {
        if (colony == null || colony.getWorld() == null || colony.getWorld().m_7654_() == null) {
            return;
        }
        colony.getPermissions().getPlayers().keySet().stream().filter(uuid -> WarSystem.isOfficerOrFriendly(colony, uuid)).forEach(uuid -> {
            ServerPlayer player = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid);
            if (player != null) {
                player.m_213846_(message);
            }
        });
    }

    private static void startWarCountdown(final WarData warData) {
        if (warData.getColony().getWorld() == null) {
            WARSYSTEM_LOGGER.error("Cannot start war countdown, world is null for colony {}", (Object)warData.getColony().getID());
            return;
        }
        final long warDurationSeconds = (long)((Integer)TaxConfig.WAR_DURATION_MINUTES.get()).intValue() * 60L;
        warData.timerTask = new TimerTask(){

            @Override
            public void run() {
                if (!ACTIVE_WARS.containsKey(warData.getColony().getID()) || warData.getColony().getWorld() == null || warData.getColony().getWorld().m_7654_() == null || warData.bossEvent == null) {
                    this.cancel();
                    return;
                }
                if (warData.getStatus() != WarData.WarStatus.INWAR) {
                    this.cancel();
                    return;
                }
                long elapsedSeconds = (System.currentTimeMillis() - warData.warStartTime) / 1000L;
                long remaining = Math.max(0L, warDurationSeconds - elapsedSeconds);
                String bossText = String.format("War: Attacker Lives: %d | Defender Lives: %d | Time: %02d:%02d", warData.getAttackerLives().values().stream().mapToInt(Integer::intValue).sum(), warData.getDefenderLives().values().stream().mapToInt(Integer::intValue).sum(), remaining / 60L, remaining % 60L);
                MutableComponent newName = Component.m_237113_((String)bossText);
                float newProgress = (float)remaining / (float)warDurationSeconds;
                warData.bossEvent.m_6456_((Component)newName);
                warData.bossEvent.m_142711_(newProgress);
                warData.bossEvent.m_8321_(true);
                if (remaining <= 0L) {
                    WarSystem.handleTimeExpiry(warData);
                    this.cancel();
                }
            }
        };
        new Timer().scheduleAtFixedRate(warData.timerTask, 1000L, 1000L);
    }

    public static void sendColonyMessage(IColony colony, Component message) {
        if (colony == null || colony.getWorld() == null) {
            return;
        }
        colony.getPermissions().getPlayers().forEach((uuid, data) -> {
            ServerPlayer p = (ServerPlayer)colony.getWorld().m_46003_(uuid);
            if (p != null) {
                p.m_213846_(message);
            }
        });
    }

    public static void sendMessageToTeam(Team team, Component msg) {
        if (team == null || ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        for (UUID member : team.getMembers()) {
            ServerPlayer sp = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(member);
            if (sp == null) continue;
            sp.m_213846_(msg);
        }
    }

    public static int processWageWarRequest(final ServerPlayer attacker, final IColony targetColony, CommandSourceStack source) {
        ServerLevel level = source.m_81372_();
        int targetGuards = WarSystem.countGuards(targetColony);
        if (targetGuards < (Integer)TaxConfig.MIN_GUARDS_TO_WAGE_WAR.get()) {
            source.m_81352_((Component)Component.m_237113_((String)("Target colony must have at least " + TaxConfig.MIN_GUARDS_TO_WAGE_WAR.get() + " guards! (Found: " + targetGuards + ")")));
            return 0;
        }
        IColony attackerColony = IColonyManager.getInstance().getColonies((Level)level).stream().filter(c -> c.getPermissions().getOwner().equals(attacker.m_20148_())).findFirst().orElse(null);
        if (attackerColony == null) {
            source.m_81352_((Component)Component.m_237113_((String)"You must own a colony to declare war."));
            return 0;
        }
        if (TaxConfig.isWarBuildingRequirementsEnabled()) {
            BuildingRequirementsManager.RequirementResult warRequirements = BuildingRequirementsManager.checkWarRequirements(attackerColony);
            if (!warRequirements.meetsRequirements) {
                source.m_81352_((Component)Component.m_237113_((String)("Cannot declare war: " + warRequirements.message)).m_130940_(ChatFormatting.RED));
                return 0;
            }
        } else {
            int attackerGuards = WarSystem.countGuards(attackerColony);
            if (attackerGuards < (Integer)TaxConfig.MIN_GUARDS_TO_WAGE_WAR.get()) {
                source.m_81352_((Component)Component.m_237113_((String)("Your colony must have at least " + TaxConfig.MIN_GUARDS_TO_WAGE_WAR.get() + " guards! (Found: " + attackerGuards + ")")));
                return 0;
            }
        }
        if (targetColony.getID() == attackerColony.getID()) {
            source.m_81352_((Component)Component.m_237113_((String)"Cannot declare war on your own colony!"));
            return 0;
        }
        ServerPlayer owner = level.m_7654_().m_6846_().m_11259_(targetColony.getPermissions().getOwner());
        if (owner == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Target colony owner is offline!"));
            return 0;
        }
        if (!((Boolean)TaxConfig.WAR_ACCEPTANCE_REQUIRED.get()).booleanValue()) {
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                MutableComponent autoAcceptMsg = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"\u2694\ufe0f WAR INITIATED \u2694\ufe0f").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"\n----------------------------------------").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\nColony ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)targetColony.getName()).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)" is now at WAR with ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)attackerColony.getName()).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"! (Auto-Accepted)").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\nThe drums of war sound! Join phase starting immediately!").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"\n----------------------------------------").m_130940_(ChatFormatting.DARK_GRAY));
                ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_((Component)autoAcceptMsg, false);
            }
            WarSystem.startJoinPhase(targetColony, attacker, owner);
            return 1;
        }
        WARSYSTEM_LOGGER.info("Adding pending war request for colony {} from attacker {}", (Object)targetColony.getID(), (Object)attacker.m_20148_());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            String attackerColonyName = attackerColony != null ? attackerColony.getName() : attacker.m_7755_().getString() + "'s forces";
            MutableComponent warDeclarationMsg = Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"war.declare.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.forces.valiant").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)attackerColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237110_((String)"war.declare.body", (Object[])new Object[]{"", targetColony.getName()}).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
            ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_((Component)warDeclarationMsg, false);
        }
        pendingWarRequests.put(targetColony.getID(), new WarRequest(attacker.m_20148_(), targetColony.getID()));
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Object removedRequest = pendingWarRequests.remove(targetColony.getID());
                if (removedRequest != null && targetColony.getWorld() != null && targetColony.getWorld().m_7654_() != null) {
                    ServerPlayer attackerPlayer;
                    ServerPlayer targetOwner = targetColony.getWorld().m_7654_().m_6846_().m_11259_(targetColony.getPermissions().getOwner());
                    if (targetOwner != null) {
                        targetOwner.m_213846_((Component)Component.m_237115_((String)"war.request.expired.defender").m_130938_(style -> style.m_131140_(ChatFormatting.RED)));
                    }
                    if ((attackerPlayer = targetColony.getWorld().m_7654_().m_6846_().m_11259_(attacker.m_20148_())) != null) {
                        attackerPlayer.m_213846_((Component)Component.m_237110_((String)"war.request.expired.attacker", (Object[])new Object[]{targetColony.getName()}).m_130938_(style -> style.m_131140_(ChatFormatting.RED)));
                    }
                }
            }
        }, 30000L);
        Rank playerRank = targetColony.getPermissions().getRank(attacker.m_20148_());
        if (playerRank == null) {
            Rank hostileRank = targetColony.getPermissions().getRankHostile();
            targetColony.getPermissions().addPlayer(attacker.m_36316_(), hostileRank);
        } else {
            targetColony.getPermissions().setPlayerRank(attacker.m_20148_(), targetColony.getPermissions().getRankHostile(), (Level)level);
        }
        Rank currentRank = targetColony.getPermissions().getRank(attacker.m_20148_());
        if (currentRank != null) {
            currentRank.setHostile(true);
        }
        MutableComponent message = Component.m_237113_((String)"\u2694\ufe0f WAR DECLARATION \u2694\ufe0f").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED).m_131136_(Boolean.valueOf(true))).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)attacker.m_7755_().getString()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)" seeks to wage war against your colony!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW))).m_7220_((Component)Component.m_237113_((String)"\n\nDo you accept this challenge?").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_(WarSystem.createAcceptButton(targetColony)).m_130946_(" ").m_7220_(WarSystem.createDeclineButton(targetColony));
        owner.m_213846_((Component)message);
        attacker.m_213846_((Component)Component.m_237110_((String)"war.request.sent", (Object[])new Object[]{targetColony.getName()}).m_130940_(ChatFormatting.YELLOW));
        WARSYSTEM_LOGGER.info("[War] Attacker UUID: {}", (Object)attacker.m_20148_());
        WARSYSTEM_LOGGER.info("[War] Target Colony Owner: {}", (Object)targetColony.getPermissions().getOwner());
        return 1;
    }

    public static int processWageWarRequestWithExtortion(ServerPlayer attacker, IColony targetColony, CommandSourceStack source, int extortionPercent) {
        ServerLevel level = source.m_81372_();
        int targetGuards = WarSystem.countGuards(targetColony);
        if (targetGuards < (Integer)TaxConfig.MIN_GUARDS_TO_WAGE_WAR.get()) {
            source.m_81352_((Component)Component.m_237113_((String)("Target colony must have at least " + TaxConfig.MIN_GUARDS_TO_WAGE_WAR.get() + " guards! (Found: " + targetGuards + ")")));
            return 0;
        }
        IColony attackerColony = IColonyManager.getInstance().getColonies((Level)level).stream().filter(c -> c.getPermissions().getOwner().equals(attacker.m_20148_())).findFirst().orElse(null);
        if (attackerColony == null) {
            source.m_81352_((Component)Component.m_237113_((String)"You must own a colony to declare war."));
            return 0;
        }
        if (TaxConfig.isWarBuildingRequirementsEnabled()) {
            BuildingRequirementsManager.RequirementResult warRequirements = BuildingRequirementsManager.checkWarRequirements(attackerColony);
            if (!warRequirements.meetsRequirements) {
                source.m_81352_((Component)Component.m_237113_((String)("Cannot declare war: " + warRequirements.message)).m_130940_(ChatFormatting.RED));
                return 0;
            }
        } else {
            int attackerGuards = WarSystem.countGuards(attackerColony);
            if (attackerGuards < (Integer)TaxConfig.MIN_GUARDS_TO_WAGE_WAR.get()) {
                source.m_81352_((Component)Component.m_237113_((String)("Your colony must have at least " + TaxConfig.MIN_GUARDS_TO_WAGE_WAR.get() + " guards! (Found: " + attackerGuards + ")")));
                return 0;
            }
        }
        if (targetColony.getID() == attackerColony.getID()) {
            source.m_81352_((Component)Component.m_237113_((String)"Cannot declare war on your own colony!"));
            return 0;
        }
        ServerPlayer owner = level.m_7654_().m_6846_().m_11259_(targetColony.getPermissions().getOwner());
        if (owner == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Target colony owner is offline!"));
            return 0;
        }
        if (!((Boolean)TaxConfig.ENABLE_EXTORTION_SYSTEM.get()).booleanValue()) {
            source.m_81352_((Component)Component.m_237113_((String)"Extortion system is disabled. Use regular war declaration."));
            return 0;
        }
        if (WarSystem.hasExtortionImmunity(targetColony.getID())) {
            long immunityExpiration = extortionImmunity.get(targetColony.getID());
            long hoursRemaining = (immunityExpiration - System.currentTimeMillis()) / 3600000L;
            source.m_81352_((Component)Component.m_237113_((String)("Colony " + targetColony.getName() + " has extortion immunity for " + hoursRemaining + " more hours. Use regular war declaration.")));
            return 0;
        }
        if (!((Boolean)TaxConfig.WAR_ACCEPTANCE_REQUIRED.get()).booleanValue()) {
            WarSystem.showExtortionChoiceWithTimer(attacker, targetColony, owner, extortionPercent);
            return 1;
        }
        WARSYSTEM_LOGGER.info("Adding pending war request with extortion for colony {} from attacker {}", (Object)targetColony.getID(), (Object)attacker.m_20148_());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            String attackerColonyName = attackerColony != null ? attackerColony.getName() : attacker.m_7755_().getString() + "'s forces";
            MutableComponent warDeclarationMsg = Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"war.declare.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.forces.valiant").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)attackerColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237110_((String)"war.declare.body", (Object[])new Object[]{"", targetColony.getName()}).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)("\n\ud83d\udcb0 Extortion Demand: " + extortionPercent + "% of your balance")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"war.time.expired.separator").m_130940_(ChatFormatting.DARK_GRAY));
            ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_((Component)warDeclarationMsg, false);
        }
        pendingWarRequests.put(targetColony.getID(), new WarRequestWithExtortion(attacker.m_20148_(), targetColony.getID(), extortionPercent));
        MutableComponent message = Component.m_237113_((String)"\u2694\ufe0f WAR DECLARATION WITH EXTORTION \u2694\ufe0f").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED).m_131136_(Boolean.valueOf(true))).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)attacker.m_7755_().getString()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)" seeks to wage war against your colony!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW))).m_7220_((Component)Component.m_237113_((String)("\n\ud83d\udcb0 Extortion Demand: " + extortionPercent + "% of your balance")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD))).m_7220_((Component)Component.m_237113_((String)"\n\nChoose your response:").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_(WarSystem.createAcceptButton(targetColony)).m_130946_(" ").m_7220_(WarSystem.createDeclineButton(targetColony)).m_130946_(" ").m_7220_((Component)WarSystem.createPayExtortionButton(targetColony, extortionPercent));
        owner.m_213846_((Component)message);
        attacker.m_213846_((Component)Component.m_237113_((String)("War declaration with " + extortionPercent + "% extortion demand sent to " + targetColony.getName())).m_130940_(ChatFormatting.YELLOW));
        return 1;
    }

    public static int processWarResponse(ServerPlayer executor, int colonyId, boolean accepted, CommandSourceStack source) {
        boolean isAuthorized;
        Object requestObj = pendingWarRequests.get(colonyId);
        UUID attackerUUID = null;
        if (requestObj instanceof WarRequest) {
            WarRequest wr = (WarRequest)requestObj;
            attackerUUID = wr.attacker();
        } else if (requestObj instanceof WarRequestWithExtortion) {
            WarRequestWithExtortion wre = (WarRequestWithExtortion)requestObj;
            attackerUUID = wre.attacker();
        }
        if (attackerUUID == null) {
            source.m_81352_((Component)Component.m_237113_((String)("No active war request found for colony ID " + colonyId + ". Only an authorized officer or the colony owner may accept.")).m_130938_(s -> s.m_131140_(ChatFormatting.RED)));
            WARSYSTEM_LOGGER.warn("No pending war or extortion war request found for colony ID {} when {} attempted to respond.", (Object)colonyId, (Object)executor.m_7755_().getString());
            return 0;
        }
        IColony targetColony = IColonyManager.getInstance().getColonyByDimension(colonyId, source.m_81372_().m_46472_());
        if (targetColony == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Target colony not found.").m_130938_(s -> s.m_131140_(ChatFormatting.RED)));
            WARSYSTEM_LOGGER.error("Target colony (ID {}) not found during war response by {}.", (Object)colonyId, (Object)executor.m_7755_().getString());
            return 0;
        }
        Rank executorRank = targetColony.getPermissions().getRank(executor.m_20148_());
        boolean bl = isAuthorized = targetColony.getPermissions().getOwner().equals(executor.m_20148_()) || executorRank != null && executorRank.isColonyManager();
        if (!isAuthorized) {
            source.m_81352_((Component)Component.m_237113_((String)"You are not authorized to accept/decline this war request.").m_130938_(s -> s.m_131140_(ChatFormatting.RED)));
            WARSYSTEM_LOGGER.warn("{} is not authorized to respond to war request for colony {}.", (Object)executor.m_7755_().getString(), (Object)targetColony.getName());
            return 0;
        }
        ServerPlayer attacker = source.m_81377_() != null ? source.m_81377_().m_6846_().m_11259_(attackerUUID) : null;
        if (attacker == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Attacker is offline!").m_130938_(s -> s.m_131140_(ChatFormatting.RED)));
            WARSYSTEM_LOGGER.warn("Attacker {} is offline when {} tried to respond to war request for colony {}.", (Object)attackerUUID, (Object)executor.m_7755_().getString(), (Object)targetColony.getName());
            return 0;
        }
        pendingWarRequests.remove(colonyId);
        if (accepted) {
            WARSYSTEM_LOGGER.info("War request for colony {} accepted by {}.", (Object)targetColony.getID(), (Object)executor.m_7755_().getString());
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                IColony attackerColony = IColonyManager.getInstance().getColonies(attacker.m_9236_()).stream().filter(c -> c.getPermissions().getOwner().equals(attacker.m_20148_())).findFirst().orElse(null);
                String attackerColonyName = attackerColony != null ? attackerColony.getName() : attacker.m_7755_().getString() + "'s forces";
                MutableComponent warAcceptedMsg = Component.m_237113_((String)"\u2705 WAR ACCEPTED! \u2705").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\n----------------------------------------").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\nThe colony of ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)targetColony.getName()).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)" (led by ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)executor.m_7755_().getString()).m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)") has accepted the challenge! War against ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)attackerColonyName).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)" will now proceed to the join phase!").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"\n----------------------------------------").m_130940_(ChatFormatting.DARK_GRAY));
                ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_((Component)warAcceptedMsg, false);
            }
            WarSystem.startJoinPhase(targetColony, attacker, executor);
        } else {
            WARSYSTEM_LOGGER.info("War request for colony {} declined by {}.", (Object)targetColony.getID(), (Object)executor.m_7755_().getString());
            executor.m_213846_((Component)Component.m_237113_((String)"\u274c War declaration declined!").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            attacker.m_213846_((Component)Component.m_237113_((String)("\u274c " + targetColony.getName() + " declined your war request!")).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                MutableComponent warDeclinedMsg = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"\u274c WAR DECLINED \u274c").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"\n----------------------------------------").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\nThe colony of ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)targetColony.getName()).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)" (led by ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)executor.m_7755_().getString()).m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)") has declined the war declaration.").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n----------------------------------------").m_130940_(ChatFormatting.DARK_GRAY));
                ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_((Component)warDeclinedMsg, false);
            }
        }
        return 1;
    }

    private static Component createAcceptButton(IColony colony) {
        return Component.m_237113_((String)"[Accept]").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/wnt war accept %d", colony.getID()))));
    }

    private static Component createDeclineButton(IColony colony) {
        return Component.m_237113_((String)"[Decline]").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/wnt war decline %d", colony.getID()))));
    }

    private static Component createStartWarButton(IColony colony) {
        return Component.m_237113_((String)"[\u2694\ufe0f START WAR NOW]").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/wnt war accept %d", colony.getID()))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to start the war immediately").m_130940_(ChatFormatting.RED))));
    }

    private static boolean canPlayerJoinWar(ServerPlayer player, WarData war) {
        IPermissions defenderPerms;
        Rank playerRank;
        IPermissions attackerPerms;
        if (player.m_20148_().equals(war.getColony().getPermissions().getOwner()) || player.m_20148_().equals(war.getAttacker()) || war.getAttackerColony() != null && player.m_20148_().equals(war.getAttackerColony().getPermissions().getOwner())) {
            return false;
        }
        if (!war.isJoinPhaseActive() || System.currentTimeMillis() >= war.getJoinPhaseEndTime()) {
            return false;
        }
        if (FTB_TEAMS_INSTALLED && FTB_TEAM_MANAGER != null) {
            Team playerTeam = FTB_TEAM_MANAGER.getTeamForPlayerID(player.m_20148_()).orElse(null);
            Team atkTeam = FTB_TEAM_MANAGER.getTeamByID(war.getAttackerTeamID()).orElse(null);
            Team defTeam = FTB_TEAM_MANAGER.getTeamByID(war.getDefenderTeamID()).orElse(null);
            if (playerTeam != null && (playerTeam.getId().equals(war.getAttackerTeamID()) || playerTeam.getId().equals(war.getDefenderTeamID()))) {
                return true;
            }
            if (atkTeam != null && atkTeam.isPartyTeam() && ((PartyTeam)atkTeam).getMembers().contains(player.m_20148_()) || defTeam != null && defTeam.isPartyTeam() && ((PartyTeam)defTeam).getMembers().contains(player.m_20148_())) {
                return true;
            }
        }
        IColony attackerColony = war.getAttackerColony();
        IColony defenderColony = war.getColony();
        if (attackerColony != null && (attackerPerms = attackerColony.getPermissions()).getPlayers().containsKey(player.m_20148_()) && (playerRank = attackerPerms.getRank(player.m_20148_())) != null && (playerRank.equals((Object)attackerPerms.getRankOwner()) || playerRank.equals((Object)attackerPerms.getRankOfficer()) || playerRank.equals((Object)attackerPerms.getRankFriend()))) {
            return true;
        }
        return defenderColony != null && (defenderPerms = defenderColony.getPermissions()).getPlayers().containsKey(player.m_20148_()) && (playerRank = defenderPerms.getRank(player.m_20148_())) != null && (playerRank.equals((Object)defenderPerms.getRankOwner()) || playerRank.equals((Object)defenderPerms.getRankOfficer()) || playerRank.equals((Object)defenderPerms.getRankFriend()));
    }

    public static int processJoinWar(ServerPlayer player, CommandSourceStack source) {
        IPermissions defenderPerms;
        Rank playerRank;
        IPermissions attackerPerms;
        WarData war = null;
        for (WarData activeWar : ACTIVE_WARS.values()) {
            if (!WarSystem.canPlayerJoinWar(player, activeWar)) continue;
            war = activeWar;
            break;
        }
        if (war == null) {
            source.m_81352_((Component)Component.m_237113_((String)"No active war to join."));
            return 0;
        }
        if (player.m_20148_().equals(war.getColony().getPermissions().getOwner()) || player.m_20148_().equals(war.getAttacker()) || war.getAttackerColony() != null && player.m_20148_().equals(war.getAttackerColony().getPermissions().getOwner())) {
            source.m_81352_((Component)Component.m_237113_((String)"Primary war participants cannot use this command to join/leave."));
            return 0;
        }
        if (System.currentTimeMillis() >= war.getJoinPhaseEndTime()) {
            source.m_81352_((Component)Component.m_237113_((String)"Join phase is over."));
            return 0;
        }
        if (!war.isJoinPhaseActive()) {
            source.m_81352_((Component)Component.m_237113_((String)"Join phase is over."));
            return 0;
        }
        int playerLives = (Integer)TaxConfig.PLAYER_LIVES_IN_WAR.get();
        if (war.getAttackerLives().containsKey(player.m_20148_()) || war.getDefenderLives().containsKey(player.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)"You are already registered in this war."));
            return 0;
        }
        boolean canJoinAttackers = false;
        boolean canJoinDefenders = false;
        if (FTB_TEAMS_INSTALLED && FTB_TEAM_MANAGER != null) {
            Team playerTeam = FTB_TEAM_MANAGER.getTeamForPlayerID(player.m_20148_()).orElse(null);
            Team atkTeam = FTB_TEAM_MANAGER.getTeamByID(war.getAttackerTeamID()).orElse(null);
            Team defTeam = FTB_TEAM_MANAGER.getTeamByID(war.getDefenderTeamID()).orElse(null);
            if (playerTeam != null && playerTeam.getId().equals(war.getAttackerTeamID())) {
                canJoinAttackers = true;
            }
            if (playerTeam != null && playerTeam.getId().equals(war.getDefenderTeamID())) {
                canJoinDefenders = true;
            }
            if (atkTeam != null && atkTeam.isPartyTeam() && ((PartyTeam)atkTeam).getMembers().contains(player.m_20148_())) {
                canJoinAttackers = true;
            }
            if (defTeam != null && defTeam.isPartyTeam() && ((PartyTeam)defTeam).getMembers().contains(player.m_20148_())) {
                canJoinDefenders = true;
            }
        }
        IColony attackerColony = war.getAttackerColony();
        IColony defenderColony = war.getColony();
        if (attackerColony != null && (attackerPerms = attackerColony.getPermissions()).getPlayers().containsKey(player.m_20148_()) && (playerRank = attackerPerms.getRank(player.m_20148_())) != null && (playerRank.equals((Object)attackerPerms.getRankOwner()) || playerRank.equals((Object)attackerPerms.getRankOfficer()) || playerRank.equals((Object)attackerPerms.getRankFriend()))) {
            canJoinAttackers = true;
        }
        if (defenderColony != null && (defenderPerms = defenderColony.getPermissions()).getPlayers().containsKey(player.m_20148_()) && (playerRank = defenderPerms.getRank(player.m_20148_())) != null && (playerRank.equals((Object)defenderPerms.getRankOwner()) || playerRank.equals((Object)defenderPerms.getRankOfficer()) || playerRank.equals((Object)defenderPerms.getRankFriend()))) {
            canJoinDefenders = true;
        }
        if (canJoinAttackers && canJoinDefenders) {
            MutableComponent message = Component.m_237113_((String)"You are eligible to join both sides. Please choose which side to join:\n").m_130940_(ChatFormatting.GOLD);
            MutableComponent joinAttackers = Component.m_237113_((String)"[Join Attackers]").m_130938_(style -> style.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wnt choosewarside attacker")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to join the attacking side").m_130940_(ChatFormatting.GOLD))));
            MutableComponent joinDefenders = Component.m_237113_((String)"[Join Defenders]").m_130938_(style -> style.m_131140_(ChatFormatting.BLUE).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wnt choosewarside defender")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to join the defending side").m_130940_(ChatFormatting.GOLD))));
            player.m_213846_((Component)message.m_130946_(" ").m_7220_((Component)joinAttackers).m_130946_(" ").m_7220_((Component)joinDefenders));
            return 1;
        }
        if (canJoinAttackers) {
            war.getAttackerLives().put(player.m_20148_(), playerLives);
            war.getAttackerAllies().add(player.m_20148_());
            WarSystem.assignWarParticipantRanks(player.m_20148_(), war.getColony(), war.getAttackerColony(), true);
            player.m_213846_((Component)Component.m_237113_((String)"You have joined the attacking side!").m_130940_(ChatFormatting.GREEN));
            if (war.alliesBossEvent != null && war.alliesBossEvent.m_8323_()) {
                war.alliesBossEvent.m_6543_(player);
            } else {
                war.bossEvent.m_6543_(player);
            }
            return 1;
        }
        if (canJoinDefenders) {
            war.getDefenderLives().put(player.m_20148_(), playerLives);
            war.getDefenderAllies().add(player.m_20148_());
            WarSystem.assignWarParticipantRanks(player.m_20148_(), war.getColony(), war.getAttackerColony(), false);
            player.m_213846_((Component)Component.m_237113_((String)"You have joined the defending side!").m_130940_(ChatFormatting.GREEN));
            if (war.alliesBossEvent != null && war.alliesBossEvent.m_8323_()) {
                war.alliesBossEvent.m_6543_(player);
            } else {
                war.bossEvent.m_6543_(player);
            }
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"You are not eligible to join this war. Only colony owners, officers, and friends can participate."));
        return 0;
    }

    public static int processLeaveWar(ServerPlayer player, CommandSourceStack source) {
        boolean removedFromDefenders;
        boolean removedFromAttackers;
        WarData war = WarSystem.getActiveWarForPlayer(player);
        if (war == null) {
            source.m_81352_((Component)Component.m_237113_((String)"No active war to leave."));
            return 0;
        }
        if (player.m_20148_().equals(war.getColony().getPermissions().getOwner()) || player.m_20148_().equals(war.getAttacker()) || war.getAttackerColony() != null && player.m_20148_().equals(war.getAttackerColony().getPermissions().getOwner())) {
            source.m_81352_((Component)Component.m_237113_((String)"Primary war participants cannot leave the war."));
            return 0;
        }
        if (System.currentTimeMillis() >= war.getJoinPhaseEndTime()) {
            source.m_81352_((Component)Component.m_237113_((String)"Join phase is over; you cannot leave now."));
            return 0;
        }
        boolean bl = removedFromAttackers = war.getAttackerLives().remove(player.m_20148_()) != null;
        if (removedFromAttackers) {
            war.getAttackerAllies().remove(player.m_20148_());
        }
        boolean bl2 = removedFromDefenders = war.getDefenderLives().remove(player.m_20148_()) != null;
        if (removedFromDefenders) {
            war.getDefenderAllies().remove(player.m_20148_());
        }
        if (removedFromAttackers || removedFromDefenders) {
            source.m_288197_(() -> Component.m_237113_((String)"You have left the war."), false);
            if (war.alliesBossEvent != null) {
                war.alliesBossEvent.m_6539_(player);
            }
            if (war.bossEvent != null) {
                war.bossEvent.m_6539_(player);
            }
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"You were not registered in the war to leave."));
        return 0;
    }

    public static IColony findColonyByName(String name, Level level) {
        return IColonyManager.getInstance().getColonies(level).stream().filter(c -> c.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public static int countGuards(IColony colony) {
        if (colony == null || colony.getCitizenManager() == null) {
            return 0;
        }
        return (int)colony.getCitizenManager().getCitizens().stream().filter(c -> c.getJob() != null && c.getJob().isGuard()).count();
    }

    private static void initializeWarMilitiaSystem(WarData war) {
        CitizenMilitiaManager.getInstance().initializeColonyMilitia(war.getColony().getID());
        if (war.getAttackerColony() != null) {
            CitizenMilitiaManager.getInstance().initializeColonyMilitia(war.getAttackerColony().getID());
        }
        WARSYSTEM_LOGGER.info("Initialized militia tracking system for war between {} and {}", (Object)(war.getAttackerColony() != null ? war.getAttackerColony().getName() : "Unknown"), (Object)war.getColony().getName());
    }

    private static void activateWarMilitia(WarData war) {
        if (!((Boolean)TaxConfig.ENABLE_CITIZEN_MILITIA.get()).booleanValue()) {
            WarSystem.setWarDefenderCounts(war);
            WARSYSTEM_LOGGER.info("Militia disabled - Set defender counts for war without militia activation");
            return;
        }
        int defenderMilitia = CitizenMilitiaManager.getInstance().activateMilitia(war.getColony());
        if (defenderMilitia > 0) {
            WarSystem.sendColonyMessage(war.getColony(), (Component)Component.m_237113_((String)"\u2694 WAR MILITIA ACTIVATED \u2694").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + defenderMilitia + " citizens have joined the militia to defend against the war!")).m_130940_(ChatFormatting.YELLOW)));
        }
        int attackerMilitia = 0;
        if (war.getAttackerColony() != null && (attackerMilitia = CitizenMilitiaManager.getInstance().activateMilitia(war.getAttackerColony())) > 0) {
            WarSystem.sendColonyMessage(war.getAttackerColony(), (Component)Component.m_237113_((String)"\u2694 WAR MILITIA ACTIVATED \u2694").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + attackerMilitia + " citizens have joined the militia for the war effort!")).m_130940_(ChatFormatting.YELLOW)));
        }
        WARSYSTEM_LOGGER.info("Activated war militia - Defenders: {} militia, Attackers: {} militia", (Object)defenderMilitia, (Object)attackerMilitia);
    }

    private static void setWarDefenderCounts(WarData war) {
        int defenderGuards = WarSystem.countGuards(war.getColony());
        CitizenMilitiaManager.getInstance().setTotalDefenders(war.getColony().getID(), defenderGuards);
        if (war.getAttackerColony() != null) {
            int attackerGuards = WarSystem.countGuards(war.getAttackerColony());
            CitizenMilitiaManager.getInstance().setTotalDefenders(war.getAttackerColony().getID(), attackerGuards);
        }
        WARSYSTEM_LOGGER.info("Set war defender counts - Defending guards: {}, Attacking guards: {}", (Object)defenderGuards, (Object)(war.getAttackerColony() != null ? WarSystem.countGuards(war.getAttackerColony()) : 0));
    }

    private static void cleanupWarMilitiaSystem(WarData war) {
        CitizenMilitiaManager.getInstance().deactivateMilitia(war.getColony());
        CitizenMilitiaManager.getInstance().clearColonyMilitia(war.getColony().getID());
        if (war.getAttackerColony() != null) {
            CitizenMilitiaManager.getInstance().deactivateMilitia(war.getAttackerColony());
            CitizenMilitiaManager.getInstance().clearColonyMilitia(war.getAttackerColony().getID());
        }
        WARSYSTEM_LOGGER.info("Cleaned up militia system for war between {} and {}", (Object)(war.getAttackerColony() != null ? war.getAttackerColony().getName() : "Unknown"), (Object)war.getColony().getName());
    }

    public static int countGuardTowers(IColony colony) {
        if (colony == null || colony.getBuildingManager() == null) {
            return 0;
        }
        return (int)colony.getBuildingManager().getBuildings().values().stream().filter(WarSystem::isGuardTower).count();
    }

    public static boolean isGuardTower(IBuilding building) {
        if (building == null) {
            return false;
        }
        String displayName = building.getBuildingDisplayName();
        if (displayName != null && "Guard Tower".equalsIgnoreCase(displayName)) {
            return true;
        }
        String className = building.getClass().getName().toLowerCase();
        if (className.contains("guardtower")) {
            return true;
        }
        try {
            String toString = building.toString().toLowerCase();
            if (toString.contains("guardtower") || toString.contains("guard_tower")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isColonyInWar(int colonyId) {
        for (WarData warData : ACTIVE_WARS.values()) {
            if (warData.getColony().getID() == colonyId) {
                return true;
            }
            if (warData.getAttackerColony() == null || warData.getAttackerColony().getID() != colonyId) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExtortionImmunity(int colonyId) {
        Long immunityExpiration = extortionImmunity.get(colonyId);
        if (immunityExpiration == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime > immunityExpiration) {
            extortionImmunity.remove(colonyId);
            return false;
        }
        return true;
    }

    public static void grantExtortionImmunity(int colonyId) {
        long immunityDuration = (long)((Integer)TaxConfig.EXTORTION_IMMUNITY_HOURS.get() * 60 * 60) * 1000L;
        long immunityExpiration = System.currentTimeMillis() + immunityDuration;
        extortionImmunity.put(colonyId, immunityExpiration);
        WARSYSTEM_LOGGER.info("Colony {} granted extortion immunity for {} hours", (Object)colonyId, TaxConfig.EXTORTION_IMMUNITY_HOURS.get());
    }

    private static void showExtortionChoiceWithTimer(final ServerPlayer attacker, final IColony targetColony, ServerPlayer owner, int extortionPercent) {
        pendingWarRequests.put(targetColony.getID(), new WarRequestWithExtortion(attacker.m_20148_(), targetColony.getID(), extortionPercent));
        int timeLimitMinutes = (Integer)TaxConfig.EXTORTION_RESPONSE_TIME_MINUTES.get();
        long timeLimitMs = (long)(timeLimitMinutes * 60) * 1000L;
        MutableComponent message = Component.m_237113_((String)("\ud83c\udfdb\ufe0f URGENT: Colony " + targetColony.getName() + " is under siege! \ud83c\udfdb\ufe0f")).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n\n" + attacker.m_7755_().getString() + " has declared war but offers terms:")).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)("\n\ud83d\udcb0 Pay " + extortionPercent + "% of your balance to avoid war")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"\n\u2694\ufe0f Or let the war begin immediately (auto-accepted)").m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)("\n\u23f0 You have " + timeLimitMinutes + " minutes to decide!")).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"\n\nChoose quickly:\n").m_130940_(ChatFormatting.WHITE)).m_7220_(WarSystem.createStartWarButton(targetColony)).m_130946_("  ").m_7220_((Component)WarSystem.createPayExtortionButton(targetColony, extortionPercent));
        owner.m_213846_((Component)message);
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                Object pendingRequest = pendingWarRequests.remove(targetColony.getID());
                if (pendingRequest instanceof WarRequestWithExtortion) {
                    WARSYSTEM_LOGGER.info("Extortion time limit expired for colony {}. Starting war automatically.", (Object)targetColony.getID());
                    if (targetColony.getWorld() != null && targetColony.getWorld().m_7654_() != null) {
                        ServerPlayer attackerPlayer;
                        ServerPlayer targetOwner = targetColony.getWorld().m_7654_().m_6846_().m_11259_(targetColony.getPermissions().getOwner());
                        if (targetOwner != null) {
                            targetOwner.m_213846_((Component)Component.m_237113_((String)"\u23f0 Time expired! War begins automatically!").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}));
                        }
                        if ((attackerPlayer = targetColony.getWorld().m_7654_().m_6846_().m_11259_(attacker.m_20148_())) != null) {
                            attackerPlayer.m_213846_((Component)Component.m_237113_((String)("\u23f0 " + targetColony.getName() + " failed to respond in time. War begins!")).m_130940_(ChatFormatting.GOLD));
                        }
                        WarSystem.startJoinPhase(targetColony, attacker, targetOwner);
                    }
                }
            }
        }, timeLimitMs);
        attacker.m_213846_((Component)Component.m_237113_((String)("War declaration with " + extortionPercent + "% extortion demand sent to " + targetColony.getName() + ". They have " + timeLimitMinutes + " minutes to respond.")).m_130940_(ChatFormatting.YELLOW));
    }

    private static void showExtortionChoice(ServerPlayer attacker, IColony targetColony, ServerPlayer owner, int extortionPercent) {
        MutableComponent message = Component.m_237113_((String)("\ud83c\udfdb\ufe0f Colony " + targetColony.getName() + " is under siege! \ud83c\udfdb\ufe0f\n")).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + attacker.m_7755_().getString() + " has declared war but offers terms:\n")).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)("\ud83d\udcb0 Pay " + extortionPercent + "% of your balance to avoid war\n")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"\u2694\ufe0f Or accept the war and fight for your colony's honor\n").m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\nChoose wisely:\n").m_130940_(ChatFormatting.WHITE)).m_7220_(WarSystem.createAcceptButton(targetColony)).m_130946_(" ").m_7220_(WarSystem.createDeclineButton(targetColony)).m_130946_(" ").m_7220_((Component)WarSystem.createPayExtortionButton(targetColony, extortionPercent));
        owner.m_213846_((Component)message);
    }

    private static MutableComponent createPayExtortionButton(IColony colony, int extortionPercent) {
        return Component.m_237113_((String)("[\ud83d\udcb0 PAY EXTORTION " + extortionPercent + "%]")).m_130938_(style -> style.m_131140_(ChatFormatting.GOLD).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wnt payextortion " + colony.getID() + " " + extortionPercent)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Click to pay " + extortionPercent + "% of your balance to avoid war")).m_130940_(ChatFormatting.YELLOW))));
    }

    public static class WarInventoryHandler {
        private static final Map<UUID, ItemStack[]> savedInventories = new ConcurrentHashMap<UUID, ItemStack[]>();
        private static final Map<UUID, ItemStack[]> savedArmors = new ConcurrentHashMap<UUID, ItemStack[]>();

        public static boolean hasSavedInventory(ServerPlayer player) {
            return savedInventories.containsKey(player.m_20148_());
        }

        public static void saveAndClearInventory(ServerPlayer player) {
            ItemStack[] main = new ItemStack[player.m_150109_().m_6643_()];
            for (int i = 0; i < main.length; ++i) {
                main[i] = player.m_150109_().m_8020_(i).m_41777_();
            }
            savedInventories.put(player.m_20148_(), main);
            ItemStack[] armor = new ItemStack[4];
            for (int i = 0; i < 4; ++i) {
                armor[i] = ((ItemStack)player.m_150109_().f_35975_.get(i)).m_41777_();
            }
            savedArmors.put(player.m_20148_(), armor);
            player.m_150109_().m_6211_();
        }

        public static void restoreInventory(ServerPlayer player) {
            ItemStack[] armor;
            UUID uuid = player.m_20148_();
            ItemStack[] main = savedInventories.remove(uuid);
            if (main != null) {
                for (int i = 0; i < main.length; ++i) {
                    player.m_150109_().m_6836_(i, main[i]);
                }
            }
            if ((armor = savedArmors.remove(uuid)) != null) {
                for (int i = 0; i < 4; ++i) {
                    player.m_150109_().f_35975_.set(i, (Object)armor[i]);
                }
            }
            player.f_36096_.m_38946_();
        }
    }

    public record WarRequest(UUID attacker, int colonyId) {
    }

    public record WarRequestWithExtortion(UUID attacker, int colonyId, int extortionPercent) {
    }
}

