/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.abandon;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.machiavelli.minecolonytax.TaxConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColonyAbandonmentManager {
    private static final Logger LOGGER = LogManager.getLogger(ColonyAbandonmentManager.class);
    private static final Map<Integer, Long> warnedColonies = new ConcurrentHashMap<Integer, Long>();
    private static final Set<Integer> abandonedColonies = ConcurrentHashMap.newKeySet();
    private static final Map<Integer, Set<UUID>> formerColonyMembers = new ConcurrentHashMap<Integer, Set<UUID>>();
    private static final Map<UUID, List<Component>> pendingNotifications = new ConcurrentHashMap<UUID, List<Component>>();

    public static void checkColoniesForAbandonment(MinecraftServer server) {
        if (!TaxConfig.isColonyAutoAbandonEnabled()) {
            return;
        }
        try {
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            int abandonedCount = 0;
            int warnedCount = 0;
            for (Level world : server.m_129785_()) {
                for (IColony colony : colonyManager.getColonies(world)) {
                    AbandonmentStatus status = ColonyAbandonmentManager.checkColonyAbandonmentStatus(colony);
                    switch (status) {
                        case SHOULD_ABANDON: {
                            if (!ColonyAbandonmentManager.abandonColony(colony, server)) break;
                            ++abandonedCount;
                            break;
                        }
                        case SHOULD_WARN: {
                            if (!ColonyAbandonmentManager.warnColonyOwnersAndOfficers(colony, server)) break;
                            ++warnedCount;
                            break;
                        }
                        case ACTIVE: {
                            warnedColonies.remove(colony.getID());
                        }
                    }
                }
            }
            if (abandonedCount > 0 || warnedCount > 0) {
                LOGGER.info("Colony abandonment check completed: {} colonies abandoned, {} colonies warned", (Object)abandonedCount, (Object)warnedCount);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error during colony abandonment check", (Throwable)e);
        }
    }

    public static AbandonmentStatus checkColonyAbandonmentStatus(IColony colony) {
        if (colony == null || colony.getPermissions() == null) {
            return AbandonmentStatus.ACTIVE;
        }
        UUID owner = colony.getPermissions().getOwner();
        if (owner == null || ColonyAbandonmentManager.isColonyAbandoned(colony)) {
            return AbandonmentStatus.ACTIVE;
        }
        int lastContactHours = colony.getLastContactInHours();
        int abandonDays = TaxConfig.getColonyAutoAbandonDays();
        int warningDays = TaxConfig.getAbandonWarningDays();
        int abandonHours = abandonDays * 24;
        int warningHours = (abandonDays - warningDays) * 24;
        if (lastContactHours >= abandonHours) {
            return AbandonmentStatus.SHOULD_ABANDON;
        }
        if (lastContactHours >= warningHours && TaxConfig.shouldNotifyOwnersBeforeAbandon()) {
            return AbandonmentStatus.SHOULD_WARN;
        }
        return AbandonmentStatus.ACTIVE;
    }

    private static boolean abandonColony(IColony colony, MinecraftServer server) {
        try {
            LOGGER.info("Abandoning colony {} ({}) due to {} hours of inactivity", (Object)colony.getName(), (Object)colony.getID(), (Object)colony.getLastContactInHours());
            IPermissions permissions = colony.getPermissions();
            ArrayList<UUID> removedPlayers = new ArrayList<UUID>();
            HashMap players = new HashMap(permissions.getPlayers());
            UUID currentOwner = permissions.getOwner();
            if (currentOwner != null) {
                removedPlayers.add(currentOwner);
            }
            for (Map.Entry entry : players.entrySet()) {
                if (!((ColonyPlayer)entry.getValue()).getRank().isColonyManager() || ((UUID)entry.getKey()).equals(currentOwner)) continue;
                removedPlayers.add((UUID)entry.getKey());
            }
            LOGGER.info("Abandoning colony {} - found {} owners/officers to make hostile: {}", (Object)colony.getName(), (Object)removedPlayers.size(), removedPlayers);
            formerColonyMembers.put(colony.getID(), new HashSet(removedPlayers));
            LOGGER.info("\ud83d\udd27 AUTOMATIC ABANDONMENT: Colony {} - ensuring valid owner ALWAYS exists", (Object)colony.getName());
            HashMap allPlayers = new HashMap(permissions.getPlayers());
            LOGGER.info("Found {} total players in colony before abandonment", (Object)allPlayers.size());
            ColonyAbandonmentManager.cleanupAbandonedEntries(permissions);
            UUID colonyOwner = permissions.getOwner();
            if (colonyOwner == null) {
                LOGGER.error("\u26a0\ufe0f NULL OWNER DETECTED during abandonment - AUTOMATICALLY FIXING!");
                UUID newOwner = null;
                if (!removedPlayers.isEmpty()) {
                    newOwner = (UUID)removedPlayers.get(0);
                } else if (!allPlayers.isEmpty()) {
                    newOwner = (UUID)allPlayers.keySet().iterator().next();
                } else {
                    newOwner = ColonyAbandonmentManager.createSystemOwner();
                    permissions.addPlayer(newOwner, "[AUTO_OWNER]", permissions.getRankOwner());
                    LOGGER.error("\ud83c\udd98 NO PLAYERS FOUND - created automatic system owner");
                }
                permissions.setPlayerRank(newOwner, permissions.getRankOwner(), colony.getWorld());
                LOGGER.error("\ud83c\udfdb\ufe0f AUTOMATIC FIX: {} is now owner to prevent GUI crashes", (Object)newOwner);
                colonyOwner = newOwner;
            } else {
                LOGGER.info("\u2705 Valid owner {} exists - keeping to prevent GUI crashes", (Object)colonyOwner);
            }
            Rank colonyNeutralRank = permissions.getRankNeutral();
            for (UUID playerId : allPlayers.keySet()) {
                if (!playerId.equals(colonyOwner)) {
                    ColonyPlayer player = (ColonyPlayer)allPlayers.get(playerId);
                    if (player.getRank().equals((Object)colonyNeutralRank)) continue;
                    boolean rankSet = permissions.setPlayerRank(playerId, colonyNeutralRank, colony.getWorld());
                    LOGGER.info("Set non-owner player {} to neutral rank: {}", (Object)playerId, (Object)rankSet);
                    continue;
                }
                LOGGER.info("\ud83c\udfdb\ufe0f KEEPING owner {} at Owner rank to prevent GUI crashes", (Object)playerId);
            }
            LOGGER.info("\u2705 ABANDONMENT SUCCESS: Colony {} keeps valid owner but all players have neutral permissions", (Object)colony.getName());
            try {
                LOGGER.info("Colony {} marked as abandoned without using setOwnerAbandoned() to prevent weird entries", (Object)colony.getName());
                ColonyAbandonmentManager.cleanupAbandonedEntries(permissions);
            }
            catch (Exception e) {
                LOGGER.error("Error during safe abandonment for colony {}", (Object)colony.getName(), (Object)e);
            }
            LOGGER.info("Successfully abandoned colony {} - set {} players to neutral rank", (Object)colony.getName(), (Object)allPlayers.size());
            LOGGER.info("Setting EXTREMELY restrictive neutral permissions for abandoned colony {}", (Object)colony.getName());
            permissions.setPermission(colonyNeutralRank, Action.BREAK_BLOCKS, false);
            permissions.setPermission(colonyNeutralRank, Action.PLACE_BLOCKS, false);
            permissions.setPermission(colonyNeutralRank, Action.RIGHTCLICK_BLOCK, false);
            permissions.setPermission(colonyNeutralRank, Action.OPEN_CONTAINER, false);
            permissions.setPermission(colonyNeutralRank, Action.TOSS_ITEM, false);
            permissions.setPermission(colonyNeutralRank, Action.PICKUP_ITEM, false);
            permissions.setPermission(colonyNeutralRank, Action.ACCESS_HUTS, false);
            permissions.setPermission(colonyNeutralRank, Action.HURT_CITIZEN, false);
            permissions.setPermission(colonyNeutralRank, Action.HURT_VISITOR, false);
            permissions.setPermission(colonyNeutralRank, Action.TELEPORT_TO_COLONY, false);
            permissions.setPermission(colonyNeutralRank, Action.RECEIVE_MESSAGES, false);
            permissions.setPermission(colonyNeutralRank, Action.USE_SCAN_TOOL, false);
            permissions.setPermission(colonyNeutralRank, Action.THROW_POTION, false);
            permissions.setPermission(colonyNeutralRank, Action.SHOOT_ARROW, false);
            permissions.setPermission(colonyNeutralRank, Action.GUARDS_ATTACK, false);
            Rank hostileRank = permissions.getRankHostile();
            permissions.setPermission(hostileRank, Action.BREAK_BLOCKS, false);
            permissions.setPermission(hostileRank, Action.PLACE_BLOCKS, false);
            permissions.setPermission(hostileRank, Action.RIGHTCLICK_BLOCK, false);
            permissions.setPermission(hostileRank, Action.OPEN_CONTAINER, false);
            permissions.setPermission(hostileRank, Action.TOSS_ITEM, false);
            permissions.setPermission(hostileRank, Action.PICKUP_ITEM, false);
            permissions.setPermission(hostileRank, Action.ACCESS_HUTS, false);
            LOGGER.info("ANTI-GRIEF SUCCESS: Colony {} - all players set to neutral/hostile with ZERO permissions", (Object)colony.getName());
            abandonedColonies.add(colony.getID());
            ColonyAbandonmentManager.scheduleAbandonmentNotifications(removedPlayers, colony, server);
            MutableComponent broadcastMessage = Component.m_237113_((String)"Colony ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)colony.getName()).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)" has been abandoned due to inactivity and can now be claimed!").m_130940_(ChatFormatting.YELLOW));
            server.m_6846_().m_240416_((Component)broadcastMessage, false);
            warnedColonies.remove(colony.getID());
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to abandon colony {} ({})", (Object)colony.getName(), (Object)colony.getID(), (Object)e);
            return false;
        }
    }

    private static boolean warnColonyOwnersAndOfficers(IColony colony, MinecraftServer server) {
        int colonyId = colony.getID();
        long currentTime = System.currentTimeMillis();
        Long lastWarned = warnedColonies.get(colonyId);
        if (lastWarned != null && currentTime - lastWarned < 86400000L) {
            return false;
        }
        try {
            int daysUntilAbandon = TaxConfig.getColonyAutoAbandonDays() - colony.getLastContactInHours() / 24;
            MutableComponent warningMessage = Component.m_237113_((String)"WARNING: Your colony ").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)colony.getName()).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)(" will be abandoned in " + daysUntilAbandon + " days due to inactivity!")).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\nVisit your colony to prevent abandonment.").m_130940_(ChatFormatting.YELLOW));
            boolean sentWarning = false;
            for (ColonyPlayer colonyPlayer : colony.getPermissions().getPlayers().values()) {
                if (!colonyPlayer.getRank().isColonyManager()) continue;
                ServerPlayer player = server.m_6846_().m_11259_(colonyPlayer.getID());
                if (player != null) {
                    player.m_213846_((Component)warningMessage);
                    sentWarning = true;
                    continue;
                }
                ColonyAbandonmentManager.queueOfflineNotification(colonyPlayer.getID(), (Component)warningMessage);
                sentWarning = true;
            }
            if (sentWarning) {
                warnedColonies.put(colonyId, currentTime);
                LOGGER.info("Warned owners/officers of colony {} ({}) about upcoming abandonment", (Object)colony.getName(), (Object)colony.getID());
            }
            return sentWarning;
        }
        catch (Exception e) {
            LOGGER.error("Failed to warn about colony abandonment for {} ({})", (Object)colony.getName(), (Object)colony.getID(), (Object)e);
            return false;
        }
    }

    private static void scheduleAbandonmentNotifications(List<UUID> playerIds, IColony colony, MinecraftServer server) {
        MutableComponent message = Component.m_237113_((String)"Your colony ").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)colony.getName()).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)" has been abandoned due to inactivity.").m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\nIt can now be claimed by other players using /wnt claimcolony.").m_130940_(ChatFormatting.YELLOW));
        for (UUID playerId : playerIds) {
            ServerPlayer player = server.m_6846_().m_11259_(playerId);
            if (player != null) {
                player.m_213846_((Component)message);
                continue;
            }
            ColonyAbandonmentManager.queueOfflineNotification(playerId, (Component)message);
        }
    }

    public static boolean isColonyAbandoned(IColony colony) {
        if (colony == null || colony.getPermissions() == null) {
            return false;
        }
        UUID owner = colony.getPermissions().getOwner();
        if (owner == null) {
            LOGGER.error("\ud83d\udea8 AUTO-FIX: Colony {} has null owner - FIXING AUTOMATICALLY!", (Object)colony.getName());
            ColonyAbandonmentManager.fixNullOwnerColony(colony);
            owner = colony.getPermissions().getOwner();
            if (owner == null) {
                LOGGER.error("\ud83d\udca5 CRITICAL: Failed to fix null owner for colony {}!", (Object)colony.getName());
                try {
                    UUID systemOwner = ColonyAbandonmentManager.createSystemOwner();
                    colony.getPermissions().addPlayer(systemOwner, "[AUTO_EMERGENCY_OWNER]", colony.getPermissions().getRankOwner());
                    colony.getPermissions().setPlayerRank(systemOwner, colony.getPermissions().getRankOwner(), colony.getWorld());
                    LOGGER.error("\ud83c\udd98 EMERGENCY: Created system owner for colony {}", (Object)colony.getName());
                }
                catch (Exception e) {
                    LOGGER.error("\ud83d\udca5 EMERGENCY SYSTEM OWNER FAILED for colony {}: {}", (Object)colony.getName(), (Object)e.getMessage());
                }
            }
        }
        return abandonedColonies.contains(colony.getID());
    }

    private static void fixNullOwnerColony(IColony colony) {
        try {
            IPermissions permissions = colony.getPermissions();
            UUID newOwner = null;
            for (ColonyPlayer player : permissions.getPlayers().values()) {
                if (player.getID() == null) continue;
                newOwner = player.getID();
                break;
            }
            if (newOwner != null) {
                permissions.setPlayerRank(newOwner, permissions.getRankOwner(), colony.getWorld());
                LOGGER.info("\ud83c\udfdb\ufe0f EMERGENCY FIX: Set {} as emergency owner of null-owner colony {}", (Object)newOwner, (Object)colony.getName());
                abandonedColonies.add(colony.getID());
                LOGGER.info("\ud83d\udccb Marked colony {} as abandoned due to null owner fix", (Object)colony.getName());
            } else {
                LOGGER.error("\u274c NO PLAYERS FOUND in null owner colony {}! Cannot fix!", (Object)colony.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("\ud83d\udca5 FAILED to fix null owner colony {}: {}", (Object)colony.getName(), (Object)e.getMessage());
        }
    }

    public static void emergencyFixAllNullOwners() {
        try {
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            int nullOwnerColonies = 0;
            int fixedColonies = 0;
            for (IColony colony : colonyManager.getAllColonies()) {
                try {
                    IPermissions permissions = colony.getPermissions();
                    UUID owner = permissions.getOwner();
                    if (owner != null) continue;
                    ++nullOwnerColonies;
                    LOGGER.error("\ud83d\udea8 AUTO-FIX: Colony {} has null owner - fixing automatically!", (Object)colony.getName());
                    UUID emergencyOwner = null;
                    for (ColonyPlayer player : permissions.getPlayers().values()) {
                        if (player.getID() == null) continue;
                        emergencyOwner = player.getID();
                        break;
                    }
                    if (emergencyOwner == null) {
                        emergencyOwner = ColonyAbandonmentManager.createSystemOwner();
                        permissions.addPlayer(emergencyOwner, "[AUTO_OWNER]", permissions.getRankOwner());
                        LOGGER.warn("No players in colony {} - created automatic system owner", (Object)colony.getName());
                    }
                    permissions.setPlayerRank(emergencyOwner, permissions.getRankOwner(), colony.getWorld());
                    abandonedColonies.add(colony.getID());
                    ++fixedColonies;
                    LOGGER.info("\u2705 AUTO-FIX: Colony {} now has owner {} (marked abandoned)", (Object)colony.getName(), (Object)emergencyOwner);
                }
                catch (Exception e) {
                    LOGGER.error("Auto-fix error in colony {}: {}", (Object)colony.getName(), (Object)e.getMessage());
                }
            }
            if (nullOwnerColonies > 0) {
                LOGGER.error("\ud83d\udea8 AUTO-FIX COMPLETE: Fixed {} null owner colonies - GUI crashes prevented!", (Object)fixedColonies);
            }
        }
        catch (Exception e) {
            LOGGER.error("Auto null owner fix error: {}", (Object)e.getMessage());
        }
    }

    private static void cleanupSystemOwner(IColony colony) {
        try {
            IPermissions permissions = colony.getPermissions();
            UUID systemOwner = ColonyAbandonmentManager.createSystemOwner();
            if (permissions.getPlayers().containsKey(systemOwner)) {
                permissions.removePlayer(systemOwner);
                LOGGER.info("CLEANUP: Removed system owner from reactivated colony {}", (Object)colony.getName());
            }
            for (ColonyPlayer player : permissions.getPlayers().values()) {
                if (ColonyAbandonmentManager.isSystemOwner(player.getID()) || !player.getRank().isColonyManager()) continue;
                LOGGER.info("CLEANUP: {} will be the effective owner of reactivated colony {}", (Object)player.getName(), (Object)colony.getName());
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error cleaning up system owner for colony {}: {}", (Object)colony.getName(), (Object)e.getMessage());
        }
    }

    public static void markColonyAsClaimed(int colonyId) {
        abandonedColonies.remove(colonyId);
        warnedColonies.remove(colonyId);
        formerColonyMembers.remove(colonyId);
    }

    public static boolean wasFormerOwnerOrOfficer(int colonyId, UUID playerId) {
        Set<UUID> formerMembers = formerColonyMembers.get(colonyId);
        return formerMembers != null && formerMembers.contains(playerId);
    }

    public static Set<UUID> getFormerOwnerAndOfficers(int colonyId) {
        return formerColonyMembers.getOrDefault(colonyId, new HashSet());
    }

    public static List<IColony> getClaimableColonies(MinecraftServer server) {
        ArrayList<IColony> claimable = new ArrayList<IColony>();
        if (!TaxConfig.isAbandonedColonyClaimingEnabled()) {
            return claimable;
        }
        try {
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            for (Level world : server.m_129785_()) {
                for (IColony colony : colonyManager.getColonies(world)) {
                    if (!ColonyAbandonmentManager.isColonyAbandoned(colony)) continue;
                    claimable.add(colony);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting claimable colonies", (Throwable)e);
        }
        return claimable;
    }

    private static void queueOfflineNotification(UUID playerId, Component message) {
        pendingNotifications.computeIfAbsent(playerId, k -> new ArrayList()).add(message);
        LOGGER.debug("Queued notification for offline player {}", (Object)playerId);
    }

    public static void sendPendingNotifications(ServerPlayer player) {
        UUID playerId = player.m_20148_();
        List<Component> notifications = pendingNotifications.remove(playerId);
        if (notifications != null && !notifications.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"=== PENDING NOTIFICATIONS ===").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
            for (Component notification : notifications) {
                player.m_213846_(notification);
            }
            player.m_213846_((Component)Component.m_237113_((String)"=== END OF NOTIFICATIONS ===").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
            LOGGER.info("Sent {} pending notifications to player {}", (Object)notifications.size(), (Object)player.m_7755_().getString());
        }
    }

    public static void clearPendingNotifications(UUID playerId) {
        pendingNotifications.remove(playerId);
    }

    public static boolean forceAbandonColony(IColony colony, MinecraftServer server, String adminName) {
        try {
            IPermissions permissions = colony.getPermissions();
            ArrayList<UUID> managersToNotify = new ArrayList<UUID>();
            UUID currentOwner = permissions.getOwner();
            if (currentOwner != null) {
                managersToNotify.add(currentOwner);
            }
            for (ColonyPlayer colonyPlayer : permissions.getPlayers().values()) {
                if (!colonyPlayer.getRank().isColonyManager() || colonyPlayer.getID().equals(currentOwner)) continue;
                managersToNotify.add(colonyPlayer.getID());
            }
            LOGGER.info("Force abandoning colony {} - found {} owners/officers to make hostile: {}", (Object)colony.getName(), (Object)managersToNotify.size(), managersToNotify);
            formerColonyMembers.put(colony.getID(), new HashSet(managersToNotify));
            HashMap allPlayers = new HashMap(permissions.getPlayers());
            LOGGER.info("Setting ALL {} players to neutral rank in force abandoned colony {}", (Object)allPlayers.size(), (Object)colony.getName());
            Rank neutralRank = permissions.getRankNeutral();
            for (UUID playerId : allPlayers.keySet()) {
                ColonyPlayer player = (ColonyPlayer)allPlayers.get(playerId);
                if (player.getRank().equals((Object)neutralRank)) continue;
                boolean rankSet = permissions.setPlayerRank(playerId, neutralRank, colony.getWorld());
                LOGGER.info("Set player {} to neutral rank in force abandoned colony {}: {}", (Object)playerId, (Object)colony.getName(), (Object)rankSet);
            }
            try {
                LOGGER.info("Colony {} marked as abandoned without using setOwnerAbandoned() to prevent weird entries", (Object)colony.getName());
                ColonyAbandonmentManager.cleanupAbandonedEntries(permissions);
            }
            catch (Exception e) {
                LOGGER.error("Error during safe abandonment for colony {}", (Object)colony.getName(), (Object)e);
            }
            LOGGER.info("Successfully force abandoned colony {} - set {} players to neutral rank", (Object)colony.getName(), (Object)allPlayers.size());
            LOGGER.info("Setting VERY restrictive neutral permissions for force abandoned colony {}", (Object)colony.getName());
            permissions.setPermission(neutralRank, Action.BREAK_BLOCKS, false);
            permissions.setPermission(neutralRank, Action.PLACE_BLOCKS, false);
            permissions.setPermission(neutralRank, Action.RIGHTCLICK_BLOCK, false);
            permissions.setPermission(neutralRank, Action.OPEN_CONTAINER, false);
            permissions.setPermission(neutralRank, Action.TOSS_ITEM, false);
            permissions.setPermission(neutralRank, Action.PICKUP_ITEM, false);
            permissions.setPermission(neutralRank, Action.ACCESS_HUTS, false);
            LOGGER.info("Force abandonment completed for colony {} - all players set to neutral with restrictive permissions", (Object)colony.getName());
            abandonedColonies.add(colony.getID());
            MutableComponent forceAbandonMessage = Component.m_237113_((String)"ADMIN ACTION: Your colony ").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)colony.getName()).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)(" has been force abandoned by admin " + adminName + ".")).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\nIt can now be claimed by other players using /wnt claimcolony.").m_130940_(ChatFormatting.YELLOW));
            for (UUID playerId : managersToNotify) {
                ServerPlayer player = server.m_6846_().m_11259_(playerId);
                if (player != null) {
                    player.m_213846_((Component)forceAbandonMessage);
                    continue;
                }
                ColonyAbandonmentManager.queueOfflineNotification(playerId, (Component)forceAbandonMessage);
            }
            LOGGER.warn("Colony {} ({}) force abandoned by admin {}", (Object)colony.getName(), (Object)colony.getID(), (Object)adminName);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to force abandon colony {} ({})", (Object)colony.getName(), (Object)colony.getID(), (Object)e);
            return false;
        }
    }

    public static void cleanupAbandonedEntries(IPermissions permissions) {
        try {
            HashMap players = new HashMap(permissions.getPlayers());
            ArrayList<UUID> toRemove = new ArrayList<UUID>();
            LOGGER.info("CLEANUP: Scanning {} player entries for [abandoned] corruption", (Object)players.size());
            for (Map.Entry entry : players.entrySet()) {
                ColonyPlayer player = (ColonyPlayer)entry.getValue();
                UUID playerId = (UUID)entry.getKey();
                boolean isProblematic = false;
                String reason = "";
                if (playerId == null) {
                    isProblematic = true;
                    reason = "null UUID";
                } else if (player == null) {
                    isProblematic = true;
                    reason = "null player object";
                } else if (player.getName() == null) {
                    isProblematic = true;
                    reason = "null player name";
                } else if (player.getName().equals("")) {
                    isProblematic = true;
                    reason = "empty player name";
                } else if (player.getName().contains("[abandoned]")) {
                    isProblematic = true;
                    reason = "contains [abandoned]";
                } else if (player.getName().toLowerCase().contains("abandoned")) {
                    isProblematic = true;
                    reason = "contains 'abandoned'";
                } else if (player.getName().equals("[SYSTEM_ABANDONED]") || ColonyAbandonmentManager.isSystemOwner(playerId)) {
                    isProblematic = true;
                    reason = "old system owner entry";
                } else if (player.getName().startsWith("~") || player.getName().startsWith("#")) {
                    isProblematic = true;
                    reason = "suspicious name prefix";
                } else {
                    String uuidStr = playerId.toString();
                    if (uuidStr.equals("00000000-0000-0000-0000-000000000000") || uuidStr.contains("abandoned") || uuidStr.length() != 36) {
                        isProblematic = true;
                        reason = "invalid UUID pattern";
                    }
                }
                if (!isProblematic) continue;
                LOGGER.warn("CLEANUP: Found problematic player entry - UUID: {}, Name: '{}', Reason: {}", (Object)playerId, (Object)(player != null ? player.getName() : "null"), (Object)reason);
                toRemove.add(playerId);
            }
            for (UUID playerId : toRemove) {
                try {
                    permissions.removePlayer(playerId);
                    LOGGER.info("CLEANUP: Successfully removed problematic entry: {}", (Object)playerId);
                }
                catch (Exception e) {
                    LOGGER.error("CLEANUP: Failed to remove problematic entry {}: {}", (Object)playerId, (Object)e.getMessage());
                    try {
                        Method method = permissions.getClass().getDeclaredMethod("removePlayer", UUID.class);
                        method.setAccessible(true);
                        method.invoke((Object)permissions, playerId);
                        LOGGER.info("CLEANUP: Force-removed entry via reflection: {}", (Object)playerId);
                    }
                    catch (Exception reflectionEx) {
                        LOGGER.error("CLEANUP: Force removal also failed for {}: {}", (Object)playerId, (Object)reflectionEx.getMessage());
                    }
                }
            }
            if (toRemove.size() > 0) {
                LOGGER.info("CLEANUP: Processed {} problematic entries", (Object)toRemove.size());
            } else {
                LOGGER.debug("CLEANUP: No problematic entries found");
            }
        }
        catch (Exception e) {
            LOGGER.error("CLEANUP: Error during abandoned entries cleanup", (Throwable)e);
        }
    }

    public static void checkForNewOfficers(IColony colony) {
        if (colony == null) {
            return;
        }
        boolean wasAbandoned = ColonyAbandonmentManager.isColonyAbandoned(colony);
        if (!wasAbandoned) {
            return;
        }
        boolean hasRealOfficers = colony.getPermissions().getPlayers().values().stream().filter(player -> !ColonyAbandonmentManager.isSystemOwner(player.getID())).anyMatch(player -> player.getRank().isColonyManager());
        if (hasRealOfficers) {
            LOGGER.info("\ud83c\udf89 COLONY REACTIVATED: {} is no longer abandoned - REAL officers have been added!", (Object)colony.getName());
            ColonyAbandonmentManager.markColonyAsClaimed(colony.getID());
            ColonyAbandonmentManager.cleanupSystemOwnerAndSetRealOwner(colony);
            ColonyAbandonmentManager.restoreNormalPermissions(colony);
        }
    }

    private static void cleanupSystemOwnerAndSetRealOwner(IColony colony) {
        block9: {
            try {
                IPermissions permissions = colony.getPermissions();
                UUID systemOwnerUUID = ColonyAbandonmentManager.createSystemOwner();
                if (permissions.getPlayers().containsKey(systemOwnerUUID)) {
                    permissions.removePlayer(systemOwnerUUID);
                    LOGGER.info("CLEANUP: Removed system owner from reactivated colony {}", (Object)colony.getName());
                }
                for (ColonyPlayer player : permissions.getPlayers().values()) {
                    if (ColonyAbandonmentManager.isSystemOwner(player.getID()) || !player.getRank().isColonyManager()) continue;
                    try {
                        Method setOwnerMethod = permissions.getClass().getMethod("setOwner", UUID.class);
                        setOwnerMethod.invoke((Object)permissions, player.getID());
                        LOGGER.info("\ud83c\udfdb\ufe0f NEW OWNER SET: {} is now the owner of reactivated colony {}", (Object)player.getName(), (Object)colony.getName());
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not set {} as owner directly, trying alternative: {}", (Object)player.getName(), (Object)e.getMessage());
                        try {
                            for (Method method : permissions.getClass().getDeclaredMethods()) {
                                if (!method.getName().equals("setOwner") || method.getParameterCount() != 1) continue;
                                method.setAccessible(true);
                                method.invoke((Object)permissions, player.getID());
                                LOGGER.info("\ud83c\udfdb\ufe0f NEW OWNER SET (alt): {} is now the owner of reactivated colony {}", (Object)player.getName(), (Object)colony.getName());
                                break block9;
                            }
                        }
                        catch (Exception e2) {
                            LOGGER.error("Failed to set {} as owner of colony {}: {}", (Object)player.getName(), (Object)colony.getName(), (Object)e2.getMessage());
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error cleaning up system owner for colony {}: {}", (Object)colony.getName(), (Object)e.getMessage());
            }
        }
    }

    public static UUID createSystemOwner() {
        return UUID.nameUUIDFromBytes("MINECOLONY_TAX_SYSTEM_OWNER".getBytes());
    }

    public static boolean isSystemOwner(UUID uuid) {
        return uuid != null && uuid.equals(ColonyAbandonmentManager.createSystemOwner());
    }

    public static void cleanupAllColoniesAbandonedEntries() {
        try {
            LOGGER.info("\ud83d\udd27 PROACTIVE CLEANUP: Starting cleanup of [abandoned] entries AND null owners across all colonies");
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            int coloniesCleaned = 0;
            int entriesRemoved = 0;
            int nullOwnersFixed = 0;
            for (IColony colony : colonyManager.getAllColonies()) {
                try {
                    IPermissions permissions = colony.getPermissions();
                    UUID owner = permissions.getOwner();
                    if (owner == null) {
                        LOGGER.warn("\ud83d\udea8 FIXING null owner colony: {}", (Object)colony.getName());
                        ColonyAbandonmentManager.fixNullOwnerColony(colony);
                        ++nullOwnersFixed;
                    }
                    HashMap playersBefore = new HashMap(permissions.getPlayers());
                    ColonyAbandonmentManager.cleanupAbandonedEntries(permissions);
                    HashMap playersAfter = new HashMap(permissions.getPlayers());
                    int removedFromColony = playersBefore.size() - playersAfter.size();
                    if (removedFromColony <= 0) continue;
                    ++coloniesCleaned;
                    entriesRemoved += removedFromColony;
                    LOGGER.info("PROACTIVE CLEANUP: Cleaned {} entries from colony '{}' ({})", (Object)removedFromColony, (Object)colony.getName(), (Object)colony.getID());
                }
                catch (Exception e) {
                    LOGGER.error("PROACTIVE CLEANUP: Error cleaning colony '{}' ({}): {}", (Object)colony.getName(), (Object)colony.getID(), (Object)e.getMessage());
                }
            }
            LOGGER.info("\u2705 PROACTIVE CLEANUP: Completed - \ud83d\udea8 {} null owners fixed, {} colonies cleaned, {} total entries removed", (Object)nullOwnersFixed, (Object)coloniesCleaned, (Object)entriesRemoved);
        }
        catch (Exception e) {
            LOGGER.error("PROACTIVE CLEANUP: Error during global cleanup", (Throwable)e);
        }
    }

    private static void restoreNormalPermissions(IColony colony) {
        try {
            IPermissions permissions = colony.getPermissions();
            Rank neutralRank = permissions.getRankNeutral();
            LOGGER.info("Restoring normal permissions for colony {} (no longer abandoned)", (Object)colony.getName());
            permissions.setPermission(neutralRank, Action.ACCESS_HUTS, true);
            permissions.setPermission(neutralRank, Action.RIGHTCLICK_BLOCK, true);
            permissions.setPermission(neutralRank, Action.OPEN_CONTAINER, true);
            permissions.setPermission(neutralRank, Action.PICKUP_ITEM, true);
            permissions.setPermission(neutralRank, Action.TOSS_ITEM, true);
            permissions.setPermission(neutralRank, Action.BREAK_BLOCKS, false);
            permissions.setPermission(neutralRank, Action.PLACE_BLOCKS, false);
            LOGGER.info("Successfully restored normal permissions for colony {}", (Object)colony.getName());
        }
        catch (Exception e) {
            LOGGER.error("Error restoring normal permissions for colony {}", (Object)colony.getID(), (Object)e);
        }
    }

    public static enum AbandonmentStatus {
        ACTIVE,
        SHOULD_WARN,
        SHOULD_ABANDON;

    }
}

