/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.abandon;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.entity.mobs.EntityMercenary;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.abandon.ColonyAbandonmentManager;
import net.machiavelli.minecolonytax.militia.CitizenMilitiaManager;
import net.machiavelli.minecolonytax.requirements.BuildingRequirementsManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColonyClaimingRaidManager {
    private static final Logger LOGGER = LogManager.getLogger(ColonyClaimingRaidManager.class);
    private static final Map<Integer, ClaimingRaidData> activeClaimingRaids = new ConcurrentHashMap<Integer, ClaimingRaidData>();
    private static final Map<UUID, Long> claimingGracePeriods = new ConcurrentHashMap<UUID, Long>();
    private static final Map<Integer, String> protectedColonies = new ConcurrentHashMap<Integer, String>();

    public static boolean startClaimingRaid(IColony colony, ServerPlayer claimingPlayer) {
        if (!TaxConfig.isAbandonedColonyClaimingEnabled()) {
            claimingPlayer.m_213846_((Component)Component.m_237113_((String)"Colony claiming is disabled!").m_130940_(ChatFormatting.RED));
            return false;
        }
        if (!ColonyAbandonmentManager.isColonyAbandoned(colony)) {
            claimingPlayer.m_213846_((Component)Component.m_237113_((String)"This colony is not abandoned!").m_130940_(ChatFormatting.RED));
            return false;
        }
        if (activeClaimingRaids.containsKey(colony.getID())) {
            claimingPlayer.m_213846_((Component)Component.m_237113_((String)"A claiming raid is already in progress for this colony!").m_130940_(ChatFormatting.RED));
            return false;
        }
        ClaimingRequirementResult requirementResult = ColonyClaimingRaidManager.checkClaimingRequirements(claimingPlayer, colony);
        if (!requirementResult.canClaim) {
            claimingPlayer.m_213846_((Component)Component.m_237113_((String)("Cannot claim colony: " + requirementResult.message)).m_130940_(ChatFormatting.RED));
            return false;
        }
        boolean isFormerMember = ColonyAbandonmentManager.wasFormerOwnerOrOfficer(colony.getID(), claimingPlayer.m_20148_());
        if (isFormerMember) {
            LOGGER.info("RECLAIM ATTEMPT: Former owner/officer {} is attempting to reclaim their abandoned colony {}", (Object)claimingPlayer.m_7755_().getString(), (Object)colony.getName());
            claimingPlayer.m_213846_((Component)Component.m_237113_((String)"You are reclaiming your former colony. Requirements bypassed but you must complete the claiming raid!").m_130940_(ChatFormatting.YELLOW));
        }
        try {
            ClaimingRaidData raidData = new ClaimingRaidData(colony.getID(), claimingPlayer.m_20148_(), colony.getCenter());
            activeClaimingRaids.put(colony.getID(), raidData);
            int citizenCount = ColonyClaimingRaidManager.convertCitizensToMilitia(colony, claimingPlayer, raidData);
            int mercenaryCount = 0;
            if (TaxConfig.shouldSpawnMercenariesIfLowDefenders() && citizenCount < 5 && (mercenaryCount = ColonyClaimingRaidManager.spawnDefendingMercenaries(colony, claimingPlayer, raidData)) > 0) {
                int totalDefenders = citizenCount + mercenaryCount;
                CitizenMilitiaManager.getInstance().setTotalDefenders(colony.getID(), totalDefenders);
                LOGGER.info("Updated total defenders to {} (citizens: {}, mercenaries: {}) for claiming raid in colony {}", (Object)totalDefenders, (Object)citizenCount, (Object)mercenaryCount, (Object)colony.getName());
            }
            LOGGER.info("Creating boss bar for claiming raid in colony {} for player {}", (Object)colony.getName(), (Object)claimingPlayer.m_7755_().getString());
            ColonyClaimingRaidManager.createRaidBossBar(raidData, claimingPlayer);
            if (raidData.bossEvent != null) {
                LOGGER.info("Boss bar successfully created for claiming raid");
            } else {
                LOGGER.error("Failed to create boss bar for claiming raid");
            }
            ColonyClaimingRaidManager.setClaimingInteractionPermissions(colony, true);
            MutableComponent startMessage = Component.m_237113_((String)"COLONY CLAIMING RAID STARTED!").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + claimingPlayer.m_7755_().getString() + " is attempting to claim the abandoned colony of ")).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)(colony.getName() + "!")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)("\nVICTORY CONDITION: Kill ALL " + (citizenCount + mercenaryCount) + " defenders!")).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)("\nDefenders: " + citizenCount + " citizen militia")).m_130940_(ChatFormatting.RED));
            if (mercenaryCount > 0) {
                startMessage.m_7220_((Component)Component.m_237113_((String)(" + " + mercenaryCount + " mercenaries")).m_130940_(ChatFormatting.DARK_RED));
            }
            startMessage.m_7220_((Component)Component.m_237113_((String)"\nTimer expiration = DEFENDER VICTORY!").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
            claimingPlayer.m_213846_((Component)startMessage);
            MutableComponent nearbyMessage = Component.m_237113_((String)"\u2694 CLAIMING RAID STARTED \u2694").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + claimingPlayer.m_7755_().getString() + " is claiming " + colony.getName())).m_130940_(ChatFormatting.YELLOW));
            ColonyClaimingRaidManager.broadcastToNearbyPlayers(colony, (Component)nearbyMessage, 100.0);
            LOGGER.info("Started claiming raid for colony {} ({}) by player {} with {} defenders", (Object)colony.getName(), (Object)colony.getID(), (Object)claimingPlayer.m_7755_().getString(), (Object)(citizenCount + mercenaryCount));
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to start claiming raid for colony {} ({})", (Object)colony.getName(), (Object)colony.getID(), (Object)e);
            activeClaimingRaids.remove(colony.getID());
            return false;
        }
    }

    private static int convertCitizensToMilitia(IColony colony, ServerPlayer claimingPlayer, ClaimingRaidData raidData) {
        int convertedCount = 0;
        CitizenMilitiaManager.getInstance().initializeColonyMilitia(colony.getID());
        try {
            for (ICitizenData citizenData : colony.getCitizenManager().getCitizens()) {
                Optional entityOpt = citizenData.getEntity();
                if (!entityOpt.isPresent()) continue;
                AbstractEntityCitizen citizen = (AbstractEntityCitizen)entityOpt.get();
                citizen.m_7292_(new MobEffectInstance(MobEffects.f_19606_, TaxConfig.getClaimingRaidDurationMinutes() * 60 * 20, 2));
                citizen.m_7292_(new MobEffectInstance(MobEffects.f_19596_, TaxConfig.getClaimingRaidDurationMinutes() * 60 * 20, 1));
                citizen.m_7292_(new MobEffectInstance(MobEffects.f_19600_, TaxConfig.getClaimingRaidDurationMinutes() * 60 * 20, 1));
                citizen.m_6710_((LivingEntity)claimingPlayer);
                citizen.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)citizen, Player.class, 10, true, false, entity -> entity.equals((Object)claimingPlayer)));
                CitizenMilitiaManager.getInstance().addMilitiaMember(colony.getID(), citizenData.getId());
                raidData.hostileCitizens.add(citizenData.getId());
                ++convertedCount;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error converting citizens to militia for colony {}", (Object)colony.getID(), (Object)e);
        }
        if (convertedCount > 0) {
            CitizenMilitiaManager.getInstance().setTotalDefenders(colony.getID(), convertedCount);
            LOGGER.info("Registered {} citizens as militia defenders for claiming raid in colony {}", (Object)convertedCount, (Object)colony.getName());
        }
        return convertedCount;
    }

    private static int spawnDefendingMercenaries(IColony colony, ServerPlayer claimingPlayer, ClaimingRaidData raidData) {
        try {
            int mercenaryCount = Math.max(1, 5 - raidData.hostileCitizens.size());
            Level world = colony.getWorld();
            for (int i = 0; i < mercenaryCount; ++i) {
                EntityMercenary mercenary = (EntityMercenary)ModEntities.MERCENARY.m_20615_(world);
                if (mercenary == null) continue;
                BlockPos spawnPos = ColonyClaimingRaidManager.findMercenarySpawnPosition(colony.getCenter(), world);
                mercenary.m_6034_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
                mercenary.m_6710_((LivingEntity)claimingPlayer);
                mercenary.m_7292_(new MobEffectInstance(MobEffects.f_19606_, TaxConfig.getClaimingRaidDurationMinutes() * 60 * 20, 2));
                mercenary.m_7292_(new MobEffectInstance(MobEffects.f_19600_, TaxConfig.getClaimingRaidDurationMinutes() * 60 * 20, 1));
                world.m_7967_((Entity)mercenary);
                raidData.spawnedMercenaries.add((Entity)mercenary);
            }
            return mercenaryCount;
        }
        catch (Exception e) {
            LOGGER.error("Error spawning defending mercenaries for colony {}", (Object)colony.getID(), (Object)e);
            return 0;
        }
    }

    private static BlockPos findMercenarySpawnPosition(BlockPos center, Level world) {
        Random random = new Random();
        for (int attempts = 0; attempts < 10; ++attempts) {
            int z;
            int y;
            int x = center.m_123341_() + random.nextInt(20) - 10;
            BlockPos spawnPos = new BlockPos(x, y = world.m_5452_(Heightmap.Types.WORLD_SURFACE, new BlockPos(x, 0, z = center.m_123343_() + random.nextInt(20) - 10)).m_123342_(), z);
            if (!world.m_8055_(spawnPos).m_60795_() || world.m_8055_(spawnPos.m_7495_()).m_60795_()) continue;
            return spawnPos;
        }
        return center;
    }

    private static void createRaidBossBar(ClaimingRaidData raidData, ServerPlayer claimingPlayer) {
        block18: {
            if (raidData == null) {
                LOGGER.error("Cannot create boss bar - raid data is null");
                return;
            }
            if (claimingPlayer == null) {
                LOGGER.error("Cannot create boss bar - claiming player is null");
                return;
            }
            IColony colony = ColonyClaimingRaidManager.getColonyById(raidData.colonyId);
            if (colony == null) {
                LOGGER.error("Cannot create boss bar - colony {} not found", (Object)raidData.colonyId);
                return;
            }
            try {
                if (raidData.bossEvent != null) {
                    LOGGER.debug("Cleaning up existing boss bar before creating new one");
                    try {
                        raidData.bossEvent.m_7706_();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Failed to clean up existing boss bar: {}", (Object)e.getMessage());
                    }
                    raidData.bossEvent = null;
                }
                int totalDefenders = raidData.hostileCitizens.size() + raidData.spawnedMercenaries.size();
                int minutes = TaxConfig.getClaimingRaidDurationMinutes();
                MutableComponent bossBarText = Component.m_237113_((String)String.format("\u2694\ufe0f Defenders: %d | %02d:%02d", totalDefenders, minutes, 0)).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD});
                raidData.bossEvent = new ServerBossEvent((Component)bossBarText, BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);
                raidData.bossEvent.m_142711_(1.0f);
                try {
                    raidData.bossEvent.m_6543_(claimingPlayer);
                    LOGGER.info("BOSS BAR CREATED: Player {} added to boss bar for colony {} ({} defenders, {} minute timer)", (Object)claimingPlayer.m_7755_().getString(), (Object)colony.getName(), (Object)totalDefenders, (Object)minutes);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to add claiming player to boss bar: {}", (Object)e.getMessage());
                    return;
                }
                Level world = colony.getWorld();
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    try {
                        BlockPos center = colony.getCenter();
                        int playersAdded = 0;
                        for (ServerPlayer player : serverLevel.m_7654_().m_6846_().m_11314_()) {
                            double distance;
                            if (player.m_9236_() != world || player.equals((Object)claimingPlayer) || !((distance = player.m_20275_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_())) <= 10000.0)) continue;
                            try {
                                raidData.bossEvent.m_6543_(player);
                                ++playersAdded;
                                LOGGER.debug("Added nearby player {} to claiming raid boss bar", (Object)player.m_7755_().getString());
                            }
                            catch (Exception e) {
                                LOGGER.warn("Failed to add nearby player {} to boss bar: {}", (Object)player.m_7755_().getString(), (Object)e.getMessage());
                            }
                        }
                        LOGGER.info("BOSS BAR SETUP: Added {} nearby players to boss bar", (Object)playersAdded);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error adding nearby players to boss bar: {}", (Object)e.getMessage());
                    }
                }
                try {
                    ColonyClaimingRaidManager.updateRaidBossBar(raidData);
                    LOGGER.info("BOSS BAR INITIALIZED: Successfully created and updated boss bar for colony {}", (Object)colony.getName());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to perform initial boss bar update: {}", (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                LOGGER.error("BOSS BAR CREATION FAILED: Error creating boss bar for claiming raid in colony {}", (Object)(colony != null ? colony.getName() : "unknown"), (Object)e);
                if (raidData == null) break block18;
                raidData.bossEvent = null;
            }
        }
    }

    public static void updateClaimingRaids() {
        ColonyClaimingRaidManager.cleanupOldGracePeriods();
        Iterator<Map.Entry<Integer, ClaimingRaidData>> iterator = activeClaimingRaids.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ClaimingRaidData> entry = iterator.next();
            ClaimingRaidData raidData = entry.getValue();
            if (raidData.isExpired()) {
                ColonyClaimingRaidManager.endClaimingRaid(raidData, "Time expired - defenders successfully held the colony!");
                iterator.remove();
                continue;
            }
            ColonyClaimingRaidManager.updateRaidBossBar(raidData);
            ColonyClaimingRaidManager.checkRaidConditions(raidData);
        }
    }

    private static void updateRaidBossBar(ClaimingRaidData raidData) {
        int totalAliveDefenders;
        if (raidData.bossEvent == null) {
            LOGGER.warn("Boss bar is null for claiming raid in colony {} - attempting to recreate", (Object)raidData.colonyId);
            ServerPlayer claimingPlayer = ColonyClaimingRaidManager.getPlayerById(raidData.claimingPlayerId);
            if (claimingPlayer != null) {
                ColonyClaimingRaidManager.createRaidBossBar(raidData, claimingPlayer);
            }
            return;
        }
        ServerPlayer claimingPlayer = ColonyClaimingRaidManager.getPlayerById(raidData.claimingPlayerId);
        if (claimingPlayer != null) {
            if (!raidData.bossEvent.m_8324_().contains(claimingPlayer)) {
                raidData.bossEvent.m_6543_(claimingPlayer);
                LOGGER.debug("Re-added claiming player {} to boss bar", (Object)claimingPlayer.m_7755_().getString());
            }
        } else {
            LOGGER.debug("Claiming player not found for boss bar update in colony {}", (Object)raidData.colonyId);
        }
        long remaining = raidData.getRemainingTime();
        long total = TaxConfig.getClaimingRaidDurationMinutes() * 60 * 1000;
        float progress = (float)remaining / (float)total;
        raidData.bossEvent.m_142711_(Math.max(0.0f, progress));
        int minutes = (int)(remaining / 60000L);
        int seconds = (int)(remaining % 60000L / 1000L);
        IColony colony = ColonyClaimingRaidManager.getColonyById(raidData.colonyId);
        String colonyName = colony != null ? colony.getName() : "Unknown";
        int aliveCitizenCount = 0;
        int aliveMercenaryCount = 0;
        if (colony != null) {
            for (Integer citizenId : raidData.hostileCitizens) {
                ICitizenData citizenData = colony.getCitizenManager().getCivilian(citizenId.intValue());
                if (citizenData == null || !citizenData.getEntity().isPresent() || !((AbstractEntityCitizen)citizenData.getEntity().get()).m_6084_()) continue;
                ++aliveCitizenCount;
            }
            for (Entity mercenary : raidData.spawnedMercenaries) {
                if (!mercenary.m_6084_()) continue;
                ++aliveMercenaryCount;
            }
        }
        String bossBarText = (totalAliveDefenders = aliveCitizenCount + aliveMercenaryCount) == 0 ? "\ud83c\udf89 VICTORY! - All Defenders Eliminated" : String.format("\u2694\ufe0f Defenders: %d | %02d:%02d", totalAliveDefenders, minutes, seconds);
        ChatFormatting textColor = totalAliveDefenders == 0 ? ChatFormatting.GREEN : (remaining <= 60000L ? ChatFormatting.DARK_RED : (remaining <= 300000L ? ChatFormatting.RED : ChatFormatting.YELLOW));
        MutableComponent newText = Component.m_237113_((String)bossBarText).m_130944_(new ChatFormatting[]{textColor, ChatFormatting.BOLD});
        raidData.bossEvent.m_6456_((Component)newText);
        if (remaining <= 60000L) {
            raidData.bossEvent.m_6451_(BossEvent.BossBarColor.RED);
        } else if (remaining <= 300000L) {
            raidData.bossEvent.m_6451_(BossEvent.BossBarColor.YELLOW);
        } else {
            raidData.bossEvent.m_6451_(BossEvent.BossBarColor.GREEN);
        }
    }

    private static void checkRaidConditions(ClaimingRaidData raidData) {
        try {
            ICitizenData citizenData;
            IColony colony = ColonyClaimingRaidManager.getColonyById(raidData.colonyId);
            if (colony == null) {
                LOGGER.error("Colony {} not found during raid condition check - ending raid", (Object)raidData.colonyId);
                ColonyClaimingRaidManager.endClaimingRaid(raidData, "Colony not found");
                return;
            }
            ServerPlayer claimingPlayer = ColonyClaimingRaidManager.getPlayerById(raidData.claimingPlayerId);
            if (claimingPlayer == null) {
                LOGGER.debug("Claiming player {} not found during raid condition check - skipping update", (Object)raidData.claimingPlayerId);
                return;
            }
            double distance = claimingPlayer.m_20275_((double)raidData.colonyCenter.m_123341_(), (double)raidData.colonyCenter.m_123342_(), (double)raidData.colonyCenter.m_123343_());
            if (distance > 10000.0) {
                ColonyClaimingRaidManager.endClaimingRaid(raidData, "Claiming player left the area - defenders win!");
                return;
            }
            int aliveDefenderCount = 0;
            HashSet<Integer> deadCitizens = new HashSet<Integer>();
            HashSet<Entity> deadMercenaries = new HashSet<Entity>();
            for (Integer citizenId : raidData.hostileCitizens) {
                citizenData = colony.getCitizenManager().getCivilian(citizenId.intValue());
                if (citizenData != null && citizenData.getEntity().isPresent() && ((AbstractEntityCitizen)citizenData.getEntity().get()).m_6084_()) {
                    ++aliveDefenderCount;
                    continue;
                }
                deadCitizens.add(citizenId);
            }
            for (Entity mercenary : raidData.spawnedMercenaries) {
                if (mercenary.m_6084_()) {
                    ++aliveDefenderCount;
                    continue;
                }
                deadMercenaries.add(mercenary);
            }
            if (!deadCitizens.isEmpty() || !deadMercenaries.isEmpty()) {
                LOGGER.info("CLEANUP: Removing {} dead citizens and {} dead mercenaries from tracking in colony {}", (Object)deadCitizens.size(), (Object)deadMercenaries.size(), (Object)colony.getName());
                raidData.hostileCitizens.removeAll(deadCitizens);
                raidData.spawnedMercenaries.removeAll(deadMercenaries);
            }
            if (aliveDefenderCount == 0) {
                LOGGER.info("CLAIMING RAID VICTORY: All {} defenders eliminated in colony {} by {}", (Object)(raidData.hostileCitizens.size() + raidData.spawnedMercenaries.size()), (Object)colony.getName(), (Object)claimingPlayer.m_7755_().getString());
                activeClaimingRaids.remove(raidData.colonyId);
                ColonyClaimingRaidManager.completeClaimingRaid(raidData, true);
                return;
            }
            LOGGER.debug("CLAIMING RAID PROGRESS - {} defenders remaining in colony {}", (Object)aliveDefenderCount, (Object)colony.getName());
            if (System.currentTimeMillis() % 10000L < 1000L) {
                LOGGER.debug("Detailed defender status for colony {}:", (Object)colony.getName());
                for (Integer citizenId : raidData.hostileCitizens) {
                    citizenData = colony.getCitizenManager().getCivilian(citizenId.intValue());
                    if (citizenData != null && citizenData.getEntity().isPresent()) {
                        boolean isAlive = ((AbstractEntityCitizen)citizenData.getEntity().get()).m_6084_();
                        LOGGER.debug("  - Citizen {} (ID: {}): {}", (Object)citizenData.getName(), (Object)citizenId, (Object)(isAlive ? "ALIVE" : "DEAD"));
                        continue;
                    }
                    LOGGER.debug("  - Citizen ID {}: NO ENTITY", (Object)citizenId);
                }
                for (Entity mercenary : raidData.spawnedMercenaries) {
                    LOGGER.debug("  - Mercenary {}: {}", (Object)mercenary.m_19879_(), (Object)(mercenary.m_6084_() ? "ALIVE" : "DEAD"));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error checking raid conditions for colony {}", (Object)raidData.colonyId, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endClaimingRaid(ClaimingRaidData raidData, String reason) {
        try {
            IColony colony = ColonyClaimingRaidManager.getColonyById(raidData.colonyId);
            ServerPlayer claimingPlayer = ColonyClaimingRaidManager.getPlayerById(raidData.claimingPlayerId);
            if (raidData.bossEvent != null) {
                raidData.bossEvent.m_7706_();
            }
            if (colony != null) {
                for (Integer citizenId : raidData.hostileCitizens) {
                    ICitizenData citizenData = colony.getCitizenManager().getCivilian(citizenId.intValue());
                    if (citizenData == null || !citizenData.getEntity().isPresent()) continue;
                    AbstractEntityCitizen citizen = (AbstractEntityCitizen)citizenData.getEntity().get();
                    citizen.m_21195_(MobEffects.f_19606_);
                    citizen.m_21195_(MobEffects.f_19596_);
                    citizen.m_21195_(MobEffects.f_19600_);
                    citizen.m_6710_(null);
                }
            }
            for (Entity mercenary : raidData.spawnedMercenaries) {
                if (!mercenary.m_6084_()) continue;
                mercenary.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (colony != null) {
                CitizenMilitiaManager.getInstance().clearColonyMilitia(colony.getID());
                ColonyClaimingRaidManager.setClaimingInteractionPermissions(colony, false);
            }
            MutableComponent failureMessage = Component.m_237113_((String)"COLONY CLAIMING RAID FAILED").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\nReason: " + reason)).m_130940_(ChatFormatting.RED));
            if (colony != null && !reason.equals("Colony not found") && !reason.equals("Player or colony not found")) {
                ColonyClaimingRaidManager.broadcastToNearbyPlayers(colony, (Component)failureMessage, 100.0);
            }
            if (claimingPlayer != null && !reason.equals("Player or colony not found") && !reason.equals("Colony not found")) {
                claimingPlayer.m_213846_((Component)Component.m_237113_((String)("Colony claiming failed: " + reason)).m_130940_(ChatFormatting.RED));
            }
            LOGGER.info("Claiming raid for colony {} ended unsuccessfully: {}", (Object)raidData.colonyId, (Object)reason);
        }
        catch (Exception e) {
            LOGGER.error("Error ending claiming raid for colony {}", (Object)raidData.colonyId, (Object)e);
        }
        finally {
            activeClaimingRaids.remove(raidData.colonyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void completeClaimingRaid(ClaimingRaidData raidData, boolean success) {
        try {
            MutableComponent personalMessage;
            MutableComponent successMessage;
            IColony colony = ColonyClaimingRaidManager.getColonyById(raidData.colonyId);
            ServerPlayer claimingPlayer = ColonyClaimingRaidManager.getPlayerById(raidData.claimingPlayerId);
            if (colony == null || claimingPlayer == null) {
                ColonyClaimingRaidManager.endClaimingRaid(raidData, "Colony or player not found");
                return;
            }
            if (raidData.bossEvent != null) {
                raidData.bossEvent.m_7706_();
            }
            IPermissions permissions = colony.getPermissions();
            LOGGER.info("COLONY CORRUPTION PREVENTION: Safely updating permissions for colony {} without removing any players", (Object)colony.getName());
            UUID systemOwnerUUID = ColonyAbandonmentManager.createSystemOwner();
            if (permissions.getPlayers().containsKey(systemOwnerUUID)) {
                try {
                    permissions.removePlayer(systemOwnerUUID);
                    LOGGER.info("CLEANUP: Removed system owner from claimed colony {}", (Object)colony.getName());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to remove system owner from colony {}: {}", (Object)colony.getName(), (Object)e.getMessage());
                }
            }
            boolean isFormerMember = ColonyAbandonmentManager.wasFormerOwnerOrOfficer(colony.getID(), claimingPlayer.m_20148_());
            Rank officerRank = permissions.getRankOfficer();
            boolean wasAlreadyInColony = permissions.getPlayers().containsKey(claimingPlayer.m_20148_());
            if (wasAlreadyInColony) {
                permissions.setPlayerRank(claimingPlayer.m_20148_(), permissions.getRankOwner(), colony.getWorld());
                LOGGER.info("CLAIMING SUCCESS: Promoted existing player {} to OWNER of colony {}", (Object)claimingPlayer.m_7755_().getString(), (Object)colony.getName());
            } else {
                permissions.addPlayer(claimingPlayer.m_20148_(), claimingPlayer.m_7755_().getString(), permissions.getRankOwner());
                LOGGER.info("CLAIMING SUCCESS: Added new player {} as OWNER of colony {}", (Object)claimingPlayer.m_7755_().getString(), (Object)colony.getName());
            }
            try {
                Method setOwnerMethod = permissions.getClass().getMethod("setOwner", UUID.class);
                setOwnerMethod.invoke((Object)permissions, claimingPlayer.m_20148_());
                LOGGER.info("\ud83c\udfdb\ufe0f CLAIMING OWNER SET: {} is now the actual owner of claimed colony {}", (Object)claimingPlayer.m_7755_().getString(), (Object)colony.getName());
            }
            catch (Exception e) {
                LOGGER.warn("Could not set claiming player as actual owner directly, trying alternative: {}", (Object)e.getMessage());
                try {
                    for (Method method : permissions.getClass().getDeclaredMethods()) {
                        if (!method.getName().equals("setOwner") || method.getParameterCount() != 1) continue;
                        method.setAccessible(true);
                        method.invoke((Object)permissions, claimingPlayer.m_20148_());
                        LOGGER.info("\ud83c\udfdb\ufe0f CLAIMING OWNER SET (alt): {} is now the actual owner of claimed colony {}", (Object)claimingPlayer.m_7755_().getString(), (Object)colony.getName());
                    }
                }
                catch (Exception e2) {
                    LOGGER.error("Failed to set claiming player as actual owner: {}", (Object)e2.getMessage());
                }
            }
            Rank neutralRank = permissions.getRankNeutral();
            LOGGER.info("Restoring normal neutral permissions for abandoned colony {}", (Object)colony.getName());
            permissions.setPermission(neutralRank, Action.ACCESS_HUTS, true);
            permissions.setPermission(neutralRank, Action.RIGHTCLICK_BLOCK, true);
            permissions.setPermission(neutralRank, Action.OPEN_CONTAINER, true);
            permissions.setPermission(neutralRank, Action.PICKUP_ITEM, true);
            permissions.setPermission(neutralRank, Action.TOSS_ITEM, true);
            permissions.setPermission(neutralRank, Action.BREAK_BLOCKS, false);
            permissions.setPermission(neutralRank, Action.PLACE_BLOCKS, false);
            LOGGER.info("Colony {} permissions safely updated - claimer is Officer, all players preserved", (Object)colony.getName());
            if (isFormerMember) {
                LOGGER.info("RECLAIMED: Former owner/officer {} has reclaimed colony {} and set as Officer", (Object)claimingPlayer.m_7755_().getString(), (Object)colony.getName());
            } else {
                LOGGER.info("CLAIMED: New claimer {} has claimed colony {} and set as Officer", (Object)claimingPlayer.m_7755_().getString(), (Object)colony.getName());
            }
            ColonyAbandonmentManager.markColonyAsClaimed(colony.getID());
            ColonyClaimingRaidManager.setClaimingInteractionPermissions(colony, false);
            for (Integer citizenId : raidData.hostileCitizens) {
                ICitizenData citizenData = colony.getCitizenManager().getCivilian(citizenId.intValue());
                if (citizenData == null || !citizenData.getEntity().isPresent()) continue;
                AbstractEntityCitizen citizen = (AbstractEntityCitizen)citizenData.getEntity().get();
                citizen.m_21195_(MobEffects.f_19606_);
                citizen.m_21195_(MobEffects.f_19596_);
                citizen.m_21195_(MobEffects.f_19600_);
                citizen.m_6710_(null);
                citizen.f_21346_.m_262460_(goal -> true);
            }
            for (Entity mercenary : raidData.spawnedMercenaries) {
                if (!mercenary.m_6084_()) continue;
                mercenary.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            ColonyClaimingRaidManager.setClaimingInteractionPermissions(colony, false);
            CitizenMilitiaManager.getInstance().clearColonyMilitia(colony.getID());
            if (isFormerMember) {
                successMessage = Component.m_237113_((String)"COLONY RECLAIMED!").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + claimingPlayer.m_7755_().getString() + " has reclaimed their former colony ")).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)(colony.getName() + " and is now an Officer!")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"\nAll existing players remain with their current ranks.").m_130940_(ChatFormatting.GRAY));
                personalMessage = Component.m_237113_((String)("Welcome back! You have successfully reclaimed your former colony " + colony.getName() + " and are now an Officer! All existing players remain in the colony. Work together to rebuild your colony.")).m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD});
            } else {
                successMessage = Component.m_237113_((String)"COLONY CLAIMED SUCCESSFULLY!").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + claimingPlayer.m_7755_().getString() + " has successfully claimed the abandoned colony of ")).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)(colony.getName() + " and is now an Officer!")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"\nAll existing players remain with their current ranks.").m_130940_(ChatFormatting.GRAY));
                personalMessage = Component.m_237113_((String)("Congratulations! You have successfully claimed the colony of " + colony.getName() + " and are now an Officer! All existing players remain in the colony. Work with the remaining citizens to rebuild this colony.")).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD});
            }
            ColonyClaimingRaidManager.broadcastToNearbyPlayers(colony, (Component)successMessage, 100.0);
            claimingPlayer.m_213846_((Component)personalMessage);
            claimingGracePeriods.put(claimingPlayer.m_20148_(), System.currentTimeMillis());
            LOGGER.info("Player {} successfully claimed colony {} ({}) - grace period set for {} hours", (Object)claimingPlayer.m_7755_().getString(), (Object)colony.getName(), (Object)colony.getID(), (Object)TaxConfig.getClaimingGracePeriodHours());
        }
        catch (Exception e) {
            LOGGER.error("Error completing claiming raid for colony {}", (Object)raidData.colonyId, (Object)e);
        }
        finally {
            activeClaimingRaids.remove(raidData.colonyId);
        }
    }

    private static IColony getPlayerColony(ServerPlayer player) {
        try {
            return IColonyManager.getInstance().getIColonyByOwner(player.m_9236_(), (Player)player);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static IColony getColonyById(int colonyId) {
        try {
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            for (IColony colony : colonyManager.getAllColonies()) {
                if (colony.getID() != colonyId) continue;
                LOGGER.debug("COLONY LOOKUP SUCCESS: Found colony {} (ID: {})", (Object)colony.getName(), (Object)colonyId);
                return colony;
            }
            LOGGER.error("COLONY LOOKUP FAILED: Colony with ID {} not found among {} total colonies", (Object)colonyId, (Object)colonyManager.getAllColonies().size());
            return null;
        }
        catch (Exception e) {
            LOGGER.error("COLONY LOOKUP ERROR: Exception while finding colony {}: {}", (Object)colonyId, (Object)e.getMessage());
            return null;
        }
    }

    private static ServerPlayer getPlayerById(UUID playerId) {
        if (playerId == null) {
            return null;
        }
        try {
            ServerLevel serverLevel;
            Level player;
            for (ClaimingRaidData raidData : activeClaimingRaids.values()) {
                Level level;
                IColony colony = ColonyClaimingRaidManager.getColonyById(raidData.colonyId);
                if (colony == null || !((level = colony.getWorld()) instanceof ServerLevel) || (player = (serverLevel = (ServerLevel)level).m_7654_().m_6846_().m_11259_(playerId)) == null) continue;
                return player;
            }
            try {
                IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
                if (colonyManager != null) {
                    for (IColony colony : colonyManager.getAllColonies()) {
                        player = colony.getWorld();
                        if (!(player instanceof ServerLevel)) continue;
                        serverLevel = (ServerLevel)player;
                        if ((player = serverLevel.m_7654_().m_6846_().m_11259_(playerId)) == null) break;
                        return player;
                    }
                }
            }
            catch (Exception fallbackException) {
                LOGGER.debug("Fallback player lookup failed for UUID {}", (Object)playerId);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.debug("Error getting player by UUID {} - player might be offline", (Object)playerId);
            return null;
        }
    }

    private static void broadcastToNearbyPlayers(IColony colony, Component message, double radius) {
        try {
            Level world = colony.getWorld();
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                BlockPos center = colony.getCenter();
                for (ServerPlayer player : serverLevel.m_7654_().m_6846_().m_11314_()) {
                    double distance;
                    if (player.m_9236_() != world || !((distance = player.m_20275_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_())) <= radius * radius)) continue;
                    player.m_213846_(message);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error broadcasting message near colony {}", (Object)colony.getID(), (Object)e);
        }
    }

    public static boolean isColonyUnderClaimingRaid(int colonyId) {
        return activeClaimingRaids.containsKey(colonyId);
    }

    public static ClaimingRaidData getClaimingRaid(int colonyId) {
        return activeClaimingRaids.get(colonyId);
    }

    public static void endAllClaimingRaids() {
        for (ClaimingRaidData raidData : activeClaimingRaids.values()) {
            ColonyClaimingRaidManager.endClaimingRaid(raidData, "Server shutdown");
        }
        activeClaimingRaids.clear();
    }

    public static boolean isPlayerInClaimingRaid(UUID playerId, int colonyId) {
        ClaimingRaidData raidData = activeClaimingRaids.get(colonyId);
        return raidData != null && raidData.claimingPlayerId.equals(playerId) && System.currentTimeMillis() < raidData.endTime;
    }

    public static Set<Integer> getActiveClaimingRaidIds() {
        return new HashSet<Integer>(activeClaimingRaids.keySet());
    }

    public static void forceCheckVictoryCondition(int colonyId) {
        ClaimingRaidData raidData = activeClaimingRaids.get(colonyId);
        if (raidData != null) {
            LOGGER.info("FORCE CHECKING victory condition for colony {}", (Object)colonyId);
            ColonyClaimingRaidManager.checkRaidConditions(raidData);
        }
    }

    public static void forceRefreshBossBar(int colonyId) {
        ClaimingRaidData raidData = activeClaimingRaids.get(colonyId);
        if (raidData != null) {
            LOGGER.info("FORCE REFRESHING boss bar for colony {}", (Object)colonyId);
            ServerPlayer claimingPlayer = ColonyClaimingRaidManager.getPlayerById(raidData.claimingPlayerId);
            if (claimingPlayer == null) {
                LOGGER.warn("Cannot refresh boss bar - claiming player not found");
                return;
            }
            if (raidData.bossEvent != null) {
                raidData.bossEvent.m_7706_();
            }
            ColonyClaimingRaidManager.createRaidBossBar(raidData, claimingPlayer);
            LOGGER.info("Recreated boss bar for claiming raid in colony {}", (Object)colonyId);
        } else {
            LOGGER.warn("No active claiming raid found for colony {}", (Object)colonyId);
        }
    }

    public static void debugClaimingRaid(int colonyId) {
        ClaimingRaidData raidData = activeClaimingRaids.get(colonyId);
        if (raidData != null) {
            LOGGER.info("=== CLAIMING RAID DEBUG for Colony {} ===", (Object)colonyId);
            LOGGER.info("Claiming Player: {}", (Object)raidData.claimingPlayerId);
            LOGGER.info("Hostile Citizens: {}", (Object)raidData.hostileCitizens.size());
            LOGGER.info("Spawned Mercenaries: {}", (Object)raidData.spawnedMercenaries.size());
            LOGGER.info("Boss Event: {}", (Object)(raidData.bossEvent != null ? "EXISTS" : "NULL"));
            LOGGER.info("Time Remaining: {} ms", (Object)raidData.getRemainingTime());
            if (raidData.bossEvent != null) {
                LOGGER.info("Boss Bar Players: {}", (Object)raidData.bossEvent.m_8324_().size());
            }
        } else {
            LOGGER.info("No active claiming raid for colony {}", (Object)colonyId);
        }
    }

    public static void protectColony(int colonyId, String adminName) {
        protectedColonies.put(colonyId, adminName);
        LOGGER.info("Colony {} marked as protected from claiming by admin {}", (Object)colonyId, (Object)adminName);
    }

    public static void unprotectColony(int colonyId) {
        String adminName = protectedColonies.remove(colonyId);
        if (adminName != null) {
            LOGGER.info("Colony {} protection removed (was protected by {})", (Object)colonyId, (Object)adminName);
        }
    }

    public static boolean isColonyProtected(int colonyId) {
        return protectedColonies.containsKey(colonyId);
    }

    public static String getProtectedBy(int colonyId) {
        return protectedColonies.get(colonyId);
    }

    public static Map<Integer, String> getProtectedColonies() {
        return new HashMap<Integer, String>(protectedColonies);
    }

    public static void cleanupOldGracePeriods() {
        long gracePeriodMs = (long)(TaxConfig.getClaimingGracePeriodHours() * 60 * 60) * 1000L;
        long currentTime = System.currentTimeMillis();
        claimingGracePeriods.entrySet().removeIf(entry -> {
            long timeSinceLastClaim = currentTime - (Long)entry.getValue();
            return timeSinceLastClaim > gracePeriodMs;
        });
    }

    public static long getRemainingGracePeriod(UUID playerId) {
        Long lastClaimTime = claimingGracePeriods.get(playerId);
        if (lastClaimTime == null) {
            return 0L;
        }
        long gracePeriodMs = (long)(TaxConfig.getClaimingGracePeriodHours() * 60 * 60) * 1000L;
        long timeSinceLastClaim = System.currentTimeMillis() - lastClaimTime;
        return Math.max(0L, gracePeriodMs - timeSinceLastClaim);
    }

    public static boolean canPlayerClaimColony(ServerPlayer player) {
        return ColonyClaimingRaidManager.canPlayerClaimColony(player, null);
    }

    public static boolean canPlayerClaimColony(ServerPlayer player, IColony targetColony) {
        ClaimingRequirementResult result = ColonyClaimingRaidManager.checkClaimingRequirements(player, targetColony);
        return result.canClaim;
    }

    public static ClaimingRequirementResult checkClaimingRequirements(ServerPlayer player) {
        return ColonyClaimingRaidManager.checkClaimingRequirements(player, null);
    }

    public static ClaimingRequirementResult checkClaimingRequirements(ServerPlayer player, IColony targetColony) {
        int requiredGuards;
        Long lastClaimTime;
        UUID playerId = player.m_20148_();
        boolean isFormerOwnerOrOfficer = false;
        if (targetColony != null) {
            isFormerOwnerOrOfficer = ColonyAbandonmentManager.wasFormerOwnerOrOfficer(targetColony.getID(), playerId);
        }
        if ((lastClaimTime = claimingGracePeriods.get(playerId)) != null) {
            long gracePeriodMs = (long)(TaxConfig.getClaimingGracePeriodHours() * 60 * 60) * 1000L;
            long timeSinceLastClaim = System.currentTimeMillis() - lastClaimTime;
            if (timeSinceLastClaim < gracePeriodMs) {
                long remainingMs = gracePeriodMs - timeSinceLastClaim;
                long remainingHours = remainingMs / 3600000L;
                long remainingMinutes = remainingMs % 3600000L / 60000L;
                String timeRemaining = remainingHours > 0L ? remainingHours + "h " + remainingMinutes + "m" : remainingMinutes + "m";
                return new ClaimingRequirementResult(false, "You must wait " + timeRemaining + " before claiming another colony (24-hour cooldown).");
            }
        }
        if (targetColony != null && ColonyClaimingRaidManager.isColonyProtected(targetColony.getID())) {
            String protectedBy = ColonyClaimingRaidManager.getProtectedBy(targetColony.getID());
            return new ClaimingRequirementResult(false, "This colony is protected from claiming by admin " + protectedBy + ". Contact an administrator for assistance.");
        }
        if (isFormerOwnerOrOfficer) {
            LOGGER.info("CLAIMING BYPASS: Player {} was former owner/officer of colony {} - bypassing requirements but must complete raid", (Object)player.m_7755_().getString(), (Object)(targetColony != null ? targetColony.getName() : "unknown"));
            return new ClaimingRequirementResult(true, "Former owner/officer of this colony - requirements bypassed! You must still complete the claiming raid to reclaim control.");
        }
        IColony playerColony = ColonyClaimingRaidManager.getPlayerColony(player);
        if (playerColony == null) {
            return new ClaimingRequirementResult(false, "You must own a colony to claim abandoned colonies.");
        }
        int guardCount = WarSystem.countGuards(playerColony);
        if (guardCount < (requiredGuards = TaxConfig.getMinGuardsForClaimingRaid())) {
            return new ClaimingRequirementResult(false, "You need at least " + requiredGuards + " guards (you have " + guardCount + ").");
        }
        BuildingRequirementsManager.RequirementResult buildingCheck = BuildingRequirementsManager.checkClaimingRequirements(playerColony);
        if (!buildingCheck.meetsRequirements) {
            return new ClaimingRequirementResult(false, buildingCheck.message);
        }
        return new ClaimingRequirementResult(true, "All requirements met!");
    }

    public static void setClaimingInteractionPermissions(IColony colony, boolean allowed) {
        if (!TaxConfig.isAbandonedColonyClaimingEnabled()) {
            return;
        }
        IPermissions perms = colony.getPermissions();
        Rank hostile = perms.getRankHostile();
        Rank neutral = perms.getRankNeutral();
        Set<Action> claimingActions = TaxConfig.getClaimingActions();
        for (Action action : claimingActions) {
            perms.setPermission(hostile, action, allowed);
        }
        if (allowed) {
            perms.setPermission(neutral, Action.HURT_CITIZEN, true);
            perms.setPermission(neutral, Action.ATTACK_CITIZEN, true);
            perms.setPermission(neutral, Action.GUARDS_ATTACK, true);
            perms.setPermission(neutral, Action.HURT_VISITOR, true);
            perms.setPermission(neutral, Action.ATTACK_ENTITY, true);
            perms.setPermission(neutral, Action.SHOOT_ARROW, true);
            perms.setPermission(neutral, Action.THROW_POTION, true);
            perms.setPermission(neutral, Action.RIGHTCLICK_ENTITY, true);
            perms.setPermission(neutral, Action.FILL_BUCKET, true);
        } else {
            perms.setPermission(neutral, Action.HURT_CITIZEN, false);
            perms.setPermission(neutral, Action.ATTACK_CITIZEN, false);
            perms.setPermission(neutral, Action.GUARDS_ATTACK, false);
            perms.setPermission(neutral, Action.HURT_VISITOR, false);
            perms.setPermission(neutral, Action.ATTACK_ENTITY, false);
            perms.setPermission(neutral, Action.SHOOT_ARROW, false);
            perms.setPermission(neutral, Action.THROW_POTION, false);
            perms.setPermission(neutral, Action.RIGHTCLICK_ENTITY, false);
            perms.setPermission(neutral, Action.FILL_BUCKET, false);
        }
        LOGGER.info("Set claiming raid permissions for colony {} to: {} (includes attack permissions)", (Object)colony.getName(), (Object)allowed);
    }

    public static void cleanupAllFailedRaids() {
        try {
            LOGGER.info("EMERGENCY CLEANUP: Starting cleanup of all failed claiming raids");
            HashMap<Integer, ClaimingRaidData> raidsCopy = new HashMap<Integer, ClaimingRaidData>(activeClaimingRaids);
            int cleanedRaids = 0;
            for (Map.Entry entry : raidsCopy.entrySet()) {
                int colonyId = (Integer)entry.getKey();
                ClaimingRaidData raidData = (ClaimingRaidData)entry.getValue();
                try {
                    IColony colony = ColonyClaimingRaidManager.getColonyById(colonyId);
                    ServerPlayer claimingPlayer = ColonyClaimingRaidManager.getPlayerById(raidData.claimingPlayerId);
                    boolean needsCleanup = false;
                    Object reason = "";
                    if (colony == null) {
                        needsCleanup = true;
                        reason = "colony not found";
                    } else if (claimingPlayer == null) {
                        needsCleanup = true;
                        reason = "claiming player offline";
                    } else if (raidData.bossEvent == null) {
                        needsCleanup = true;
                        reason = "boss bar is null";
                    } else if (System.currentTimeMillis() - raidData.startTime > (long)TaxConfig.getClaimingRaidDurationMinutes() * 60000L + 300000L) {
                        needsCleanup = true;
                        reason = "raid overtime (+" + (System.currentTimeMillis() - raidData.startTime) / 60000L + " minutes)";
                    }
                    if (!needsCleanup) continue;
                    LOGGER.info("EMERGENCY CLEANUP: Ending failed raid for colony {} - {}", (Object)(colony != null ? colony.getName() : "Unknown"), reason);
                    if (raidData.bossEvent != null) {
                        raidData.bossEvent.m_7706_();
                    }
                    if (colony != null) {
                        ColonyClaimingRaidManager.setClaimingInteractionPermissions(colony, false);
                    }
                    activeClaimingRaids.remove(colonyId);
                    ++cleanedRaids;
                }
                catch (Exception e) {
                    LOGGER.error("EMERGENCY CLEANUP: Error cleaning raid for colony {}: {}", (Object)colonyId, (Object)e.getMessage());
                    activeClaimingRaids.remove(colonyId);
                    ++cleanedRaids;
                }
            }
            LOGGER.info("EMERGENCY CLEANUP: Cleaned up {} failed claiming raids", (Object)cleanedRaids);
        }
        catch (Exception e) {
            LOGGER.error("EMERGENCY CLEANUP: Error during cleanup of failed raids: {}", (Object)e.getMessage());
        }
    }

    public static class ClaimingRequirementResult {
        public final boolean canClaim;
        public final String message;

        public ClaimingRequirementResult(boolean canClaim, String message) {
            this.canClaim = canClaim;
            this.message = message;
        }
    }

    public static class ClaimingRaidData {
        public final int colonyId;
        public final UUID claimingPlayerId;
        public final long startTime;
        public final long endTime;
        public final Set<Integer> hostileCitizens;
        public final Set<Entity> spawnedMercenaries;
        public final BlockPos colonyCenter;
        public ServerBossEvent bossEvent;

        public ClaimingRaidData(int colonyId, UUID claimingPlayerId, BlockPos colonyCenter) {
            this.colonyId = colonyId;
            this.claimingPlayerId = claimingPlayerId;
            this.colonyCenter = colonyCenter;
            this.startTime = System.currentTimeMillis();
            this.endTime = this.startTime + (long)(TaxConfig.getClaimingRaidDurationMinutes() * 60 * 1000);
            this.hostileCitizens = ConcurrentHashMap.newKeySet();
            this.spawnedMercenaries = ConcurrentHashMap.newKeySet();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() >= this.endTime;
        }

        public long getRemainingTime() {
            return Math.max(0L, this.endTime - System.currentTimeMillis());
        }
    }
}

