/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.machiavelli.minecolonytax.MineColonyTax;
import net.machiavelli.minecolonytax.data.PlayerWarData;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="minecolonytax")
public class PlayerWarDataCapability {
    public static final ResourceLocation ID = new ResourceLocation("minecolonytax", "player_war_data");
    public static final Capability<PlayerWarData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerWarData>(){});

    public static PlayerWarData getOrCreate(Player player) {
        return (PlayerWarData)player.getCapability(CAPABILITY).orElseGet(PlayerWarData::new);
    }

    public static LazyOptional<PlayerWarData> get(Player player) {
        return player.getCapability(CAPABILITY);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        MineColonyTax.LOGGER.debug("Registering PlayerWarData capability");
        event.register(PlayerWarData.class);
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            MineColonyTax.LOGGER.debug("Attaching PlayerWarData capability to player entity");
            Provider provider = new Provider();
            event.addCapability(ID, (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerWarDataCapability.loadDataFromPersistent(serverPlayer, provider);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            try {
                String playerIdStr = player2.m_20149_();
                MineColonyTax.LOGGER.debug("Loading PlayerWarData for player " + playerIdStr);
                player2.getCapability(CAPABILITY).ifPresent(data -> {
                    CompoundTag persistentData = player2.getPersistentData();
                    if (persistentData.m_128441_("ForgeData")) {
                        CompoundTag forgeData = persistentData.m_128469_("ForgeData");
                        if (forgeData.m_128441_("minecolonytax_war_data")) {
                            CompoundTag warDataNbt = forgeData.m_128469_("minecolonytax_war_data");
                            data.deserializeNBT(warDataNbt);
                            MineColonyTax.LOGGER.debug("Loaded war data from persistent storage: " + warDataNbt);
                            MineColonyTax.LOGGER.info("Loaded war stats - PlayersKilled: " + data.getPlayersKilledInWar() + ", RaidedColonies: " + data.getRaidedColonies() + ", AmountRaided: " + data.getAmountRaided() + ", WarsWon: " + data.getWarsWon() + ", WarStalemates: " + data.getWarStalemates());
                        } else {
                            MineColonyTax.LOGGER.info("No war data found in ForgeData for player " + playerIdStr);
                        }
                    } else {
                        MineColonyTax.LOGGER.info("No ForgeData found for player " + playerIdStr);
                    }
                });
            }
            catch (Exception e) {
                MineColonyTax.LOGGER.error("Error loading player war data: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static void loadDataFromPersistent(ServerPlayer player, Provider provider) {
        try {
            String playerIdStr = player.m_20149_();
            MineColonyTax.LOGGER.info("Attempting to load persistent war data for player " + playerIdStr);
            CompoundTag persistentData = player.getPersistentData();
            if (persistentData.m_128441_("ForgeData")) {
                CompoundTag forgeData = persistentData.m_128469_("ForgeData");
                if (forgeData.m_128441_("minecolonytax_war_data")) {
                    CompoundTag warDataNbt = forgeData.m_128469_("minecolonytax_war_data");
                    provider.deserializeNBT(warDataNbt);
                    MineColonyTax.LOGGER.info("Successfully loaded war data from persistent storage: " + warDataNbt);
                } else {
                    MineColonyTax.LOGGER.info("No war data found in persistent storage for player " + playerIdStr);
                }
            }
        }
        catch (Exception e) {
            MineColonyTax.LOGGER.error("Error loading persistent data: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            try {
                event.getOriginal().getCapability(CAPABILITY).ifPresent(oldData -> {
                    try {
                        CompoundTag nbt = oldData.serializeNBT();
                        MineColonyTax.LOGGER.info("PlayerWarData on death: " + nbt);
                        event.getEntity().getCapability(CAPABILITY).ifPresent(newData -> {
                            try {
                                newData.deserializeNBT(nbt);
                                MineColonyTax.LOGGER.info("PlayerWarData after respawn: " + newData.serializeNBT());
                            }
                            catch (Exception e) {
                                MineColonyTax.LOGGER.error("Error deserializing player clone data: " + e.getMessage());
                            }
                        });
                    }
                    catch (Exception e) {
                        MineColonyTax.LOGGER.error("Error serializing original player data: " + e.getMessage());
                    }
                });
            }
            catch (Exception e) {
                MineColonyTax.LOGGER.error("Error during player clone: " + e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            String playerIdStr = player2.m_20149_();
            MineColonyTax.LOGGER.info("Player " + playerIdStr + " changed dimension, verifying war data persistence");
            player2.getCapability(CAPABILITY).ifPresent(data -> MineColonyTax.LOGGER.info("War stats after dimension change - PlayersKilled: " + data.getPlayersKilledInWar() + ", RaidedColonies: " + data.getRaidedColonies() + ", AmountRaided: " + data.getAmountRaided() + ", WarsWon: " + data.getWarsWon() + ", WarStalemates: " + data.getWarStalemates()));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            try {
                String playerIdStr = player2.m_20149_();
                MineColonyTax.LOGGER.info("Player " + playerIdStr + " logged in, ensuring war data is loaded");
                player2.getCapability(CAPABILITY).ifPresent(data -> {
                    CompoundTag persistentData = player2.getPersistentData();
                    if (persistentData.m_128441_("ForgeData")) {
                        CompoundTag forgeData = persistentData.m_128469_("ForgeData");
                        if (forgeData.m_128441_("minecolonytax_war_data")) {
                            CompoundTag warDataNbt = forgeData.m_128469_("minecolonytax_war_data");
                            data.deserializeNBT(warDataNbt);
                            MineColonyTax.LOGGER.info("War data loaded on player login: " + warDataNbt);
                            MineColonyTax.LOGGER.info("War stats on login - PlayersKilled: " + data.getPlayersKilledInWar() + ", RaidedColonies: " + data.getRaidedColonies() + ", AmountRaided: " + data.getAmountRaided() + ", WarsWon: " + data.getWarsWon() + ", WarStalemates: " + data.getWarStalemates());
                        } else {
                            MineColonyTax.LOGGER.info("No war data found for player " + playerIdStr + " on login");
                        }
                    }
                });
            }
            catch (Exception e) {
                MineColonyTax.LOGGER.error("Error loading war data on player login: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            try {
                String playerIdStr = player2.m_20149_();
                MineColonyTax.LOGGER.info("Player " + playerIdStr + " logged out, ensuring war data is saved");
                player2.getCapability(CAPABILITY).ifPresent(data -> {
                    CompoundTag nbt = data.serializeNBT();
                    MineColonyTax.LOGGER.info("War stats on logout - PlayersKilled: " + data.getPlayersKilledInWar() + ", RaidedColonies: " + data.getRaidedColonies() + ", AmountRaided: " + data.getAmountRaided() + ", WarsWon: " + data.getWarsWon() + ", WarStalemates: " + data.getWarStalemates());
                    CompoundTag persistentData = player2.getPersistentData();
                    if (!persistentData.m_128441_("ForgeData")) {
                        persistentData.m_128365_("ForgeData", (Tag)new CompoundTag());
                    }
                    CompoundTag forgeData = persistentData.m_128469_("ForgeData");
                    forgeData.m_128365_("minecolonytax_war_data", (Tag)nbt);
                    MineColonyTax.LOGGER.info("War data saved on player logout: " + nbt);
                });
            }
            catch (Exception e) {
                MineColonyTax.LOGGER.error("Error saving war data on player logout: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerSave(PlayerEvent.SaveToFile event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            try {
                CompoundTag persistentData;
                PlayerWarData data = PlayerWarDataCapability.getOrCreate((Player)player2);
                CompoundTag nbt = data.serializeNBT();
                String playerIdStr = player2.m_20149_();
                MineColonyTax.LOGGER.debug("Saving PlayerWarData for player " + playerIdStr);
                if (MineColonyTax.LOGGER.isDebugEnabled()) {
                    MineColonyTax.LOGGER.debug("Saving war stats - PlayersKilled: " + data.getPlayersKilledInWar() + ", RaidedColonies: " + data.getRaidedColonies() + ", AmountRaided: " + data.getAmountRaided() + ", WarsWon: " + data.getWarsWon() + ", WarStalemates: " + data.getWarStalemates());
                }
                if (!(persistentData = player2.getPersistentData()).m_128441_("ForgeData")) {
                    persistentData.m_128365_("ForgeData", (Tag)new CompoundTag());
                }
                CompoundTag forgeData = persistentData.m_128469_("ForgeData");
                forgeData.m_128365_("minecolonytax_war_data", (Tag)nbt);
                MineColonyTax.LOGGER.debug("PlayerWarData successfully saved to persistent storage for player " + playerIdStr);
            }
            catch (Exception e) {
                MineColonyTax.LOGGER.error("Error saving player war data: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final PlayerWarData data = new PlayerWarData();
        private final LazyOptional<PlayerWarData> instance = LazyOptional.of(() -> this.data);

        private Provider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> requiredCapability, @Nullable Direction side) {
            return CAPABILITY.orEmpty(requiredCapability, this.instance);
        }

        void invalidate() {
            this.instance.invalidate();
        }

        public CompoundTag serializeNBT() {
            try {
                CompoundTag tag = this.data.serializeNBT();
                return tag;
            }
            catch (Exception e) {
                MineColonyTax.LOGGER.error("Error serializing PlayerWarData: " + e.getMessage());
                return new CompoundTag();
            }
        }

        public void deserializeNBT(CompoundTag nbt) {
            try {
                if (nbt != null) {
                    this.data.deserializeNBT(nbt);
                } else {
                    MineColonyTax.LOGGER.warn("Received null NBT data for PlayerWarData");
                }
            }
            catch (Exception e) {
                MineColonyTax.LOGGER.error("Error deserializing PlayerWarData: " + e.getMessage());
            }
        }
    }
}

