/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.commands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.machiavelli.minecolonytax.CrashLogger;
import net.machiavelli.minecolonytax.TaxManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckTaxRevenueCommand {
    private static final Logger LOGGER = LogManager.getLogger(CheckTaxRevenueCommand.class);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"checktax").requires(source -> source.m_6761_(0))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).requires(source -> source.m_6761_(2))).executes(context -> CheckTaxRevenueCommand.checkTaxForPlayer((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"))))).executes(CheckTaxRevenueCommand::checkTaxForSelf);
        dispatcher.register(command);
    }

    private static int checkTaxForSelf(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer player = source.m_81375_();
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Unable to retrieve server instance."));
                return 0;
            }
            LOGGER.info("Executing /checktax command for player: {}", (Object)player.m_7755_().getString());
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            List colonies = colonyManager.getAllColonies();
            boolean foundColonies = false;
            for (IColony colony : colonies) {
                Rank playerRank = colony.getPermissions().getRank(player.m_20148_());
                LOGGER.info("Checking colony: {}, Player rank: {}", (Object)colony.getName(), (Object)playerRank);
                if (!playerRank.isColonyManager()) continue;
                foundColonies = true;
                int taxRevenue = TaxManager.getStoredTaxForColony(colony);
                LOGGER.info("Player {} is a manager of colony '{}'. Tax revenue: {}", (Object)player.m_7755_().getString(), (Object)colony.getName(), (Object)taxRevenue);
                source.m_288197_(() -> Component.m_237110_((String)"command.checktax.self", (Object[])new Object[]{colony.getName(), taxRevenue}), false);
            }
            if (!foundColonies) {
                LOGGER.warn("Player {} is not a manager of any colonies.", (Object)player.m_7755_().getString());
                source.m_81352_((Component)Component.m_237115_((String)"command.checktax.no_colonies"));
            }
            return 1;
        }
        catch (CommandSyntaxException e) {
            CrashLogger.logCrash((Exception)((Object)e), "CommandSyntaxException while executing /checktax for player.");
            source.m_81352_((Component)Component.m_237113_((String)"An error occurred while processing the command. Please report this issue."));
            return 0;
        }
        catch (Exception e) {
            String additionalInfo = "Unexpected error while player: " + source.m_81368_() + " attempted to check tax.";
            CrashLogger.logCrash(e, additionalInfo);
            source.m_81352_((Component)Component.m_237113_((String)"An unexpected error occurred. Please report this issue to the server admin."));
            return 0;
        }
    }

    private static int checkTaxForPlayer(CommandContext<CommandSourceStack> context, String playerName) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer targetPlayer = source.m_81377_().m_6846_().m_11255_(playerName);
        if (targetPlayer != null) {
            MinecraftServer server = source.m_81377_();
            if (server == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Unable to retrieve server instance."));
                return 0;
            }
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            List colonies = colonyManager.getAllColonies();
            boolean foundColonies = false;
            for (IColony colony : colonies) {
                Rank playerRank = colony.getPermissions().getRank(targetPlayer.m_20148_());
                if (!playerRank.isColonyManager()) continue;
                foundColonies = true;
                int taxRevenue = TaxManager.getStoredTaxForColony(colony);
                source.m_288197_(() -> Component.m_237110_((String)"command.checktax.other", (Object[])new Object[]{playerName, colony.getName(), taxRevenue}), false);
            }
            if (!foundColonies) {
                source.m_81352_((Component)Component.m_237115_((String)"command.checktax.no_colonies"));
            }
        } else {
            source.m_81352_((Component)Component.m_237110_((String)"command.checktax.player_not_found", (Object[])new Object[]{playerName}));
        }
        return 1;
    }
}

