/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.commands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.stream.Collectors;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.data.WarData;
import net.machiavelli.minecolonytax.permissions.TaxPermissionManager;
import net.machiavelli.minecolonytax.raid.RaidManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.sixik.sdmshoprework.SDMShopR;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClaimTaxCommand {
    private static final Logger LOGGER = LogManager.getLogger(ClaimTaxCommand.class);
    private static final SuggestionProvider<CommandSourceStack> COLONY_SUGGESTIONS = (context, builder) -> {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        catch (CommandSyntaxException e) {
            return builder.buildFuture();
        }
        IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
        List colonyNames = colonyManager.getAllColonies().stream().filter(colony -> colony.getPermissions().getRank(player.m_20148_()).isColonyManager()).map(IColony::getName).map(name -> name.contains(" ") ? "\"" + name + "\"" : name).collect(Collectors.toList());
        return SharedSuggestionProvider.m_82970_(colonyNames, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"claimtax").requires(source -> source.m_6761_(0))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(COLONY_SUGGESTIONS).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            String colonyName = StringArgumentType.getString((CommandContext)context, (String)"colony").replace("\"", "");
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            return ClaimTaxCommand.execute((CommandContext<CommandSourceStack>)context, colonyName, amount);
        }))).executes(context -> {
            String colonyName = StringArgumentType.getString((CommandContext)context, (String)"colony").replace("\"", "");
            return ClaimTaxCommand.execute((CommandContext<CommandSourceStack>)context, colonyName, -1);
        }))).executes(context -> ClaimTaxCommand.execute((CommandContext<CommandSourceStack>)context, null, -1)));
    }

    private static int execute(CommandContext<CommandSourceStack> context, String colonyName, int amount) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
        List colonies = colonyManager.getAllColonies();
        boolean foundColonies = false;
        for (IColony colony : colonies) {
            boolean isOfficer;
            Rank playerRank = colony.getPermissions().getRank(player.m_20148_());
            if (colonyName != null && !colony.getName().equalsIgnoreCase(colonyName) || playerRank == null || !playerRank.isColonyManager()) continue;
            foundColonies = true;
            boolean isOwner = playerRank.equals((Object)colony.getPermissions().getRankOwner());
            boolean bl = isOfficer = playerRank.equals((Object)colony.getPermissions().getRankOfficer()) || isOwner;
            if (!TaxPermissionManager.canPlayerClaimTax(colony.getID(), player.m_20148_(), isOwner, isOfficer)) {
                player.m_213846_((Component)Component.m_237113_((String)("You do not have permission to claim taxes for colony " + colony.getName() + ". Contact a colony owner.")).m_130940_(ChatFormatting.RED));
                continue;
            }
            if (RaidManager.getActiveRaidForColony(colony.getID()) != null) {
                player.m_213846_((Component)Component.m_237113_((String)("Cannot claim tax for colony " + colony.getName() + " - colony is currently being raided!")).m_130940_(ChatFormatting.RED));
                continue;
            }
            WarData war = WarSystem.ACTIVE_WARS.get(colony.getID());
            if (war == null) {
                for (WarData wd : WarSystem.ACTIVE_WARS.values()) {
                    if (wd.getAttackerColony() == null || wd.getAttackerColony().getID() != colony.getID()) continue;
                    war = wd;
                    break;
                }
            }
            if (war != null) {
                String phase = war.isJoinPhaseActive() ? "join phase" : "active war";
                player.m_213846_((Component)Component.m_237113_((String)("Cannot claim tax for colony " + colony.getName() + " - colony is currently at war (" + phase + ")!")).m_130940_(ChatFormatting.RED));
                continue;
            }
            int totalClaimed = TaxManager.claimTax(colony, amount);
            if (totalClaimed > 0) {
                player.m_213846_((Component)Component.m_237110_((String)"command.claimtax.success", (Object[])new Object[]{colony.getName(), totalClaimed}));
                if (TaxConfig.isSDMShopConversionEnabled()) {
                    long currentBalance = SDMShopR.getMoney((Player)player);
                    SDMShopR.setMoney((Player)player, (long)(currentBalance + (long)totalClaimed));
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(TaxConfig.getCurrencyItemName()));
                if (item != null) {
                    ItemStack itemStack = new ItemStack((ItemLike)item, totalClaimed);
                    boolean added = player.m_150109_().m_36054_(itemStack);
                    if (!added) {
                        player.m_36176_(itemStack, false);
                        player.m_213846_((Component)Component.m_237110_((String)"taxmanager.inventory_full", (Object[])new Object[]{totalClaimed, TaxConfig.getCurrencyItemName()}));
                        continue;
                    }
                    player.m_213846_((Component)Component.m_237110_((String)"taxmanager.currency_received", (Object[])new Object[]{totalClaimed, TaxConfig.getCurrencyItemName()}));
                    continue;
                }
                String itemName = TaxConfig.getCurrencyItemName();
                String giveCommand = String.format("give %s %s %d", player.m_7755_().getString(), itemName, totalClaimed);
                source.m_81377_().m_129892_().m_230957_(source.m_81377_().m_129893_(), giveCommand);
                continue;
            }
            player.m_213846_((Component)Component.m_237110_((String)"command.claimtax.no_tax", (Object[])new Object[]{colony.getName()}));
        }
        if (!foundColonies) {
            if (colonyName != null) {
                source.m_81352_((Component)Component.m_237110_((String)"command.claimtax.colony_not_found", (Object[])new Object[]{colonyName}));
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"command.claimtax.no_colonies"));
            }
        }
        return 1;
    }
}

