/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.commands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.machiavelli.minecolonytax.TaxConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class ColonyActivityCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"colonyactivity").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"check").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ColonyActivityCommand::checkColonyActivity)))).then(Commands.m_82127_((String)"list").executes(ColonyActivityCommand::listInactiveColonies))).then(Commands.m_82127_((String)"status").executes(ColonyActivityCommand::showSystemStatus)));
    }

    private static int checkColonyActivity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int colonyId;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        IColony colony = ColonyActivityCommand.findColonyById(source, colonyId = IntegerArgumentType.getInteger(context, (String)"colonyId"));
        if (colony == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Colony with ID " + colonyId + " not found.")));
            return 0;
        }
        int lastContactHours = colony.getLastContactInHours();
        int threshold = TaxConfig.getColonyInactivityHoursThreshold();
        boolean isInactive = TaxConfig.isColonyInactivityTaxPauseEnabled() && lastContactHours >= threshold;
        String status = isInactive ? "INACTIVE (Tax generation paused)" : "ACTIVE";
        source.m_288197_(() -> Component.m_237110_((String)"command.minecolonytax.inactivity_status", (Object[])new Object[]{colony.getName(), lastContactHours, threshold, status}), true);
        if (isInactive) {
            int hoursOverThreshold = lastContactHours - threshold;
            source.m_288197_(() -> Component.m_237113_((String)String.format("Colony has been inactive for %d hours beyond the threshold of %d hours.", hoursOverThreshold, threshold)), true);
        }
        return 1;
    }

    private static int listInactiveColonies(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!TaxConfig.isColonyInactivityTaxPauseEnabled()) {
            source.m_288197_(() -> Component.m_237113_((String)"Colony inactivity tax pause system is currently disabled."), true);
            return 1;
        }
        source.m_288197_(() -> Component.m_237113_((String)"Scanning for inactive colonies..."), true);
        int[] counters = new int[]{0, 0};
        int threshold = TaxConfig.getColonyInactivityHoursThreshold();
        for (Level world : source.m_81377_().m_129785_()) {
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            for (IColony colony : colonyManager.getColonies(world)) {
                counters[1] = counters[1] + 1;
                int lastContactHours = colony.getLastContactInHours();
                if (lastContactHours < threshold) continue;
                counters[0] = counters[0] + 1;
                String colonyName = colony.getName();
                int colonyId = colony.getID();
                int finalLastContactHours = lastContactHours;
                source.m_288197_(() -> Component.m_237113_((String)String.format("\u2022 %s (ID: %d) - Last contact: %d hours ago", colonyName, colonyId, finalLastContactHours)), true);
            }
        }
        int finalInactiveCount = counters[0];
        int finalTotalCount = counters[1];
        if (finalInactiveCount == 0) {
            source.m_288197_(() -> Component.m_237113_((String)("No inactive colonies found! All " + finalTotalCount + " colonies are active.")), true);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)String.format("Found %d inactive colonies out of %d total colonies.", finalInactiveCount, finalTotalCount)), true);
        }
        return 1;
    }

    private static int showSystemStatus(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        boolean enabled = TaxConfig.isColonyInactivityTaxPauseEnabled();
        int threshold = TaxConfig.getColonyInactivityHoursThreshold();
        source.m_288197_(() -> Component.m_237113_((String)"=== Colony Inactivity System Status ==="), true);
        source.m_288197_(() -> Component.m_237113_((String)("System Enabled: " + (enabled ? "YES" : "NO"))), true);
        if (enabled) {
            source.m_288197_(() -> Component.m_237113_((String)("Inactivity Threshold: " + threshold + " hours")), true);
            source.m_288197_(() -> Component.m_237113_((String)("Threshold in Days: " + String.format("%.1f", (double)threshold / 24.0))), true);
            int[] stats = new int[]{0, 0};
            for (Level world : source.m_81377_().m_129785_()) {
                IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
                for (IColony colony : colonyManager.getColonies(world)) {
                    stats[0] = stats[0] + 1;
                    if (colony.getLastContactInHours() < threshold) continue;
                    stats[1] = stats[1] + 1;
                }
            }
            int finalTotalColonies = stats[0];
            int finalInactiveColonies = stats[1];
            int finalActiveColonies = finalTotalColonies - finalInactiveColonies;
            source.m_288197_(() -> Component.m_237113_((String)("Total Colonies: " + finalTotalColonies)), true);
            source.m_288197_(() -> Component.m_237113_((String)("Inactive Colonies: " + finalInactiveColonies)), true);
            source.m_288197_(() -> Component.m_237113_((String)("Active Colonies: " + finalActiveColonies)), true);
            if (finalTotalColonies > 0) {
                double inactivePercentage = (double)finalInactiveColonies * 100.0 / (double)finalTotalColonies;
                source.m_288197_(() -> Component.m_237113_((String)String.format("Inactive Percentage: %.1f%%", inactivePercentage)), true);
            }
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"Tax generation continues normally for all colonies."), true);
        }
        return 1;
    }

    private static IColony findColonyById(CommandSourceStack source, int colonyId) {
        for (Level world : source.m_81377_().m_129785_()) {
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            for (IColony colony : colonyManager.getColonies(world)) {
                if (colony.getID() != colonyId) continue;
                return colony;
            }
        }
        return null;
    }
}

