/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.commands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.raid.EntityRaidManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityRaidCommands {
    private static final Logger LOGGER = LogManager.getLogger(EntityRaidCommands.class);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"wnt").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"entityraid").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"status").executes(EntityRaidCommands::showEntityRaidStatus))).then(Commands.m_82127_((String)"config").executes(EntityRaidCommands::showEntityRaidConfig))).then(Commands.m_82127_((String)"end").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).executes(EntityRaidCommands::endEntityRaid)))).then(Commands.m_82127_((String)"test").then(Commands.m_82129_((String)"colonyName", (ArgumentType)StringArgumentType.string()).executes(EntityRaidCommands::testEntityRaid)))).then(Commands.m_82127_((String)"reload").executes(EntityRaidCommands::reloadEntityRaidConfig))));
    }

    public static int showEntityRaidStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            Map<Integer, EntityRaidManager.ActiveEntityRaid> activeRaids = EntityRaidManager.getActiveEntityRaids();
            if (activeRaids.isEmpty()) {
                source.m_288197_(() -> Component.m_237113_((String)"No active entity raids.").m_130940_(ChatFormatting.GREEN), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Active Entity Raids (" + activeRaids.size() + "):")).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
                for (Map.Entry<Integer, EntityRaidManager.ActiveEntityRaid> entry : activeRaids.entrySet()) {
                    int colonyId = entry.getKey();
                    EntityRaidManager.ActiveEntityRaid raid = entry.getValue();
                    IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (Level)source.m_81372_());
                    String colonyName = colony != null ? colony.getName() : "Unknown";
                    long duration = (System.currentTimeMillis() - raid.getStartTime()) / 1000L;
                    String status = raid.hasLeftBoundary() ? "BOUNDARY VIOLATION" : "ACTIVE";
                    source.m_288197_(() -> Component.m_237113_((String)("  \u2022 Colony: " + colonyName + " (ID: " + colonyId + ")")).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)("\n    Status: " + status)).m_130940_(raid.hasLeftBoundary() ? ChatFormatting.RED : ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)("\n    Duration: " + duration + "s")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("\n    Entities: " + raid.getTriggeringEntities().size())).m_130940_(ChatFormatting.AQUA)), false);
                }
            }
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error showing entity raid status", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error retrieving entity raid status: " + e.getMessage())));
            return 0;
        }
    }

    public static int showEntityRaidConfig(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            source.m_288197_(() -> Component.m_237113_((String)"Entity Raid Configuration:").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
            source.m_288197_(() -> Component.m_237113_((String)("  Enabled: " + TaxConfig.isEntityRaidsEnabled())).m_130940_(TaxConfig.isEntityRaidsEnabled() ? ChatFormatting.GREEN : ChatFormatting.RED), false);
            source.m_288197_(() -> Component.m_237113_((String)("  Threshold: " + TaxConfig.getEntityRaidThreshold() + " entities")).m_130940_(ChatFormatting.YELLOW), false);
            source.m_288197_(() -> Component.m_237113_((String)("  Detection Radius: " + TaxConfig.getEntityRaidDetectionRadius() + " blocks")).m_130940_(ChatFormatting.YELLOW), false);
            source.m_288197_(() -> Component.m_237113_((String)("  Message Only: " + TaxConfig.isEntityRaidMessageOnly())).m_130940_(ChatFormatting.YELLOW), false);
            source.m_288197_(() -> Component.m_237113_((String)("  Boundary Timer: " + TaxConfig.getEntityRaidBoundaryTimerSeconds() + " seconds")).m_130940_(ChatFormatting.YELLOW), false);
            source.m_288197_(() -> Component.m_237113_((String)("  Check Interval: " + TaxConfig.getEntityRaidCheckIntervalTicks() + " ticks")).m_130940_(ChatFormatting.YELLOW), false);
            source.m_288197_(() -> Component.m_237113_((String)("  Cooldown: " + TaxConfig.getEntityRaidCooldownMinutes() + " minutes")).m_130940_(ChatFormatting.YELLOW), false);
            List<? extends String> whitelist = TaxConfig.getEntityRaidWhitelist();
            source.m_288197_(() -> Component.m_237113_((String)("  Whitelisted Entities (" + whitelist.size() + "):")).m_130940_(ChatFormatting.AQUA), false);
            for (String string : whitelist) {
                source.m_288197_(() -> Component.m_237113_((String)("    \u2022 " + entityType)).m_130940_(ChatFormatting.GRAY), false);
            }
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error showing entity raid config", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error retrieving entity raid config: " + e.getMessage())));
            return 0;
        }
    }

    public static int endEntityRaid(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int colonyId = IntegerArgumentType.getInteger(context, (String)"colonyId");
        try {
            if (!EntityRaidManager.hasActiveEntityRaid(colonyId)) {
                source.m_81352_((Component)Component.m_237113_((String)("No active entity raid found for colony ID: " + colonyId)));
                return 0;
            }
            EntityRaidManager.endEntityRaid(colonyId, "Ended by administrator");
            source.m_288197_(() -> Component.m_237113_((String)("Entity raid ended for colony ID: " + colonyId)).m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error ending entity raid", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error ending entity raid: " + e.getMessage())));
            return 0;
        }
    }

    public static int testEntityRaid(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String colonyName = StringArgumentType.getString(context, (String)"colonyName");
        try {
            IColony foundColony = null;
            for (IColony c : IColonyManager.getInstance().getAllColonies()) {
                if (!c.getName().equalsIgnoreCase(colonyName)) continue;
                foundColony = c;
                break;
            }
            if (foundColony == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Colony not found: " + colonyName)));
                return 0;
            }
            IColony colony = foundColony;
            if (EntityRaidManager.hasActiveEntityRaid(colony.getID())) {
                source.m_81352_((Component)Component.m_237113_((String)("Colony already has an active entity raid: " + colonyName)));
                return 0;
            }
            if (!TaxConfig.isEntityRaidsEnabled()) {
                source.m_81352_((Component)Component.m_237113_((String)"Entity raids are disabled in the configuration"));
                return 0;
            }
            source.m_288197_(() -> Component.m_237113_((String)"\u26a0 TEST ENTITY RAID TRIGGERED \u26a0").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
            source.m_288197_(() -> Component.m_237113_((String)("This is a test of the entity raid system for colony: " + colony.getName())).m_130940_(ChatFormatting.YELLOW), true);
            source.m_288197_(() -> Component.m_237113_((String)("In a real scenario, this would be triggered by " + TaxConfig.getEntityRaidThreshold() + " or more whitelisted entities within " + TaxConfig.getEntityRaidDetectionRadius() + " blocks of the colony.")).m_130940_(ChatFormatting.GRAY), false);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error testing entity raid", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error testing entity raid: " + e.getMessage())));
            return 0;
        }
    }

    public static int reloadEntityRaidConfig(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            source.m_288197_(() -> Component.m_237113_((String)"Entity raid configuration reloaded successfully!").m_130940_(ChatFormatting.GREEN), true);
            source.m_288197_(() -> Component.m_237113_((String)("Current status: " + (TaxConfig.isEntityRaidsEnabled() ? "ENABLED" : "DISABLED"))).m_130940_(TaxConfig.isEntityRaidsEnabled() ? ChatFormatting.GREEN : ChatFormatting.RED), false);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error reloading entity raid config", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error reloading entity raid config: " + e.getMessage())));
            return 0;
        }
    }
}

