/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.commands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.permissions.GeneralColonyPermissionsManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeneralPermissionsCommands {
    private static final Logger LOGGER = LogManager.getLogger(GeneralPermissionsCommands.class);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"wnt").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"permissions").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"status").executes(GeneralPermissionsCommands::showPermissionsStatus))).then(Commands.m_82127_((String)"config").executes(GeneralPermissionsCommands::showPermissionsConfig))).then(Commands.m_82127_((String)"apply").executes(GeneralPermissionsCommands::applyGeneralPermissions))).then(Commands.m_82127_((String)"remove").executes(GeneralPermissionsCommands::removeGeneralPermissions))).then(Commands.m_82127_((String)"reload").executes(GeneralPermissionsCommands::reloadGeneralPermissions))).then(Commands.m_82127_((String)"apply").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).executes(GeneralPermissionsCommands::applyToSpecificColony)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).executes(GeneralPermissionsCommands::removeFromSpecificColony)))));
    }

    public static int showPermissionsStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            Map<Integer, Boolean> status = GeneralColonyPermissionsManager.getGeneralPermissionsStatus();
            source.m_288197_(() -> Component.m_237113_((String)"General Colony Permissions Status:").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
            source.m_288197_(() -> Component.m_237113_((String)("System Enabled: " + TaxConfig.isGeneralItemInteractionsEnabled())).m_130940_(TaxConfig.isGeneralItemInteractionsEnabled() ? ChatFormatting.GREEN : ChatFormatting.RED), false);
            if (status.isEmpty()) {
                source.m_288197_(() -> Component.m_237113_((String)"No colonies have general permissions applied.").m_130940_(ChatFormatting.YELLOW), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Colonies with General Permissions (" + status.size() + "):")).m_130940_(ChatFormatting.AQUA), false);
                for (Map.Entry<Integer, Boolean> entry : status.entrySet()) {
                    int colonyId = entry.getKey();
                    IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (Level)source.m_81372_());
                    String colonyName = colony != null ? colony.getName() : "Unknown";
                    source.m_288197_(() -> Component.m_237113_((String)("  \u2022 Colony: " + colonyName + " (ID: " + colonyId + ")")).m_130940_(ChatFormatting.GREEN), false);
                }
            }
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error showing permissions status", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error retrieving permissions status: " + e.getMessage())));
            return 0;
        }
    }

    public static int showPermissionsConfig(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            source.m_288197_(() -> Component.m_237113_((String)"General Colony Permissions Configuration:").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
            source.m_288197_(() -> Component.m_237113_((String)("  Enabled: " + TaxConfig.isGeneralItemInteractionsEnabled())).m_130940_(TaxConfig.isGeneralItemInteractionsEnabled() ? ChatFormatting.GREEN : ChatFormatting.RED), false);
            List<? extends String> actions = TaxConfig.getGeneralColonyActions();
            source.m_288197_(() -> Component.m_237113_((String)("  Allowed Actions (" + actions.size() + "):")).m_130940_(ChatFormatting.AQUA), false);
            for (String string : actions) {
                source.m_288197_(() -> Component.m_237113_((String)("    \u2022 " + action)).m_130940_(ChatFormatting.GRAY), false);
            }
            source.m_288197_(() -> Component.m_237113_((String)"  Description: These actions are allowed for ALL players").m_130940_(ChatFormatting.YELLOW), false);
            source.m_288197_(() -> Component.m_237113_((String)"  (including strangers and enemies) within colony boundaries.").m_130940_(ChatFormatting.YELLOW), false);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error showing permissions config", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error retrieving permissions config: " + e.getMessage())));
            return 0;
        }
    }

    public static int applyGeneralPermissions(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            if (!TaxConfig.isGeneralItemInteractionsEnabled()) {
                source.m_81352_((Component)Component.m_237113_((String)"General colony permissions are disabled in configuration"));
                return 0;
            }
            GeneralColonyPermissionsManager.applyGeneralPermissionsToAllColonies();
            source.m_288197_(() -> Component.m_237113_((String)"General permissions applied to all colonies successfully!").m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error applying general permissions", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error applying general permissions: " + e.getMessage())));
            return 0;
        }
    }

    public static int removeGeneralPermissions(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            GeneralColonyPermissionsManager.removeGeneralPermissionsFromAllColonies();
            source.m_288197_(() -> Component.m_237113_((String)"General permissions removed from all colonies successfully!").m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error removing general permissions", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error removing general permissions: " + e.getMessage())));
            return 0;
        }
    }

    public static int reloadGeneralPermissions(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            GeneralColonyPermissionsManager.reapplyGeneralPermissions();
            source.m_288197_(() -> Component.m_237113_((String)"General permissions reloaded successfully!").m_130940_(ChatFormatting.GREEN), true);
            source.m_288197_(() -> Component.m_237113_((String)("Current status: " + (TaxConfig.isGeneralItemInteractionsEnabled() ? "ENABLED" : "DISABLED"))).m_130940_(TaxConfig.isGeneralItemInteractionsEnabled() ? ChatFormatting.GREEN : ChatFormatting.RED), false);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error reloading general permissions", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error reloading general permissions: " + e.getMessage())));
            return 0;
        }
    }

    public static int applyToSpecificColony(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int colonyId = IntegerArgumentType.getInteger(context, (String)"colonyId");
        try {
            IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (Level)source.m_81372_());
            if (colony == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Colony not found with ID: " + colonyId)));
                return 0;
            }
            if (!TaxConfig.isGeneralItemInteractionsEnabled()) {
                source.m_81352_((Component)Component.m_237113_((String)"General colony permissions are disabled in configuration"));
                return 0;
            }
            GeneralColonyPermissionsManager.applyGeneralPermissions(colony);
            source.m_288197_(() -> Component.m_237113_((String)("General permissions applied to colony '" + colony.getName() + "' successfully!")).m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error applying general permissions to specific colony", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error applying general permissions: " + e.getMessage())));
            return 0;
        }
    }

    public static int removeFromSpecificColony(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int colonyId = IntegerArgumentType.getInteger(context, (String)"colonyId");
        try {
            IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (Level)source.m_81372_());
            if (colony == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Colony not found with ID: " + colonyId)));
                return 0;
            }
            GeneralColonyPermissionsManager.removeGeneralPermissions(colony);
            source.m_288197_(() -> Component.m_237113_((String)("General permissions removed from colony '" + colony.getName() + "' successfully!")).m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Error removing general permissions from specific colony", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Error removing general permissions: " + e.getMessage())));
            return 0;
        }
    }
}

