/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.event.RecipeDisableEventHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeDisableTestCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecipeDisableTestCommand.class);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"testrecipedisable").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"status").executes(RecipeDisableTestCommand::showStatus))).then(Commands.m_82127_((String)"list").executes(RecipeDisableTestCommand::listDisabledRecipes))).then(Commands.m_82127_((String)"check").then(Commands.m_82129_((String)"block_id", (ArgumentType)StringArgumentType.string()).executes(RecipeDisableTestCommand::checkBlock))));
    }

    private static int showStatus(CommandContext<CommandSourceStack> context) {
        boolean isEnabled = TaxConfig.isDisableHutRecipesEnabled();
        MutableComponent message = Component.m_237113_((String)"Recipe Disabling Status: ").m_7220_((Component)Component.m_237113_((String)(isEnabled ? "ENABLED" : "DISABLED")).m_130940_(isEnabled ? ChatFormatting.GREEN : ChatFormatting.RED));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> RecipeDisableTestCommand.lambda$showStatus$1((Component)message), false);
        return 1;
    }

    private static int listDisabledRecipes(CommandContext<CommandSourceStack> context) {
        Set<ResourceLocation> disabledRecipes = RecipeDisableEventHandler.getDisabledHutRecipes();
        MutableComponent message = Component.m_237113_((String)("Disabled Hut Recipes (" + disabledRecipes.size() + " total):")).m_130940_(ChatFormatting.YELLOW);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> RecipeDisableTestCommand.lambda$listDisabledRecipes$2((Component)message), false);
        for (ResourceLocation blockId : disabledRecipes) {
            MutableComponent blockMessage = Component.m_237113_((String)("  - " + blockId.toString())).m_130940_(ChatFormatting.GRAY);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> RecipeDisableTestCommand.lambda$listDisabledRecipes$3((Component)blockMessage), false);
        }
        return disabledRecipes.size();
    }

    private static int checkBlock(CommandContext<CommandSourceStack> context) {
        String blockIdString = StringArgumentType.getString(context, (String)"block_id");
        ResourceLocation blockId = ResourceLocation.m_135820_((String)blockIdString);
        if (blockId == null) {
            MutableComponent errorMessage = Component.m_237113_((String)("Invalid block ID: " + blockIdString)).m_130940_(ChatFormatting.RED);
            ((CommandSourceStack)context.getSource()).m_81352_((Component)errorMessage);
            return 0;
        }
        boolean shouldDisable = RecipeDisableEventHandler.shouldDisableRecipe(blockId);
        MutableComponent message = Component.m_237113_((String)("Block " + blockId + " recipe should be disabled: ")).m_7220_((Component)Component.m_237113_((String)(shouldDisable ? "YES" : "NO")).m_130940_(shouldDisable ? ChatFormatting.RED : ChatFormatting.GREEN));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> RecipeDisableTestCommand.lambda$checkBlock$4((Component)message), false);
        return shouldDisable ? 1 : 0;
    }

    private static /* synthetic */ Component lambda$checkBlock$4(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$listDisabledRecipes$3(Component blockMessage) {
        return blockMessage;
    }

    private static /* synthetic */ Component lambda$listDisabledRecipes$2(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$showStatus$1(Component message) {
        return message;
    }
}

