/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.commands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.stream.Collectors;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.sixik.sdmshoprework.SDMShopR;

public class TaxDebtCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"taxdebt").requires(source -> source.m_6761_(0))).then(Commands.m_82127_((String)"pay").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            ServerPlayer player;
            try {
                player = ((CommandSourceStack)context.getSource()).m_81375_();
            }
            catch (Exception e) {
                return builder.buildFuture();
            }
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            List colonyNames = colonyManager.getAllColonies().stream().filter(colony -> colony.getPermissions().getRank(player.m_20148_()).isColonyManager()).map(IColony::getName).map(name -> name.contains(" ") ? "\"" + name + "\"" : name).collect(Collectors.toList());
            return SharedSuggestionProvider.m_82970_(colonyNames, (SuggestionsBuilder)builder);
        }).executes(context -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            String colonyName = StringArgumentType.getString((CommandContext)context, (String)"colony").replace("\"", "");
            return TaxDebtCommand.execute((CommandContext<CommandSourceStack>)context, colonyName, amount);
        })))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, String colonyName, int amount) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
        boolean foundColony = false;
        for (IColony colony : colonyManager.getAllColonies()) {
            Rank playerRank = colony.getPermissions().getRank(player.m_20148_());
            if (playerRank == null || !playerRank.isColonyManager() || colonyName != null && !colony.getName().equalsIgnoreCase(colonyName)) continue;
            foundColony = true;
            int currentTax = TaxManager.getStoredTaxForColony(colony);
            boolean deducted = TaxDebtCommand.deductCurrency(player, amount);
            if (!deducted) {
                source.m_81352_((Component)Component.m_237110_((String)"command.taxdebt.insufficient_funds", (Object[])new Object[]{amount}));
                continue;
            }
            int paid = TaxManager.payTaxDebt(colony, amount);
            source.m_288197_(() -> Component.m_237110_((String)"command.taxdebt.success", (Object[])new Object[]{paid, colony.getName(), TaxManager.getStoredTaxForColony(colony)}), false);
        }
        if (!foundColony) {
            source.m_81352_((Component)Component.m_237110_((String)"command.taxdebt.colony_not_found", (Object[])new Object[]{colonyName}));
        }
        return 1;
    }

    private static boolean deductCurrency(ServerPlayer player, int amount) {
        if (TaxConfig.isSDMShopConversionEnabled()) {
            long balance = SDMShopR.getMoney((Player)player);
            if (balance < (long)amount) {
                return false;
            }
            SDMShopR.setMoney((Player)player, (long)(balance - (long)amount));
            return true;
        }
        return TaxDebtCommand.deductCurrencyFromInventory(player, amount);
    }

    private static boolean deductCurrencyFromInventory(ServerPlayer player, int amount) {
        int remaining = amount;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ResourceLocation registryName;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || (registryName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())) == null || !registryName.toString().equals(TaxConfig.getCurrencyItemName())) continue;
            int available = stack.m_41613_();
            if (available >= remaining) {
                stack.m_41774_(remaining);
                return true;
            }
            remaining -= available;
            stack.m_41764_(0);
        }
        return remaining <= 0;
    }
}

