/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.commands;

import com.minecolonies.api.colony.IColony;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.data.WarData;
import net.machiavelli.minecolonytax.peace.PeaceProposalManager;
import net.machiavelli.minecolonytax.raid.RaidManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class WarCommands {
    private static RaidManager raidManagerInstance;
    private static PeaceProposalManager peaceProposalManagerInstance;

    private static RaidManager getRaidManager() {
        if (raidManagerInstance == null) {
            raidManagerInstance = new RaidManager();
        }
        return raidManagerInstance;
    }

    private static PeaceProposalManager getPeaceProposalManager() {
        if (peaceProposalManagerInstance == null) {
            peaceProposalManagerInstance = new PeaceProposalManager();
        }
        return peaceProposalManagerInstance;
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"raid").then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).executes(WarCommands::handleRaidCommand)));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"wagewar").then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).executes(WarCommands::handleWageWarCommand)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"suepeace").then(Commands.m_82127_((String)"whitepeace").executes(WarCommands::suePeaceWhiteCommand))).then(Commands.m_82127_((String)"reparations").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> WarCommands.suePeaceReparationsCommand((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"joinwar").executes(WarCommands::joinWarCommand));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"leavewar").executes(WarCommands::leaveWarCommand));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"war").then(Commands.m_82127_((String)"accept").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> WarCommands.handleWarResponseCommand((CommandContext<CommandSourceStack>)ctx, true))))).then(Commands.m_82127_((String)"decline").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> WarCommands.handleWarResponseCommand((CommandContext<CommandSourceStack>)ctx, false)))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wardebug").requires(src -> src.m_6761_(2))).executes(WarCommands::debugWarCommand));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"warinfo").executes(WarCommands::warInfoCommand));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"choosewarside").then(Commands.m_82127_((String)"attacker").executes(ctx -> WarCommands.chooseWarSideCommand((CommandContext<CommandSourceStack>)ctx, true)))).then(Commands.m_82127_((String)"defender").executes(ctx -> WarCommands.chooseWarSideCommand((CommandContext<CommandSourceStack>)ctx, false))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"warstop").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).executes(WarCommands::stopWarCommand)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"warstopall").requires(src -> src.m_6761_(2))).executes(WarCommands::stopAllWarsCommand));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"raidstop").requires(src -> src.m_6761_(2))).executes(WarCommands::stopRaidCommand));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"peace").then(Commands.m_82127_((String)"accept").executes(WarCommands::acceptPeaceCommand))).then(Commands.m_82127_((String)"decline").executes(WarCommands::declinePeaceCommand)));
    }

    private static int handleRaidCommand(CommandContext<CommandSourceStack> context) {
        return WarCommands.getRaidManager().handleRaid(context);
    }

    private static int handleWageWarCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerLevel level;
        ServerPlayer attacker = ((CommandSourceStack)ctx.getSource()).m_81375_();
        String colonyName = StringArgumentType.getString(ctx, (String)"colony");
        IColony targetColony = WarSystem.findColonyByName(colonyName, (Level)(level = ((CommandSourceStack)ctx.getSource()).m_81372_()));
        if (targetColony == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Target colony not found!"));
            return 0;
        }
        WarCommands.getRaidManager();
        if (!RaidManager.getActiveRaids().isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"A raid is currently active! You cannot declare war."));
            return 0;
        }
        if (WarSystem.ACTIVE_WARS.containsKey(targetColony.getID())) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"A war is already active for this colony!"));
            return 0;
        }
        return WarSystem.processWageWarRequest(attacker, targetColony, (CommandSourceStack)ctx.getSource());
    }

    private static int handleWarResponseCommand(CommandContext<CommandSourceStack> ctx, boolean accepted) throws CommandSyntaxException {
        ServerPlayer executor = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int colonyId = IntegerArgumentType.getInteger(ctx, (String)"colonyId");
        return WarSystem.processWarResponse(executor, colonyId, accepted, (CommandSourceStack)ctx.getSource());
    }

    private static int joinWarCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        WarData war = WarSystem.getActiveWarForPlayer(player);
        if (war == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.joinwar.error.none").m_130940_(ChatFormatting.RED));
            return 0;
        }
        return WarSystem.processJoinWar(player, (CommandSourceStack)ctx.getSource());
    }

    private static int leaveWarCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        WarData war = WarSystem.getActiveWarForPlayer(player);
        if (war == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.joinwar.error.none").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (player.m_20148_().equals(war.getColony().getPermissions().getOwner()) || player.m_20148_().equals(war.getAttacker()) || war.getAttackerColony() != null && player.m_20148_().equals(war.getAttackerColony().getPermissions().getOwner())) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.leavewar.error.owner").m_130940_(ChatFormatting.RED));
            return 0;
        }
        return WarSystem.processLeaveWar(player, (CommandSourceStack)ctx.getSource());
    }

    private static int suePeaceWhiteCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WarCommands.getPeaceProposalManager().suePeaceWhite(ctx);
    }

    private static int suePeaceReparationsCommand(CommandContext<CommandSourceStack> ctx, int amount) throws CommandSyntaxException {
        return WarCommands.getPeaceProposalManager().suePeaceReparations(ctx, amount);
    }

    private static int acceptPeaceCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WarCommands.getPeaceProposalManager().acceptPeace(ctx);
    }

    private static int declinePeaceCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WarCommands.getPeaceProposalManager().declinePeace(ctx);
    }

    private static int warInfoCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String remainingStr;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        WarData war = WarSystem.getActiveWarForPlayer(player);
        if (war == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"You are not currently in an active war!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        String attackerColName = war.getAttackerColony() != null ? war.getAttackerColony().getName() : "UnknownAttackerColony";
        String defenderColName = war.getColony() != null ? war.getColony().getName() : "UnknownDefenderColony";
        String status = war.getStatus() != null ? war.getStatus().toString() : "UNKNOWN";
        long now = System.currentTimeMillis();
        if (war.isJoinPhaseActive()) {
            long remaining = Math.max(0L, (war.getJoinPhaseEndTime() - now) / 1000L);
            remainingStr = String.format("%02d:%02d", remaining / 60L, remaining % 60L);
        } else {
            long warDuration = (long)((Integer)TaxConfig.WAR_DURATION_MINUTES.get()).intValue() * 60L;
            long elapsed = (now - war.warStartTime) / 1000L;
            long remaining = Math.max(0L, warDuration - elapsed);
            remainingStr = String.format("%02d:%02d", remaining / 60L, remaining % 60L);
        }
        sb.append("\u00a7a\u00a7lWar Report: ").append(attackerColName).append(" vs ").append(defenderColName).append("\n");
        sb.append("\u00a7aWar ID: \u00a7f").append(war.getWarID()).append("\n");
        sb.append("\u00a7aStatus: \u00a7f").append(status).append("\n");
        sb.append("\u00a7aTime Remaining: \u00a7f").append(remainingStr).append("\n");
        sb.append("------------------------------------------\n");
        sb.append("\u00a7bAttacker Team:\n");
        war.getAttackerLives().forEach((uuid, lives) -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
            String name = sp != null ? sp.m_7755_().getString() : "OfflinePlayer";
            sb.append("  ").append(name).append(" - ").append(lives).append(" lives\n");
        });
        sb.append("\u00a7bDefender Team:\n");
        war.getDefenderLives().forEach((uuid, lives) -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
            String name = sp != null ? sp.m_7755_().getString() : "OfflinePlayer";
            sb.append("  ").append(name).append(" - ").append(lives).append(" lives\n");
        });
        sb.append("\u00a7aGuard Count:\n");
        sb.append(attackerColName).append(" = ").append(war.getRemainingAttackerGuards()).append("\n");
        sb.append(defenderColName).append(" = ").append(war.getRemainingDefenderGuards()).append("\n");
        sb.append("\u00a76==========================\n");
        if (!war.getPenaltyReport().isEmpty()) {
            sb.append("\u00a7cPenalty Report: \u00a7f").append(war.getPenaltyReport()).append("\n");
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)sb.toString()), false);
        return 1;
    }

    private static int debugWarCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ((CommandSourceStack)ctx.getSource()).m_81375_();
        if (WarSystem.ACTIVE_WARS.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No active wars at the moment!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        for (WarData war : WarSystem.ACTIVE_WARS.values()) {
            String remainingStr;
            String attackerColName = war.getAttackerColony() != null ? war.getAttackerColony().getName() : "UnknownAttackerColony";
            String defenderColName = war.getColony() != null ? war.getColony().getName() : "UnknownDefenderColony";
            String status = war.getStatus() != null ? war.getStatus().toString() : "UNKNOWN";
            long now = System.currentTimeMillis();
            if (war.isJoinPhaseActive()) {
                remaining = Math.max(0L, (war.getJoinPhaseEndTime() - now) / 1000L);
                remainingStr = String.format("%02d:%02d", remaining / 60L, remaining % 60L);
            } else {
                long warDuration = (long)((Integer)TaxConfig.WAR_DURATION_MINUTES.get()).intValue() * 60L;
                long elapsed = (now - war.warStartTime) / 1000L;
                remaining = Math.max(0L, warDuration - elapsed);
                remainingStr = String.format("%02d:%02d", remaining / 60L, remaining % 60L);
            }
            sb.append("\n\u00a7e\u00a7lWar Report: ").append(attackerColName).append(" vs ").append(defenderColName).append("\n");
            sb.append("\u00a7eWar ID: \u00a7f").append(war.getWarID()).append("\n");
            sb.append("\u00a7eStatus: \u00a7f").append(status).append("\n");
            sb.append("\u00a7eTime Remaining: \u00a7f").append(remainingStr).append("\n");
            sb.append("------------------------------------------\n");
            sb.append("\u00a7bAttacker Team:\n");
            war.getAttackerLives().forEach((uuid, lives) -> {
                ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
                String name = sp != null ? sp.m_7755_().getString() : "OfflinePlayer";
                sb.append("  ").append(name).append(" - ").append(lives).append(" lives\n");
            });
            sb.append("\u00a7bDefender Team:\n");
            war.getDefenderLives().forEach((uuid, lives) -> {
                ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
                String name = sp != null ? sp.m_7755_().getString() : "OfflinePlayer";
                sb.append("  ").append(name).append(" - ").append(lives).append(" lives\n");
            });
            sb.append("\u00a7eGuard Count:\n");
            sb.append(attackerColName).append(" = ").append(war.getRemainingAttackerGuards()).append("\n");
            sb.append(defenderColName).append(" = ").append(war.getRemainingDefenderGuards()).append("\n");
            sb.append("\u00a76==========================\n");
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)sb.toString()), false);
        return 1;
    }

    private static int stopAllWarsCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection<WarData> activeWars = WarSystem.ACTIVE_WARS.values();
        if (activeWars.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No active wars to stop.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        ArrayList<IColony> coloniesToStop = new ArrayList<IColony>();
        for (WarData war : activeWars) {
            coloniesToStop.add(war.getColony());
        }
        for (IColony colony : coloniesToStop) {
            WarSystem.endWar(colony);
            WarSystem.sendColonyMessage(colony, (Component)Component.m_237113_((String)"War has been stopped by an operator.").m_130940_(ChatFormatting.GOLD));
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"All active wars have been stopped.").m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int stopWarCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String colonyName = StringArgumentType.getString(ctx, (String)"colony");
        IColony colony = WarSystem.findColonyByName(colonyName, (Level)((CommandSourceStack)ctx.getSource()).m_81372_());
        if (colony == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Colony not found: " + colonyName)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (!WarSystem.ACTIVE_WARS.containsKey(colony.getID())) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("No active war for colony: " + colonyName)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        WarSystem.endWar(colony);
        WarSystem.sendColonyMessage(colony, (Component)Component.m_237113_((String)("War for " + colony.getName() + " has been stopped by an operator.")).m_130940_(ChatFormatting.GOLD));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("War stopped for " + colony.getName() + ".")).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int stopRaidCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WarCommands.getRaidManager().stopRaidCommand(ctx);
    }

    private static int chooseWarSideCommand(CommandContext<CommandSourceStack> ctx, boolean joinAttackers) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            WarData war = WarSystem.getActiveWarForPlayer(player);
            if (war == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No active war to join."));
                return 0;
            }
            if (!war.isJoinPhaseActive()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Join phase is over."));
                return 0;
            }
            int playerLives = (Integer)TaxConfig.PLAYER_LIVES_IN_WAR.get();
            if (joinAttackers) {
                if (!war.getAttackerLives().containsKey(player.m_20148_())) {
                    war.getAttackerLives().put(player.m_20148_(), playerLives);
                    player.m_213846_((Component)Component.m_237113_((String)"You have chosen to join the attacking side.").m_130940_(ChatFormatting.GREEN));
                    if (war.alliesBossEvent != null && war.alliesBossEvent.m_8323_()) {
                        war.alliesBossEvent.m_6543_(player);
                    } else {
                        war.bossEvent.m_6543_(player);
                    }
                    return 1;
                }
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"You are already registered on the attacking side."));
                return 0;
            }
            if (!war.getDefenderLives().containsKey(player.m_20148_())) {
                war.getDefenderLives().put(player.m_20148_(), playerLives);
                player.m_213846_((Component)Component.m_237113_((String)"You have chosen to join the defending side.").m_130940_(ChatFormatting.GREEN));
                if (war.alliesBossEvent != null && war.alliesBossEvent.m_8323_()) {
                    war.alliesBossEvent.m_6543_(player);
                } else {
                    war.bossEvent.m_6543_(player);
                }
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"You are already registered on the defending side."));
            return 0;
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"You must be a player to use this command."));
            return 0;
        }
    }
}

