/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.commands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.machiavelli.minecolonytax.data.HistoryManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class WarHistoryCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"warhistory").requires(src -> src.m_6761_(0))).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.word()).executes(ctx -> WarHistoryCommand.execute((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"colony"))))).executes(ctx -> WarHistoryCommand.execute((CommandContext<CommandSourceStack>)ctx, null)));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx, String colonyArg) throws CommandSyntaxException {
        ServerPlayer player;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        try {
            player = src.m_81375_();
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be a player to run this command."));
            return 0;
        }
        IColony colony = WarHistoryCommand.resolveColony(src, player, colonyArg);
        if (colony == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Colony not found or you're not a manager of any colony."));
            return 0;
        }
        Rank rank = colony.getPermissions().getRank(player.m_20148_());
        if (rank == null || !rank.isColonyManager()) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be a colony officer to view history."));
            return 0;
        }
        HistoryManager.ColonyHistory history = HistoryManager.getColonyHistory(colony.getID());
        if (history == null || history.getEvents().isEmpty()) {
            src.m_288197_(() -> Component.m_237113_((String)("No war history for colony \u201c" + colony.getName() + "\u201d")), false);
            return 1;
        }
        src.m_288197_(() -> Component.m_237113_((String)("\u00a76War History for \u201c" + colony.getName() + "\u201d:")), false);
        for (String event : history.getEvents()) {
            src.m_288197_(() -> Component.m_237113_((String)event), false);
        }
        return 1;
    }

    private static IColony resolveColony(CommandSourceStack src, ServerPlayer player, String arg) {
        IColonyManager mgr = IMinecoloniesAPI.getInstance().getColonyManager();
        if (arg != null) {
            try {
                int id = Integer.parseInt(arg);
                for (IColony c2 : mgr.getAllColonies()) {
                    if (c2.getID() != id) continue;
                    return c2;
                }
            }
            catch (NumberFormatException id) {
                // empty catch block
            }
            for (IColony c3 : mgr.getAllColonies()) {
                if (!c3.getName().equalsIgnoreCase(arg)) continue;
                return c3;
            }
            return null;
        }
        Optional<IColony> own = mgr.getAllColonies().stream().filter(c -> {
            Rank rank = c.getPermissions().getRank(player.m_20148_());
            return rank != null && rank.isColonyManager();
        }).findFirst();
        return own.orElse(null);
    }
}

