/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.machiavelli.minecolonytax.MineColonyTax;
import net.machiavelli.minecolonytax.capability.PlayerWarDataCapability;
import net.machiavelli.minecolonytax.data.PlayerWarData;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;

public class WarStatsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder warStatsCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"warstats").executes(WarStatsCommand::showStats);
        dispatcher.register(warStatsCommand);
    }

    private static int showStats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        MineColonyTax.LOGGER.info("Player " + player.m_7755_().getString() + " requested war stats");
        LazyOptional<PlayerWarData> warDataOptional = PlayerWarDataCapability.get((Player)player);
        if (warDataOptional.isPresent()) {
            PlayerWarData warData = (PlayerWarData)warDataOptional.resolve().get();
            CompoundTag nbt = warData.serializeNBT();
            MineColonyTax.LOGGER.info("WarStats command found capability data: " + nbt.toString());
            MutableComponent message = Component.m_237113_((String)"Your War Statistics").m_130938_(style -> style.m_131140_(ChatFormatting.GOLD).m_131136_(Boolean.valueOf(true))).m_7220_((Component)Component.m_237113_((String)"\n- Players killed in wars: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)String.valueOf(warData.getPlayersKilledInWar())).m_130940_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237113_((String)"\n- Colonies raided: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)String.valueOf(warData.getRaidedColonies())).m_130940_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237113_((String)"\n- Total amount raided: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)String.valueOf(warData.getAmountRaided())).m_130940_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237113_((String)"\n- Wars won: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)String.valueOf(warData.getWarsWon())).m_130940_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237113_((String)"\n- War stalemates: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)String.valueOf(warData.getWarStalemates())).m_130940_(ChatFormatting.WHITE)));
            player.m_213846_((Component)message);
            player.getPersistentData().m_128379_("minecolonytax:save_requested", true);
            if (player.m_20194_() != null) {
                player.m_20194_().m_6846_().m_11302_();
            }
        } else {
            MineColonyTax.LOGGER.warn("Player " + player.m_7755_().getString() + " has no capability data!");
            player.m_213846_((Component)Component.m_237113_((String)"You don't have any war statistics yet.").m_130940_(ChatFormatting.RED));
        }
        return 1;
    }
}

