/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.commands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.machiavelli.minecolonytax.MineColonyTax;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.abandon.ColonyAbandonmentManager;
import net.machiavelli.minecolonytax.abandon.ColonyClaimingRaidManager;
import net.machiavelli.minecolonytax.capability.PlayerWarDataCapability;
import net.machiavelli.minecolonytax.commands.EntityRaidCommands;
import net.machiavelli.minecolonytax.commands.GeneralPermissionsCommands;
import net.machiavelli.minecolonytax.data.HistoryManager;
import net.machiavelli.minecolonytax.data.PlayerWarData;
import net.machiavelli.minecolonytax.data.WarData;
import net.machiavelli.minecolonytax.integration.SDMShopIntegration;
import net.machiavelli.minecolonytax.peace.PeaceProposalManager;
import net.machiavelli.minecolonytax.raid.ActiveRaidData;
import net.machiavelli.minecolonytax.raid.RaidManager;
import net.machiavelli.minecolonytax.requirements.BuildingRequirementsManager;
import net.machiavelli.minecolonytax.vassalization.VassalManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.sixik.sdmshoprework.SDMShopR;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="minecolonytax", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WntCommands {
    private static final Logger LOGGER = LogManager.getLogger(WntCommands.class);
    private static RaidManager raidManagerInstance;
    private static PeaceProposalManager peaceProposalManagerInstance;
    private static final SuggestionProvider<CommandSourceStack> COLONY_SUGGESTIONS;
    private static final SuggestionProvider<CommandSourceStack> PLAYER_COLONY_SUGGESTIONS;
    private static final SuggestionProvider<CommandSourceStack> ABANDONED_COLONY_SUGGESTIONS;

    private static RaidManager getRaidManager() {
        if (raidManagerInstance == null) {
            raidManagerInstance = new RaidManager();
        }
        return raidManagerInstance;
    }

    private static PeaceProposalManager getPeaceProposalManager() {
        if (peaceProposalManagerInstance == null) {
            peaceProposalManagerInstance = new PeaceProposalManager();
        }
        return peaceProposalManagerInstance;
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wnt").executes(WntCommands::showMainHelp)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"help").executes(WntCommands::showHelp)).then(Commands.m_82129_((String)"command", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(List.of("wagewar", "raid", "claimtax", "checktax", "taxdebt", "joinwar", "leavewar", "war", "peace", "warinfo", "wardebug", "warstop", "warstopall", "raidstop", "warhistory", "warstats", "taxgen", "vasalize", "vasalaccept", "vasaldecline", "revoke", "vasals", "entityraid", "permissions"), (SuggestionsBuilder)builder)).executes(WntCommands::showSpecificHelp)))).then(Commands.m_82127_((String)"wagewar").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(COLONY_SUGGESTIONS).executes(WntCommands::handleWageWarCommand)).then(Commands.m_82129_((String)"extortionPercent", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(WntCommands::handleWageWarWithExtortionCommand))))).then(Commands.m_82127_((String)"raid").then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(COLONY_SUGGESTIONS).executes(WntCommands::handleRaidCommand)))).then(Commands.m_82127_((String)"joinwar").executes(WntCommands::joinWarCommand))).then(Commands.m_82127_((String)"leavewar").executes(WntCommands::leaveWarCommand))).then(Commands.m_82127_((String)"payextortion").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"extortionPercent", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(WntCommands::handlePayExtortionCommand))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"war").then(Commands.m_82127_((String)"accept").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).suggests((context, builder) -> {
            ArrayList<String> pendingIds = new ArrayList<String>();
            for (WarData war : WarSystem.ACTIVE_WARS.values()) {
                if (!war.isJoinPhaseActive()) continue;
                pendingIds.add(String.valueOf(war.getColony().getID()));
            }
            return SharedSuggestionProvider.m_82970_(pendingIds, (SuggestionsBuilder)builder);
        }).executes(ctx -> WntCommands.handleWarResponseCommand((CommandContext<CommandSourceStack>)ctx, true))))).then(Commands.m_82127_((String)"decline").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).suggests((context, builder) -> {
            ArrayList<String> pendingIds = new ArrayList<String>();
            for (WarData war : WarSystem.ACTIVE_WARS.values()) {
                if (!war.isJoinPhaseActive()) continue;
                pendingIds.add(String.valueOf(war.getColony().getID()));
            }
            return SharedSuggestionProvider.m_82970_(pendingIds, (SuggestionsBuilder)builder);
        }).executes(ctx -> WntCommands.handleWarResponseCommand((CommandContext<CommandSourceStack>)ctx, false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"peace").then(Commands.m_82127_((String)"whitepeace").executes(WntCommands::suePeaceWhiteCommand))).then(Commands.m_82127_((String)"reparations").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> WntCommands.suePeaceReparationsCommand((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount")))))).then(Commands.m_82127_((String)"accept").executes(WntCommands::acceptPeaceCommand))).then(Commands.m_82127_((String)"decline").executes(WntCommands::declinePeaceCommand)))).then(Commands.m_82127_((String)"warinfo").executes(WntCommands::warInfoCommand))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"wardebug").requires(src -> src.m_6761_(2))).executes(WntCommands::debugWarCommand))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"warstop").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(COLONY_SUGGESTIONS).executes(WntCommands::stopWarCommand)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"warstopall").requires(src -> src.m_6761_(2))).executes(WntCommands::stopAllWarsCommand))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"raidstop").requires(src -> src.m_6761_(2))).executes(WntCommands::stopRaidCommand))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"claimtax").executes(context -> WntCommands.executeClaimTax((CommandContext<CommandSourceStack>)context, null, -1))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_COLONY_SUGGESTIONS).executes(context -> {
            String colonyName = WntCommands.extractColonyName(StringArgumentType.getString((CommandContext)context, (String)"colony"));
            return WntCommands.executeClaimTax((CommandContext<CommandSourceStack>)context, colonyName, -1);
        })).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            String colonyName = WntCommands.extractColonyName(StringArgumentType.getString((CommandContext)context, (String)"colony"));
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            return WntCommands.executeClaimTax((CommandContext<CommandSourceStack>)context, colonyName, amount);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"checktax").executes(WntCommands::checkTaxForSelf)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).requires(src -> src.m_6761_(2))).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])((CommandSourceStack)context.getSource()).m_81377_().m_7641_(), (SuggestionsBuilder)builder)).executes(ctx -> WntCommands.checkTaxForPlayer((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"player")))))).then(Commands.m_82127_((String)"taxdebt").then(Commands.m_82127_((String)"pay").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_COLONY_SUGGESTIONS).executes(context -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            String colonyName = WntCommands.extractColonyName(StringArgumentType.getString((CommandContext)context, (String)"colony"));
            return WntCommands.executeTaxDebt((CommandContext<CommandSourceStack>)context, colonyName, amount);
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"warhistory").executes(ctx -> WntCommands.executeWarHistory((CommandContext<CommandSourceStack>)ctx, null))).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.word()).suggests(PLAYER_COLONY_SUGGESTIONS).executes(ctx -> WntCommands.executeWarHistory((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"colony")))))).then(Commands.m_82127_((String)"warstats").executes(WntCommands::showWarStats))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debugguards").requires(src -> src.m_6761_(2))).executes(WntCommands::debugGuardCounts)).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.greedyString()).suggests(COLONY_SUGGESTIONS).executes(WntCommands::debugGuardCountsForColony)))).then(Commands.m_82127_((String)"vasalize").then(Commands.m_82129_((String)"percent", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(COLONY_SUGGESTIONS).executes(ctx -> WntCommands.handleVassalize((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"percent"), WntCommands.extractColonyName(StringArgumentType.getString((CommandContext)ctx, (String)"colony")))))))).then(Commands.m_82127_((String)"vasalaccept").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> WntCommands.handleVassalAccept((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"colonyId")))))).then(Commands.m_82127_((String)"vasaldecline").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> WntCommands.handleVassalDecline((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"colonyId")))))).then(Commands.m_82127_((String)"revoke").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> WntCommands.handleVassalRevoke((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"player")))))).then(Commands.m_82127_((String)"vasals").executes(WntCommands::handleVassalList))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"taxgen").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"disable").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            int id = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"colonyId");
            TaxManager.disableTaxGeneration(id);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Disabled tax generation for colony " + id)), false);
            return 1;
        })))).then(Commands.m_82127_((String)"enable").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            int id = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"colonyId");
            TaxManager.enableTaxGeneration(id);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Enabled tax generation for colony " + id)), false);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"entityraid").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"status").executes(ctx -> EntityRaidCommands.showEntityRaidStatus((CommandContext<CommandSourceStack>)ctx)))).then(Commands.m_82127_((String)"config").executes(ctx -> EntityRaidCommands.showEntityRaidConfig((CommandContext<CommandSourceStack>)ctx)))).then(Commands.m_82127_((String)"end").then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> EntityRaidCommands.endEntityRaid((CommandContext<CommandSourceStack>)ctx))))).then(Commands.m_82127_((String)"test").then(Commands.m_82129_((String)"colonyName", (ArgumentType)StringArgumentType.string()).suggests(COLONY_SUGGESTIONS).executes(ctx -> EntityRaidCommands.testEntityRaid((CommandContext<CommandSourceStack>)ctx))))).then(Commands.m_82127_((String)"reload").executes(ctx -> EntityRaidCommands.reloadEntityRaidConfig((CommandContext<CommandSourceStack>)ctx))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"permissions").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"status").executes(ctx -> GeneralPermissionsCommands.showPermissionsStatus((CommandContext<CommandSourceStack>)ctx)))).then(Commands.m_82127_((String)"config").executes(ctx -> GeneralPermissionsCommands.showPermissionsConfig((CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"apply").executes(ctx -> GeneralPermissionsCommands.applyGeneralPermissions((CommandContext<CommandSourceStack>)ctx))).then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> GeneralPermissionsCommands.applyToSpecificColony((CommandContext<CommandSourceStack>)ctx))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").executes(ctx -> GeneralPermissionsCommands.removeGeneralPermissions((CommandContext<CommandSourceStack>)ctx))).then(Commands.m_82129_((String)"colonyId", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> GeneralPermissionsCommands.removeFromSpecificColony((CommandContext<CommandSourceStack>)ctx))))).then(Commands.m_82127_((String)"reload").executes(ctx -> GeneralPermissionsCommands.reloadGeneralPermissions((CommandContext<CommandSourceStack>)ctx))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"claimcolony").executes(WntCommands::showClaimableColonies)).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(ABANDONED_COLONY_SUGGESTIONS).executes(WntCommands::handleClaimColony)))).then(Commands.m_82127_((String)"listabandoned").executes(WntCommands::listAbandonedColonies))).then(Commands.m_82127_((String)"claimstatus").executes(WntCommands::checkClaimingStatus))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"claimraidstatus").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(ABANDONED_COLONY_SUGGESTIONS).executes(WntCommands::checkClaimingRaidStatus)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"protectcolony").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(COLONY_SUGGESTIONS).executes(WntCommands::protectColonyFromClaiming)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unprotectcolony").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(COLONY_SUGGESTIONS).executes(WntCommands::unprotectColonyFromClaiming)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cleanupabandonedentries").requires(source -> source.m_6761_(2))).executes(WntCommands::handleCleanupAbandonedEntries))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"debugbossbar").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(COLONY_SUGGESTIONS).executes(WntCommands::handleDebugBossBar)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"forcecleanupcolony").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(COLONY_SUGGESTIONS).executes(WntCommands::handleForceCleanupColony)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"emergencyfix").requires(source -> source.m_6761_(2))).executes(WntCommands::handleEmergencyFix))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"fixnullowners").requires(source -> source.m_6761_(2))).executes(WntCommands::handleFixNullOwners))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"listprotected").requires(source -> source.m_6761_(2))).executes(WntCommands::listProtectedColonies))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"forceabandon").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"colony", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_COLONY_SUGGESTIONS).executes(WntCommands::handleForceAbandonColony))));
    }

    private static int showMainHelp(CommandContext<CommandSourceStack> context) {
        return WntCommands.showHelp(context);
    }

    private static int showHelp(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76\u00a7l=== War 'N Taxes Commands ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt help [command] \u00a77- Show detailed help for a specific command"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76War Commands:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt wagewar <colony> \u00a77- Declare war on a colony"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt raid <colony> \u00a77- Start a raid on a colony"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt joinwar \u00a77- Join an active war"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt leavewar \u00a77- Leave current war"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt war accept/decline <colonyId> \u00a77- Respond to war declaration"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt peace whitepeace \u00a77- Propose white peace"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt peace reparations <amount> \u00a77- Propose peace with reparations"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt peace accept/decline \u00a77- Respond to peace proposal"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt warinfo \u00a77- Show current war information"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76Tax Commands:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt claimtax [colony] [amount] \u00a77- Claim tax revenue"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt checktax [player] \u00a77- Check tax revenue"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt taxdebt pay <amount> <colony> \u00a77- Pay colony debt"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76Info Commands:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt warhistory [colony] \u00a77- View war history"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt warstats \u00a77- View your war statistics"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76Vassal Commands:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt vasalize <percent> <colony> \u00a77- Offer vassalization to a colony"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt vasalaccept <colonyId> \u00a77- Accept a vassalization proposal"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt vasaldecline <colonyId> \u00a77- Decline a vassalization proposal"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt revoke <player> \u00a77- Revoke a vassalization relationship"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt vasals \u00a77- List your vassals"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76Colony Claiming Commands:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt claimcolony [colony] \u00a77- Claim an abandoned colony"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt listabandoned \u00a77- List all abandoned colonies"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt claimstatus \u00a77- Check your claiming eligibility and cooldown"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        if (source.m_6761_(2)) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7cAdmin Commands:"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt wardebug \u00a77- Debug war information"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt warstop <colony> \u00a77- Stop specific war"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt warstopall \u00a77- Stop all wars"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt raidstop \u00a77- Stop active raid"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt debugguards [colony] \u00a77- Debug guard/tower counting"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt forceabandon <colony> \u00a77- Force abandon a colony (admin only)"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt protectcolony <colony> \u00a77- Protect colony from claiming"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt unprotectcolony <colony> \u00a77- Remove claiming protection"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt listprotected \u00a77- List all protected colonies"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt claimraidstatus <colony> \u00a77- Check claiming raid status"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt taxgen disable/enable <colonyId> \u00a77- Control tax generation"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt entityraid status \u00a77- Show active entity raids"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt entityraid config \u00a77- Show entity raid configuration"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt entityraid end <colonyId> \u00a77- End active entity raid"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt entityraid test <colony> \u00a77- Test entity raid system"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt entityraid reload \u00a77- Reload entity raid config"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt permissions status \u00a77- Show general permissions status"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt permissions config \u00a77- Show permissions configuration"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt permissions apply/remove \u00a77- Apply/remove general permissions"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/wnt permissions reload \u00a77- Reload general permissions"), false);
        }
        return 1;
    }

    private static int showSpecificHelp(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String command = StringArgumentType.getString(context, (String)"command");
        switch (command.toLowerCase()) {
            case "wagewar": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt wagewar <colony>"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Declare war on the specified colony."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Requirements:"), false);
                if (TaxConfig.isWarBuildingRequirementsEnabled()) {
                    source.m_288197_(() -> Component.m_237113_((String)("\u00a77- Building requirements: " + String.join((CharSequence)", ", BuildingRequirementsManager.getFormattedRequirements(TaxConfig.getWarBuildingRequirements())))), false);
                } else {
                    source.m_288197_(() -> Component.m_237113_((String)("\u00a77- Your colony must have at least " + TaxConfig.MIN_GUARDS_TO_WAGE_WAR.get() + " guards")), false);
                }
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- Target colony owner must be online (unless configured otherwise)"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- You must wait for grace period between wars"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- No active raid is ongoing"), false);
                break;
            }
            case "raid": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt raid <colony>"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Start a raid on the specified colony."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Requirements:"), false);
                if (TaxConfig.isRaidBuildingRequirementsEnabled()) {
                    source.m_288197_(() -> Component.m_237113_((String)("\u00a77- Building requirements: " + String.join((CharSequence)", ", BuildingRequirementsManager.getFormattedRequirements(TaxConfig.getRaidBuildingRequirements())))), false);
                } else {
                    source.m_288197_(() -> Component.m_237113_((String)("\u00a77- Your colony must have at least " + TaxConfig.getMinGuardsToRaid() + " guards")), false);
                }
                if (TaxConfig.isRaidGuardProtectionEnabled()) {
                    source.m_288197_(() -> Component.m_237113_((String)("\u00a77- Target colony must have at least " + TaxConfig.getMinGuardsToBeRaided() + " guards")), false);
                    source.m_288197_(() -> Component.m_237113_((String)("\u00a77- Target colony must have at least " + TaxConfig.getMinGuardTowersToBeRaided() + " guard towers")), false);
                }
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77During a raid:"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- Tax is awarded only after a successful raid (not periodically)"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- If you die, you pay a penalty to your killer"), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77- Raid lasts up to " + TaxConfig.MAX_RAID_DURATION_MINUTES.get() + " minutes")), false);
                break;
            }
            case "claimtax": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt claimtax [colony] [amount]"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Claim tax revenue from your colonies."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- No arguments: Claims all tax from all your colonies"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- [colony]: Claims all tax from specified colony"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- [colony] [amount]: Claims specific amount from colony"), false);
                break;
            }
            case "checktax": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt checktax [player]"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Check stored tax revenue."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- No arguments: Shows your colonies' tax"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- [player]: Shows another player's tax (admin only)"), false);
                break;
            }
            case "taxdebt": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt taxdebt pay <amount> <colony>"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Pay debt for your colony."), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77Uses " + (TaxConfig.isSDMShopConversionEnabled() ? "SDMShop balance" : "emeralds from inventory"))), false);
                break;
            }
            case "joinwar": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt joinwar"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Join the current war during the join phase."), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77Join phase lasts " + TaxConfig.JOIN_PHASE_DURATION_MINUTES.get() + " minutes.")), false);
                break;
            }
            case "leavewar": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt leavewar"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Leave the current war during the join phase."), false);
                break;
            }
            case "war": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt war accept/decline <colonyId>"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Respond to a war declaration."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Only colony owners/officers can accept/decline wars."), false);
                break;
            }
            case "peace": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt peace whitepeace"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt peace reparations <amount>"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt peace accept/decline"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Propose or respond to peace proposals during war."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- whitepeace: End war with no reparations"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- reparations: End war with payment"), false);
                break;
            }
            case "warinfo": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt warinfo"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Show detailed information about current wars."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Displays lives, guards, timers, and penalties."), false);
                break;
            }
            case "warhistory": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt warhistory [colony]"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77View war and raid history."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Shows outcomes and amounts transferred."), false);
                break;
            }
            case "warstats": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt warstats"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77View your personal war statistics."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Shows kills, raids, amount gained, wars won, etc."), false);
                break;
            }
            case "debugguards": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt debugguards [colony]"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Debug guard and guard tower counting for raid protection."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Shows detection results for the specified colony or your colony."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to view this command."));
                break;
            }
            case "vasalize": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt vasalize <percent> <colony>"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Offer vassalization to a colony."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- percent: The percentage of tax revenue to be paid to the overlord"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- colony: The name of the colony to offer vassalization to"), false);
                break;
            }
            case "vasalaccept": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt vasalaccept <colonyId>"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Accept a vassalization proposal from a colony."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- colonyId: The ID of the colony that proposed vassalization"), false);
                break;
            }
            case "vasaldecline": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt vasaldecline <colonyId>"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Decline a vassalization proposal from a colony."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- colonyId: The ID of the colony that proposed vassalization"), false);
                break;
            }
            case "revoke": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt revoke <player>"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Revoke a vassalization relationship with a player."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- player: The name of the player to revoke the relationship with"), false);
                break;
            }
            case "vasals": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt vasals"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77List your vassals."), false);
                break;
            }
            case "wardebug": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt wardebug"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Show debug information for all active wars."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to view this command."));
                break;
            }
            case "warstop": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt warstop <colony>"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Force stop a specific war by colony name."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to view this command."));
                break;
            }
            case "warstopall": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt warstopall"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Force stop all active wars."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to view this command."));
                break;
            }
            case "raidstop": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt raidstop"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Force stop the active raid."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to view this command."));
                break;
            }
            case "taxgen": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt taxgen disable/enable <colonyId>"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Control tax generation for specific colonies."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to view this command."));
                break;
            }
            case "entityraid": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt entityraid <subcommand>"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Manage entity-triggered raids on colonies."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Subcommands:"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77- status: Show active entity raids"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77- config: Show current configuration"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77- end <colonyId>: End an active entity raid"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77- test <colony>: Test the entity raid system"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77- reload: Reload configuration"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Entity raids are triggered when a configurable"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77number of whitelisted entities gather near colonies."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to view this command."));
                break;
            }
            case "permissions": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt permissions <subcommand>"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Manage general colony permissions for all players."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Subcommands:"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77- status: Show current permissions status"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77- config: Show current configuration"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77- apply [colonyId]: Apply permissions to all/specific colony"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77- remove [colonyId]: Remove permissions from all/specific colony"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77- reload: Reload permissions based on current config"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77General permissions allow ALL players (including non-allies)"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77to toss items and pickup items within colony boundaries when enabled."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Additional actions like block placement can be configured as needed."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to view this command."));
                break;
            }
            case "claimcolony": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt claimcolony [colony]"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Claim an abandoned colony through combat."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Requirements:"), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77- You must have at least " + TaxConfig.getMinGuardsForClaimingRaid() + " guards")), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- Target colony must be abandoned"), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77- " + TaxConfig.getClaimingGracePeriodHours() + "-hour cooldown between claims")), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77When claiming:"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- All citizens become hostile militia"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- Citizens get resistance effects"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- Mercenaries may spawn if too few defenders"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77- You must defeat all defenders to claim the colony"), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77- Claiming raid lasts " + TaxConfig.getClaimingRaidDurationMinutes() + " minutes maximum")), false);
                break;
            }
            case "listabandoned": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt listabandoned"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77List all abandoned colonies that can be claimed."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Shows colony name, ID, location, and time since abandonment."), false);
                break;
            }
            case "claimstatus": {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76/wnt claimstatus"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Check your eligibility to claim colonies."), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Shows requirements status and cooldown time."), false);
                break;
            }
            case "forceabandon": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt forceabandon <colony>"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Force abandon a colony (admin only)."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77This removes all owners and officers from the colony."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77The colony will become claimable by other players."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7cWarning: This action cannot be undone!"), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to use this command."));
                break;
            }
            case "protectcolony": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt protectcolony <colony>"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Protect a colony from being claimed (admin only)."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Protected colonies cannot be claimed even when abandoned."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Useful for spawn towns, admin colonies, or special areas."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to use this command."));
                break;
            }
            case "unprotectcolony": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt unprotectcolony <colony>"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Remove claiming protection from a colony (admin only)."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77The colony will become claimable when abandoned."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to use this command."));
                break;
            }
            case "listprotected": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt listprotected"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77List all colonies protected from claiming (admin only)."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Shows colony name, status, and protecting admin."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to use this command."));
                break;
            }
            case "claimraidstatus": {
                if (source.m_6761_(2)) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7c/wnt claimraidstatus <colony>"), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Check the status of an active claiming raid (admin only)."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Shows defender counts and forces victory condition check."), false);
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a77Useful for debugging stuck claiming raids."), false);
                    break;
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou don't have permission to use this command."));
                break;
            }
            default: {
                source.m_81352_((Component)Component.m_237113_((String)("\u00a7cUnknown command: " + command)));
                return 0;
            }
        }
        return 1;
    }

    private static int handleWageWarCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerLevel level;
        ServerPlayer attacker = ((CommandSourceStack)ctx.getSource()).m_81375_();
        String colonyName = WntCommands.extractColonyName(StringArgumentType.getString(ctx, (String)"colony"));
        IColony targetColony = WarSystem.findColonyByName(colonyName, (Level)(level = ((CommandSourceStack)ctx.getSource()).m_81372_()));
        if (targetColony == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Target colony not found!"));
            return 0;
        }
        if (!RaidManager.getActiveRaids().isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"A raid is currently active! You cannot declare war."));
            return 0;
        }
        if (WarSystem.ACTIVE_WARS.containsKey(targetColony.getID())) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"A war is already active for this colony!"));
            return 0;
        }
        if (((Boolean)TaxConfig.ENABLE_EXTORTION_SYSTEM.get()).booleanValue()) {
            int defaultExtortionPercent = (int)Math.round((Double)TaxConfig.DEFAULT_EXTORTION_PERCENTAGE.get() * 100.0);
            return WarSystem.processWageWarRequestWithExtortion(attacker, targetColony, (CommandSourceStack)ctx.getSource(), defaultExtortionPercent);
        }
        return WarSystem.processWageWarRequest(attacker, targetColony, (CommandSourceStack)ctx.getSource());
    }

    private static int handleWageWarWithExtortionCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer attacker = ((CommandSourceStack)ctx.getSource()).m_81375_();
        String colonyName = WntCommands.extractColonyName(StringArgumentType.getString(ctx, (String)"colony"));
        int extortionPercent = IntegerArgumentType.getInteger(ctx, (String)"extortionPercent");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        IColony targetColony = WarSystem.findColonyByName(colonyName, (Level)level);
        if (targetColony == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Target colony not found!"));
            return 0;
        }
        if (!RaidManager.getActiveRaids().isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"A raid is currently active! You cannot declare war."));
            return 0;
        }
        if (WarSystem.ACTIVE_WARS.containsKey(targetColony.getID())) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"A war is already active for this colony!"));
            return 0;
        }
        return WarSystem.processWageWarRequestWithExtortion(attacker, targetColony, (CommandSourceStack)ctx.getSource(), extortionPercent);
    }

    private static int handleRaidCommand(CommandContext<CommandSourceStack> context) {
        return WntCommands.getRaidManager().handleRaid(context);
    }

    private static int joinWarCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        WarData war = WarSystem.getActiveWarForPlayer(player);
        if (war == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.joinwar.error.none").m_130940_(ChatFormatting.RED));
            return 0;
        }
        return WarSystem.processJoinWar(player, (CommandSourceStack)ctx.getSource());
    }

    private static int leaveWarCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        WarData war = WarSystem.getActiveWarForPlayer(player);
        if (war == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.joinwar.error.none").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (player.m_20148_().equals(war.getColony().getPermissions().getOwner()) || player.m_20148_().equals(war.getAttacker()) || war.getAttackerColony() != null && player.m_20148_().equals(war.getAttackerColony().getPermissions().getOwner())) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.leavewar.error.owner").m_130940_(ChatFormatting.RED));
            return 0;
        }
        return WarSystem.processLeaveWar(player, (CommandSourceStack)ctx.getSource());
    }

    private static int handleWarResponseCommand(CommandContext<CommandSourceStack> ctx, boolean accepted) throws CommandSyntaxException {
        ServerPlayer executor = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int colonyId = IntegerArgumentType.getInteger(ctx, (String)"colonyId");
        return WarSystem.processWarResponse(executor, colonyId, accepted, (CommandSourceStack)ctx.getSource());
    }

    private static int suePeaceWhiteCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WntCommands.getPeaceProposalManager().suePeaceWhite(ctx);
    }

    private static int suePeaceReparationsCommand(CommandContext<CommandSourceStack> ctx, int amount) throws CommandSyntaxException {
        return WntCommands.getPeaceProposalManager().suePeaceReparations(ctx, amount);
    }

    private static int acceptPeaceCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WntCommands.getPeaceProposalManager().acceptPeace(ctx);
    }

    private static int declinePeaceCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WntCommands.getPeaceProposalManager().declinePeace(ctx);
    }

    private static int warInfoCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String remainingStr;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        WarData war = WarSystem.getActiveWarForPlayer(player);
        if (war == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"You are not currently in an active war!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        String attackerColName = war.getAttackerColony() != null ? war.getAttackerColony().getName() : "UnknownAttackerColony";
        String defenderColName = war.getColony() != null ? war.getColony().getName() : "UnknownDefenderColony";
        String status = war.getStatus() != null ? war.getStatus().toString() : "UNKNOWN";
        long now = System.currentTimeMillis();
        if (war.isJoinPhaseActive()) {
            long remaining = Math.max(0L, (war.getJoinPhaseEndTime() - now) / 1000L);
            remainingStr = String.format("%02d:%02d", remaining / 60L, remaining % 60L);
        } else {
            long warDuration = (long)((Integer)TaxConfig.WAR_DURATION_MINUTES.get()).intValue() * 60L;
            long elapsed = (now - war.warStartTime) / 1000L;
            long remaining = Math.max(0L, warDuration - elapsed);
            remainingStr = String.format("%02d:%02d", remaining / 60L, remaining % 60L);
        }
        sb.append("\u00a7a\u00a7lWar Report: ").append(attackerColName).append(" vs ").append(defenderColName).append("\n");
        sb.append("\u00a7aWar ID: \u00a7f").append(war.getWarID()).append("\n");
        sb.append("\u00a7aStatus: \u00a7f").append(status).append("\n");
        sb.append("\u00a7aTime Remaining: \u00a7f").append(remainingStr).append("\n");
        sb.append("------------------------------------------\n");
        sb.append("\u00a7bAttacker Team:\n");
        war.getAttackerLives().forEach((uuid, lives) -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
            String name = sp != null ? sp.m_7755_().getString() : "OfflinePlayer";
            sb.append("  ").append(name).append(" - ").append(lives).append(" lives\n");
        });
        sb.append("\u00a7bDefender Team:\n");
        war.getDefenderLives().forEach((uuid, lives) -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
            String name = sp != null ? sp.m_7755_().getString() : "OfflinePlayer";
            sb.append("  ").append(name).append(" - ").append(lives).append(" lives\n");
        });
        sb.append("\u00a7aGuard Count:\n");
        sb.append(attackerColName).append(" = ").append(war.getRemainingAttackerGuards()).append("\n");
        sb.append(defenderColName).append(" = ").append(war.getRemainingDefenderGuards()).append("\n");
        sb.append("\u00a76==========================\n");
        if (!war.getPenaltyReport().isEmpty()) {
            sb.append("\u00a7cPenalty Report: \u00a7f").append(war.getPenaltyReport()).append("\n");
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)sb.toString()), false);
        return 1;
    }

    private static int debugWarCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (WarSystem.ACTIVE_WARS.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No active wars at the moment!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        for (WarData war : WarSystem.ACTIVE_WARS.values()) {
            String remainingStr;
            String attackerColName = war.getAttackerColony() != null ? war.getAttackerColony().getName() : "UnknownAttackerColony";
            String defenderColName = war.getColony() != null ? war.getColony().getName() : "UnknownDefenderColony";
            String status = war.getStatus() != null ? war.getStatus().toString() : "UNKNOWN";
            long now = System.currentTimeMillis();
            if (war.isJoinPhaseActive()) {
                remaining = Math.max(0L, (war.getJoinPhaseEndTime() - now) / 1000L);
                remainingStr = String.format("%02d:%02d", remaining / 60L, remaining % 60L);
            } else {
                long warDuration = (long)((Integer)TaxConfig.WAR_DURATION_MINUTES.get()).intValue() * 60L;
                long elapsed = (now - war.warStartTime) / 1000L;
                remaining = Math.max(0L, warDuration - elapsed);
                remainingStr = String.format("%02d:%02d", remaining / 60L, remaining % 60L);
            }
            sb.append("\n\u00a7e\u00a7lWar Report: ").append(attackerColName).append(" vs ").append(defenderColName).append("\n");
            sb.append("\u00a7eWar ID: \u00a7f").append(war.getWarID()).append("\n");
            sb.append("\u00a7eStatus: \u00a7f").append(status).append("\n");
            sb.append("\u00a7eTime Remaining: \u00a7f").append(remainingStr).append("\n");
            sb.append("------------------------------------------\n");
            sb.append("\u00a7bAttacker Team:\n");
            war.getAttackerLives().forEach((uuid, lives) -> {
                ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
                String name = sp != null ? sp.m_7755_().getString() : "OfflinePlayer";
                sb.append("  ").append(name).append(" - ").append(lives).append(" lives\n");
            });
            sb.append("\u00a7bDefender Team:\n");
            war.getDefenderLives().forEach((uuid, lives) -> {
                ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
                String name = sp != null ? sp.m_7755_().getString() : "OfflinePlayer";
                sb.append("  ").append(name).append(" - ").append(lives).append(" lives\n");
            });
            sb.append("\u00a7eGuard Count:\n");
            sb.append(attackerColName).append(" = ").append(war.getRemainingAttackerGuards()).append("\n");
            sb.append(defenderColName).append(" = ").append(war.getRemainingDefenderGuards()).append("\n");
            sb.append("\u00a76==========================\n");
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)sb.toString()), false);
        return 1;
    }

    private static int stopWarCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String colonyName = WntCommands.extractColonyName(StringArgumentType.getString(ctx, (String)"colony"));
        IColony colony = WarSystem.findColonyByName(colonyName, (Level)((CommandSourceStack)ctx.getSource()).m_81372_());
        if (colony == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Colony not found: " + colonyName)));
            return 0;
        }
        WarData war = WarSystem.ACTIVE_WARS.get(colony.getID());
        if (war == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("No active war found for colony: " + colonyName)));
            return 0;
        }
        WarSystem.endWar(colony);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("War stopped for colony: " + colonyName)), false);
        return 1;
    }

    private static int stopAllWarsCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection<WarData> activeWars = WarSystem.ACTIVE_WARS.values();
        if (activeWars.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No active wars to stop.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        ArrayList<IColony> coloniesToStop = new ArrayList<IColony>();
        for (WarData war : activeWars) {
            coloniesToStop.add(war.getColony());
        }
        for (IColony colony : coloniesToStop) {
            WarSystem.endWar(colony);
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Stopped " + coloniesToStop.size() + " active wars.")), false);
        return 1;
    }

    private static int stopRaidCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        RaidManager raidManager = WntCommands.getRaidManager();
        Map<UUID, ActiveRaidData> activeRaids = raidManager.getActiveRaids();
        if (activeRaids.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No active raids to stop.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        ArrayList<UUID> raiderIds = new ArrayList<UUID>(activeRaids.keySet());
        for (UUID raiderId : raiderIds) {
            ActiveRaidData raidData = activeRaids.get(raiderId);
            if (raidData == null) continue;
            RaidManager.endActiveRaid(raidData, "Raid administratively stopped via /wnt raidstop command");
        }
        activeRaids.clear();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"All active raids stopped."), false);
        return 1;
    }

    private static int executeClaimTax(CommandContext<CommandSourceStack> context, String colonyName, int amount) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
        List colonies = colonyManager.getAllColonies();
        boolean foundColonies = false;
        for (IColony colony : colonies) {
            Rank playerRank = colony.getPermissions().getRank(player.m_20148_());
            if (colonyName != null && !colony.getName().equalsIgnoreCase(colonyName) || playerRank == null || !playerRank.isColonyManager()) continue;
            foundColonies = true;
            int claimedAmount = TaxManager.claimTax(colony, amount);
            if (claimedAmount > 0) {
                player.m_213846_((Component)Component.m_237110_((String)"command.claimtax.success", (Object[])new Object[]{claimedAmount, colony.getName()}));
                if (TaxConfig.isSDMShopConversionEnabled()) {
                    long currentBalance = SDMShopR.getMoney((Player)player);
                    SDMShopR.setMoney((Player)player, (long)(currentBalance + (long)claimedAmount));
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(TaxConfig.getCurrencyItemName()));
                if (item != null) {
                    ItemStack itemStack = new ItemStack((ItemLike)item, claimedAmount);
                    boolean added = player.m_150109_().m_36054_(itemStack);
                    if (!added) {
                        player.m_36176_(itemStack, false);
                        player.m_213846_((Component)Component.m_237110_((String)"taxmanager.inventory_full", (Object[])new Object[]{claimedAmount, TaxConfig.getCurrencyItemName()}));
                        continue;
                    }
                    player.m_213846_((Component)Component.m_237110_((String)"taxmanager.currency_received", (Object[])new Object[]{claimedAmount, TaxConfig.getCurrencyItemName()}));
                    continue;
                }
                String itemName = TaxConfig.getCurrencyItemName();
                String giveCommand = String.format("give %s %s %d", player.m_7755_().getString(), itemName, claimedAmount);
                source.m_81377_().m_129892_().m_230957_(source.m_81377_().m_129893_(), giveCommand);
                continue;
            }
            player.m_213846_((Component)Component.m_237110_((String)"command.claimtax.no_tax", (Object[])new Object[]{colony.getName()}));
        }
        if (!foundColonies) {
            if (colonyName != null) {
                source.m_81352_((Component)Component.m_237110_((String)"command.claimtax.colony_not_found", (Object[])new Object[]{colonyName}));
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"command.claimtax.no_colonies"));
            }
        }
        return 1;
    }

    private static int checkTaxForSelf(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer player = source.m_81375_();
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Unable to retrieve server instance."));
                return 0;
            }
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            List colonies = colonyManager.getAllColonies();
            boolean foundColonies = false;
            for (IColony colony : colonies) {
                Rank playerRank = colony.getPermissions().getRank(player.m_20148_());
                if (!playerRank.isColonyManager()) continue;
                foundColonies = true;
                int taxRevenue = TaxManager.getStoredTaxForColony(colony);
                source.m_288197_(() -> Component.m_237110_((String)"command.checktax.self", (Object[])new Object[]{colony.getName(), taxRevenue}), false);
            }
            if (!foundColonies) {
                source.m_81352_((Component)Component.m_237115_((String)"command.checktax.no_colonies"));
            }
            return 1;
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237113_((String)"An error occurred while processing the command."));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)"An unexpected error occurred."));
            return 0;
        }
    }

    private static int checkTaxForPlayer(CommandContext<CommandSourceStack> context, String playerName) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer targetPlayer = source.m_81377_().m_6846_().m_11255_(playerName);
        if (targetPlayer != null) {
            MinecraftServer server = source.m_81377_();
            if (server == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Unable to retrieve server instance."));
                return 0;
            }
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            List colonies = colonyManager.getAllColonies();
            boolean foundColonies = false;
            for (IColony colony : colonies) {
                Rank playerRank = colony.getPermissions().getRank(targetPlayer.m_20148_());
                if (!playerRank.isColonyManager()) continue;
                foundColonies = true;
                int taxRevenue = TaxManager.getStoredTaxForColony(colony);
                source.m_288197_(() -> Component.m_237110_((String)"command.checktax.other", (Object[])new Object[]{playerName, colony.getName(), taxRevenue}), false);
            }
            if (!foundColonies) {
                source.m_81352_((Component)Component.m_237115_((String)"command.checktax.no_colonies"));
            }
        } else {
            source.m_81352_((Component)Component.m_237110_((String)"command.checktax.player_not_found", (Object[])new Object[]{playerName}));
        }
        return 1;
    }

    private static int executeTaxDebt(CommandContext<CommandSourceStack> context, String colonyName, int amount) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
        boolean foundColony = false;
        for (IColony colony : colonyManager.getAllColonies()) {
            Rank playerRank = colony.getPermissions().getRank(player.m_20148_());
            if (playerRank == null || !playerRank.isColonyManager() || colonyName != null && !colony.getName().equalsIgnoreCase(colonyName)) continue;
            foundColony = true;
            boolean deducted = WntCommands.deductCurrency(player, amount);
            if (!deducted) {
                source.m_81352_((Component)Component.m_237110_((String)"command.taxdebt.insufficient_funds", (Object[])new Object[]{amount}));
                continue;
            }
            int paid = TaxManager.payTaxDebt(colony, amount);
            source.m_288197_(() -> Component.m_237110_((String)"command.taxdebt.success", (Object[])new Object[]{paid, colony.getName(), TaxManager.getStoredTaxForColony(colony)}), false);
        }
        if (!foundColony) {
            source.m_81352_((Component)Component.m_237110_((String)"command.taxdebt.colony_not_found", (Object[])new Object[]{colonyName}));
        }
        return 1;
    }

    private static boolean deductCurrency(ServerPlayer player, int amount) {
        if (TaxConfig.isSDMShopConversionEnabled()) {
            long balance = SDMShopR.getMoney((Player)player);
            if (balance < (long)amount) {
                return false;
            }
            SDMShopR.setMoney((Player)player, (long)(balance - (long)amount));
            return true;
        }
        return WntCommands.deductCurrencyFromInventory(player, amount);
    }

    private static boolean deductCurrencyFromInventory(ServerPlayer player, int amount) {
        int remaining = amount;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ResourceLocation registryName;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || (registryName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())) == null || !registryName.toString().equals(TaxConfig.getCurrencyItemName())) continue;
            int available = stack.m_41613_();
            if (available >= remaining) {
                stack.m_41774_(remaining);
                return true;
            }
            remaining -= available;
            stack.m_41764_(0);
        }
        return remaining <= 0;
    }

    private static int executeWarHistory(CommandContext<CommandSourceStack> ctx, String colonyArg) throws CommandSyntaxException {
        ServerPlayer player;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        try {
            player = src.m_81375_();
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be a player to run this command."));
            return 0;
        }
        IColony colony = WntCommands.resolveColony(src, player, colonyArg);
        if (colony == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Colony not found or you're not a manager of any colony."));
            return 0;
        }
        Rank rank = colony.getPermissions().getRank(player.m_20148_());
        if (rank == null || !rank.isColonyManager()) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be a colony officer to view history."));
            return 0;
        }
        HistoryManager.ColonyHistory history = HistoryManager.getColonyHistory(colony.getID());
        if (history == null || history.getEvents().isEmpty()) {
            src.m_288197_(() -> Component.m_237113_((String)("No war history for colony " + colony.getName())), false);
            return 1;
        }
        src.m_288197_(() -> Component.m_237113_((String)("\u00a76War History for " + colony.getName() + ":")), false);
        for (String event : history.getEvents()) {
            src.m_288197_(() -> Component.m_237113_((String)event), false);
        }
        return 1;
    }

    private static IColony resolveColony(CommandSourceStack src, ServerPlayer player, String colonyArg) {
        IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
        if (colonyArg != null) {
            try {
                int id = Integer.parseInt(colonyArg);
                return colonyManager.getColonyByDimension(id, player.m_9236_().m_46472_());
            }
            catch (NumberFormatException ignored) {
                return colonyManager.getAllColonies().stream().filter(c -> c.getName().equalsIgnoreCase(colonyArg)).filter(c -> c.getPermissions().getRank(player.m_20148_()).isColonyManager()).findFirst().orElse(null);
            }
        }
        return colonyManager.getAllColonies().stream().filter(c -> c.getPermissions().getRank(player.m_20148_()).isColonyManager()).findFirst().orElse(null);
    }

    private static int showWarStats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        LazyOptional<PlayerWarData> warDataOptional = PlayerWarDataCapability.get((Player)player);
        if (warDataOptional.isPresent()) {
            PlayerWarData warData = (PlayerWarData)warDataOptional.resolve().get();
            MineColonyTax.LOGGER.info("War stats retrieved for " + player.m_7755_().getString() + ": PlayersKilled=" + warData.getPlayersKilledInWar() + ", RaidedColonies=" + warData.getRaidedColonies() + ", AmountRaided=" + warData.getAmountRaided() + ", WarsWon=" + warData.getWarsWon() + ", WarStalemates=" + warData.getWarStalemates());
            MutableComponent message = Component.m_237113_((String)"Your War Statistics").m_130938_(style -> style.m_131140_(ChatFormatting.GOLD).m_131136_(Boolean.valueOf(true))).m_7220_((Component)Component.m_237113_((String)"\n- Players killed in wars: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)String.valueOf(warData.getPlayersKilledInWar())).m_130940_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237113_((String)"\n- Colonies raided: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)String.valueOf(warData.getRaidedColonies())).m_130940_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237113_((String)"\n- Total amount raided: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)String.valueOf(warData.getAmountRaided())).m_130940_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237113_((String)"\n- Wars won: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)String.valueOf(warData.getWarsWon())).m_130940_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237113_((String)"\n- War stalemates: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)String.valueOf(warData.getWarStalemates())).m_130940_(ChatFormatting.WHITE)));
            player.m_213846_((Component)message);
            player.getPersistentData().m_128379_("minecolonytax:save_requested", true);
            MineColonyTax.LOGGER.debug("Marked player data for save after displaying war stats for " + player.m_7755_().getString());
            return 1;
        }
        player.m_213846_((Component)Component.m_237113_((String)"No war statistics available."));
        MineColonyTax.LOGGER.warn("War data capability not found for player " + player.m_7755_().getString());
        return 0;
    }

    private static int handleVassalize(CommandContext<CommandSourceStack> ctx, int percent, String colonyName) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        IColony target = IMinecoloniesAPI.getInstance().getColonyManager().getAllColonies().stream().filter(c -> c.getName().equalsIgnoreCase(colonyName)).findFirst().orElse(null);
        if (target == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Colony not found"));
            return 0;
        }
        if (target.getPermissions().getRank((Player)player).isColonyManager() || target.getPermissions().isColonyMember((Player)player)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"You cannot vassalize a colony you are a member or officer of"));
            return 0;
        }
        return VassalManager.requestVassalization(player, target, percent);
    }

    private static int handleVassalAccept(CommandContext<CommandSourceStack> ctx, int colonyId) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        return VassalManager.acceptProposal(player, colonyId);
    }

    private static int handleVassalDecline(CommandContext<CommandSourceStack> ctx, int colonyId) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        return VassalManager.declineProposal(player, colonyId);
    }

    private static int handleVassalRevoke(CommandContext<CommandSourceStack> ctx, String playerName) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        return VassalManager.revokeRelation(player, playerName);
    }

    private static int handleVassalList(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        return VassalManager.listVassals(player);
    }

    private static String extractColonyName(String input) {
        if (input.startsWith("\"") && input.endsWith("\"")) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }

    private static int debugGuardCounts(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        IColony playerColony = IColonyManager.getInstance().getColonies((Level)level).stream().filter(c -> c.getPermissions().getPlayers().containsKey(player.m_20148_())).findFirst().orElse(null);
        if (playerColony == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You must be a member of a colony to use this command without specifying a colony name."));
            return 0;
        }
        return WntCommands.performGuardDebug((CommandSourceStack)context.getSource(), playerColony);
    }

    private static int debugGuardCountsForColony(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        String colonyName = WntCommands.extractColonyName(StringArgumentType.getString(context, (String)"colony"));
        IColony targetColony = WarSystem.findColonyByName(colonyName, (Level)level);
        if (targetColony == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Colony '" + colonyName + "' not found!")));
            return 0;
        }
        return WntCommands.performGuardDebug((CommandSourceStack)context.getSource(), targetColony);
    }

    private static int performGuardDebug(CommandSourceStack source, IColony colony) {
        int guardCount = WarSystem.countGuards(colony);
        int guardTowerCount = WarSystem.countGuardTowers(colony);
        int minGuardsRequired = TaxConfig.getMinGuardsToBeRaided();
        int minGuardTowersRequired = TaxConfig.getMinGuardTowersToBeRaided();
        boolean protectionEnabled = TaxConfig.isRaidGuardProtectionEnabled();
        boolean guardProtection = guardCount >= minGuardsRequired;
        boolean towerProtection = guardTowerCount >= minGuardTowersRequired;
        boolean fullyProtected = protectionEnabled && guardProtection && towerProtection;
        source.m_288197_(() -> Component.m_237113_((String)("\u00a76=== Guard Debug Report for Colony: " + colony.getName() + " ===")), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Colony ID: " + colony.getID())), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7eGuard Counts:"), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Guards found: " + guardCount + " (required: " + minGuardsRequired + ") " + (guardProtection ? "\u00a7a\u2713" : "\u00a7c\u2717"))), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Guard towers found: " + guardTowerCount + " (required: " + minGuardTowersRequired + ") " + (towerProtection ? "\u00a7a\u2713" : "\u00a7c\u2717"))), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7eProtection Status:"), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Raid Guard Protection: " + (protectionEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Can be raided: " + (fullyProtected ? "\u00a7cNo (protected)" : "\u00a7aYes (vulnerable)"))), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7eBuilding Analysis:"), false);
        AtomicInteger totalBuildings = new AtomicInteger(0);
        AtomicInteger guardTowersDetected = new AtomicInteger(0);
        for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
            totalBuildings.incrementAndGet();
            String displayName = building.getBuildingDisplayName();
            String className = building.getClass().getName();
            boolean isGuardTower = WarSystem.isGuardTower(building);
            if (!isGuardTower) continue;
            guardTowersDetected.incrementAndGet();
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Found Guard Tower: " + displayName + " (class: " + className + ")")), false);
        }
        int totalBuildingCount = totalBuildings.get();
        int guardTowerDetectedCount = guardTowersDetected.get();
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Total buildings scanned: " + totalBuildingCount)), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Guard towers detected: " + guardTowerDetectedCount)), false);
        if (guardTowerDetectedCount != guardTowerCount) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7c\u26a0 Warning: Guard tower count mismatch!"), false);
        }
        return 1;
    }

    private static int handlePayExtortionCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        long baseBalance;
        boolean isAuthorized;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int colonyId = IntegerArgumentType.getInteger(ctx, (String)"colonyId");
        int extortionPercent = IntegerArgumentType.getInteger(ctx, (String)"extortionPercent");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        IColony targetColony = IColonyManager.getInstance().getColonyByDimension(colonyId, level.m_46472_());
        if (targetColony == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Colony not found!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        Rank playerRank = targetColony.getPermissions().getRank(player.m_20148_());
        boolean bl = isAuthorized = targetColony.getPermissions().getOwner().equals(player.m_20148_()) || playerRank != null && playerRank.isColonyManager();
        if (!isAuthorized) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"You are not authorized to pay extortion for this colony!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        Object requestObj = WarSystem.pendingWarRequests.get(colonyId);
        if (requestObj == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No pending war request found for this colony!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        WarSystem.WarRequestWithExtortion extortionRequest = null;
        if (!(requestObj instanceof WarSystem.WarRequestWithExtortion)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"This war request does not have extortion terms!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        extortionRequest = (WarSystem.WarRequestWithExtortion)requestObj;
        if (extortionRequest.extortionPercent() != extortionPercent) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Extortion percentage mismatch! Expected: " + extortionRequest.extortionPercent() + "%")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        boolean sdmAvailable = SDMShopIntegration.isAvailable();
        long playerBalance = sdmAvailable ? SDMShopIntegration.getMoney(player) : 0L;
        int colonyBalance = TaxManager.getStoredTaxForColony(targetColony);
        long l = baseBalance = playerBalance > 0L ? playerBalance : (long)colonyBalance;
        if (baseBalance <= 0L) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"You have no personal balance or colony funds to pay extortion!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        long extortionAmount = Math.round((double)baseBalance * ((double)extortionPercent / 100.0));
        if (extortionAmount <= 0L) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Calculated extortion amount is too small!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (level.m_7654_() == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Server not available!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        ServerPlayer attacker = level.m_7654_().m_6846_().m_11259_(extortionRequest.attacker());
        if (attacker == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Attacker is offline! Cannot process extortion payment.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (sdmAvailable) {
            if (playerBalance + (long)colonyBalance < extortionAmount) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Insufficient funds to pay extortion! Needed: " + extortionAmount + ", Available: " + (playerBalance + (long)colonyBalance))).m_130940_(ChatFormatting.RED));
                return 0;
            }
        } else if ((long)colonyBalance < extortionAmount) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Colony funds are insufficient to pay extortion! Needed: " + extortionAmount + ", Available: " + colonyBalance)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        long takenFromPlayer = 0L;
        int takenFromColony = 0;
        if (sdmAvailable && playerBalance > 0L && (takenFromPlayer = Math.min(playerBalance, extortionAmount)) > 0L && !SDMShopIntegration.removeMoney(player, takenFromPlayer)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to deduct from your SDMShop balance!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        long remaining = extortionAmount - takenFromPlayer;
        if (remaining > 0L) {
            if ((long)colonyBalance < remaining) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Colony funds are insufficient to cover the remaining extortion amount!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            takenFromColony = (int)remaining;
            TaxManager.adjustTax(targetColony, -takenFromColony);
        }
        if (takenFromPlayer > 0L) {
            SDMShopIntegration.addMoney(attacker, takenFromPlayer);
        }
        if (takenFromColony > 0) {
            IColony attackerColony = IColonyManager.getInstance().getColonies(attacker.m_9236_()).stream().filter(c -> c.getPermissions().getOwner().equals(attacker.m_20148_())).findFirst().orElse(null);
            if (attackerColony != null) {
                TaxManager.adjustTax(attackerColony, takenFromColony);
            } else if (sdmAvailable) {
                SDMShopIntegration.addMoney(attacker, takenFromColony);
            }
        }
        WarSystem.grantExtortionImmunity(colonyId);
        WarSystem.pendingWarRequests.remove(colonyId);
        MutableComponent successMessage = Component.m_237113_((String)"\ud83d\udcb0 EXTORTION PAID! \ud83d\udcb0").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\n" + targetColony.getName() + " has paid " + String.format("%.2f", extortionAmount) + " coins to avoid war!")).m_130940_(ChatFormatting.GREEN));
        player.m_213846_((Component)successMessage);
        attacker.m_213846_((Component)Component.m_237113_((String)("\ud83d\udcb0 " + targetColony.getName() + " has paid you " + String.format("%.2f", extortionAmount) + " coins to avoid war!")).m_130940_(ChatFormatting.GOLD));
        if (level.m_7654_() != null) {
            MutableComponent broadcastMsg = Component.m_237113_((String)"\ud83d\udcb0 EXTORTION PAID! \ud83d\udcb0").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\n----------------------------------------").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\nThe colony of ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)targetColony.getName()).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)" has paid ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)(String.format("%.2f", extortionAmount) + " coins")).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)" to ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)attacker.m_7755_().getString()).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)" to avoid war! Peace is maintained through commerce.").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"\n----------------------------------------").m_130940_(ChatFormatting.DARK_GRAY));
            level.m_7654_().m_6846_().m_240416_((Component)broadcastMsg, false);
        }
        LOGGER.info("Extortion payment processed: {} paid {} coins to {} to avoid war on colony {}", (Object)player.m_7755_().getString(), (Object)extortionAmount, (Object)attacker.m_7755_().getString(), (Object)targetColony.getName());
        return 1;
    }

    private static int showClaimableColonies(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        List<IColony> claimableColonies = ColonyAbandonmentManager.getClaimableColonies(player.m_20194_());
        if (claimableColonies.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"No abandoned colonies are currently available for claiming.").m_130940_(ChatFormatting.YELLOW));
            return 1;
        }
        player.m_213846_((Component)Component.m_237113_((String)"Available abandoned colonies:").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        for (IColony colony : claimableColonies) {
            int citizenCount = colony.getCitizenManager().getCurrentCitizenCount();
            int guardCount = WarSystem.countGuards(colony);
            MutableComponent colonyInfo = Component.m_237113_((String)"\u2022 ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)colony.getName()).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)(" (ID: " + colony.getID() + ")")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)(" - Citizens: " + citizenCount + ", Guards: " + guardCount)).m_130940_(ChatFormatting.WHITE));
            player.m_213846_((Component)colonyInfo);
        }
        player.m_213846_((Component)Component.m_237113_((String)""));
        ColonyClaimingRaidManager.ClaimingRequirementResult eligibility = ColonyClaimingRaidManager.checkClaimingRequirements(player);
        if (eligibility.canClaim) {
            player.m_213846_((Component)Component.m_237113_((String)"\u2713 You are eligible to claim colonies!").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
            player.m_213846_((Component)Component.m_237113_((String)"Use '/wnt claimcolony <colony>' to start a claiming raid!").m_130940_(ChatFormatting.GREEN));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)("\u2717 You cannot claim colonies: " + eligibility.message)).m_130940_(ChatFormatting.RED));
            player.m_213846_((Component)Component.m_237113_((String)"Meet the requirements first, then use '/wnt claimcolony <colony>'").m_130940_(ChatFormatting.YELLOW));
        }
        return 1;
    }

    private static int handleClaimColony(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String colonyName = WntCommands.extractColonyName(StringArgumentType.getString(context, (String)"colony"));
        IColony targetColony = WarSystem.findColonyByName(colonyName, (Level)(level = ((CommandSourceStack)context.getSource()).m_81372_()));
        if (targetColony == null) {
            player.m_213846_((Component)Component.m_237113_((String)("Colony '" + colonyName + "' not found!")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (ColonyClaimingRaidManager.isColonyUnderClaimingRaid(targetColony.getID())) {
            player.m_213846_((Component)Component.m_237113_((String)"A claiming raid is already in progress for this colony!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        ColonyClaimingRaidManager.ClaimingRequirementResult requirementResult = ColonyClaimingRaidManager.checkClaimingRequirements(player, targetColony);
        if (!requirementResult.canClaim) {
            player.m_213846_((Component)Component.m_237113_((String)("Cannot claim colony: " + requirementResult.message)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        boolean success = ColonyClaimingRaidManager.startClaimingRaid(targetColony, player);
        if (success) {
            player.m_213846_((Component)Component.m_237113_((String)("Claiming raid started for colony " + targetColony.getName() + "!")).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\nDefeat all defenders to claim the colony!").m_130940_(ChatFormatting.YELLOW)));
            return 1;
        }
        return 0;
    }

    private static int listAbandonedColonies(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        List<IColony> abandonedColonies = ColonyAbandonmentManager.getClaimableColonies(player.m_20194_());
        if (abandonedColonies.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"No abandoned colonies found.").m_130940_(ChatFormatting.YELLOW));
            return 1;
        }
        player.m_213846_((Component)Component.m_237113_((String)"=== Abandoned Colonies ===").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        for (IColony colony : abandonedColonies) {
            int citizenCount = colony.getCitizenManager().getCurrentCitizenCount();
            int guardCount = WarSystem.countGuards(colony);
            int lastContactHours = colony.getLastContactInHours();
            boolean isProtected = ColonyClaimingRaidManager.isColonyProtected(colony.getID());
            String protectedBy = isProtected ? ColonyClaimingRaidManager.getProtectedBy(colony.getID()) : null;
            MutableComponent colonyDetails = Component.m_237113_((String)"Colony: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)colony.getName()).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)("\n  ID: " + colony.getID())).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("\n  Location: " + colony.getCenter().m_123341_() + ", " + colony.getCenter().m_123342_() + ", " + colony.getCenter().m_123343_())).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("\n  Citizens: " + citizenCount + ", Guards: " + guardCount)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)("\n  Last contact: " + lastContactHours + " hours ago")).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\n  Status: ").m_130940_(ChatFormatting.WHITE));
            if (isProtected) {
                colonyDetails.m_7220_((Component)Component.m_237113_((String)("Protected (by " + protectedBy + ")")).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            } else {
                colonyDetails.m_7220_((Component)Component.m_237113_((String)"Claimable").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
            }
            player.m_213846_((Component)colonyDetails);
            player.m_213846_((Component)Component.m_237113_((String)""));
        }
        player.m_213846_((Component)Component.m_237113_((String)"Use '/wnt claimcolony <colony>' to claim a colony!").m_130940_(ChatFormatting.GREEN));
        return 1;
    }

    private static int checkClaimingStatus(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ColonyClaimingRaidManager.ClaimingRequirementResult eligibility = ColonyClaimingRaidManager.checkClaimingRequirements(player);
        player.m_213846_((Component)Component.m_237113_((String)"=== Colony Claiming Status ===").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        if (eligibility.canClaim) {
            player.m_213846_((Component)Component.m_237113_((String)"\u2713 You are eligible to claim colonies!").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
            player.m_213846_((Component)Component.m_237113_((String)"Use '/wnt claimcolony <colony>' to start a claiming raid!").m_130940_(ChatFormatting.GREEN));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)("\u2717 You cannot claim colonies: " + eligibility.message)).m_130940_(ChatFormatting.RED));
            long remainingGracePeriod = ColonyClaimingRaidManager.getRemainingGracePeriod(player.m_20148_());
            if (remainingGracePeriod > 0L) {
                long remainingHours = remainingGracePeriod / 3600000L;
                long remainingMinutes = remainingGracePeriod % 3600000L / 60000L;
                String timeRemaining = remainingHours > 0L ? remainingHours + "h " + remainingMinutes + "m" : remainingMinutes + "m";
                player.m_213846_((Component)Component.m_237113_((String)("Cooldown remaining: " + timeRemaining)).m_130940_(ChatFormatting.YELLOW));
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"Meet the requirements first, then use '/wnt claimcolony <colony>'").m_130940_(ChatFormatting.YELLOW));
            }
        }
        return 1;
    }

    private static int checkClaimingRaidStatus(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String colonyName = WntCommands.extractColonyName(StringArgumentType.getString(context, (String)"colony"));
        IColony targetColony = WarSystem.findColonyByName(colonyName, (Level)(level = ((CommandSourceStack)context.getSource()).m_81372_()));
        if (targetColony == null) {
            source.m_288197_(() -> Component.m_237113_((String)("Colony '" + colonyName + "' not found!")).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        ColonyClaimingRaidManager.ClaimingRaidData raidData = ColonyClaimingRaidManager.getClaimingRaid(targetColony.getID());
        if (raidData == null) {
            source.m_288197_(() -> Component.m_237113_((String)("No active claiming raid for colony " + targetColony.getName())).m_130940_(ChatFormatting.YELLOW), false);
            return 1;
        }
        int aliveCitizensCount = 0;
        int aliveMercenariesCount = 0;
        for (Integer citizenId : raidData.hostileCitizens) {
            ICitizenData citizenData = targetColony.getCitizenManager().getCivilian(citizenId.intValue());
            if (citizenData == null || !citizenData.getEntity().isPresent() || !((AbstractEntityCitizen)citizenData.getEntity().get()).m_6084_()) continue;
            ++aliveCitizensCount;
        }
        for (Entity mercenary : raidData.spawnedMercenaries) {
            if (!mercenary.m_6084_()) continue;
            ++aliveMercenariesCount;
        }
        int aliveCitizens = aliveCitizensCount;
        int aliveMercenaries = aliveMercenariesCount;
        int totalDefenders = aliveCitizens + aliveMercenaries;
        source.m_288197_(() -> Component.m_237113_((String)("=== Claiming Raid Status for " + targetColony.getName() + " ===")).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        source.m_288197_(() -> Component.m_237113_((String)("Claimer: " + raidData.claimingPlayerId)).m_130940_(ChatFormatting.YELLOW), false);
        source.m_288197_(() -> Component.m_237113_((String)("Defenders remaining: " + totalDefenders)).m_130940_(ChatFormatting.WHITE), false);
        source.m_288197_(() -> Component.m_237113_((String)("  - Citizens: " + aliveCitizens)).m_130940_(ChatFormatting.GRAY), false);
        source.m_288197_(() -> Component.m_237113_((String)("  - Mercenaries: " + aliveMercenaries)).m_130940_(ChatFormatting.GRAY), false);
        long remaining = raidData.getRemainingTime();
        int minutes = (int)(remaining / 60000L);
        int seconds = (int)(remaining % 60000L / 1000L);
        source.m_288197_(() -> Component.m_237113_((String)("Time remaining: " + String.format("%02d:%02d", minutes, seconds))).m_130940_(ChatFormatting.AQUA), false);
        source.m_288197_(() -> Component.m_237113_((String)"Forcing victory condition check...").m_130940_(ChatFormatting.GREEN), false);
        ColonyClaimingRaidManager.forceCheckVictoryCondition(targetColony.getID());
        source.m_288197_(() -> Component.m_237113_((String)"Forcing boss bar refresh...").m_130940_(ChatFormatting.GREEN), false);
        ColonyClaimingRaidManager.forceRefreshBossBar(targetColony.getID());
        source.m_288197_(() -> Component.m_237113_((String)"Debug info logged to console...").m_130940_(ChatFormatting.AQUA), false);
        ColonyClaimingRaidManager.debugClaimingRaid(targetColony.getID());
        return 1;
    }

    private static int protectColonyFromClaiming(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String colonyName = WntCommands.extractColonyName(StringArgumentType.getString(context, (String)"colony"));
        IColony targetColony = WarSystem.findColonyByName(colonyName, (Level)(level = ((CommandSourceStack)context.getSource()).m_81372_()));
        if (targetColony == null) {
            source.m_288197_(() -> Component.m_237113_((String)("Colony '" + colonyName + "' not found!")).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (ColonyClaimingRaidManager.isColonyProtected(targetColony.getID())) {
            String protectedBy = ColonyClaimingRaidManager.getProtectedBy(targetColony.getID());
            source.m_288197_(() -> Component.m_237113_((String)("Colony " + targetColony.getName() + " is already protected by " + protectedBy)).m_130940_(ChatFormatting.YELLOW), false);
            return 1;
        }
        String adminName = source.m_81368_();
        ColonyClaimingRaidManager.protectColony(targetColony.getID(), adminName);
        source.m_288197_(() -> Component.m_237113_((String)("Colony " + targetColony.getName() + " is now protected from claiming!")).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}), false);
        source.m_288197_(() -> Component.m_237113_((String)"This colony cannot be claimed even when abandoned.").m_130940_(ChatFormatting.GRAY), false);
        return 1;
    }

    private static int unprotectColonyFromClaiming(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String colonyName = WntCommands.extractColonyName(StringArgumentType.getString(context, (String)"colony"));
        IColony targetColony = WarSystem.findColonyByName(colonyName, (Level)(level = ((CommandSourceStack)context.getSource()).m_81372_()));
        if (targetColony == null) {
            source.m_288197_(() -> Component.m_237113_((String)("Colony '" + colonyName + "' not found!")).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (!ColonyClaimingRaidManager.isColonyProtected(targetColony.getID())) {
            source.m_288197_(() -> Component.m_237113_((String)("Colony " + targetColony.getName() + " is not protected.")).m_130940_(ChatFormatting.YELLOW), false);
            return 1;
        }
        ColonyClaimingRaidManager.unprotectColony(targetColony.getID());
        source.m_288197_(() -> Component.m_237113_((String)("Colony " + targetColony.getName() + " protection removed!")).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}), false);
        source.m_288197_(() -> Component.m_237113_((String)"This colony can now be claimed when abandoned.").m_130940_(ChatFormatting.GRAY), false);
        return 1;
    }

    private static int listProtectedColonies(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Map<Integer, String> protectedColonies = ColonyClaimingRaidManager.getProtectedColonies();
        if (protectedColonies.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"No colonies are currently protected from claiming.").m_130940_(ChatFormatting.YELLOW), false);
            return 1;
        }
        source.m_288197_(() -> Component.m_237113_((String)"=== Protected Colonies ===").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        for (Map.Entry<Integer, String> entry : protectedColonies.entrySet()) {
            int colonyId = entry.getKey();
            String protectedBy = entry.getValue();
            IColony colony = null;
            try {
                colony = IMinecoloniesAPI.getInstance().getColonyManager().getColonyByWorld(colonyId, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (colony != null) {
                String colonyName = colony.getName();
                boolean isAbandoned = ColonyAbandonmentManager.isColonyAbandoned(colony);
                source.m_288197_(() -> Component.m_237113_((String)"Colony: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)colonyName).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)(" (ID: " + colonyId + ")")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"\n  Status: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)(isAbandoned ? "Abandoned" : "Active")).m_130940_(isAbandoned ? ChatFormatting.RED : ChatFormatting.GREEN))).m_7220_((Component)Component.m_237113_((String)("\n  Protected by: " + protectedBy)).m_130940_(ChatFormatting.AQUA)), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Colony ID: " + colonyId + " (Not Found)")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)("\n  Protected by: " + protectedBy)).m_130940_(ChatFormatting.AQUA)), false);
            }
            source.m_288197_(() -> Component.m_237113_((String)""), false);
        }
        return 1;
    }

    private static int handleForceAbandonColony(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer admin;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.m_6761_(2)) {
            source.m_81352_((Component)Component.m_237113_((String)"You don't have permission to use this command!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        String colonyName = WntCommands.extractColonyName(StringArgumentType.getString(context, (String)"colony"));
        IColony targetColony = WarSystem.findColonyByName(colonyName, (admin = source.m_81375_()).m_9236_());
        if (targetColony == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Colony '" + colonyName + "' not found!")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (ColonyAbandonmentManager.isColonyAbandoned(targetColony)) {
            source.m_81352_((Component)Component.m_237113_((String)("Colony '" + targetColony.getName() + "' is already abandoned!")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        try {
            ArrayList<UUID> managersToNotify = new ArrayList<UUID>();
            for (ColonyPlayer colonyPlayer : targetColony.getPermissions().getPlayers().values()) {
                if (!colonyPlayer.getRank().isColonyManager()) continue;
                managersToNotify.add(colonyPlayer.getID());
            }
            if (ColonyAbandonmentManager.forceAbandonColony(targetColony, admin.m_20194_(), admin.m_7755_().getString())) {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully force abandoned colony '" + targetColony.getName() + "'!")).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}), true);
                source.m_288197_(() -> Component.m_237113_((String)("Colony ID: " + targetColony.getID() + ", Notified " + managersToNotify.size() + " former managers.")).m_130940_(ChatFormatting.GRAY), false);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)("Failed to abandon colony '" + targetColony.getName() + "'!")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Error while abandoning colony: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
    }

    private static int handleCleanupAbandonedEntries(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"Starting cleanup of [abandoned] entries across all colonies...").m_130940_(ChatFormatting.YELLOW), false);
        try {
            ColonyAbandonmentManager.cleanupAllColoniesAbandonedEntries();
            source.m_288197_(() -> Component.m_237113_((String)"Cleanup completed successfully! Check server logs for details.").m_130940_(ChatFormatting.GREEN), false);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Cleanup failed: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    private static int handleDebugBossBar(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String colonyName = WntCommands.extractColonyName(StringArgumentType.getString(context, (String)"colony"));
        IColony targetColony = WarSystem.findColonyByName(colonyName, (Level)(level = source.m_81372_()));
        if (targetColony == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Colony '" + colonyName + "' not found!")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        ColonyClaimingRaidManager.debugClaimingRaid(targetColony.getID());
        if (ColonyClaimingRaidManager.isColonyUnderClaimingRaid(targetColony.getID())) {
            ColonyClaimingRaidManager.forceRefreshBossBar(targetColony.getID());
            source.m_288197_(() -> Component.m_237113_((String)("Forced boss bar refresh for colony '" + colonyName + "'. Check server logs for debug info.")).m_130940_(ChatFormatting.GREEN), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)("No active claiming raid for colony '" + colonyName + "'. Debug info logged.")).m_130940_(ChatFormatting.YELLOW), false);
        }
        return 1;
    }

    private static int handleForceCleanupColony(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String colonyName = WntCommands.extractColonyName(StringArgumentType.getString(context, (String)"colony"));
        IColony targetColony = WarSystem.findColonyByName(colonyName, (Level)(level = source.m_81372_()));
        if (targetColony == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Colony '" + colonyName + "' not found!")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)("Starting force cleanup of [abandoned] entries for colony '" + colonyName + "'...")).m_130940_(ChatFormatting.YELLOW), false);
        try {
            int playersBefore = targetColony.getPermissions().getPlayers().size();
            Method cleanupMethod = ColonyAbandonmentManager.class.getDeclaredMethod("cleanupAbandonedEntries", IPermissions.class);
            cleanupMethod.setAccessible(true);
            cleanupMethod.invoke(null, targetColony.getPermissions());
            int playersAfter = targetColony.getPermissions().getPlayers().size();
            int removedEntries = playersBefore - playersAfter;
            if (removedEntries > 0) {
                source.m_288197_(() -> Component.m_237113_((String)("Force cleanup completed! Removed " + removedEntries + " problematic entries from colony '" + colonyName + "'.")).m_130940_(ChatFormatting.GREEN), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Force cleanup completed! No problematic entries found in colony '" + colonyName + "'.")).m_130940_(ChatFormatting.YELLOW), false);
            }
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Force cleanup failed: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    private static int handleEmergencyFix(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\ud83d\udea8 EMERGENCY FIX STARTED \ud83d\udea8").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), false);
        try {
            source.m_288197_(() -> Component.m_237113_((String)"\ud83d\udea8 STEP 0: EMERGENCY null owner fixes...").m_130940_(ChatFormatting.RED), false);
            ColonyAbandonmentManager.emergencyFixAllNullOwners();
            source.m_288197_(() -> Component.m_237113_((String)"Step 1: Cleaning up [abandoned] entries AND fixing null owners...").m_130940_(ChatFormatting.YELLOW), false);
            ColonyAbandonmentManager.cleanupAllColoniesAbandonedEntries();
            source.m_288197_(() -> Component.m_237113_((String)"Step 2: Fixing abandoned colonies...").m_130940_(ChatFormatting.YELLOW), false);
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            int[] fixedColonies = new int[]{0};
            for (IColony colony : colonyManager.getAllColonies()) {
                try {
                    IPermissions permissions = colony.getPermissions();
                    UUID owner = permissions.getOwner();
                    boolean needsFix = false;
                    String[] issue = new String[]{""};
                    if (owner == null) {
                        needsFix = true;
                        issue[0] = "null owner";
                    } else {
                        for (ColonyPlayer player : permissions.getPlayers().values()) {
                            if (player.getName() == null || !player.getName().contains("[abandoned]") && !player.getName().toLowerCase().contains("abandoned")) continue;
                            needsFix = true;
                            issue[0] = "has [abandoned] entries";
                            break;
                        }
                    }
                    if (!needsFix) continue;
                    String colonyName = colony.getName();
                    String fixIssue = issue[0];
                    source.m_288197_(() -> Component.m_237113_((String)("  Fixing " + colonyName + " - " + fixIssue)).m_130940_(ChatFormatting.AQUA), false);
                    ColonyAbandonmentManager.cleanupAbandonedEntries(permissions);
                    if (permissions.getOwner() == null || ColonyAbandonmentManager.isSystemOwner(permissions.getOwner())) {
                        UUID systemOwner = ColonyAbandonmentManager.createSystemOwner();
                        permissions.addPlayer(systemOwner, "[SYSTEM_ABANDONED]", permissions.getRankOwner());
                        try {
                            Method setOwnerMethod = permissions.getClass().getMethod("setOwner", UUID.class);
                            setOwnerMethod.invoke((Object)permissions, systemOwner);
                            source.m_288197_(() -> Component.m_237113_((String)"    Set system owner as actual owner to prevent GUI crashes").m_130940_(ChatFormatting.GREEN), false);
                        }
                        catch (Exception e) {
                            try {
                                for (Method method : permissions.getClass().getDeclaredMethods()) {
                                    if (!method.getName().equals("setOwner") || method.getParameterCount() != 1) continue;
                                    method.setAccessible(true);
                                    method.invoke((Object)permissions, systemOwner);
                                    source.m_288197_(() -> Component.m_237113_((String)"    Set system owner (alt method) to prevent GUI crashes").m_130940_(ChatFormatting.GREEN), false);
                                }
                            }
                            catch (Exception e2) {
                                source.m_81352_((Component)Component.m_237113_((String)"    WARNING: Could not set actual owner - GUI may crash!").m_130940_(ChatFormatting.RED));
                            }
                        }
                        Rank neutralRank = permissions.getRankNeutral();
                        for (UUID playerId : permissions.getPlayers().keySet()) {
                            if (ColonyAbandonmentManager.isSystemOwner(playerId)) continue;
                            permissions.setPlayerRank(playerId, neutralRank, colony.getWorld());
                        }
                        permissions.setPermission(neutralRank, Action.BREAK_BLOCKS, false);
                        permissions.setPermission(neutralRank, Action.PLACE_BLOCKS, false);
                        permissions.setPermission(neutralRank, Action.RIGHTCLICK_BLOCK, false);
                        permissions.setPermission(neutralRank, Action.OPEN_CONTAINER, false);
                    }
                    fixedColonies[0] = fixedColonies[0] + 1;
                }
                catch (Exception e) {
                    String colonyName = colony.getName();
                    source.m_81352_((Component)Component.m_237113_((String)("  Error fixing " + colonyName + ": " + e.getMessage())).m_130940_(ChatFormatting.RED));
                }
            }
            source.m_288197_(() -> Component.m_237113_((String)"Step 3: Cleaning up failed claiming raids...").m_130940_(ChatFormatting.YELLOW), false);
            ColonyClaimingRaidManager.cleanupAllFailedRaids();
            source.m_288197_(() -> Component.m_237113_((String)"\u2705 EMERGENCY FIX COMPLETE \u2705").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}), false);
            source.m_288197_(() -> Component.m_237113_((String)("Fixed " + fixedColonies[0] + " colonies")).m_130940_(ChatFormatting.GREEN), false);
            source.m_288197_(() -> Component.m_237113_((String)"Try your claiming raids again!").m_130940_(ChatFormatting.GREEN), false);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u274c EMERGENCY FIX FAILED: " + e.getMessage())).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            return 0;
        }
    }

    private static int handleFixNullOwners(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\ud83d\udea8 EMERGENCY NULL OWNER FIX STARTED \ud83d\udea8").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), false);
        try {
            source.m_288197_(() -> Component.m_237113_((String)"Scanning all colonies for null owners...").m_130940_(ChatFormatting.YELLOW), false);
            ColonyAbandonmentManager.emergencyFixAllNullOwners();
            source.m_288197_(() -> Component.m_237113_((String)"\u2705 NULL OWNER FIX COMPLETED!").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}), false);
            source.m_288197_(() -> Component.m_237113_((String)"All colonies now have valid owners - GUI crashes should be prevented!").m_130940_(ChatFormatting.GREEN), false);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\ud83d\udca5 ERROR during null owner fix: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            LOGGER.error("Error during /wnt fixnullowners command", (Throwable)e);
        }
        return 1;
    }

    static {
        COLONY_SUGGESTIONS = (context, builder) -> {
            try {
                ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
                IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
                List colonyNames = colonyManager.getAllColonies().stream().map(IColony::getName).map(name -> name.contains(" ") ? "\"" + name + "\"" : name).collect(Collectors.toList());
                return SharedSuggestionProvider.m_82970_(colonyNames, (SuggestionsBuilder)builder);
            }
            catch (Exception e) {
                return builder.buildFuture();
            }
        };
        PLAYER_COLONY_SUGGESTIONS = (context, builder) -> {
            try {
                ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
                IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
                List colonyNames = colonyManager.getAllColonies().stream().filter(colony -> colony.getPermissions().getRank(player.m_20148_()).isColonyManager()).map(IColony::getName).map(name -> name.contains(" ") ? "\"" + name + "\"" : name).collect(Collectors.toList());
                return SharedSuggestionProvider.m_82970_(colonyNames, (SuggestionsBuilder)builder);
            }
            catch (Exception e) {
                return builder.buildFuture();
            }
        };
        ABANDONED_COLONY_SUGGESTIONS = (context, builder) -> {
            try {
                ((CommandSourceStack)context.getSource()).m_81375_();
                List colonyNames = ColonyAbandonmentManager.getClaimableColonies(((CommandSourceStack)context.getSource()).m_81377_()).stream().map(IColony::getName).map(name -> name.contains(" ") ? "\"" + name + "\"" : name).collect(Collectors.toList());
                return SharedSuggestionProvider.m_82970_(colonyNames, (SuggestionsBuilder)builder);
            }
            catch (Exception e) {
                return builder.buildFuture();
            }
        };
    }
}

