/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.data;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="minecolonytax", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MCTLanguageProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new EnglishLanguageProvider(packOutput));
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new RussianLanguageProvider(packOutput));
    }

    public static class EnglishLanguageProvider
    extends BaseLanguageProvider {
        public EnglishLanguageProvider(PackOutput output) {
            super(output, "en_us");
        }

        @Override
        protected void addTranslations() {
            this.add("command.checktax.self", "Colony: %s - Stored Tax Revenue: %d");
            this.add("command.checktax.other", "%s's colony: %s - Stored Tax Revenue: %d coins");
            this.add("command.checktax.no_colonies", "You are not an owner or officer of any colonies.");
            this.add("command.claimtax.success", "You have claimed %d in tax revenue from colony %s.");
            this.add("command.claimtax.no_tax", "No taxes available to claim for colony %s.");
            this.add("war.declare.title", "\ud83d\udcdc WAR DECLARED! \ud83d\udcdc");
            this.add("war.declare.body", "%s has declared WAR upon %s!");
            this.add("war.begin.title", "\ud83d\udd25 THE WAR BEGINS! \ud83d\udd25");
        }
    }

    public static class RussianLanguageProvider
    extends BaseLanguageProvider {
        public RussianLanguageProvider(PackOutput output) {
            super(output, "ru_ru");
        }

        @Override
        protected void addTranslations() {
            this.add("command.checktax.self", "\u041a\u043e\u043b\u043e\u043d\u0438\u044f: %s - \u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u043d\u044b\u0439 \u043d\u0430\u043b\u043e\u0433\u043e\u0432\u044b\u0439 \u0434\u043e\u0445\u043e\u0434: %d");
            this.add("command.checktax.other", "\u041a\u043e\u043b\u043e\u043d\u0438\u044f %s: %s - \u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u043d\u044b\u0439 \u043d\u0430\u043b\u043e\u0433\u043e\u0432\u044b\u0439 \u0434\u043e\u0445\u043e\u0434: %d \u043c\u043e\u043d\u0435\u0442");
            this.add("command.checktax.no_colonies", "\u0412\u044b \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0435\u0441\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0435\u043c \u0438\u043b\u0438 \u043e\u0444\u0438\u0446\u0435\u0440\u043e\u043c \u043d\u0438 \u043e\u0434\u043d\u043e\u0439 \u043a\u043e\u043b\u043e\u043d\u0438\u0438.");
            this.add("command.claimtax.success", "\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 %d \u043d\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u0445\u043e\u0434\u0430 \u043e\u0442 \u043a\u043e\u043b\u043e\u043d\u0438\u0438 %s.");
            this.add("command.claimtax.no_tax", "\u0412 \u043a\u043e\u043b\u043e\u043d\u0438\u0438 %s \u043d\u0435\u0442 \u043d\u0430\u043b\u043e\u0433\u043e\u0432 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f.");
            this.add("war.declare.title", "\ud83d\udcdc \u041e\u0411\u042a\u042f\u0412\u041b\u0415\u041d\u0410 \u0412\u041e\u0419\u041d\u0410! \ud83d\udcdc");
            this.add("war.declare.body", "%s \u043e\u0431\u044a\u044f\u0432\u0438\u043b \u0412\u041e\u0419\u041d\u0423 %s!");
            this.add("war.begin.title", "\ud83d\udd25 \u0412\u041e\u0419\u041d\u0410 \u041d\u0410\u0427\u0410\u041b\u0410\u0421\u042c! \ud83d\udd25");
        }
    }

    public static abstract class BaseLanguageProvider
    extends LanguageProvider {
        public BaseLanguageProvider(PackOutput output, String locale) {
            super(output, "minecolonytax", locale);
        }

        protected abstract void addTranslations();
    }
}

