/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.data;

import net.machiavelli.minecolonytax.MineColonyTax;
import net.machiavelli.minecolonytax.capability.PlayerWarDataCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Objective;

public class PlayerWarDataManager {
    public static void incrementPlayersKilledInWar(ServerPlayer player) {
        PlayerWarDataCapability.get((Player)player).ifPresent(data -> {
            data.incrementPlayersKilledInWar();
            PlayerWarDataManager.updateScoreboard(player, "playersKilled", data.getPlayersKilledInWar());
            PlayerWarDataManager.markDirty(player);
        });
    }

    public static void incrementRaidedColonies(ServerPlayer player) {
        PlayerWarDataCapability.get((Player)player).ifPresent(data -> {
            data.incrementRaidedColonies();
            PlayerWarDataManager.updateScoreboard(player, "raidsCompleted", data.getRaidedColonies());
            PlayerWarDataManager.markDirty(player);
        });
    }

    public static void addAmountRaided(ServerPlayer player, long amount) {
        PlayerWarDataCapability.get((Player)player).ifPresent(data -> {
            data.addAmountRaided(amount);
            PlayerWarDataManager.updateScoreboard(player, "amountRaided", (int)data.getAmountRaided());
            PlayerWarDataManager.markDirty(player);
        });
    }

    public static void incrementWarsWon(ServerPlayer player) {
        PlayerWarDataCapability.get((Player)player).ifPresent(data -> {
            data.incrementWarsWon();
            PlayerWarDataManager.updateScoreboard(player, "warsWon", data.getWarsWon());
            PlayerWarDataManager.markDirty(player);
        });
    }

    public static void incrementWarStalemates(ServerPlayer player) {
        PlayerWarDataCapability.get((Player)player).ifPresent(data -> {
            data.incrementWarStalemates();
            PlayerWarDataManager.updateScoreboard(player, "warStalemates", data.getWarStalemates());
            PlayerWarDataManager.markDirty(player);
        });
    }

    private static void updateScoreboard(ServerPlayer player, String objective, int value) {
        ServerScoreboard sb;
        Objective obj;
        if (player.m_20194_() != null && (obj = (sb = player.m_20194_().m_129896_()).m_83477_(objective)) != null) {
            sb.m_83471_(player.m_7755_().getString(), obj).m_83402_(value);
        }
    }

    private static void markDirty(ServerPlayer player) {
        try {
            MineColonyTax.LOGGER.debug("Marking player data dirty for " + player.m_7755_().getString());
            PlayerWarDataCapability.get((Player)player).ifPresent(data -> {
                try {
                    CompoundTag nbt = data.serializeNBT();
                    CompoundTag persistentData = player.getPersistentData();
                    if (!persistentData.m_128441_("ForgeData")) {
                        persistentData.m_128365_("ForgeData", (Tag)new CompoundTag());
                    }
                    CompoundTag forgeData = persistentData.m_128469_("ForgeData");
                    forgeData.m_128365_("minecolonytax_war_data", (Tag)nbt);
                    CompoundTag verifyData = forgeData.m_128469_("minecolonytax_war_data");
                    if (verifyData.m_128456_()) {
                        MineColonyTax.LOGGER.error("Failed to save war data to persistent storage for player " + player.m_7755_().getString());
                    } else {
                        MineColonyTax.LOGGER.debug("Updated persistent data for player " + player.m_7755_().getString() + ": " + nbt);
                    }
                    player.getPersistentData().m_128379_("minecolonytax:data_changed", true);
                    player.getPersistentData().m_128379_("minecolonytax:data_changed", true);
                    MineColonyTax.LOGGER.debug("Marked player data as dirty for " + player.m_7755_().getString());
                }
                catch (Exception e) {
                    MineColonyTax.LOGGER.error("Error updating persistent data: " + e.getMessage());
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            MineColonyTax.LOGGER.error("Failed to save player data: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

