/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.data;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Action;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.peace.PeaceProposal;
import net.minecraft.server.level.ServerBossEvent;

public class WarData {
    private final UUID warID;
    private final UUID attacker;
    private final UUID defender;
    private final UUID attackerTeamID;
    private final UUID defenderTeamID;
    private final IColony colony;
    public long warStartTime;
    public long joinPhaseEndTime;
    private final Map<UUID, Integer> attackerLives = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Integer> defenderLives = new ConcurrentHashMap<UUID, Integer>();
    private final Set<UUID> spectators = ConcurrentHashMap.newKeySet();
    private final Set<Integer> guardIDs = ConcurrentHashMap.newKeySet();
    private final Set<UUID> attackerAllies = ConcurrentHashMap.newKeySet();
    private final Set<UUID> defenderAllies = ConcurrentHashMap.newKeySet();
    private final Set<UUID> lastLifeInventoryPreservation = ConcurrentHashMap.newKeySet();
    public TimerTask timerTask;
    public ServerBossEvent bossEvent;
    public ServerBossEvent alliesBossEvent;
    private String penaltyReport = "";
    private final Set<UUID> acceptedAllies = new HashSet<UUID>();
    private final Set<UUID> declinedAllies = new HashSet<UUID>();
    public Map<Action, Boolean> originalHostilePerms;
    public Map<Action, Boolean> originalHostilePermsForAttacker;
    public int totalGuards;
    public int remainingGuards;
    private PeaceProposal activeProposal;
    private boolean stalemateTriggered;
    private WarStatus status;
    private boolean accepted = false;
    private final IColony attackerColony;
    public final int initialAttackerGuards;
    public int remainingAttackerGuards;
    public final int initialDefenderGuards;
    public int remainingDefenderGuards;
    public int initialAttackerTotalLives;
    public int initialDefenderTotalLives;

    public WarData(UUID attacker, UUID defender, UUID attackerTeamID, UUID defenderTeamID, long joinPhaseStart, ServerBossEvent bossEvent, IColony colony, IColony attackerColony) {
        this.attacker = attacker;
        this.defender = defender;
        this.warID = UUID.randomUUID();
        this.attackerTeamID = attackerTeamID;
        this.defenderTeamID = defenderTeamID;
        this.colony = colony;
        this.attackerColony = attackerColony;
        this.warStartTime = joinPhaseStart;
        this.joinPhaseEndTime = joinPhaseStart + TimeUnit.MINUTES.toMillis(((Integer)TaxConfig.JOIN_PHASE_DURATION_MINUTES.get()).intValue());
        this.bossEvent = bossEvent;
        this.status = WarStatus.JOINING;
        this.remainingDefenderGuards = this.initialDefenderGuards = colony.getCitizenManager().getCitizens().stream().filter(citizen -> citizen.getJob() != null && citizen.getJob().isGuard()).mapToInt(c -> 1).sum();
        this.remainingAttackerGuards = this.initialAttackerGuards = attackerColony.getCitizenManager().getCitizens().stream().filter(citizen -> citizen.getJob() != null && citizen.getJob().isGuard()).mapToInt(c -> 1).sum();
        this.initializeGuards(colony);
        if (attackerColony != null) {
            this.initializeGuards(attackerColony);
        }
    }

    private void initializeGuards(IColony colony) {
        colony.getCitizenManager().getCitizens().stream().filter(citizen -> citizen.getJob() != null && citizen.getJob().isGuard()).forEach(citizen -> this.guardIDs.add(citizen.getId()));
    }

    public void setActiveProposal(PeaceProposal proposal) {
        this.activeProposal = proposal;
    }

    public void setPenaltyReport(String report) {
        this.penaltyReport = report;
    }

    public String getPenaltyReport() {
        return this.penaltyReport;
    }

    public UUID getAttacker() {
        return this.attacker;
    }

    public UUID getDefender() {
        return this.defender;
    }

    public WarStatus getStatus() {
        return this.status;
    }

    public void setStatus(WarStatus status) {
        this.status = status;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public int getRemainingAttackerGuards() {
        return this.remainingAttackerGuards;
    }

    public int getRemainingDefenderGuards() {
        return this.remainingDefenderGuards;
    }

    public IColony getAttackerColony() {
        return this.attackerColony;
    }

    public UUID getWarID() {
        return this.warID;
    }

    public UUID getAttackerTeamID() {
        return this.attackerTeamID;
    }

    public UUID getDefenderTeamID() {
        return this.defenderTeamID;
    }

    public IColony getColony() {
        return this.colony;
    }

    public Map<UUID, Integer> getAttackerLives() {
        return this.attackerLives;
    }

    public Map<UUID, Integer> getDefenderLives() {
        return this.defenderLives;
    }

    public Set<UUID> getSpectators() {
        return this.spectators;
    }

    public Set<Integer> getGuardIDs() {
        return this.guardIDs;
    }

    public boolean isJoinPhaseActive() {
        return System.currentTimeMillis() < this.joinPhaseEndTime;
    }

    public boolean isWarTimeExpired() {
        return System.currentTimeMillis() - this.warStartTime > TimeUnit.HOURS.toMillis(2L);
    }

    public boolean isStalemateTriggered() {
        return this.stalemateTriggered;
    }

    public PeaceProposal getActiveProposal() {
        return this.activeProposal;
    }

    public Set<UUID> getAcceptedAllies() {
        return this.acceptedAllies;
    }

    public Set<UUID> getDeclinedAllies() {
        return this.declinedAllies;
    }

    public long getJoinPhaseEndTime() {
        return this.joinPhaseEndTime;
    }

    public void setJoinPhaseEndTime(long joinPhaseEndTime) {
        this.joinPhaseEndTime = joinPhaseEndTime;
    }

    public Set<UUID> getAttackerAllies() {
        return this.attackerAllies;
    }

    public Set<UUID> getDefenderAllies() {
        return this.defenderAllies;
    }

    public Set<UUID> getLastLifeInventoryPreservation() {
        return this.lastLifeInventoryPreservation;
    }

    public static enum WarStatus {
        JOINING,
        INWAR,
        ERROR;

    }
}

