/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.blocks.ModBlocks;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.recipe.DisabledRecipeSerializer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisabledRecipeProvider
extends RecipeProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisabledRecipeProvider.class);
    private static final Set<ResourceLocation> DISABLED_HUT_RECIPES = new HashSet<ResourceLocation>();

    private static void addHutBlock(Object block) {
        ResourceLocation blockId;
        if (block != null && (blockId = ForgeRegistries.BLOCKS.getKey((Object)((Block)block))) != null) {
            DISABLED_HUT_RECIPES.add(blockId);
        }
    }

    public DisabledRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> consumer) {
        if (!TaxConfig.isDisableHutRecipesEnabled()) {
            LOGGER.info("Recipe disabling is not enabled - skipping disabled recipe generation");
            return;
        }
        LOGGER.info("Recipe disabling is enabled - generating disabled recipe files for buildings with taxes/maintenance costs");
        for (ResourceLocation blockId : DISABLED_HUT_RECIPES) {
            final ItemStack resultItem = new ItemStack((ItemLike)ForgeRegistries.BLOCKS.getValue(blockId));
            if (resultItem.m_41619_()) continue;
            final ResourceLocation recipeId = new ResourceLocation("minecolonytax", "disabled_" + blockId.m_135815_());
            consumer.accept(new FinishedRecipe(){

                public void m_7917_(@NotNull JsonObject json) {
                    json.addProperty("type", "minecolonytax:disabled_recipe");
                    json.add("result", (JsonElement)DisabledRecipeProvider.this.itemStackToJson(resultItem));
                }

                @NotNull
                public ResourceLocation m_6445_() {
                    return recipeId;
                }

                @NotNull
                public RecipeSerializer<?> m_6637_() {
                    return DisabledRecipeSerializer.INSTANCE;
                }

                @NotNull
                public ResourceLocation m_6448_() {
                    return new ResourceLocation("");
                }

                @NotNull
                public JsonObject m_5860_() {
                    return new JsonObject();
                }
            });
            LOGGER.debug("Generated disabled recipe for: {} -> {}", (Object)blockId, (Object)recipeId);
        }
        LOGGER.info("Generated {} disabled recipe files", (Object)DISABLED_HUT_RECIPES.size());
    }

    @NotNull
    private JsonObject itemStackToJson(@NotNull ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        if (stack.m_41613_() > 1) {
            json.addProperty("count", (Number)stack.m_41613_());
        }
        return json;
    }

    public static Set<ResourceLocation> getDisabledHutRecipes() {
        return new HashSet<ResourceLocation>(DISABLED_HUT_RECIPES);
    }

    public static boolean shouldDisableRecipe(ResourceLocation blockId) {
        return TaxConfig.isDisableHutRecipesEnabled() && DISABLED_HUT_RECIPES.contains(blockId);
    }

    static {
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutAlchemist);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutConcreteMixer);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutFletcher);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutLumberjack);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutRabbitHutch);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutShepherd);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutSmeltery);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutSwineHerder);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutTownHall);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutWareHouse);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutBaker);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutBlacksmith);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutBuilder);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutChickenHerder);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutComposter);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutCook);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutCowboy);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutCrusher);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutDeliveryman);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutDyer);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutEnchanter);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutFarmer);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutFisherman);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutFlorist);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutGlassblower);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutHospital);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutLibrary);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutMechanic);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutMiner);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutPlantation);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutSawmill);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutStonemason);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutTavern);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutNetherWorker);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutGraveyard);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutBeekeeper);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutUniversity);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutHome);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutBarracks);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutGuardTower);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutBarracksTower);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutArchery);
        DisabledRecipeProvider.addHutBlock(ModBlocks.blockHutCombatAcademy);
    }
}

