/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import net.machiavelli.minecolonytax.abandon.ColonyAbandonmentManager;
import net.machiavelli.minecolonytax.abandon.ColonyClaimingRaidManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class AbandonedColonyProtectionHandler {
    private static final Logger LOGGER = LogManager.getLogger(AbandonedColonyProtectionHandler.class);

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (AbandonedColonyProtectionHandler.isBlockInAbandonedColony(event.getPos(), (Level)event.getLevel(), serverPlayer)) {
            event.setCanceled(true);
            serverPlayer.m_213846_((Component)Component.m_237113_((String)"You cannot break blocks in abandoned colonies!").m_130940_(ChatFormatting.RED));
            LOGGER.debug("Blocked block breaking by {} in abandoned colony at {}", (Object)player.m_7755_().getString(), (Object)event.getPos());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
            if (AbandonedColonyProtectionHandler.isBlockInAbandonedColony(event.getPos(), (Level)event.getLevel(), serverPlayer)) {
                event.setCanceled(true);
                serverPlayer.m_213846_((Component)Component.m_237113_((String)"You cannot place blocks in abandoned colonies!").m_130940_(ChatFormatting.RED));
                LOGGER.debug("Blocked block placing by {} in abandoned colony at {}", (Object)serverPlayer.m_7755_().getString(), (Object)event.getPos());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (AbandonedColonyProtectionHandler.isBlockInAbandonedColony(event.getPos(), event.getLevel(), serverPlayer)) {
                if (AbandonedColonyProtectionHandler.isPlayerInActiveClaimingRaid(serverPlayer, IColonyManager.getInstance().getColonyByPosFromWorld(event.getLevel(), event.getPos()))) {
                    return;
                }
                event.setCanceled(true);
                serverPlayer.m_213846_((Component)Component.m_237113_((String)"You cannot interact with blocks in abandoned colonies!").m_130940_(ChatFormatting.RED));
                LOGGER.debug("Blocked block interaction by {} in abandoned colony at {}", (Object)serverPlayer.m_7755_().getString(), (Object)event.getPos());
            }
        }
    }

    private static boolean isBlockInAbandonedColony(BlockPos pos, Level level, ServerPlayer player) {
        try {
            IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(level, pos);
            if (colony == null) {
                return false;
            }
            if (!ColonyAbandonmentManager.isColonyAbandoned(colony)) {
                return false;
            }
            if (player.m_20310_(2)) {
                return false;
            }
            if (AbandonedColonyProtectionHandler.isPlayerInActiveClaimingRaid(player, colony)) {
                return false;
            }
            LOGGER.debug("Blocking {} from modifying blocks in abandoned colony {} at {}", (Object)player.m_7755_().getString(), (Object)colony.getName(), (Object)pos);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error checking abandoned colony protection for position {}", (Object)pos, (Object)e);
            return false;
        }
    }

    private static boolean isPlayerInActiveClaimingRaid(ServerPlayer player, IColony colony) {
        try {
            return ColonyClaimingRaidManager.isPlayerInClaimingRaid(player.m_20148_(), colony.getID());
        }
        catch (Exception e) {
            LOGGER.debug("Error checking claiming raid status", (Throwable)e);
            return false;
        }
    }
}

