/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.raid.ActiveRaidData;
import net.machiavelli.minecolonytax.raid.EntityRaidManager;
import net.machiavelli.minecolonytax.raid.RaidManager;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="minecolonytax", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ColonyEventListener {
    private static final Logger LOGGER = LogManager.getLogger(ColonyEventListener.class);
    private static final Map<Integer, Map<IBuilding, Integer>> colonyBuildingLevels = new HashMap<Integer, Map<IBuilding, Integer>>();
    private static int tickCounter = 0;
    private static final int CHECK_INTERVAL_TICKS = 20;
    private static int entityScanTickCounter = 0;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (((Boolean)TaxConfig.ENABLE_ENTITY_RAIDS.get()).booleanValue()) {
            EntityRaidManager.tick();
        }
        if (((Boolean)TaxConfig.ENABLE_ENTITY_RAIDS.get()).booleanValue() && ++entityScanTickCounter >= 200) {
            entityScanTickCounter = 0;
            ColonyEventListener.scanColoniesForEntityRaids();
        }
        List colonies = IColonyManager.getInstance().getAllColonies();
        for (IColony colony : colonies) {
            int colonyId = colony.getID();
            Map buildingLevels = colonyBuildingLevels.computeIfAbsent(colonyId, k -> new HashMap());
            int guardTowerCount = 0;
            int newOrUpgradedBuildingsCount = 0;
            for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                int currentLevel = building.getBuildingLevel();
                if (ColonyEventListener.isGuardTower(building)) {
                    ++guardTowerCount;
                }
                if (buildingLevels.containsKey(building) && (Integer)buildingLevels.get(building) >= currentLevel) continue;
                ++newOrUpgradedBuildingsCount;
                buildingLevels.put(building, currentLevel);
            }
            if (newOrUpgradedBuildingsCount <= 0 || !TaxConfig.showColonyInitializationLogs()) continue;
            LOGGER.info("Colony '{}': Detected {} new/upgraded buildings (Guards: {})", (Object)colony.getName(), (Object)newOrUpgradedBuildingsCount, (Object)guardTowerCount);
        }
    }

    private static void scanColoniesForEntityRaids() {
        try {
            int threshold = Math.max(1, TaxConfig.getEntityRaidThreshold());
            long cooldownMs = (long)Math.max(0, TaxConfig.getEntityRaidCooldownMinutes()) * 60000L;
            List colonies = IColonyManager.getInstance().getAllColonies();
            for (IColony colony : colonies) {
                int colonyId;
                if (colony == null || colony.getWorld() == null || !(colony.getWorld() instanceof ServerLevel) || EntityRaidManager.hasActiveEntityRaid(colonyId = colony.getID())) continue;
                long now = System.currentTimeMillis();
                if (EntityRaidManager.isOnCooldown(colonyId, cooldownMs)) {
                    long last = EntityRaidManager.getLastRaidTime(colonyId);
                    if (!TaxConfig.isEntityRaidDebugEnabled()) continue;
                    LOGGER.info("[EntityRaid-SCAN] Colony '{}' on cooldown ({}s left)", (Object)colony.getName(), (Object)((cooldownMs - (now - last)) / 1000L));
                    continue;
                }
                ServerLevel level = (ServerLevel)colony.getWorld();
                int eligibleCount = 0;
                Entity firstTrigger = null;
                if (TaxConfig.isEntityRaidDebugEnabled() && TaxConfig.getEntityRaidDebugLevel() >= 2) {
                    LOGGER.info("[EntityRaid-SCAN] \ud83d\udd0d Scanning colony '{}' for whitelisted entities currently INSIDE boundary", (Object)colony.getName());
                }
                for (Entity e : level.m_142646_().m_142273_()) {
                    try {
                        if (!EntityRaidManager.shouldTriggerEntityRaid(e, colony)) continue;
                        boolean inside = false;
                        try {
                            inside = colony.isCoordInColony(colony.getWorld(), e.m_20183_());
                        }
                        catch (Throwable t) {
                            inside = false;
                        }
                        if (!inside) continue;
                        ++eligibleCount;
                        if (firstTrigger == null) {
                            firstTrigger = e;
                        }
                        if (TaxConfig.isEntityRaidDebugEnabled() && TaxConfig.getEntityRaidDebugLevel() >= 3) {
                            LOGGER.debug("[EntityRaid-SCAN] \u2705 Entity {} is INSIDE boundary and qualifies (count: {})", (Object)e.m_6095_().m_20675_(), (Object)eligibleCount);
                        }
                        if (eligibleCount < threshold) continue;
                        break;
                    }
                    catch (Exception ex) {
                        if (!TaxConfig.isEntityRaidDebugEnabled()) continue;
                        LOGGER.warn("[EntityRaid-SCAN] Error evaluating entity near colony '{}': {}", (Object)colony.getName(), (Object)ex.toString());
                    }
                }
                if (eligibleCount >= threshold && firstTrigger != null) {
                    if (TaxConfig.isEntityRaidDebugEnabled()) {
                        LOGGER.info("[EntityRaid-SCAN] Threshold met for colony '{}' (count={}, threshold={}) \u2014 starting raid.", (Object)colony.getName(), (Object)eligibleCount, (Object)threshold);
                    }
                    EntityRaidManager.startEntityRaid(colony, firstTrigger);
                    continue;
                }
                if (!TaxConfig.isEntityRaidDebugEnabled() || TaxConfig.getEntityRaidDebugLevel() < 2) continue;
                LOGGER.info("[EntityRaid-SCAN] Colony '{}' count={} (threshold={}), no raid.", (Object)colony.getName(), (Object)eligibleCount, (Object)threshold);
            }
        }
        catch (Exception e) {
            LOGGER.error("[EntityRaid-SCAN] Unexpected error during scan:", (Throwable)e);
        }
    }

    private static boolean isGuardTower(IBuilding building) {
        if (building == null) {
            return false;
        }
        String displayName = building.getBuildingDisplayName();
        if (displayName != null && "Guard Tower".equalsIgnoreCase(displayName)) {
            return true;
        }
        String className = building.getClass().getName().toLowerCase();
        if (className.contains("guardtower")) {
            return true;
        }
        try {
            String toString = building.toString().toLowerCase();
            if (toString.contains("guardtower") || toString.contains("guard_tower")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @SubscribeEvent
    public static void onGuardDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof AbstractEntityCitizen)) {
            return;
        }
        AbstractEntityCitizen citizen = (AbstractEntityCitizen)livingEntity;
        ICitizenData citizenData = citizen.getCitizenData();
        if (citizenData == null || citizenData.getJob() == null) {
            return;
        }
        if (!citizenData.getJob().isGuard()) {
            return;
        }
        IColony colony = citizenData.getColony();
        if (colony == null) {
            return;
        }
        ActiveRaidData raidData = RaidManager.getActiveRaidByColony(colony.getID());
        if (raidData == null) {
            return;
        }
        raidData.incrementGuardsKilled();
        LOGGER.info("Guard killed during raid! Colony: {}, Guards killed: {}/{}", (Object)colony.getName(), (Object)raidData.getGuardsKilled(), (Object)raidData.getTotalGuards());
        if (raidData.getBossEvent() != null) {
            double killPercentage = raidData.getGuardKillPercentage();
            String progressText = String.format("Raid Progress: %d/%d Guards Defeated (%.1f%%)", raidData.getGuardsKilled(), raidData.getTotalGuards(), killPercentage * 100.0);
            raidData.getBossEvent().m_6456_((Component)Component.m_237113_((String)progressText));
        }
    }
}

