/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.machiavelli.minecolonytax.abandon.ColonyAbandonmentManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ColonyPermissionMonitor {
    private static final Logger LOGGER = LogManager.getLogger(ColonyPermissionMonitor.class);
    private static final Map<Integer, Set<UUID>> lastKnownOfficers = new ConcurrentHashMap<Integer, Set<UUID>>();
    private static int tickCounter = 0;
    private static final int CHECK_INTERVAL = 100;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter < 100) {
            return;
        }
        tickCounter = 0;
        ColonyPermissionMonitor.checkColonyOfficerChanges(event.getServer());
    }

    private static void checkColonyOfficerChanges(MinecraftServer server) {
        try {
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            for (Level world : server.m_129785_()) {
                for (IColony colony : colonyManager.getColonies(world)) {
                    ColonyPermissionMonitor.checkColonyForOfficerChanges(colony);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error checking colony officer changes", (Throwable)e);
        }
    }

    private static void checkColonyForOfficerChanges(IColony colony) {
        try {
            boolean newOfficersAdded;
            int colonyId = colony.getID();
            Set currentOfficers = colony.getPermissions().getPlayers().values().stream().filter(player -> player.getRank().isColonyManager()).map(ColonyPlayer::getID).collect(Collectors.toSet());
            Set<UUID> previousOfficers = lastKnownOfficers.get(colonyId);
            lastKnownOfficers.put(colonyId, currentOfficers);
            if (previousOfficers == null) {
                return;
            }
            boolean bl = newOfficersAdded = currentOfficers.size() > previousOfficers.size() || !previousOfficers.containsAll(currentOfficers);
            if (newOfficersAdded) {
                LOGGER.info("Detected officer changes in colony {}: {} -> {} officers", (Object)colony.getName(), (Object)previousOfficers.size(), (Object)currentOfficers.size());
                if (ColonyAbandonmentManager.isColonyAbandoned(colony) && !currentOfficers.isEmpty()) {
                    LOGGER.info("Colony {} was abandoned but now has officers - marking as no longer abandoned", (Object)colony.getName());
                    ColonyAbandonmentManager.checkForNewOfficers(colony);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error checking colony {} for officer changes", (Object)colony.getID(), (Object)e);
        }
    }

    public static void refreshColonyOfficerTracking(IColony colony) {
        try {
            Set currentOfficers = colony.getPermissions().getPlayers().values().stream().filter(player -> player.getRank().isColonyManager()).map(ColonyPlayer::getID).collect(Collectors.toSet());
            lastKnownOfficers.put(colony.getID(), currentOfficers);
            LOGGER.debug("Refreshed officer tracking for colony {}: {} officers", (Object)colony.getName(), (Object)currentOfficers.size());
        }
        catch (Exception e) {
            LOGGER.error("Error refreshing officer tracking for colony {}", (Object)colony.getID(), (Object)e);
        }
    }

    public static void clearColonyTracking(int colonyId) {
        lastKnownOfficers.remove(colonyId);
    }
}

