/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.machiavelli.minecolonytax.TaxConfig;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class DatapackInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatapackInjector.class);
    private static final String PACK_FOLDER_NAME = "mct_disable_huts";

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        try {
            MinecraftServer server = event.getServer();
            Path datapacksDir = server.m_129843_(LevelResource.f_78180_);
            Path packRoot = datapacksDir.resolve(PACK_FOLDER_NAME);
            if (!TaxConfig.isDisableHutRecipesEnabled()) {
                if (Files.exists(packRoot, new LinkOption[0])) {
                    DatapackInjector.deleteRecursive(packRoot);
                    LOGGER.info("DatapackInjector: (pre-scan) removed datapack '{}' at {}", (Object)PACK_FOLDER_NAME, (Object)packRoot.toAbsolutePath());
                }
                return;
            }
            Path packMeta = packRoot.resolve("pack.mcmeta");
            Path dataRecipesDir = packRoot.resolve("data/minecolonies/recipes");
            Files.createDirectories(dataRecipesDir, new FileAttribute[0]);
            if (!Files.exists(packMeta, new LinkOption[0])) {
                String mcmeta = "{\n  \"pack\": {\n    \"pack_format\": 10,\n    \"description\": \"MineColonyTax: Disable MineColonies Hut Recipes\"\n  }\n}";
                Files.writeString(packMeta, (CharSequence)mcmeta, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            String[] recipeFiles = new String[]{"blockhutcombatacademy.json", "blockhutarchery.json", "blockhutbarracks.json", "blockhutbarrackstower.json", "blockhutbeekeeper.json", "blockhutblacksmith.json", "blockhutbuilder.json", "blockhutchickenherder.json", "blockhutcitizen.json", "blockhutcomposter.json", "blockhutconcretemixer.json", "blockhutcowboy.json", "blockhutdeliveryman.json", "blockhutdeliverymaniron.json", "blockhutdyer.json", "blockhutfarmer.json", "blockhutfarmerstone.json", "blockhutfisherman.json", "blockhutfletcher.json", "blockhutglassblower.json", "blockhutgraveyard.json", "blockhutguardtower.json", "blockhutkitchen.json", "blockhutlibrary.json", "blockhutlumberjack.json", "blockhutlumberjackstone.json", "blockhutmechanic.json", "blockhutmediumquarry.json", "blockhutminer.json", "blockhutminerstone.json", "blockhutnetherworker.json", "blockhutplantation.json", "blockhutplantationfield.json", "blockhutrabbithutch.json", "blockhutsawmill.json", "blockhutschool.json", "blockhutshepherd.json", "blockhutsimplequarry.json", "blockhutsmeltery.json", "blockhutstonemason.json", "blockhutstonesmeltery.json", "blockhutswineherder.json", "blockhuttavern.json", "blockhuttownhall.json", "blockhutuniversity.json", "blockhutwarehouse.json", "mediumquarry.json", "supplycampdeployer.json", "supplychestdeployer.json"};
            int written = 0;
            for (String name : recipeFiles) {
                Path dest = dataRecipesDir.resolve(name);
                Files.writeString(dest, (CharSequence)"{}\n", StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                ++written;
            }
            LOGGER.info("DatapackInjector: (pre-scan) prepared datapack '{}' at {} ({} files)", new Object[]{PACK_FOLDER_NAME, packRoot.toAbsolutePath(), written});
        }
        catch (Throwable t) {
            LOGGER.error("DatapackInjector: pre-scan datapack setup failed", t);
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        try {
            MinecraftServer server = event.getServer();
            Path datapacksDir = server.m_129843_(LevelResource.f_78180_);
            Path packRoot = datapacksDir.resolve(PACK_FOLDER_NAME);
            if (!TaxConfig.isDisableHutRecipesEnabled()) {
                if (Files.exists(packRoot, new LinkOption[0])) {
                    DatapackInjector.deleteRecursive(packRoot);
                    LOGGER.info("DatapackInjector: Removed datapack '{}' (recipes re-enabled).", (Object)PACK_FOLDER_NAME);
                    server.m_129892_().m_230957_(server.m_129893_(), "reload");
                }
                return;
            }
            Path packMeta = packRoot.resolve("pack.mcmeta");
            Path dataRecipesDir = packRoot.resolve("data/minecolonies/recipes");
            Files.createDirectories(dataRecipesDir, new FileAttribute[0]);
            if (!Files.exists(packMeta, new LinkOption[0])) {
                String mcmeta = "{\n  \"pack\": {\n    \"pack_format\": 10,\n    \"description\": \"MineColonyTax: Disable MineColonies Hut Recipes\"\n  }\n}";
                Files.writeString(packMeta, (CharSequence)mcmeta, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            String[] recipeFiles = new String[]{"blockhutcombatacademy.json", "blockhutarchery.json", "blockhutbarracks.json", "blockhutbarrackstower.json", "blockhutbeekeeper.json", "blockhutblacksmith.json", "blockhutbuilder.json", "blockhutchickenherder.json", "blockhutcitizen.json", "blockhutcomposter.json", "blockhutconcretemixer.json", "blockhutcowboy.json", "blockhutdeliveryman.json", "blockhutdeliverymaniron.json", "blockhutdyer.json", "blockhutfarmer.json", "blockhutfarmerstone.json", "blockhutfisherman.json", "blockhutfletcher.json", "blockhutglassblower.json", "blockhutgraveyard.json", "blockhutguardtower.json", "blockhutkitchen.json", "blockhutlibrary.json", "blockhutlumberjack.json", "blockhutlumberjackstone.json", "blockhutmechanic.json", "blockhutmediumquarry.json", "blockhutminer.json", "blockhutminerstone.json", "blockhutnetherworker.json", "blockhutplantation.json", "blockhutplantationfield.json", "blockhutrabbithutch.json", "blockhutsawmill.json", "blockhutschool.json", "blockhutshepherd.json", "blockhutsimplequarry.json", "blockhutsmeltery.json", "blockhutstonemason.json", "blockhutstonesmeltery.json", "blockhutswineherder.json", "blockhuttavern.json", "blockhuttownhall.json", "blockhutuniversity.json", "blockhutwarehouse.json", "mediumquarry.json", "supplycampdeployer.json", "supplychestdeployer.json"};
            int written = 0;
            for (String name : recipeFiles) {
                Path dest = dataRecipesDir.resolve(name);
                Files.writeString(dest, (CharSequence)"{}\n", StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                ++written;
            }
            server.m_129892_().m_230957_(server.m_129893_(), "datapack enable \"file/mct_disable_huts\"");
            server.m_129892_().m_230957_(server.m_129893_(), "reload");
            LOGGER.info("DatapackInjector: Installed datapack '{}' and reloaded resources ({} recipes).", (Object)PACK_FOLDER_NAME, (Object)written);
        }
        catch (IOException e) {
            LOGGER.error("DatapackInjector: IO error while creating datapack", (Throwable)e);
        }
        catch (Throwable t) {
            LOGGER.error("DatapackInjector: Failed to create/apply datapack", t);
        }
    }

    private static void deleteRecursive(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walk(path, new FileVisitOption[0]).sorted((a, b) -> b.getNameCount() - a.getNameCount()).forEach(p -> {
            try {
                Files.deleteIfExists(p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

