/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.raid.EntityRaidManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="minecolonytax", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityRaidBossbarAttachHandler {
    private static final Logger LOGGER = LogManager.getLogger(EntityRaidBossbarAttachHandler.class);

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!((Boolean)TaxConfig.ENABLE_ENTITY_RAIDS.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        EntityRaidBossbarAttachHandler.attachToActiveRaids(player2, "login");
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!((Boolean)TaxConfig.ENABLE_ENTITY_RAIDS.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        EntityRaidBossbarAttachHandler.attachToActiveRaids(player2, "respawn");
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!((Boolean)TaxConfig.ENABLE_ENTITY_RAIDS.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        EntityRaidBossbarAttachHandler.attachToActiveRaids(player2, "dimension-change");
    }

    private static void attachToActiveRaids(ServerPlayer player, String cause) {
        block3: {
            try {
                for (EntityRaidManager.ActiveEntityRaid raid : EntityRaidManager.getActiveEntityRaids().values()) {
                    if (raid.getColony() == null || raid.getColony().getWorld() != player.m_9236_()) continue;
                    raid.attachEligiblePlayer(player);
                    if (!TaxConfig.isEntityRaidDebugEnabled()) continue;
                    LOGGER.info("[EntityRaid] Bossbar attach check for {} on {} \u2014 colony '{}'", (Object)player.m_36316_().getName(), (Object)cause, (Object)raid.getColony().getName());
                }
            }
            catch (Exception e) {
                if (!TaxConfig.isEntityRaidDebugEnabled()) break block3;
                LOGGER.warn("[EntityRaid] Failed during bossbar attach on {}: {}", (Object)cause, (Object)e.toString());
            }
        }
    }
}

