/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import com.minecolonies.api.colony.IColonyManager;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.raid.EntityRaidDebugLogger;
import net.machiavelli.minecolonytax.raid.EntityRaidManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="minecolonytax", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityRaidEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(EntityRaidEventHandler.class);

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        if (!((Boolean)TaxConfig.ENABLE_ENTITY_RAIDS.get()).booleanValue()) {
            return;
        }
        String registryId = String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()));
        EntityRaidDebugLogger.logFilterStep(entity, null, "ENTITY_JOIN_LEVEL", true, "Entity joined level: " + registryId + " at " + entity.m_20183_());
        EntityRaidEventHandler.checkNearbyColoniesForRaidTrigger(entity, level);
    }

    private static void checkNearbyColoniesForRaidTrigger(Entity entity, Level level) {
        int threshold = Math.max(1, TaxConfig.getEntityRaidThreshold());
        long cooldownMs = (long)Math.max(0, TaxConfig.getEntityRaidCooldownMinutes()) * 60000L;
        IColonyManager.getInstance().getAllColonies().forEach(colony -> {
            if (colony.getWorld() != level) {
                return;
            }
            int colonyId = colony.getID();
            if (EntityRaidManager.hasActiveEntityRaid(colonyId)) {
                return;
            }
            long now = System.currentTimeMillis();
            if (EntityRaidManager.isOnCooldown(colonyId, cooldownMs)) {
                long last = EntityRaidManager.getLastRaidTime(colonyId);
                if (TaxConfig.isEntityRaidDebugEnabled()) {
                    LOGGER.info("[EntityRaid-Event] Colony '{}' on cooldown ({}s left)", (Object)colony.getName(), (Object)((cooldownMs - (now - last)) / 1000L));
                }
                return;
            }
            int eligibleCount = 0;
            Entity firstTrigger = null;
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity e : serverLevel.m_142646_().m_142273_()) {
                try {
                    if (!EntityRaidManager.shouldTriggerEntityRaid(e, colony)) continue;
                    boolean inside = false;
                    try {
                        inside = colony.isCoordInColony(colony.getWorld(), e.m_20183_());
                    }
                    catch (Throwable t) {
                        inside = false;
                    }
                    if (!inside) continue;
                    ++eligibleCount;
                    if (firstTrigger == null) {
                        firstTrigger = e;
                    }
                    if (eligibleCount < threshold) continue;
                    break;
                }
                catch (Exception ex) {
                    if (!TaxConfig.isEntityRaidDebugEnabled()) continue;
                    LOGGER.warn("[EntityRaid-Event] Error evaluating entity for colony '{}': {}", (Object)colony.getName(), (Object)ex.toString());
                }
            }
            if (eligibleCount >= threshold && firstTrigger != null) {
                if (TaxConfig.isEntityRaidDebugEnabled()) {
                    LOGGER.info("[EntityRaid-Event] Threshold met for colony '{}' (count={}, threshold={}). Starting raid.", (Object)colony.getName(), (Object)eligibleCount, (Object)threshold);
                }
                EntityRaidManager.startEntityRaid(colony, firstTrigger);
            } else if (TaxConfig.isEntityRaidDebugEnabled() && TaxConfig.getEntityRaidDebugLevel() >= 3) {
                LOGGER.debug("[EntityRaid-Event] Colony '{}' count={} (threshold={}), no raid.", (Object)colony.getName(), (Object)eligibleCount, (Object)threshold);
            }
        });
    }
}

