/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.abandon.ColonyClaimingRaidManager;
import net.machiavelli.minecolonytax.integration.SDMShopIntegration;
import net.machiavelli.minecolonytax.raid.RaidManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PvPKillEconomyHandler {
    private static final Logger LOGGER = LogManager.getLogger(PvPKillEconomyHandler.class);

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        double raidPenaltyMultiplier;
        Entity entity;
        if (!((Boolean)TaxConfig.ENABLE_PVP_KILL_ECONOMY.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer victim = (ServerPlayer)livingEntity;
        DamageSource damageSource = event.getSource();
        if (damageSource == null || !((entity = damageSource.m_7639_()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer killer = (ServerPlayer)entity;
        if (victim.m_20148_().equals(killer.m_20148_())) {
            return;
        }
        boolean isRaidRelated = PvPKillEconomyHandler.checkIfRaidRelated(victim, killer);
        double rewardPercentage = (Double)TaxConfig.PVP_KILL_REWARD_PERCENTAGE.get();
        if (isRaidRelated && (raidPenaltyMultiplier = ((Double)TaxConfig.RAID_PENALTY_PERCENTAGE.get()).doubleValue()) > 0.0) {
            rewardPercentage = Math.max(rewardPercentage, raidPenaltyMultiplier);
            LOGGER.info("Applying enhanced raid death penalty: {}% (base: {}%, raid penalty: {}%)", (Object)(rewardPercentage * 100.0), (Object)((Double)TaxConfig.PVP_KILL_REWARD_PERCENTAGE.get() * 100.0), (Object)(raidPenaltyMultiplier * 100.0));
        }
        if (rewardPercentage <= 0.0) {
            return;
        }
        if (TaxConfig.isSDMShopConversionEnabled()) {
            PvPKillEconomyHandler.handleSDMShopTransfer(victim, killer, rewardPercentage, isRaidRelated);
        } else {
            PvPKillEconomyHandler.handleItemTransfer(victim, killer, rewardPercentage, isRaidRelated);
        }
    }

    private static boolean checkIfRaidRelated(ServerPlayer victim, ServerPlayer killer) {
        if (RaidManager.getActiveRaidForPlayer(victim.m_20148_()) != null) {
            LOGGER.debug("Victim {} is an active raider - raid-related death", (Object)victim.m_7755_().getString());
            return true;
        }
        for (int colonyId : ColonyClaimingRaidManager.getActiveClaimingRaidIds()) {
            if (!ColonyClaimingRaidManager.isPlayerInClaimingRaid(victim.m_20148_(), colonyId)) continue;
            LOGGER.debug("Victim {} is in an active claiming raid - raid-related death", (Object)victim.m_7755_().getString());
            return true;
        }
        if (RaidManager.getActiveRaidForPlayer(killer.m_20148_()) != null) {
            LOGGER.debug("Killer {} killed a raider {} - raid-related death", (Object)killer.m_7755_().getString(), (Object)victim.m_7755_().getString());
            return true;
        }
        return false;
    }

    private static void handleSDMShopTransfer(ServerPlayer victim, ServerPlayer killer, double percentage, boolean isRaidRelated) {
        if (!SDMShopIntegration.isAvailable()) {
            LOGGER.warn("SDMShop integration enabled but SDMShop mod not available for PvP kill reward");
            return;
        }
        try {
            long victimBalance = SDMShopIntegration.getMoney(victim);
            if (victimBalance <= 0L) {
                killer.m_213846_((Component)Component.m_237113_((String)("PvP Kill: " + victim.m_7755_().getString() + " had no money to transfer.")).m_130940_(ChatFormatting.GRAY));
                return;
            }
            long transferAmount = Math.max(1L, (long)((double)victimBalance * percentage));
            long killerBalance = SDMShopIntegration.getMoney(killer);
            if (SDMShopIntegration.setMoney(victim, victimBalance - transferAmount) && SDMShopIntegration.setMoney(killer, killerBalance + transferAmount)) {
                String deathType = isRaidRelated ? "Raid Death" : "PvP Death";
                String killType = isRaidRelated ? "Raid Defense" : "PvP Kill";
                victim.m_213846_((Component)Component.m_237113_((String)(deathType + ": Lost $" + transferAmount + " to " + killer.m_7755_().getString())).m_130940_(ChatFormatting.RED));
                killer.m_213846_((Component)Component.m_237113_((String)(killType + ": Earned $" + transferAmount + " from " + victim.m_7755_().getString())).m_130940_(ChatFormatting.GREEN));
                LOGGER.info("{} economy: {} transferred ${} from {} to {}", (Object)(isRaidRelated ? "Raid" : "PvP"), (Object)(percentage * 100.0 + "%"), (Object)transferAmount, (Object)victim.m_7755_().getString(), (Object)killer.m_7755_().getString());
            } else {
                LOGGER.error("Failed to transfer ${} from {} to {} via SDMShop API", (Object)transferAmount, (Object)victim.m_7755_().getString(), (Object)killer.m_7755_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in SDMShop PvP kill transfer: {}", (Object)e.getMessage());
        }
    }

    private static void handleItemTransfer(ServerPlayer victim, ServerPlayer killer, double percentage, boolean isRaidRelated) {
        try {
            int transferAmount;
            String currencyItemName = TaxConfig.getCurrencyItemName();
            Item currencyItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(currencyItemName));
            if (currencyItem == null) {
                LOGGER.warn("Currency item '{}' not found for PvP kill reward", (Object)currencyItemName);
                return;
            }
            int victimCurrencyCount = 0;
            for (ItemStack stack : victim.m_150109_().f_35974_) {
                if (stack.m_41720_() != currencyItem) continue;
                victimCurrencyCount += stack.m_41613_();
            }
            if (victimCurrencyCount <= 0) {
                String killType = isRaidRelated ? "Raid Defense" : "PvP Kill";
                killer.m_213846_((Component)Component.m_237113_((String)(killType + ": " + victim.m_7755_().getString() + " had no " + currencyItemName + " to transfer.")).m_130940_(ChatFormatting.GRAY));
                return;
            }
            int remainingToRemove = transferAmount = Math.max(1, (int)((double)victimCurrencyCount * percentage));
            for (int i = 0; i < victim.m_150109_().f_35974_.size() && remainingToRemove > 0; ++i) {
                ItemStack stack = (ItemStack)victim.m_150109_().f_35974_.get(i);
                if (stack.m_41720_() != currencyItem) continue;
                int toRemove = Math.min(remainingToRemove, stack.m_41613_());
                stack.m_41774_(toRemove);
                remainingToRemove -= toRemove;
            }
            ItemStack rewardStack = new ItemStack((ItemLike)currencyItem, transferAmount);
            boolean added = killer.m_150109_().m_36054_(rewardStack);
            if (!added) {
                killer.m_36176_(rewardStack, false);
            }
            String deathType = isRaidRelated ? "Raid Death" : "PvP Death";
            String killType = isRaidRelated ? "Raid Defense" : "PvP Kill";
            victim.m_213846_((Component)Component.m_237113_((String)(deathType + ": Lost " + transferAmount + " " + currencyItemName + " to " + killer.m_7755_().getString())).m_130940_(ChatFormatting.RED));
            killer.m_213846_((Component)Component.m_237113_((String)(killType + ": Earned " + transferAmount + " " + currencyItemName + " from " + victim.m_7755_().getString())).m_130940_(ChatFormatting.GREEN));
            LOGGER.info("{} economy: {} transferred {} {} from {} to {}", (Object)(isRaidRelated ? "Raid" : "PvP"), (Object)(percentage * 100.0 + "%"), (Object)transferAmount, (Object)currencyItemName, (Object)victim.m_7755_().getString(), (Object)killer.m_7755_().getString());
        }
        catch (Exception e) {
            LOGGER.error("Error in item-based PvP kill transfer: {}", (Object)e.getMessage());
        }
    }
}

