/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.entity.mobs.EntityMercenary;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.abandon.ColonyClaimingRaidManager;
import net.machiavelli.minecolonytax.data.WarData;
import net.machiavelli.minecolonytax.integration.SDMShopIntegration;
import net.machiavelli.minecolonytax.militia.CitizenMilitiaManager;
import net.machiavelli.minecolonytax.raid.ActiveRaidData;
import net.machiavelli.minecolonytax.raid.RaidManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber
public class RaidKillTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaidKillTracker.class);

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractEntityCitizen) {
            AbstractEntityCitizen citizen = (AbstractEntityCitizen)livingEntity;
            RaidKillTracker.handleEntityDeath(citizen, event.getSource());
        } else {
            livingEntity = event.getEntity();
            if (livingEntity instanceof EntityMercenary) {
                EntityMercenary mercenary = (EntityMercenary)livingEntity;
                RaidKillTracker.handleMercenaryDeath(mercenary, event.getSource());
            } else {
                return;
            }
        }
    }

    private static void handleEntityDeath(AbstractEntityCitizen citizen, DamageSource damageSource) {
        IBuilding workBuilding;
        String buildingName;
        boolean wasInOriginalSnapshot;
        ICitizenData citizenData;
        ServerPlayer player;
        Entity entity = damageSource.m_7639_();
        ServerPlayer killer = entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null;
        IColony colony = IColonyManager.getInstance().getColonyByWorld(citizen.getCitizenColonyHandler().getColonyId(), citizen.m_9236_());
        if (colony == null) {
            return;
        }
        boolean isColonyUnderRaid = RaidManager.isColonyUnderRaid(colony.getID());
        boolean isRegularRaid = false;
        boolean isClaimingRaid = false;
        boolean isWar = false;
        if (killer != null) {
            ActiveRaidData raidData = RaidManager.getActiveRaidForPlayer(killer.m_20148_());
            isRegularRaid = raidData != null && raidData.isActive() && raidData.getColony().getID() == colony.getID();
            isClaimingRaid = ColonyClaimingRaidManager.isPlayerInClaimingRaid(killer.m_20148_(), colony.getID());
            WarData warData = WarSystem.ACTIVE_WARS.get(colony.getID());
            isWar = warData != null && RaidKillTracker.isPlayerInWar(killer.m_20148_(), warData);
        } else if (isColonyUnderRaid) {
            isRegularRaid = true;
        }
        if (!(isRegularRaid || isClaimingRaid || isWar)) {
            return;
        }
        if (isClaimingRaid) {
            LOGGER.info("CLAIMING RAID DEATH DETECTED: {} died in colony {} (killer: {})", new Object[]{citizen.getCitizenData() != null ? citizen.getCitizenData().getName() : "Unknown", colony.getName(), killer != null ? killer.m_7755_().getString() : "environmental"});
            RaidKillTracker.handleClaimingRaidDeath(citizen, colony, killer);
            return;
        }
        String combatType = isClaimingRaid ? "claiming" : (isWar ? "war" : "regular");
        ActiveRaidData raidData = null;
        WarData warData = null;
        if (isRegularRaid && killer != null) {
            raidData = RaidManager.getActiveRaidForPlayer(killer.m_20148_());
        }
        if (isWar) {
            warData = WarSystem.ACTIVE_WARS.get(colony.getID());
        }
        if ((citizenData = citizen.getCitizenData()) == null) {
            return;
        }
        boolean isGuard = false;
        boolean isMilitia = false;
        ActiveRaidData activeRaid = RaidManager.getActiveRaidForColony(colony.getID());
        if (activeRaid != null && (wasInOriginalSnapshot = activeRaid.isOriginalGuard(citizenData.getId()))) {
            isGuard = true;
            LOGGER.info("GUARD DETECTED via original snapshot - {} was an original guard (ID: {})", (Object)citizenData.getName(), (Object)citizenData.getId());
        }
        IJob citizenJob = null;
        if (!isGuard && (citizenJob = citizenData.getJob()) != null && citizenJob.isGuard()) {
            isGuard = true;
            LOGGER.info("GUARD DETECTED via job check - {} is a guard", (Object)citizenData.getName());
        }
        if (!isGuard && citizenJob == null && citizenData.getWorkBuilding() != null && ((buildingName = (workBuilding = citizenData.getWorkBuilding()).getBuildingDisplayName().toLowerCase()).contains("guard") || buildingName.contains("barracks") || buildingName.contains("archery") || buildingName.contains("combat"))) {
            isGuard = true;
            LOGGER.info("GUARD DETECTED via building (job cleared) - {} worked at {}", (Object)citizenData.getName(), (Object)workBuilding.getBuildingDisplayName());
        }
        if (!isGuard && citizenData.getWorkBuilding() != null && ((buildingName = (workBuilding = citizenData.getWorkBuilding()).getBuildingDisplayName().toLowerCase()).contains("guard") || buildingName.contains("barracks") || buildingName.contains("archery") || buildingName.contains("combat"))) {
            isGuard = true;
            LOGGER.info("GUARD DETECTED via building assignment - {} works at {}", (Object)citizenData.getName(), (Object)workBuilding.getBuildingDisplayName());
        }
        if (!isGuard && (isMilitia = CitizenMilitiaManager.getInstance().isMilitiaMember(colony.getID(), citizenData.getId()))) {
            LOGGER.info("MILITIA DETECTED - {} is a militia member", (Object)citizenData.getName());
        }
        if (!isMilitia && !isGuard) {
            LOGGER.debug("Citizen {} detection check - Job: {}, Building: {}, trying count comparison", new Object[]{citizenData.getName(), citizenJob != null ? citizenJob.getJobRegistryEntry().toString() : "null", citizenData.getWorkBuilding() != null ? citizenData.getWorkBuilding().getBuildingDisplayName() : "none"});
        }
        if (!isGuard && !isMilitia) {
            int defendersBefore = CitizenMilitiaManager.getInstance().getTotalDefenders(colony.getID());
            long currentGuardsAlive = colony.getCitizenManager().getCitizens().stream().filter(c -> c.getId() != citizenData.getId()).filter(c -> {
                IJob job = c.getJob();
                if (job != null && job.isGuard()) {
                    return true;
                }
                if (c.getWorkBuilding() != null) {
                    String buildingName = c.getWorkBuilding().getBuildingDisplayName().toLowerCase();
                    return buildingName.contains("guard") || buildingName.contains("barracks") || buildingName.contains("archery") || buildingName.contains("combat");
                }
                return false;
            }).count();
            int actualMilitia = CitizenMilitiaManager.getInstance().getMilitiaMembers(colony.getID()).size();
            int defendersAfter = (int)currentGuardsAlive + actualMilitia;
            LOGGER.debug("COUNT COMPARISON - {} killed, before: {}, after: {} (guards: {}, militia: {})", new Object[]{citizenData.getName(), defendersBefore, defendersAfter, currentGuardsAlive, actualMilitia});
            if (defendersAfter < defendersBefore) {
                isGuard = true;
                LOGGER.info("GUARD DETECTED via count comparison - {} was a guard (count: {} -> {})", new Object[]{citizenData.getName(), defendersBefore, defendersAfter});
            } else if (defendersBefore > 0 && defendersAfter >= defendersBefore) {
                LOGGER.warn("COUNT MISMATCH - Expected defender count to decrease but didn't. Assuming {} was a guard", (Object)citizenData.getName());
                isGuard = true;
            }
        }
        if (!isGuard && !isMilitia) {
            LOGGER.debug("KILL TRACKER SKIP - {} was not a defender", (Object)citizenData.getName());
            return;
        }
        int defendersBefore = CitizenMilitiaManager.getInstance().getTotalDefenders(colony.getID());
        int defendersAfter = defendersBefore - 1;
        String defenderType = isMilitia ? "militia" : "guard";
        int actualGuards = (int)colony.getCitizenManager().getCitizens().stream().filter(c -> c.getId() != citizenData.getId()).filter(c -> c.getJob() != null && c.getJob().isGuard()).count();
        int actualMilitia = CitizenMilitiaManager.getInstance().getMilitiaMembers(colony.getID()).size();
        if (isMilitia) {
            --actualMilitia;
        }
        String killerName = killer != null ? killer.m_7755_().getString() : "environmental damage";
        LOGGER.info("KILL DETECTED - {} {} killed by {} (defenders: {} -> {})", new Object[]{defenderType, citizenData.getName(), killerName, defendersBefore, defendersAfter});
        CitizenMilitiaManager.getInstance().recordDefenderDeath(colony, isGuard);
        CitizenMilitiaManager.getInstance().setTotalDefenders(colony.getID(), defendersAfter);
        if (activeRaid != null) {
            boolean wasOriginalGuard = activeRaid.markGuardKilled(citizenData.getId());
            if (wasOriginalGuard) {
                LOGGER.info("ID-TRACK: Marked original guard '{}' (ID {}) as killed. {}/{} killed.", new Object[]{citizenData.getName(), citizenData.getId(), activeRaid.getKilledGuardCount(), activeRaid.getOriginalGuardCount()});
            } else if (isGuard) {
                LOGGER.info("ID-TRACK: '{}' (ID {}) was a guard but not in original snapshot (auto-promotion). Ignoring for victory.", (Object)citizenData.getName(), (Object)citizenData.getId());
            }
        }
        int remainingDefenders = defendersAfter;
        double currentStealPercentage = CitizenMilitiaManager.getInstance().calculateTaxPercentage(colony.getID());
        int defendersKilled = CitizenMilitiaManager.getInstance().getDefendersKilled(colony.getID());
        LOGGER.info("KILL PROGRESS - Guards: {}, Militia: {}, Total Remaining: {}, Kills: {}", new Object[]{actualGuards, actualMilitia, remainingDefenders, defendersKilled});
        if (isGuard) {
            LOGGER.info("REMAINING GUARDS in colony after kill:");
            colony.getCitizenManager().getCitizens().stream().filter(c -> c.getId() != citizenData.getId()).filter(c -> c.getJob() != null && c.getJob().isGuard()).forEach(c -> LOGGER.info("  - Guard: {} (ID: {}, Job: {})", new Object[]{c.getName(), c.getId(), c.getJob().getJobRegistryEntry().toString()}));
        }
        if ("regular".equals(combatType) && activeRaid != null) {
            int originalGuardsKilled = activeRaid.getKilledGuardCount();
            int originalGuardCount = activeRaid.getOriginalGuardCount();
            LOGGER.info("VICTORY CHECK - Original guards killed: {}/{} (ID-based tracking)", (Object)originalGuardsKilled, (Object)originalGuardCount);
            if (originalGuardsKilled >= originalGuardCount && originalGuardCount > 0 && raidData != null) {
                ServerPlayer raidingPlayer;
                RaidManager.endActiveRaid(raidData, "All guards eliminated - Raiders victorious!");
                UUID raidingPlayerId = raidData.getRaider();
                if (raidingPlayerId != null && (raidingPlayer = RaidManager.getServerPlayerById(raidingPlayerId)) != null) {
                    raidingPlayer.m_213846_((Component)Component.m_237113_((String)"\ud83c\udfc6 RAID VICTORY! \ud83c\udfc6").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\nAll guards eliminated! Raid completed successfully!").m_130940_(ChatFormatting.GREEN)));
                }
                return;
            }
        }
        if ("regular".equals(combatType)) {
            if (raidData != null) {
                RaidManager.updateRaidBossBar(raidData);
            }
        } else if ("war".equals(combatType) && warData != null) {
            boolean isDefenderGuard = warData.getColony().getID() == colony.getID();
            WarSystem.handleGuardKilled(warData, isDefenderGuard);
        }
        int guardsKilled = CitizenMilitiaManager.getInstance().getGuardsKilledCount(colony.getID());
        int totalGuards = CitizenMilitiaManager.getInstance().getTotalGuardsCount(colony.getID());
        int guardsRemaining = totalGuards - guardsKilled;
        if (killer != null && "regular".equals(combatType) && raidData != null && killer.m_20148_().equals(raidData.getRaider())) {
            MutableComponent killMessage = Component.m_237113_((String)("\u2694 " + defenderType.toUpperCase() + " ELIMINATED \u2694")).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"Killed: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)citizenData.getName()).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)(" (" + defenderType + ")")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"\n").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"Guards Progress: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)(guardsKilled + "/" + totalGuards + " guards eliminated")).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)(" (" + guardsRemaining + " guards remaining)")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"\n").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"Tax steal progress: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)String.format("%.1f%%", currentStealPercentage * 100.0)).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
            killer.m_213846_((Component)killMessage);
        }
        String killedByText = killer != null ? " was killed by " + killer.m_7755_().getString() : " died during the raid";
        MutableComponent defenseMessage = Component.m_237113_((String)"\ud83d\udee1 DEFENDER FALLEN \ud83d\udee1").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)citizenData.getName()).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)(" (" + defenderType + ")")).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)killedByText).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\n").m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"Remaining defenders: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)String.valueOf(remainingDefenders)).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        colony.getPermissions().getPlayers().forEach((arg_0, arg_1) -> RaidKillTracker.lambda$handleEntityDeath$7(killer, colony, (Component)defenseMessage, arg_0, arg_1));
        if ("claiming".equals(combatType) && killer != null) {
            int colonyTax = TaxManager.getStoredTaxForColony(colony);
            int originalDefenders = defendersBefore;
            int taxAwarded = 0;
            if (originalDefenders > 0) {
                if (colonyTax > 0) {
                    double taxPerKill = currentStealPercentage / (double)originalDefenders;
                    taxAwarded = Math.max(1, (int)((double)colonyTax * taxPerKill));
                } else {
                    int debtLimit = TaxConfig.getDebtLimit();
                    if (debtLimit > 0) {
                        int taxStealPerGuard = TaxConfig.getTaxStealPerGuard();
                        taxAwarded = Math.max(10, taxStealPerGuard);
                    }
                }
            }
            if (taxAwarded > 0) {
                try {
                    TaxManager.payTaxDebt(colony, -taxAwarded);
                    if (TaxConfig.isSDMShopConversionEnabled()) {
                        if (SDMShopIntegration.isAvailable()) {
                            long currentBalance = SDMShopIntegration.getMoney(killer);
                            SDMShopIntegration.setMoney(killer, currentBalance + (long)taxAwarded);
                            MutableComponent taxMessage = Component.m_237113_((String)"\ud83d\udcb0 TAX STOLEN: ").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("+" + taxAwarded + " coins")).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)" (added to your account)").m_130940_(ChatFormatting.GREEN));
                            killer.m_213846_((Component)taxMessage);
                        }
                    } else {
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(TaxConfig.getCurrencyItemName()));
                        if (item != null) {
                            ItemStack itemStack = new ItemStack((ItemLike)item, taxAwarded);
                            boolean added = killer.m_150109_().m_36054_(itemStack);
                            if (!added) {
                                killer.m_36176_(itemStack, false);
                            }
                            MutableComponent taxMessage = Component.m_237113_((String)"\ud83d\udcb0 TAX STOLEN: ").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("+" + taxAwarded + " " + item.m_41466_().getString())).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)(added ? " (added to inventory)" : " (dropped nearby)")).m_130940_(ChatFormatting.GREEN));
                            killer.m_213846_((Component)taxMessage);
                        }
                    }
                    LOGGER.info("CLAIMING RAID TAX: {} stole {} tax from colony {} by killing {}", new Object[]{killer.m_7755_().getString(), taxAwarded, colony.getName(), citizenData.getName()});
                }
                catch (Exception e) {
                    LOGGER.error("Failed to award tax for claiming raid kill", (Throwable)e);
                }
            } else {
                MutableComponent noTaxMessage = Component.m_237113_((String)"\u26a0\ufe0f No tax to steal from this colony!").m_130940_(ChatFormatting.YELLOW);
                killer.m_213846_((Component)noTaxMessage);
            }
        }
    }

    private static void handleMercenaryDeath(EntityMercenary mercenary, DamageSource damageSource) {
        ServerPlayer player;
        Entity entity = damageSource.m_7639_();
        ServerPlayer killer = entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null;
        String killerName = killer != null ? killer.m_7755_().getString() : "environmental damage";
        for (ColonyClaimingRaidManager.ClaimingRaidData raidData : ColonyClaimingRaidManager.getActiveClaimingRaidIds().stream().map(ColonyClaimingRaidManager::getClaimingRaid).filter(Objects::nonNull).collect(Collectors.toList())) {
            if (!raidData.spawnedMercenaries.contains(mercenary)) continue;
            raidData.spawnedMercenaries.remove(mercenary);
            IColony colony = RaidKillTracker.getColonyById(raidData.colonyId);
            if (colony == null) break;
            LOGGER.info("CLAIMING RAID - Mercenary killed by {} in colony {}", (Object)killerName, (Object)colony.getName());
            if (killer != null && killer.m_20148_().equals(raidData.claimingPlayerId)) {
                MutableComponent killMessage = Component.m_237113_((String)"\u2694 MERCENARY ELIMINATED \u2694").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\nKilled: Mercenary").m_130940_(ChatFormatting.YELLOW));
                killer.m_213846_((Component)killMessage);
            }
            RaidKillTracker.checkClaimingRaidVictory(raidData, colony, killerName);
            break;
        }
    }

    private static void checkClaimingRaidVictory(ColonyClaimingRaidManager.ClaimingRaidData raidData, IColony colony, String killerName) {
        int remainingCitizens = 0;
        int remainingMercenaries = 0;
        for (Integer citizenId : raidData.hostileCitizens) {
            ICitizenData remainingCitizen = colony.getCitizenManager().getCivilian(citizenId.intValue());
            if (remainingCitizen == null || !remainingCitizen.getEntity().isPresent() || !((AbstractEntityCitizen)remainingCitizen.getEntity().get()).m_6084_()) continue;
            ++remainingCitizens;
        }
        for (Entity mercenary : raidData.spawnedMercenaries) {
            if (!mercenary.m_6084_()) continue;
            ++remainingMercenaries;
        }
        int totalRemaining = remainingCitizens + remainingMercenaries;
        LOGGER.info("CLAIMING RAID PROGRESS - {} defenders remaining ({} citizens, {} mercenaries) in colony {}", new Object[]{totalRemaining, remainingCitizens, remainingMercenaries, colony.getName()});
        if (totalRemaining == 0) {
            LOGGER.info("CLAIMING RAID VICTORY - All defenders eliminated in colony {} by {}", (Object)colony.getName(), (Object)killerName);
            ColonyClaimingRaidManager.completeClaimingRaid(raidData, true);
        }
    }

    private static IColony getColonyById(int colonyId) {
        try {
            return IMinecoloniesAPI.getInstance().getColonyManager().getColonyByWorld(colonyId, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void handleClaimingRaidDeath(AbstractEntityCitizen citizen, IColony colony, ServerPlayer killer) {
        ICitizenData citizenData = citizen.getCitizenData();
        if (citizenData == null) {
            LOGGER.warn("Claiming raid death - citizen data is null");
            return;
        }
        ColonyClaimingRaidManager.ClaimingRaidData raidData = ColonyClaimingRaidManager.getClaimingRaid(colony.getID());
        if (raidData == null) {
            LOGGER.warn("Claiming raid death detected but no raid data found for colony {}", (Object)colony.getID());
            return;
        }
        LOGGER.info("Processing claiming raid death: {} (ID: {}) in colony {}", new Object[]{citizenData.getName(), citizenData.getId(), colony.getName()});
        String killerName = killer != null ? killer.m_7755_().getString() : "environmental damage";
        boolean wasHostileCitizen = raidData.hostileCitizens.contains(citizenData.getId());
        if (wasHostileCitizen) {
            raidData.hostileCitizens.remove(citizenData.getId());
            LOGGER.info("CLAIMING RAID - Hostile citizen {} killed by {} in colony {}", new Object[]{citizenData.getName(), killerName, colony.getName()});
            if (killer != null && killer.m_20148_().equals(raidData.claimingPlayerId)) {
                MutableComponent killMessage = Component.m_237113_((String)"\u2694 DEFENDER ELIMINATED \u2694").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\nKilled: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)citizenData.getName()).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" (militia)").m_130940_(ChatFormatting.GRAY));
                killer.m_213846_((Component)killMessage);
            }
            RaidKillTracker.checkClaimingRaidVictory(raidData, colony, killerName);
            ColonyClaimingRaidManager.forceCheckVictoryCondition(colony.getID());
        } else {
            LOGGER.debug("CLAIMING RAID - Non-defender citizen {} died in colony {} (not part of hostile militia)", (Object)citizenData.getName(), (Object)colony.getName());
        }
    }

    private static boolean isPlayerInWar(UUID playerUUID, WarData warData) {
        if (playerUUID == null || warData == null) {
            return false;
        }
        if (warData.getAttackerLives().containsKey(playerUUID)) {
            return true;
        }
        return warData.getDefenderLives().containsKey(playerUUID);
    }

    private static /* synthetic */ void lambda$handleEntityDeath$7(ServerPlayer killer, IColony colony, Component defenseMessage, UUID uuid, ColonyPlayer data) {
        ServerPlayer defender;
        if (!(killer != null && uuid.equals(killer.m_20148_()) || (defender = (ServerPlayer)colony.getWorld().m_46003_(uuid)) == null)) {
            defender.m_213846_(defenseMessage);
        }
    }
}

