/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.machiavelli.minecolonytax.raid.ActiveRaidData;
import net.machiavelli.minecolonytax.raid.RaidManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="minecolonytax", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RaidLoginNotifier {
    private static final List<ActiveRaidData> completedRaids = Collections.synchronizedList(new ArrayList());
    private static final Map<UUID, Set<UUID>> notifiedRaidsByPlayer = new HashMap<UUID, Set<UUID>>();

    public static void recordCompletedRaid(ActiveRaidData raid) {
        completedRaids.add(raid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        UUID playerUUID = player.m_20148_();
        notifiedRaidsByPlayer.computeIfAbsent(playerUUID, k -> new HashSet());
        Set<UUID> notified = notifiedRaidsByPlayer.get(playerUUID);
        for (ActiveRaidData raid : RaidManager.getActiveRaids().values()) {
            if (RaidLoginNotifier.isPlayerOfficerOrOwner(player, raid.getColony().getPermissions())) {
                RaidLoginNotifier.notifyPlayer(player, raid, true);
                UUID identifier = UUID.nameUUIDFromBytes((raid.getColony().getID() + ":" + raid.getRaider()).getBytes());
                notified.add(identifier);
                continue;
            }
            RaidLoginNotifier.notifyIfRelevant(player, raid, notified, true);
        }
        List<ActiveRaidData> list = completedRaids;
        synchronized (list) {
            Iterator<ActiveRaidData> it = completedRaids.iterator();
            while (it.hasNext()) {
                ActiveRaidData raid = it.next();
                boolean wasRelevant = RaidLoginNotifier.notifyIfRelevant(player, raid, notified, false);
                if (!wasRelevant || !raid.getColony().getPermissions().getOwner().equals(playerUUID)) continue;
                it.remove();
            }
        }
    }

    private static boolean isPlayerOfficerOrOwner(ServerPlayer player, IPermissions perms) {
        UUID playerUUID = player.m_20148_();
        boolean isOwner = perms.getOwner().equals(playerUUID);
        boolean isOfficer = perms.getPlayersByRank(perms.getRankOfficer()).stream().anyMatch(cp -> cp.getID().equals(playerUUID));
        return isOwner || isOfficer;
    }

    private static void notifyPlayer(ServerPlayer player, ActiveRaidData raid, boolean ongoing) {
        String raiderName = RaidLoginNotifier.getRaiderName(raid.getRaider());
        String colonyName = raid.getColony().getName();
        if (ongoing) {
            player.m_213846_((Component)Component.m_237113_((String)("You are being Raided! " + colonyName + " by " + raiderName)).m_130940_(ChatFormatting.RED));
        } else {
            String baseMessage = "You have been Raided " + colonyName + " by " + raiderName + " - Check your tax balance with /wnt checktax for any defense rewards!";
            player.m_213846_((Component)Component.m_237113_((String)baseMessage).m_130940_(ChatFormatting.GOLD));
        }
        String headerJson = "{\"text\":\"RAID!\",\"color\":\"red\",\"bold\":true}";
        String subtitleJson = "{\"text\":\"" + colonyName + " by " + raiderName + "\",\"color\":\"yellow\"}";
        if (player.m_20194_() != null) {
            String playerName = player.m_7755_().getString();
            player.m_20194_().m_129892_().m_230957_(player.m_20203_().m_81324_(), "title " + playerName + " title " + headerJson);
            player.m_20194_().m_129892_().m_230957_(player.m_20203_().m_81324_(), "title " + playerName + " subtitle " + subtitleJson);
        }
    }

    private static boolean notifyIfRelevant(ServerPlayer player, ActiveRaidData raid, Set<UUID> notified, boolean ongoing) {
        IPermissions perms = raid.getColony().getPermissions();
        Set notifySet = perms.getPlayersByRank(perms.getRankOfficer()).stream().map(ColonyPlayer::getID).collect(Collectors.toSet());
        notifySet.add(perms.getOwner());
        UUID identifier = UUID.nameUUIDFromBytes((raid.getColony().getID() + ":" + raid.getRaider()).getBytes());
        if (notifySet.contains(player.m_20148_()) && !notified.contains(identifier)) {
            RaidLoginNotifier.notifyPlayer(player, raid, ongoing);
            notified.add(identifier);
            return true;
        }
        return false;
    }

    private static String getRaiderName(UUID raiderUUID) {
        ServerPlayer raider = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(raiderUUID);
        return raider != null ? raider.m_7755_().getString() : "an unknown raider";
    }
}

