/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import com.minecolonies.api.blocks.ModBlocks;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.machiavelli.minecolonytax.TaxConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class RecipeDisableClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecipeDisableClient.class);
    private static final Set<Item> HUT_BLOCK_ITEMS = new HashSet<Item>();

    private static void add(Object blockObj) {
        Block block;
        Item item;
        if (blockObj instanceof Block && (item = (block = (Block)blockObj).m_5456_()) != null) {
            HUT_BLOCK_ITEMS.add(item);
        }
    }

    @SubscribeEvent
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        if (!TaxConfig.isDisableHutRecipesEnabled()) {
            return;
        }
        try {
            RecipeManager manager = event.getRecipeManager();
            List craftingRecipes = manager.m_44013_(RecipeType.f_44107_);
            Set<ResourceLocation> toRemove = craftingRecipes.stream().filter(RecipeDisableClient::isHutOutput).map(Recipe::m_6423_).collect(Collectors.toSet());
            if (toRemove.isEmpty()) {
                return;
            }
            RecipeDisableClient.removeFromManager(manager, toRemove);
            LOGGER.info("RecipeDisabler(Client): Disabled {} MineColonies hut crafting recipes on client.", (Object)toRemove.size());
        }
        catch (Throwable t) {
            LOGGER.error("RecipeDisabler(Client): Failed to disable hut recipes on client.", t);
        }
    }

    private static boolean isHutOutput(Recipe<?> recipe) {
        try {
            ItemStack out = recipe.m_8043_(null);
            if (out.m_41619_()) {
                return false;
            }
            return HUT_BLOCK_ITEMS.contains(out.m_41720_());
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static void removeFromManager(RecipeManager manager, Set<ResourceLocation> toRemove) throws Exception {
        String[] recipesFieldNames = new String[]{"recipes", "byType", "f_44006_"};
        String[] byNameFieldNames = new String[]{"byName", "f_44007_"};
        Field recipesField = RecipeDisableClient.findField(manager.getClass(), recipesFieldNames);
        Field byNameField = RecipeDisableClient.findField(manager.getClass(), byNameFieldNames);
        if (recipesField == null || byNameField == null) {
            throw new IllegalStateException("RecipeManager fields not found (client)");
        }
        recipesField.setAccessible(true);
        byNameField.setAccessible(true);
        Map recipesByType = (Map)recipesField.get(manager);
        Map byName = (Map)byNameField.get(manager);
        Map craftingMap = (Map)recipesByType.get(RecipeType.f_44107_);
        if (craftingMap == null) {
            return;
        }
        for (ResourceLocation id : toRemove) {
            craftingMap.remove(id);
            byName.remove(id);
        }
    }

    private static Field findField(Class<?> clazz, String[] names) {
        for (String n : names) {
            try {
                return clazz.getDeclaredField(n);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        return null;
    }

    static {
        RecipeDisableClient.add(ModBlocks.blockHutAlchemist);
        RecipeDisableClient.add(ModBlocks.blockHutConcreteMixer);
        RecipeDisableClient.add(ModBlocks.blockHutFletcher);
        RecipeDisableClient.add(ModBlocks.blockHutLumberjack);
        RecipeDisableClient.add(ModBlocks.blockHutRabbitHutch);
        RecipeDisableClient.add(ModBlocks.blockHutShepherd);
        RecipeDisableClient.add(ModBlocks.blockHutSmeltery);
        RecipeDisableClient.add(ModBlocks.blockHutSwineHerder);
        RecipeDisableClient.add(ModBlocks.blockHutTownHall);
        RecipeDisableClient.add(ModBlocks.blockHutWareHouse);
        RecipeDisableClient.add(ModBlocks.blockHutBaker);
        RecipeDisableClient.add(ModBlocks.blockHutBlacksmith);
        RecipeDisableClient.add(ModBlocks.blockHutBuilder);
        RecipeDisableClient.add(ModBlocks.blockHutChickenHerder);
        RecipeDisableClient.add(ModBlocks.blockHutComposter);
        RecipeDisableClient.add(ModBlocks.blockHutCook);
        RecipeDisableClient.add(ModBlocks.blockHutCowboy);
        RecipeDisableClient.add(ModBlocks.blockHutCrusher);
        RecipeDisableClient.add(ModBlocks.blockHutDeliveryman);
        RecipeDisableClient.add(ModBlocks.blockHutDyer);
        RecipeDisableClient.add(ModBlocks.blockHutEnchanter);
        RecipeDisableClient.add(ModBlocks.blockHutFarmer);
        RecipeDisableClient.add(ModBlocks.blockHutFisherman);
        RecipeDisableClient.add(ModBlocks.blockHutFlorist);
        RecipeDisableClient.add(ModBlocks.blockHutGlassblower);
        RecipeDisableClient.add(ModBlocks.blockHutHospital);
        RecipeDisableClient.add(ModBlocks.blockHutLibrary);
        RecipeDisableClient.add(ModBlocks.blockHutMechanic);
        RecipeDisableClient.add(ModBlocks.blockHutMiner);
        RecipeDisableClient.add(ModBlocks.blockHutPlantation);
        RecipeDisableClient.add(ModBlocks.blockHutSawmill);
        RecipeDisableClient.add(ModBlocks.blockHutStonemason);
        RecipeDisableClient.add(ModBlocks.blockHutTavern);
        RecipeDisableClient.add(ModBlocks.blockHutNetherWorker);
        RecipeDisableClient.add(ModBlocks.blockHutGraveyard);
        RecipeDisableClient.add(ModBlocks.blockHutBeekeeper);
        RecipeDisableClient.add(ModBlocks.blockHutUniversity);
        RecipeDisableClient.add(ModBlocks.blockHutHome);
        RecipeDisableClient.add(ModBlocks.blockHutBarracks);
        RecipeDisableClient.add(ModBlocks.blockHutGuardTower);
        RecipeDisableClient.add(ModBlocks.blockHutBarracksTower);
        RecipeDisableClient.add(ModBlocks.blockHutArchery);
        RecipeDisableClient.add(ModBlocks.blockHutCombatAcademy);
    }
}

