/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import com.minecolonies.api.blocks.ModBlocks;
import java.util.HashSet;
import java.util.Set;
import net.machiavelli.minecolonytax.TaxConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber
public class RecipeDisableEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecipeDisableEventHandler.class);
    private static final Set<ResourceLocation> DISABLED_HUT_RECIPES = new HashSet<ResourceLocation>();

    private static void addHutBlock(Object block) {
        ResourceLocation blockId;
        if (block != null && (blockId = ForgeRegistries.BLOCKS.getKey((Object)((Block)block))) != null) {
            DISABLED_HUT_RECIPES.add(blockId);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        if (TaxConfig.isDisableHutRecipesEnabled()) {
            LOGGER.info("Recipe disabling is enabled - hut recipes for buildings with taxes/maintenance costs should be disabled");
            LOGGER.info("The following building hut recipes should be disabled:");
            for (ResourceLocation blockId : DISABLED_HUT_RECIPES) {
                LOGGER.info("  - {} (block: {})", (Object)blockId, (Object)blockId);
            }
        }
    }

    public static Set<ResourceLocation> getDisabledHutRecipes() {
        return new HashSet<ResourceLocation>(DISABLED_HUT_RECIPES);
    }

    public static boolean shouldDisableRecipe(ResourceLocation blockId) {
        return TaxConfig.isDisableHutRecipesEnabled() && DISABLED_HUT_RECIPES.contains(blockId);
    }

    static {
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutAlchemist);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutConcreteMixer);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutFletcher);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutLumberjack);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutRabbitHutch);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutShepherd);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutSmeltery);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutSwineHerder);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutTownHall);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutWareHouse);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutBaker);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutBlacksmith);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutBuilder);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutChickenHerder);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutComposter);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutCook);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutCowboy);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutCrusher);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutDeliveryman);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutDyer);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutEnchanter);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutFarmer);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutFisherman);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutFlorist);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutGlassblower);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutHospital);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutLibrary);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutMechanic);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutMiner);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutPlantation);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutSawmill);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutStonemason);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutTavern);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutNetherWorker);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutGraveyard);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutBeekeeper);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutUniversity);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutHome);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutBarracks);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutGuardTower);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutBarracksTower);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutArchery);
        RecipeDisableEventHandler.addHutBlock(ModBlocks.blockHutCombatAcademy);
    }
}

