/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import com.minecolonies.api.blocks.ModBlocks;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.machiavelli.minecolonytax.TaxConfig;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class RecipeDisableRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecipeDisableRuntime.class);
    private static final Set<ResourceLocation> HUT_BLOCK_IDS = new HashSet<ResourceLocation>();
    private static final Set<Item> HUT_BLOCK_ITEMS = new HashSet<Item>();

    private static void add(Object blockObj) {
        if (blockObj instanceof Block) {
            Item item;
            Block block = (Block)blockObj;
            ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
            if (id != null) {
                HUT_BLOCK_IDS.add(id);
            }
            if ((item = block.m_5456_()) != null) {
                HUT_BLOCK_ITEMS.add(item);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (!TaxConfig.isDisableHutRecipesEnabled()) {
            return;
        }
        RecipeDisableRuntime.disableHutRecipes(event.getServer());
    }

    private static void disableHutRecipes(MinecraftServer server) {
        try {
            RecipeManager manager = server.m_129894_();
            List craftingRecipes = manager.m_44013_(RecipeType.f_44107_);
            Set<ResourceLocation> toRemove = craftingRecipes.stream().filter(r -> RecipeDisableRuntime.isHutOutput(r, server)).map(Recipe::m_6423_).collect(Collectors.toSet());
            if (toRemove.isEmpty()) {
                LOGGER.info("RecipeDisabler: No hut crafting recipes found to remove (maybe already removed).");
                return;
            }
            RecipeDisableRuntime.removeFromManager(manager, toRemove);
            LOGGER.info("RecipeDisabler: Disabled {} MineColonies hut crafting recipes.", (Object)toRemove.size());
        }
        catch (Throwable t) {
            LOGGER.error("RecipeDisabler: Failed to disable hut recipes.", t);
        }
    }

    private static boolean isHutOutput(Recipe<?> recipe, MinecraftServer server) {
        try {
            ItemStack out = recipe.m_8043_((RegistryAccess)server.m_206579_());
            return !out.m_41619_() && HUT_BLOCK_ITEMS.contains(out.m_41720_());
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static void removeFromManager(RecipeManager manager, Set<ResourceLocation> toRemove) throws Exception {
        String[] recipesFieldNames = new String[]{"recipes", "byType", "f_44006_"};
        String[] byNameFieldNames = new String[]{"byName", "f_44007_"};
        Field recipesField = RecipeDisableRuntime.findField(manager.getClass(), recipesFieldNames);
        Field byNameField = RecipeDisableRuntime.findField(manager.getClass(), byNameFieldNames);
        if (recipesField == null || byNameField == null) {
            throw new IllegalStateException("RecipeManager fields not found (mappings mismatch)");
        }
        recipesField.setAccessible(true);
        byNameField.setAccessible(true);
        Map recipesByType = (Map)recipesField.get(manager);
        Map byName = (Map)byNameField.get(manager);
        Map craftingMap = (Map)recipesByType.get(RecipeType.f_44107_);
        if (craftingMap == null) {
            return;
        }
        for (ResourceLocation id : toRemove) {
            craftingMap.remove(id);
            byName.remove(id);
        }
    }

    private static Field findField(Class<?> clazz, String[] names) {
        for (String n : names) {
            try {
                return clazz.getDeclaredField(n);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        return null;
    }

    static {
        RecipeDisableRuntime.add(ModBlocks.blockHutAlchemist);
        RecipeDisableRuntime.add(ModBlocks.blockHutConcreteMixer);
        RecipeDisableRuntime.add(ModBlocks.blockHutFletcher);
        RecipeDisableRuntime.add(ModBlocks.blockHutLumberjack);
        RecipeDisableRuntime.add(ModBlocks.blockHutRabbitHutch);
        RecipeDisableRuntime.add(ModBlocks.blockHutShepherd);
        RecipeDisableRuntime.add(ModBlocks.blockHutSmeltery);
        RecipeDisableRuntime.add(ModBlocks.blockHutSwineHerder);
        RecipeDisableRuntime.add(ModBlocks.blockHutTownHall);
        RecipeDisableRuntime.add(ModBlocks.blockHutWareHouse);
        RecipeDisableRuntime.add(ModBlocks.blockHutBaker);
        RecipeDisableRuntime.add(ModBlocks.blockHutBlacksmith);
        RecipeDisableRuntime.add(ModBlocks.blockHutBuilder);
        RecipeDisableRuntime.add(ModBlocks.blockHutChickenHerder);
        RecipeDisableRuntime.add(ModBlocks.blockHutComposter);
        RecipeDisableRuntime.add(ModBlocks.blockHutCook);
        RecipeDisableRuntime.add(ModBlocks.blockHutCowboy);
        RecipeDisableRuntime.add(ModBlocks.blockHutCrusher);
        RecipeDisableRuntime.add(ModBlocks.blockHutDeliveryman);
        RecipeDisableRuntime.add(ModBlocks.blockHutDyer);
        RecipeDisableRuntime.add(ModBlocks.blockHutEnchanter);
        RecipeDisableRuntime.add(ModBlocks.blockHutFarmer);
        RecipeDisableRuntime.add(ModBlocks.blockHutFisherman);
        RecipeDisableRuntime.add(ModBlocks.blockHutFlorist);
        RecipeDisableRuntime.add(ModBlocks.blockHutGlassblower);
        RecipeDisableRuntime.add(ModBlocks.blockHutHospital);
        RecipeDisableRuntime.add(ModBlocks.blockHutLibrary);
        RecipeDisableRuntime.add(ModBlocks.blockHutMechanic);
        RecipeDisableRuntime.add(ModBlocks.blockHutMiner);
        RecipeDisableRuntime.add(ModBlocks.blockHutPlantation);
        RecipeDisableRuntime.add(ModBlocks.blockHutSawmill);
        RecipeDisableRuntime.add(ModBlocks.blockHutStonemason);
        RecipeDisableRuntime.add(ModBlocks.blockHutTavern);
        RecipeDisableRuntime.add(ModBlocks.blockHutNetherWorker);
        RecipeDisableRuntime.add(ModBlocks.blockHutGraveyard);
        RecipeDisableRuntime.add(ModBlocks.blockHutBeekeeper);
        RecipeDisableRuntime.add(ModBlocks.blockHutUniversity);
        RecipeDisableRuntime.add(ModBlocks.blockHutHome);
        RecipeDisableRuntime.add(ModBlocks.blockHutBarracks);
        RecipeDisableRuntime.add(ModBlocks.blockHutGuardTower);
        RecipeDisableRuntime.add(ModBlocks.blockHutBarracksTower);
        RecipeDisableRuntime.add(ModBlocks.blockHutArchery);
        RecipeDisableRuntime.add(ModBlocks.blockHutCombatAcademy);
    }
}

