/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import com.minecolonies.api.colony.IColony;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.ArrayList;
import java.util.UUID;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.data.WarData;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.sixik.sdmshoprework.SDMShopR;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WarEconomyHandler {
    private static final Logger LOGGER = LogManager.getLogger(WarEconomyHandler.class);

    public static long deductTeamBalanceWithReport(UUID teamID, double fraction) {
        long totalDeducted = 0L;
        ArrayList<UUID> losingPlayers = new ArrayList<UUID>();
        if (WarSystem.FTB_TEAMS_INSTALLED) {
            Team losingTeam = WarSystem.FTB_TEAM_MANAGER.getTeamByID(teamID).orElse(null);
            if (losingTeam != null) {
                losingPlayers.addAll(losingTeam.getMembers());
            } else {
                losingPlayers.add(teamID);
            }
        } else {
            for (WarData war : WarSystem.ACTIVE_WARS.values()) {
                if (teamID != null && teamID.equals(war.getAttackerTeamID())) {
                    losingPlayers.addAll(war.getAttackerLives().keySet());
                    continue;
                }
                if (teamID == null || !teamID.equals(war.getDefenderTeamID())) continue;
                losingPlayers.addAll(war.getDefenderLives().keySet());
            }
        }
        for (UUID loserUUID : losingPlayers) {
            long deducted;
            ServerPlayer loserPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(loserUUID);
            if (loserPlayer == null) continue;
            if (TaxConfig.isSDMShopConversionEnabled()) {
                long balance = SDMShopR.getMoney((Player)loserPlayer);
                deducted = (long)((double)balance * fraction);
                SDMShopR.setMoney((Player)loserPlayer, (long)(balance - deducted));
            } else {
                long invBalance = WarEconomyHandler.getInventoryCurrencyBalance(loserPlayer);
                deducted = (long)((double)invBalance * fraction);
                deducted = WarEconomyHandler.deductCurrencyFromInventory(loserPlayer, deducted);
            }
            totalDeducted += deducted;
            loserPlayer.m_213846_((Component)Component.m_237113_((String)("You lost " + deducted + " coins due to war reparations!")).m_130940_(ChatFormatting.RED));
        }
        return totalDeducted;
    }

    public static long transferTeamBalanceToSinglePlayer(UUID losingTeamID, UUID winnerUUID, double fraction) {
        long totalTransferred = 0L;
        ServerPlayer winnerPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(winnerUUID);
        if (TaxConfig.isSDMShopConversionEnabled()) {
            Team losingTeam = (Team)WarSystem.FTB_TEAM_MANAGER.getTeamByID(losingTeamID).orElseThrow();
            for (UUID loserUUID : losingTeam.getMembers()) {
                ServerPlayer loserPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(loserUUID);
                if (loserPlayer == null) continue;
                long balance = SDMShopR.getMoney((Player)loserPlayer);
                long lostAmount = (long)((double)balance * fraction);
                SDMShopR.setMoney((Player)loserPlayer, (long)(balance - lostAmount));
                totalTransferred += lostAmount;
                loserPlayer.m_213846_((Component)Component.m_237113_((String)("You lost " + lostAmount + " coins in reparations to " + (winnerPlayer != null ? winnerPlayer.m_7755_().getString() : "your enemy") + "!")).m_130940_(ChatFormatting.RED));
            }
            if (winnerPlayer != null && totalTransferred > 0L) {
                long winnerBalance = SDMShopR.getMoney((Player)winnerPlayer);
                SDMShopR.setMoney((Player)winnerPlayer, (long)(winnerBalance + totalTransferred));
                winnerPlayer.m_213846_((Component)Component.m_237113_((String)("You received " + totalTransferred + " coins in war reparations!")).m_130940_(ChatFormatting.GREEN));
            }
        } else {
            Team losingTeam = (Team)WarSystem.FTB_TEAM_MANAGER.getTeamByID(losingTeamID).orElseThrow();
            for (UUID loserUUID : losingTeam.getMembers()) {
                ServerPlayer loserPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(loserUUID);
                if (loserPlayer == null) continue;
                long invBalance = WarEconomyHandler.getInventoryCurrencyBalance(loserPlayer);
                long lostAmount = (long)((double)invBalance * fraction);
                long actuallyDeducted = WarEconomyHandler.deductCurrencyFromInventory(loserPlayer, lostAmount);
                totalTransferred += actuallyDeducted;
                loserPlayer.m_213846_((Component)Component.m_237113_((String)("You lost " + actuallyDeducted + " coins in reparations to " + (winnerPlayer != null ? winnerPlayer.m_7755_().getString() : "your enemy") + "!")).m_130940_(ChatFormatting.RED));
            }
            if (winnerPlayer != null && totalTransferred > 0L) {
                ItemStack coinStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(TaxConfig.getCurrencyItemName())), (int)totalTransferred);
                boolean added = winnerPlayer.m_150109_().m_36054_(coinStack);
                if (!added) {
                    winnerPlayer.m_36176_(coinStack, false);
                    LOGGER.debug("Winner's inventory was full, dropped {} items near them", (Object)totalTransferred);
                }
                winnerPlayer.m_213846_((Component)Component.m_237113_((String)("You received " + totalTransferred + " coins in war reparations!")).m_130940_(ChatFormatting.GREEN));
            }
        }
        return totalTransferred;
    }

    public static long getInventoryCurrencyBalance(ServerPlayer player) {
        long total = 0L;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ResourceLocation registryName;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || (registryName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())) == null || !registryName.toString().equals(TaxConfig.getCurrencyItemName())) continue;
            total += (long)stack.m_41613_();
        }
        return total;
    }

    public static long deductCurrencyFromInventory(ServerPlayer player, long amount) {
        long remaining = amount;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ResourceLocation registryName;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || (registryName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())) == null || !registryName.toString().equals(TaxConfig.getCurrencyItemName())) continue;
            int available = stack.m_41613_();
            if ((long)available >= remaining) {
                stack.m_41774_((int)remaining);
                return amount;
            }
            remaining -= (long)available;
            stack.m_41764_(0);
        }
        return amount - remaining;
    }

    public static long getTeamTotalBalance(UUID teamID) {
        long sum = 0L;
        if (TaxConfig.isSDMShopConversionEnabled()) {
            Team team = (Team)WarSystem.FTB_TEAM_MANAGER.getTeamByID(teamID).orElseThrow();
            for (UUID member : team.getMembers()) {
                ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(member);
                if (player == null) continue;
                sum += SDMShopR.getMoney((Player)player);
            }
        } else {
            Team team = (Team)WarSystem.FTB_TEAM_MANAGER.getTeamByID(teamID).orElseThrow();
            for (UUID member : team.getMembers()) {
                ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(member);
                if (player == null) continue;
                sum += WarEconomyHandler.getInventoryCurrencyBalance(player);
            }
        }
        return sum;
    }

    public static boolean payReparationsProportionally(UUID losingTeamID, UUID winnerUUID, long demandedAmount) {
        ServerPlayer winner;
        if (TaxConfig.isSDMShopConversionEnabled()) {
            Team losingTeam = (Team)WarSystem.FTB_TEAM_MANAGER.getTeamByID(losingTeamID).orElseThrow();
            long totalTransferred = 0L;
            ServerPlayer winner2 = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(winnerUUID);
            for (UUID member : losingTeam.getMembers()) {
                ServerPlayer loser = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(member);
                if (loser == null) continue;
                long balance = SDMShopR.getMoney((Player)loser);
                long take = (long)((double)balance * ((double)demandedAmount / (double)WarEconomyHandler.getTeamTotalBalance(losingTeamID)));
                SDMShopR.setMoney((Player)loser, (long)(balance - take));
                totalTransferred += take;
                loser.m_213846_((Component)Component.m_237113_((String)("You lost " + take + " coins in reparations!")).m_130940_(ChatFormatting.RED));
            }
            if (winner2 != null && totalTransferred > 0L) {
                long wb = SDMShopR.getMoney((Player)winner2);
                SDMShopR.setMoney((Player)winner2, (long)(wb + totalTransferred));
                winner2.m_213846_((Component)Component.m_237113_((String)("You received " + totalTransferred + " coins in reparations!")).m_130940_(ChatFormatting.GREEN));
            }
            return true;
        }
        IColony losingColony = null;
        for (WarData w : WarSystem.ACTIVE_WARS.values()) {
            if (losingTeamID.equals(w.getAttackerTeamID())) {
                losingColony = w.getAttackerColony();
                continue;
            }
            if (!losingTeamID.equals(w.getDefenderTeamID())) continue;
            losingColony = w.getColony();
        }
        long claimedFromColony = 0L;
        if (losingColony != null) {
            claimedFromColony = TaxManager.claimTax(losingColony, (int)demandedAmount);
        }
        long remaining = demandedAmount - claimedFromColony;
        long totalTaken = claimedFromColony;
        if (remaining > 0L && losingColony != null) {
            WarData war = WarSystem.ACTIVE_WARS.get(losingColony.getID());
            ArrayList members = new ArrayList();
            if (losingTeamID.equals(war.getAttackerTeamID())) {
                war.getAttackerLives().keySet().forEach(uuid -> {
                    ServerPlayer p = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
                    if (p != null) {
                        members.add(p);
                    }
                });
            } else {
                war.getDefenderLives().keySet().forEach(uuid -> {
                    ServerPlayer p = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
                    if (p != null) {
                        members.add(p);
                    }
                });
            }
            long sumInv = members.stream().mapToLong(WarEconomyHandler::getInventoryCurrencyBalance).sum();
            long toTake = remaining;
            for (ServerPlayer p : members) {
                long bal = WarEconomyHandler.getInventoryCurrencyBalance(p);
                long take = Math.round((double)bal / (double)sumInv * (double)remaining);
                if (take > toTake) {
                    take = toTake;
                }
                long actually = WarEconomyHandler.deductCurrencyFromInventory(p, take);
                totalTaken += actually;
                p.m_213846_((Component)Component.m_237113_((String)("You lost " + actually + " coins in reparations!")).m_130940_(ChatFormatting.RED));
                if ((toTake -= actually) > 0L) continue;
                break;
            }
        }
        if (totalTaken > 0L && (winner = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(winnerUUID)) != null) {
            ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(TaxConfig.getCurrencyItemName())), (int)totalTaken);
            if (!winner.m_150109_().m_36054_(stack)) {
                winner.m_36176_(stack, false);
                LOGGER.debug("Winner's inventory was full, dropped {} items near them", (Object)totalTaken);
            }
            winner.m_213846_((Component)Component.m_237113_((String)("You received " + totalTaken + " coins in reparations!")).m_130940_(ChatFormatting.GREEN));
        }
        return true;
    }

    public static double transferBalanceToPlayer(UUID loserUUID, UUID winnerUUID, double percentage) {
        double transferredAmount = 0.0;
        ServerPlayer loserPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(loserUUID);
        ServerPlayer winnerPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(winnerUUID);
        if (loserPlayer != null && winnerPlayer != null) {
            if (TaxConfig.isSDMShopConversionEnabled()) {
                long loserBalance = SDMShopR.getMoney((Player)loserPlayer);
                long transferAmount = (long)((double)loserBalance * percentage);
                if (transferAmount > 0L) {
                    SDMShopR.setMoney((Player)loserPlayer, (long)(loserBalance - transferAmount));
                    long winnerBalance = SDMShopR.getMoney((Player)winnerPlayer);
                    SDMShopR.setMoney((Player)winnerPlayer, (long)(winnerBalance + transferAmount));
                    transferredAmount = transferAmount;
                    loserPlayer.m_213846_((Component)Component.m_237113_((String)("You lost " + transferAmount + " as war reparations to " + winnerPlayer.m_7755_().getString() + "!")).m_130940_(ChatFormatting.RED));
                }
            } else {
                long actuallyDeducted;
                long loserInvBalance = WarEconomyHandler.getInventoryCurrencyBalance(loserPlayer);
                long transferAmount = (long)((double)loserInvBalance * percentage);
                if (transferAmount > 0L && (actuallyDeducted = WarEconomyHandler.deductCurrencyFromInventory(loserPlayer, transferAmount)) > 0L) {
                    ItemStack coinStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(TaxConfig.getCurrencyItemName())), (int)actuallyDeducted);
                    boolean added = winnerPlayer.m_150109_().m_36054_(coinStack);
                    if (!added) {
                        winnerPlayer.m_36176_(coinStack, false);
                        LOGGER.debug("Winner's inventory was full, dropped {} items near them", (Object)actuallyDeducted);
                    }
                    transferredAmount = actuallyDeducted;
                    loserPlayer.m_213846_((Component)Component.m_237113_((String)("You lost " + actuallyDeducted + " as war reparations to " + winnerPlayer.m_7755_().getString() + "!")).m_130940_(ChatFormatting.RED));
                }
            }
        }
        return transferredAmount;
    }
}

