/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.event;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.data.WarData;
import net.machiavelli.minecolonytax.raid.ActiveRaidData;
import net.machiavelli.minecolonytax.raid.RaidManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="minecolonytax", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WarEventHandler {
    private static final Map<UUID, ItemStack[]> savedInventories = new HashMap<UUID, ItemStack[]>();
    private static final Map<UUID, Integer> disconnectedWarParticipants = new HashMap<UUID, Integer>();

    public static Map<UUID, Integer> getDisconnectedWarParticipants() {
        return disconnectedWarParticipants;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        Object i22;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ActiveRaidData raidData = RaidManager.getActiveRaidForPlayer(player.m_20148_());
        if (raidData != null) {
            Entity src = event.getSource().m_7639_();
            if (src instanceof ServerPlayer) {
                ServerPlayer killer = (ServerPlayer)src;
                RaidManager.handleRaiderKilled(raidData, killer);
            } else {
                RaidManager.endActiveRaid(raidData, "Raider killed");
            }
            return;
        }
        System.out.println("[DEBUG] WarEventHandler.onPlayerDeath fired for " + player.m_7755_().getString());
        WarData war = WarSystem.getActiveWarForPlayer(player);
        if (war == null) {
            return;
        }
        System.out.println("[DEBUG] WarEventHandler.onPlayerDeath triggered confirmed for " + player.m_7755_().getString());
        if (war.isJoinPhaseActive()) {
            System.out.println("[DEBUG] War is still in join phase, not deducting lives for " + player.m_7755_().getString());
            return;
        }
        Map<UUID, Integer> lives = WarSystem.getLivesForPlayer(war, player);
        int currentLives = lives.getOrDefault(player.m_20148_(), 0);
        if (currentLives == 1 && ((Boolean)TaxConfig.KEEP_INVENTORY_ON_LAST_LIFE.get()).booleanValue()) {
            System.out.println("[DEBUG] Player " + player.m_7755_().getString() + " is on last life with keepInventoryOnLastLife enabled - preserving inventory on respawn");
            ItemStack[] inventoryCopy = new ItemStack[player.m_150109_().m_6643_()];
            for (int i22 = 0; i22 < player.m_150109_().m_6643_(); ++i22) {
                inventoryCopy[i22] = player.m_150109_().m_8020_(i22).m_41777_();
            }
            savedInventories.put(player.m_20148_(), inventoryCopy);
            war.getLastLifeInventoryPreservation().add(player.m_20148_());
            event.getEntity().m_19880_().add("war_keep_inventory");
            System.out.println("[DEBUG] Inventory saved for last life preservation for " + player.m_7755_().getString());
        }
        if ((i22 = event.getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer killer = (ServerPlayer)i22;
            WarSystem.onPlayerKilledInWar(killer, player, war);
            for (Map.Entry entry : RaidManager.getActiveRaids().entrySet()) {
                if (!((UUID)entry.getKey()).equals(player.m_20148_())) continue;
                System.out.println("[DEBUG] Raider killed during raid: " + player.m_7755_().getString());
                RaidManager.handleRaiderKilled((ActiveRaidData)entry.getValue(), killer);
                break;
            }
        }
        UUID playerUUID = player.m_20148_();
        System.out.println("[DEBUG] Player " + player.m_7755_().getString() + " died during war. Lives map before: " + lives);
        System.out.println("[DEBUG] Player UUID: " + playerUUID + ", lives before death: " + lives.get(playerUUID));
        if (lives.isEmpty()) {
            System.out.println("[DEBUG] Player " + player.m_7755_().getString() + " is not participating in any war, skipping lives processing");
            return;
        }
        int defaultLives = (Integer)TaxConfig.PLAYER_LIVES_IN_WAR.get();
        if (!lives.containsKey(playerUUID)) {
            System.out.println("[DEBUG] Player " + player.m_7755_().getString() + " was not in lives map, initializing with " + defaultLives + " lives");
            lives.put(playerUUID, defaultLives);
        }
        int n = lives.compute(playerUUID, (k, v) -> {
            if (v == null || v <= 0) {
                System.out.println("[DEBUG] Lives value was null or invalid (" + v + "), using default " + defaultLives + " minus 1");
                return defaultLives - 1;
            }
            return Math.max(0, v - 1);
        });
        System.out.println("[DEBUG] " + player.m_7755_().getString() + " now has " + n + " lives after death.");
        System.out.println("[DEBUG] Lives map after: " + lives);
        player.m_5496_(SoundEvents.f_11920_, 1.0f, 1.0f);
        player.m_21195_(MobEffects.f_19619_);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        WarData war = WarSystem.getActiveWarForPlayer(player2);
        if (war == null) {
            return;
        }
        UUID playerUUID = player2.m_20148_();
        Map<UUID, Integer> lives = WarSystem.getLivesForPlayer(war, player2);
        System.out.println("[DEBUG] RESPAWN - Player " + player2.m_7755_().getString() + " respawning");
        System.out.println("[DEBUG] RESPAWN - Lives map: " + lives);
        System.out.println("[DEBUG] RESPAWN - Player UUID: " + playerUUID);
        System.out.println("[DEBUG] RESPAWN - Contains player key: " + lives.containsKey(playerUUID));
        if (lives.isEmpty()) {
            System.out.println("[DEBUG] RESPAWN - Player " + player2.m_7755_().getString() + " is not participating in any war, skipping respawn processing");
            return;
        }
        int currentLives = lives.getOrDefault(playerUUID, 0);
        System.out.println("[DEBUG] RESPAWN - Player " + player2.m_7755_().getString() + " respawned with " + currentLives + " lives remaining");
        if (war.getLastLifeInventoryPreservation().contains(playerUUID) && savedInventories.containsKey(playerUUID)) {
            ItemStack[] savedItems = savedInventories.get(playerUUID);
            player2.m_150109_().m_6211_();
            for (int i = 0; i < savedItems.length && i < player2.m_150109_().m_6643_(); ++i) {
                if (savedItems[i] == null) continue;
                player2.m_150109_().m_6836_(i, savedItems[i]);
            }
            player2.m_213846_((Component)Component.m_237113_((String)"Your inventory has been restored as configured.").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)));
            savedInventories.remove(playerUUID);
            war.getSpectators().add(playerUUID);
            player2.m_143403_(GameType.SPECTATOR);
            player2.m_213846_((Component)Component.m_237113_((String)"You have died on your last life! You are now a spectator until the war ends.").m_130938_(style -> style.m_131140_(ChatFormatting.GOLD).m_131136_(Boolean.valueOf(true))));
            System.out.println("[INFO] Restored inventory for player " + player2.m_7755_().getString() + " after last life death");
            WarSystem.checkForVictory(war);
            WarSystem.updateBossBar(war);
        } else if (currentLives <= 0) {
            if (!((Boolean)TaxConfig.KEEP_INVENTORY_ON_LAST_LIFE.get()).booleanValue() && !WarSystem.WarInventoryHandler.hasSavedInventory(player2)) {
                WarSystem.WarInventoryHandler.saveAndClearInventory(player2);
            }
            war.getSpectators().add(playerUUID);
            player2.m_143403_(GameType.SPECTATOR);
            player2.m_213846_((Component)Component.m_237113_((String)"You are now a spectator until the war ends.").m_130938_(style -> style.m_131140_(ChatFormatting.DARK_GRAY).m_131155_(Boolean.valueOf(true))));
            WarSystem.checkForVictory(war);
            WarSystem.updateBossBar(war);
        } else if (currentLives == 1) {
            player2.m_213846_((Component)Component.m_237113_((String)"\u26a0 WARNING: This is your LAST LIFE! \u26a0").m_130938_(style -> style.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))));
            String keepInventoryMessage = (Boolean)TaxConfig.KEEP_INVENTORY_ON_LAST_LIFE.get() != false ? "\u00a7e\u00a7lWarning: \u00a7r\u00a7eYou are on your last life! If you die, you will keep your inventory and become a spectator." : "\u00a7e\u00a7lWarning: \u00a7r\u00a7eYou are on your last life! If you die, you will lose your inventory and become a spectator.";
            player2.m_213846_((Component)Component.m_237113_((String)keepInventoryMessage));
            player2.m_5496_(SoundEvents.f_11871_, 1.0f, 0.5f);
            if (((Boolean)TaxConfig.ENABLE_COLONY_TRANSFER.get()).booleanValue() && ((Boolean)TaxConfig.KEEP_INVENTORY_ON_LAST_LIFE.get()).booleanValue()) {
                player2.m_213846_((Component)Component.m_237113_((String)"If you die, you will keep your inventory and can continue fighting as a spectator.").m_130938_(style -> style.m_131140_(ChatFormatting.GOLD)));
            }
            WarSystem.updateBossBar(war);
        } else {
            WarSystem.updateBossBar(war);
        }
        if (war.getStatus() == WarData.WarStatus.INWAR) {
            player2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 999999, 0, false, false));
        }
        player2.m_19880_().remove("war_keep_inventory");
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ActiveRaidData raidData;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID playerUUID = player2.m_20148_();
        WarData war = WarSystem.getActiveWarForPlayer(player2);
        if (war != null) {
            if (war.getAttackerLives().containsKey(playerUUID)) {
                disconnectedWarParticipants.put(playerUUID, 1);
            } else if (war.getDefenderLives().containsKey(playerUUID)) {
                disconnectedWarParticipants.put(playerUUID, 2);
            }
            System.out.println("[DEBUG] Player " + player2.m_7755_().getString() + " disconnected during active war");
        }
        if ((raidData = RaidManager.getActiveRaidForPlayer(playerUUID)) != null) {
            disconnectedWarParticipants.put(playerUUID, 3);
            System.out.println("[DEBUG] Player " + player2.m_7755_().getString() + " disconnected during active raid");
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID playerUUID = player2.m_20148_();
        if (disconnectedWarParticipants.containsKey(playerUUID)) {
            ActiveRaidData raidData;
            int warStatus = disconnectedWarParticipants.get(playerUUID);
            if (warStatus == 1 || warStatus == 2) {
                for (WarData war : WarSystem.ACTIVE_WARS.values()) {
                    boolean isAttacker = war.getAttackerLives().containsKey(playerUUID);
                    boolean isDefender = war.getDefenderLives().containsKey(playerUUID);
                    if (!isAttacker && !isDefender) continue;
                    if (war.alliesBossEvent != null && war.alliesBossEvent.m_8323_()) {
                        war.alliesBossEvent.m_6543_(player2);
                    } else if (war.bossEvent != null) {
                        war.bossEvent.m_6543_(player2);
                    }
                    player2.m_213846_((Component)Component.m_237113_((String)"You have reconnected to an active war.").m_130940_(ChatFormatting.GOLD));
                    if (!war.getSpectators().contains(playerUUID)) continue;
                    player2.m_143403_(GameType.SPECTATOR);
                }
            } else if (warStatus == 3 && (raidData = RaidManager.getActiveRaidForPlayer(playerUUID)) != null && raidData.getBossEvent() != null) {
                raidData.getBossEvent().m_6543_(player2);
                player2.m_213846_((Component)Component.m_237113_((String)"You have reconnected to an active raid.").m_130940_(ChatFormatting.GOLD));
            }
            disconnectedWarParticipants.remove(playerUUID);
        }
        for (ActiveRaidData raidData : RaidManager.getActiveRaids().values()) {
            if (!raidData.isActive() || raidData.getBossEvent() == null || raidData.getColony() == null || !raidData.getColony().getPermissions().getPlayers().containsKey(playerUUID)) continue;
            raidData.getBossEvent().m_6543_(player2);
            player2.m_213846_((Component)Component.m_237113_((String)"Your colony is currently being raided!").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        }
    }

    @SubscribeEvent
    public static void onCitizenDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof AbstractEntityCitizen)) {
            return;
        }
        AbstractEntityCitizen citizen = (AbstractEntityCitizen)livingEntity;
        ICitizenData data = citizen.getCitizenData();
        if (data == null) {
            return;
        }
        IColony citizenColony = data.getColony();
        if (citizenColony == null) {
            return;
        }
        WarData war = WarSystem.ACTIVE_WARS.get(citizenColony.getID());
        if (war == null) {
            return;
        }
        if (war.getGuardIDs().remove(data.getId())) {
            if (citizenColony.equals(war.getColony())) {
                war.remainingDefenderGuards = Math.max(0, war.remainingDefenderGuards - 1);
                for (UUID uuid : war.getDefenderLives().keySet()) {
                    ServerPlayer p;
                    if (war.getColony().getWorld().m_7654_() == null || (p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid)) == null) continue;
                    p.m_213846_((Component)Component.m_237113_((String)"Your guard has been killed!").m_130938_(s -> s.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))));
                }
            } else if (citizenColony.equals(war.getAttackerColony())) {
                war.remainingAttackerGuards = Math.max(0, war.remainingAttackerGuards - 1);
                for (UUID uuid : war.getAttackerLives().keySet()) {
                    ServerPlayer p;
                    if (war.getColony().getWorld().m_7654_() == null || (p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid)) == null) continue;
                    p.m_213846_((Component)Component.m_237113_((String)"Your guard has been killed!").m_130938_(s -> s.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))));
                }
            } else {
                WarEventHandler.sendWarParticipantsMessage(war, (Component)Component.m_237113_((String)"A guard has been killed!").m_130938_(s -> s.m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true))));
            }
            citizen.m_21195_(MobEffects.f_19619_);
            citizen.m_9236_().m_6263_(null, citizen.m_20182_().m_7096_(), citizen.m_20182_().m_7098_(), citizen.m_20182_().m_7094_(), SoundEvents.f_12506_, SoundSource.HOSTILE, 1.0f, 0.8f);
            WarSystem.updateBossBar(war);
            WarSystem.checkForVictory(war);
            System.out.println("[DEBUG] Attacker Guards: " + war.getRemainingAttackerGuards() + " | Defender Guards: " + war.getRemainingDefenderGuards());
        }
    }

    private static void sendWarParticipantsMessage(WarData war, Component message) {
        ServerPlayer p;
        for (UUID uuid : war.getAttackerLives().keySet()) {
            if (war.getColony().getWorld().m_7654_() == null || (p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid)) == null) continue;
            p.m_213846_(message);
        }
        for (UUID uuid : war.getDefenderLives().keySet()) {
            if (war.getColony().getWorld().m_7654_() == null || (p = war.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid)) == null) continue;
            p.m_213846_(message);
        }
    }

    private static void sendColonyMessage(IColony colony, Component message) {
        colony.getPermissions().getPlayers().forEach((uuid, data) -> {
            ServerPlayer p = (ServerPlayer)colony.getWorld().m_46003_(uuid);
            if (p != null) {
                p.m_213846_(message);
            }
        });
    }
}

