/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.machiavelli.minecolonytax.gui.data.ColonyTaxData;
import net.machiavelli.minecolonytax.gui.data.OfficerData;
import net.machiavelli.minecolonytax.gui.data.VassalIncomeData;
import net.machiavelli.minecolonytax.network.NetworkHandler;
import net.machiavelli.minecolonytax.network.packets.ClaimTaxPacket;
import net.machiavelli.minecolonytax.network.packets.EndVassalizationPacket;
import net.machiavelli.minecolonytax.network.packets.PayTaxDebtPacket;
import net.machiavelli.minecolonytax.network.packets.RequestColonyDataPacket;
import net.machiavelli.minecolonytax.network.packets.RequestOfficerDataPacket;
import net.machiavelli.minecolonytax.network.packets.UpdatePlayerTaxPermissionPacket;
import net.machiavelli.minecolonytax.network.packets.UpdateTaxPermissionPacket;
import net.machiavelli.minecolonytax.permissions.TaxPermissionManager;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TaxManagementScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("minecolonytax", "textures/gui/backgroundmenu.png");
    private static final int GUI_WIDTH = 360;
    private static final int GUI_HEIGHT = 280;
    private List<ColonyTaxData> colonies = new ArrayList<ColonyTaxData>();
    private List<VassalIncomeData> vassalData = new ArrayList<VassalIncomeData>();
    private List<OfficerData> officerData = new ArrayList<OfficerData>();
    private int scrollOffset = 0;
    private int vassalScrollOffset = 0;
    private final int maxVisibleColonies = 5;
    private final int maxVisibleVassals = 5;
    private ColonyTaxData selectedColony = null;
    private Button refreshButton;
    private Button claimAllButton;
    private Button vassalsTabButton;
    private Button coloniesTabButton;
    private Button permissionsTabButton;
    private Button claimSelectedButton;
    private Button payDebtButton;
    private Button endVassalButton;
    private boolean showingVassals = false;
    private boolean showingPermissions = false;
    private Rectangle permissionToggleButton;
    private Map<Integer, Rectangle> officerToggleButtons;
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int COLOR_LIGHT_GRAY = 0xE0E0E0;
    private static final int COLOR_GREEN = 5025616;
    private static final int COLOR_LIGHT_GREEN = 9159498;
    private static final int COLOR_RED = 16007990;
    private static final int COLOR_ORANGE = 16750592;
    private static final int COLOR_YELLOW = 16771899;
    private static final int COLOR_GOLD = 16761095;
    private static final int COLOR_BLUE = 2201331;
    private static final int COLOR_GRAY = 0x9E9E9E;
    private static final int COLOR_BACKGROUND = 0x2E2E2E;
    private static final int COLOR_BORDER = 0x5E5E5E;
    private static final int COLOR_HEADER = 1668818;

    public TaxManagementScreen() {
        super((Component)Component.m_237115_((String)"gui.minecolonytax.tax_management.title"));
    }

    protected void m_7856_() {
        super.m_7856_();
        int guiLeft = (this.f_96543_ - 360) / 2;
        int guiTop = (this.f_96544_ - 280) / 2;
        int tabButtonWidth = 70;
        int tabButtonHeight = 20;
        int totalTabWidth = tabButtonWidth * 3 + 10;
        int tabStartX = guiLeft + (360 - totalTabWidth) / 2;
        this.coloniesTabButton = Button.m_253074_((Component)Component.m_237113_((String)"Colonies"), button -> this.switchToColonies()).m_252987_(tabStartX, guiTop + 25, tabButtonWidth, tabButtonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.coloniesTabButton);
        this.vassalsTabButton = Button.m_253074_((Component)Component.m_237113_((String)"Vassals"), button -> this.switchToVassals()).m_252987_(tabStartX + tabButtonWidth + 5, guiTop + 25, tabButtonWidth, tabButtonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.vassalsTabButton);
        this.permissionsTabButton = Button.m_253074_((Component)Component.m_237113_((String)"Officers"), button -> this.switchToPermissions()).m_252987_(tabStartX + (tabButtonWidth + 5) * 2, guiTop + 25, tabButtonWidth, tabButtonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.permissionsTabButton);
        int buttonHeight = 20;
        int buttonMargin = 30;
        int totalButtonsWidth = 320;
        int buttonAreaWidth = 360 - buttonMargin * 2;
        int buttonSpacing = (buttonAreaWidth - totalButtonsWidth + 20) / 6;
        int buttonStartX = guiLeft + buttonMargin;
        this.refreshButton = Button.m_253074_((Component)Component.m_237113_((String)"Refresh"), button -> this.requestColonyData()).m_252987_(buttonStartX, guiTop + 280 - 28, 55, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.refreshButton);
        this.claimSelectedButton = Button.m_253074_((Component)Component.m_237113_((String)"Claim"), button -> {
            if (this.selectedColony != null && this.selectedColony.canClaimTax()) {
                NetworkHandler.sendToServer(new ClaimTaxPacket(this.selectedColony.getColonyId(), -1));
                this.selectedColony = null;
                this.updateButtonVisibility();
            }
        }).m_252987_(buttonStartX + 55 + buttonSpacing, guiTop + 280 - 28, 50, buttonHeight).m_253136_();
        this.claimSelectedButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.claimSelectedButton);
        this.payDebtButton = Button.m_253074_((Component)Component.m_237113_((String)"Pay Debt"), button -> {
            if (this.selectedColony != null && this.selectedColony.getDebtAmount() > 0) {
                NetworkHandler.sendToServer(new PayTaxDebtPacket(this.selectedColony.getColonyId()));
                this.selectedColony = null;
                this.updateButtonVisibility();
            }
        }).m_252987_(buttonStartX + 55 + 50 + buttonSpacing * 2, guiTop + 280 - 28, 60, buttonHeight).m_253136_();
        this.payDebtButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.payDebtButton);
        this.endVassalButton = Button.m_253074_((Component)Component.m_237113_((String)"End Vassal"), button -> {
            if (this.selectedColony != null && this.selectedColony.isVassal()) {
                NetworkHandler.sendToServer(new EndVassalizationPacket(this.selectedColony.getColonyId()));
                this.selectedColony = null;
                this.updateButtonVisibility();
            }
        }).m_252987_(buttonStartX + 55 + 50 + 60 + buttonSpacing * 3, guiTop + 280 - 28, 70, buttonHeight).m_253136_();
        this.endVassalButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.endVassalButton);
        this.claimAllButton = Button.m_253074_((Component)Component.m_237113_((String)"Claim All"), button -> this.claimAllTaxes()).m_252987_(guiLeft + 360 - buttonMargin - 65, guiTop + 280 - 28, 65, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.claimAllButton);
        this.requestColonyData();
    }

    private void requestColonyData() {
        NetworkHandler.sendToServer(new RequestColonyDataPacket());
        this.officerData.clear();
    }

    private void switchToColonies() {
        this.showingVassals = false;
        this.showingPermissions = false;
        this.scrollOffset = 0;
    }

    private void switchToVassals() {
        this.showingVassals = true;
        this.showingPermissions = false;
        this.vassalScrollOffset = 0;
    }

    private void switchToPermissions() {
        this.showingVassals = false;
        this.showingPermissions = true;
        this.scrollOffset = 0;
        if (this.selectedColony != null) {
            NetworkHandler.sendToServer(new RequestOfficerDataPacket(this.selectedColony.getColonyId()));
        }
    }

    private void claimAllTaxes() {
        for (ColonyTaxData colony : this.colonies) {
            if (colony.getTaxBalance() <= 0 || !colony.canClaimTax()) continue;
            NetworkHandler.CHANNEL.sendToServer((Object)new ClaimTaxPacket(colony.getColonyId(), -1));
        }
        this.requestColonyData();
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int guiLeft = (this.f_96543_ - 360) / 2;
        int guiTop = (this.f_96544_ - 280) / 2;
        try {
            int TEXTURE_WIDTH = 256;
            int TEXTURE_HEIGHT = 256;
            this.renderTiledBackground(guiGraphics, guiLeft, guiTop, 256, 256);
        }
        catch (Exception e) {
            guiGraphics.m_280509_(guiLeft, guiTop, guiLeft + 360, guiTop + 280, -13816528);
            guiGraphics.m_280509_(guiLeft + 2, guiTop + 2, guiLeft + 360 - 2, guiTop + 280 - 2, -14803426);
        }
        MutableComponent title = Component.m_237115_((String)"gui.minecolonytax.tax_management.title");
        guiGraphics.m_280653_(this.f_96547_, (Component)title, guiLeft + 180, guiTop + 6, 0xFFFFFF);
        int tabButtonWidth = 70;
        int totalTabWidth = tabButtonWidth * 3 + 10;
        int tabStartX = guiLeft + (360 - totalTabWidth) / 2;
        if (this.showingPermissions) {
            guiGraphics.m_280509_(tabStartX + (tabButtonWidth + 5) * 2, guiTop + 47, tabStartX + (tabButtonWidth + 5) * 2 + tabButtonWidth, guiTop + 49, 16761095);
        } else if (this.showingVassals) {
            guiGraphics.m_280509_(tabStartX + tabButtonWidth + 5, guiTop + 47, tabStartX + tabButtonWidth + 5 + tabButtonWidth, guiTop + 49, 16761095);
        } else {
            guiGraphics.m_280509_(tabStartX, guiTop + 47, tabStartX + tabButtonWidth, guiTop + 49, 16761095);
        }
        if (this.showingPermissions) {
            this.renderPermissionsManagement(guiGraphics, guiLeft, guiTop, mouseX, mouseY);
        } else if (this.showingVassals) {
            this.renderVassalList(guiGraphics, guiLeft, guiTop, mouseX, mouseY);
            if (this.vassalData.size() > 5) {
                this.renderVassalScrollIndicator(guiGraphics, guiLeft, guiTop);
            }
        } else {
            this.renderColonyList(guiGraphics, guiLeft, guiTop, mouseX, mouseY);
            if (this.colonies.size() > 5) {
                this.renderScrollIndicator(guiGraphics, guiLeft, guiTop);
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderTiledBackground(GuiGraphics guiGraphics, int guiLeft, int guiTop, int textureWidth, int textureHeight) {
        guiGraphics.m_280168_().m_85836_();
        float scaleX = 360.0f / (float)textureWidth;
        float scaleY = 280.0f / (float)textureHeight;
        guiGraphics.m_280168_().m_252880_((float)guiLeft, (float)guiTop, 0.0f);
        guiGraphics.m_280168_().m_85841_(scaleX, scaleY, 1.0f);
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
        guiGraphics.m_280168_().m_85849_();
        int borderColor = 0x40000000;
        guiGraphics.m_280509_(guiLeft, guiTop, guiLeft + 360, guiTop + 1, borderColor);
        guiGraphics.m_280509_(guiLeft, guiTop + 280 - 1, guiLeft + 360, guiTop + 280, borderColor);
        guiGraphics.m_280509_(guiLeft, guiTop, guiLeft + 1, guiTop + 280, borderColor);
        guiGraphics.m_280509_(guiLeft + 360 - 1, guiTop, guiLeft + 360, guiTop + 280, borderColor);
    }

    private void renderColonyList(GuiGraphics guiGraphics, int guiLeft, int guiTop, int mouseX, int mouseY) {
        Font font = this.f_96547_;
        int startY = guiTop + 50;
        int entryHeight = 35;
        int contentMargin = 50;
        int contentX = guiLeft + contentMargin;
        int contentWidth = 360 - contentMargin * 2;
        for (int i = 0; i < Math.min(5, this.colonies.size() - this.scrollOffset); ++i) {
            int taxColor;
            String taxText;
            int borderColor;
            int bgColor;
            boolean isSelected;
            ColonyTaxData colony = this.colonies.get(i + this.scrollOffset);
            int entryY = startY + i * entryHeight;
            boolean isHovered = mouseX >= contentX && mouseX < contentX + contentWidth && mouseY >= entryY && mouseY < entryY + entryHeight - 2;
            boolean bl = isSelected = this.selectedColony != null && this.selectedColony.getColonyId() == colony.getColonyId();
            if (isSelected) {
                bgColor = 5917242;
                borderColor = 16761095;
            } else if (colony.isOwner()) {
                bgColor = isHovered ? 4863784 : (i % 2 == 0 ? 3812126 : 3286295);
                borderColor = isHovered ? 16761095 : 9136404;
            } else {
                bgColor = isHovered ? 0x404040 : (i % 2 == 0 ? 0x303030 : 0x2A2A2A);
                borderColor = isHovered ? 16761095 : 0x505050;
            }
            guiGraphics.m_280509_(contentX, entryY, contentX + contentWidth, entryY + entryHeight - 2, borderColor);
            guiGraphics.m_280509_(contentX + 1, entryY + 1, contentX + contentWidth - 1, entryY + entryHeight - 3, bgColor);
            Object colonyName = colony.getColonyName();
            if (colony.isOwner()) {
                colonyName = "\u2605 " + (String)colonyName;
            }
            if (isSelected) {
                colonyName = "\u25b6 " + (String)colonyName;
            }
            if (((String)colonyName).length() > 18) {
                colonyName = ((String)colonyName).substring(0, 15) + "...";
            }
            int statusColor = this.getColonyStatusColor(colony);
            Object statusText = this.getColonyStatusText(colony);
            if (isSelected) {
                statusText = "SELECTED - " + (String)statusText;
                statusColor = 16761095;
            }
            guiGraphics.m_280488_(font, (String)colonyName, contentX + 5, entryY + 2, 0xFFFFFF);
            guiGraphics.m_280488_(font, (String)statusText, contentX + 5, entryY + 11, statusColor);
            if (colony.hasDebt()) {
                taxText = "DEBT: " + colony.getDebtAmount();
                taxColor = 16007990;
            } else {
                taxText = colony.getTaxBalance() + " / " + colony.getMaxTaxRevenue();
                taxColor = 16761095;
            }
            String buildingText = "B:" + colony.getBuildingCount() + " G:" + colony.getGuardCount();
            String revenueText = "Approx. " + colony.getApproximateRevenuePerInterval() + " $/ Interval";
            int rightX = contentX + contentWidth - 5;
            guiGraphics.m_280488_(font, taxText, rightX - font.m_92895_(taxText), entryY + 2, taxColor);
            guiGraphics.m_280488_(font, buildingText, rightX - font.m_92895_(buildingText), entryY + 11, 0x9E9E9E);
            guiGraphics.m_280488_(font, revenueText, rightX - font.m_92895_(revenueText), entryY + 20, 0xE0E0E0);
            if (colony.isVassal()) {
                String vassalText = "Vassal (" + colony.getVassalTributeRate() + "%)";
                int vassalTextWidth = font.m_92895_(vassalText);
                int vassalBgX = contentX + 100;
                int vassalBgY = entryY + 1;
                guiGraphics.m_280509_(vassalBgX - 2, vassalBgY, vassalBgX + vassalTextWidth + 2, vassalBgY + 9, 16750592);
                guiGraphics.m_280488_(font, vassalText, vassalBgX, vassalBgY + 1, 0xFFFFFF);
                continue;
            }
            if (!colony.hasVassals()) continue;
            String overlordText = "Overlord (" + colony.getVassalCount() + ")";
            int overlordTextWidth = font.m_92895_(overlordText);
            int overlordBgX = contentX + 100;
            int overlordBgY = entryY + 1;
            guiGraphics.m_280509_(overlordBgX - 2, overlordBgY, overlordBgX + overlordTextWidth + 2, overlordBgY + 9, 5025616);
            guiGraphics.m_280488_(font, overlordText, overlordBgX, overlordBgY + 1, 0xFFFFFF);
        }
        if (this.colonies.isEmpty()) {
            MutableComponent noColonies = Component.m_237115_((String)"gui.minecolonytax.no_colonies");
            int textWidth = font.m_92852_((FormattedText)noColonies);
            guiGraphics.m_280430_(font, (Component)noColonies, guiLeft + (360 - textWidth) / 2, guiTop + 140, 0x9E9E9E);
        }
    }

    private void renderScrollIndicator(GuiGraphics guiGraphics, int guiLeft, int guiTop) {
        int scrollBarX = guiLeft + 360 - 20;
        int scrollBarY = guiTop + 50;
        int scrollBarHeight = 140;
        guiGraphics.m_280509_(scrollBarX - 1, scrollBarY - 1, scrollBarX + 8, scrollBarY + scrollBarHeight + 1, 0x5E5E5E);
        guiGraphics.m_280509_(scrollBarX, scrollBarY, scrollBarX + 7, scrollBarY + scrollBarHeight, 0x2E2E2E);
        int thumbHeight = Math.max(10, 5 * scrollBarHeight / this.colonies.size());
        int thumbY = scrollBarY + this.scrollOffset * (scrollBarHeight - thumbHeight) / Math.max(1, this.colonies.size() - 5);
        guiGraphics.m_280509_(scrollBarX + 1, thumbY, scrollBarX + 6, thumbY + thumbHeight, 1668818);
        guiGraphics.m_280509_(scrollBarX + 2, thumbY + 1, scrollBarX + 5, thumbY + thumbHeight - 1, 2201331);
    }

    private void renderVassalList(GuiGraphics guiGraphics, int guiLeft, int guiTop, int mouseX, int mouseY) {
        Font font = this.f_96547_;
        int startY = guiTop + 50;
        int entryHeight = 30;
        int contentMargin = 50;
        int contentX = guiLeft + contentMargin;
        int contentWidth = 360 - contentMargin * 2;
        MutableComponent yourVassalsTitle = Component.m_237113_((String)"Your Vassals:");
        guiGraphics.m_280430_(font, (Component)yourVassalsTitle, contentX, startY, 2201331);
        int currentY = startY + 15;
        if (this.vassalData.isEmpty()) {
            MutableComponent noVassals = Component.m_237113_((String)"No vassals");
            guiGraphics.m_280430_(font, (Component)noVassals, contentX, currentY, 0x9E9E9E);
            currentY += 15;
        } else {
            int visibleVassals = Math.min(5, this.vassalData.size() - this.vassalScrollOffset);
            for (int i = 0; i < visibleVassals; ++i) {
                boolean isHovered;
                VassalIncomeData vassal = this.vassalData.get(i + this.vassalScrollOffset);
                int entryY = currentY + i * entryHeight;
                boolean bl = isHovered = mouseX >= contentX && mouseX < contentX + contentWidth && mouseY >= entryY && mouseY < entryY + entryHeight - 2;
                int bgColor = isHovered ? 0x404040 : (i % 2 == 0 ? 0x303030 : 0x2A2A2A);
                int borderColor = isHovered ? 16761095 : 0x505050;
                guiGraphics.m_280509_(contentX, entryY, contentX + contentWidth, entryY + entryHeight - 2, borderColor);
                guiGraphics.m_280509_(contentX + 1, entryY + 1, contentX + contentWidth - 1, entryY + entryHeight - 3, bgColor);
                Object colonyName = vassal.getVassalColonyName();
                if (((String)colonyName).length() > 16) {
                    colonyName = ((String)colonyName).substring(0, 13) + "...";
                }
                guiGraphics.m_280488_(font, (String)colonyName, contentX + 5, entryY + 3, 0xFFFFFF);
                String tributeInfo = vassal.getTributeRate() + "% tribute";
                guiGraphics.m_280488_(font, tributeInfo, contentX + 5, entryY + 13, 16750592);
                int estimatedNextTribute = (int)((double)vassal.getTributeOwed() * ((double)vassal.getTributeRate() / 100.0));
                String estimationText = "Next Est: " + estimatedNextTribute;
                int estimationWidth = font.m_92895_(estimationText);
                guiGraphics.m_280488_(font, estimationText, contentX + contentWidth - 5 - estimationWidth, entryY + 2, 16771899);
                String lastText = "Last: " + vassal.getLastTribute() + " (" + vassal.getFormattedLastPayment() + ")";
                int lastTextWidth = font.m_92895_(lastText);
                guiGraphics.m_280488_(font, lastText, contentX + contentWidth - 5 - lastTextWidth, entryY + 13, 0x9E9E9E);
                String autoText = "Auto-collected at tax intervals";
                int autoTextWidth = font.m_92895_(autoText);
                int autoX = contentX + contentWidth - 5 - autoTextWidth;
                guiGraphics.m_280488_(font, autoText, autoX, entryY + 22, 9159498);
            }
            currentY += visibleVassals * entryHeight;
        }
        MutableComponent vassalOfTitle = Component.m_237113_((String)"You are vassal of:");
        guiGraphics.m_280430_(font, (Component)vassalOfTitle, contentX, currentY += 20, 16007990);
        currentY += 15;
        List playerVassalColonies = this.colonies.stream().filter(ColonyTaxData::isVassal).collect(Collectors.toList());
        if (playerVassalColonies.isEmpty()) {
            MutableComponent noOverlords = Component.m_237113_((String)"You are independent");
            guiGraphics.m_280430_(font, (Component)noOverlords, contentX, currentY, 0x9E9E9E);
        } else {
            for (int i = 0; i < playerVassalColonies.size() && i < 3; ++i) {
                boolean isHovered;
                ColonyTaxData vassalColony = (ColonyTaxData)playerVassalColonies.get(i);
                int entryY = currentY + i * 25;
                boolean isSelected = this.selectedColony != null && this.selectedColony.getColonyId() == vassalColony.getColonyId();
                boolean bl = isHovered = mouseX >= contentX && mouseX < contentX + contentWidth && mouseY >= entryY && mouseY < entryY + 23;
                int bgColor = isSelected ? 16761095 : (isHovered ? 0x404040 : 0x303030);
                guiGraphics.m_280509_(contentX, entryY, contentX + contentWidth, entryY + 23, bgColor);
                String colonyText = vassalColony.getColonyName() + " (paying " + vassalColony.getVassalTributeRate() + "%)";
                if (colonyText.length() > 25) {
                    colonyText = colonyText.substring(0, 22) + "...";
                }
                guiGraphics.m_280488_(font, colonyText, contentX + 5, entryY + 3, 0xFFFFFF);
                if (isSelected) {
                    int buttonX = guiLeft + 360 - 70;
                    int buttonY = entryY + 10;
                    int buttonWidth = 60;
                    int buttonHeight = 10;
                    boolean isButtonHovered = mouseX >= buttonX && mouseX < buttonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight;
                    int buttonColor = isButtonHovered ? 0x800000 : 0x600000;
                    guiGraphics.m_280509_(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, buttonColor);
                    String endText = "End Vassalage";
                    guiGraphics.m_280488_(font, endText, buttonX + (buttonWidth - font.m_92895_(endText)) / 2, buttonY + 1, 0xFFFFFF);
                    vassalColony.setClaimButtonBounds(buttonX, buttonY, buttonWidth, buttonHeight);
                }
                guiGraphics.m_280488_(font, "Click to select", contentX + 5, entryY + 13, 0xE0E0E0);
            }
        }
    }

    private void renderVassalScrollIndicator(GuiGraphics guiGraphics, int guiLeft, int guiTop) {
        int scrollBarX = guiLeft + 360 - 20;
        int scrollBarY = guiTop + 50;
        int scrollBarHeight = 150;
        guiGraphics.m_280509_(scrollBarX - 1, scrollBarY - 1, scrollBarX + 8, scrollBarY + scrollBarHeight + 1, 0x5E5E5E);
        guiGraphics.m_280509_(scrollBarX, scrollBarY, scrollBarX + 7, scrollBarY + scrollBarHeight, 0x2E2E2E);
        int thumbHeight = Math.max(10, 5 * scrollBarHeight / this.vassalData.size());
        int thumbY = scrollBarY + this.vassalScrollOffset * (scrollBarHeight - thumbHeight) / Math.max(1, this.vassalData.size() - 5);
        guiGraphics.m_280509_(scrollBarX + 1, thumbY, scrollBarX + 6, thumbY + thumbHeight, 1668818);
        guiGraphics.m_280509_(scrollBarX + 2, thumbY + 1, scrollBarX + 5, thumbY + thumbHeight - 1, 2201331);
    }

    private int getColonyStatusColor(ColonyTaxData colony) {
        if (!colony.canClaimTax()) {
            if (colony.isAtWar()) {
                return 16007990;
            }
            if (colony.isBeingRaided()) {
                return 16007990;
            }
            return 16771899;
        }
        if (colony.getTaxBalance() < 0) {
            return 16007990;
        }
        if ((double)colony.getTaxBalance() >= (double)colony.getMaxTaxRevenue() * 0.9) {
            return 16771899;
        }
        return 5025616;
    }

    private String getColonyStatusText(ColonyTaxData colony) {
        if (colony.isAtWar()) {
            return "At War";
        }
        if (colony.isBeingRaided()) {
            return "Under Raid";
        }
        if (!colony.canClaimTax()) {
            return "Restricted";
        }
        if (colony.getTaxBalance() < 0) {
            return "In Debt";
        }
        return "Healthy";
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.showingPermissions && !this.officerData.isEmpty()) {
            int maxOfficersVisible = 8;
            int maxScrollOffset = Math.max(0, this.officerData.size() - maxOfficersVisible);
            if (delta > 0.0) {
                this.scrollOffset = Math.max(0, this.scrollOffset - 1);
            } else if (delta < 0.0) {
                this.scrollOffset = Math.min(maxScrollOffset, this.scrollOffset + 1);
            }
            return true;
        }
        if (this.showingVassals) {
            if (this.vassalData.size() > 5) {
                this.vassalScrollOffset = Mth.m_14045_((int)(this.vassalScrollOffset - (int)delta), (int)0, (int)(this.vassalData.size() - 5));
                return true;
            }
        } else if (this.colonies.size() > 5) {
            this.scrollOffset = Mth.m_14045_((int)(this.scrollOffset - (int)delta), (int)0, (int)(this.colonies.size() - 5));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        block12: {
            int guiTop;
            int guiLeft;
            block14: {
                block13: {
                    if (button != 0) break block12;
                    guiLeft = (this.f_96543_ - 360) / 2;
                    guiTop = (this.f_96544_ - 280) / 2;
                    if (!this.showingVassals) break block13;
                    List playerVassalColonies = this.colonies.stream().filter(ColonyTaxData::isVassal).collect(Collectors.toList());
                    int startY = guiTop + 50 + 15;
                    if (!this.vassalData.isEmpty()) {
                        startY += this.vassalData.size() * 30 + 20;
                    }
                    startY += 35;
                    for (int i = 0; i < playerVassalColonies.size() && i < 3; ++i) {
                        boolean isSelected;
                        ColonyTaxData vassalColony = (ColonyTaxData)playerVassalColonies.get(i);
                        int entryY = startY + i * 25;
                        int contentMargin = 50;
                        int contentX = guiLeft + contentMargin;
                        int contentWidth = 360 - contentMargin * 2;
                        if (!(mouseX >= (double)contentX) || !(mouseX < (double)(contentX + contentWidth)) || !(mouseY >= (double)entryY) || !(mouseY < (double)(entryY + 23))) continue;
                        boolean bl = isSelected = this.selectedColony != null && this.selectedColony.getColonyId() == vassalColony.getColonyId();
                        if (isSelected && vassalColony.isClaimButtonClicked(mouseX, mouseY)) {
                            NetworkHandler.sendToServer(new EndVassalizationPacket(vassalColony.getColonyId()));
                            this.selectedColony = null;
                            this.updateButtonVisibility();
                            this.requestColonyData();
                            return true;
                        }
                        this.selectedColony = isSelected ? null : vassalColony;
                        this.updateButtonVisibility();
                        return true;
                    }
                    break block12;
                }
                if (!this.showingPermissions) break block14;
                if (this.selectedColony == null || !this.selectedColony.isOwner()) break block12;
                if (this.permissionToggleButton != null && mouseX >= (double)this.permissionToggleButton.x && mouseX < (double)(this.permissionToggleButton.x + this.permissionToggleButton.width) && mouseY >= (double)this.permissionToggleButton.y && mouseY < (double)(this.permissionToggleButton.y + this.permissionToggleButton.height)) {
                    boolean newPermission = TaxPermissionManager.toggleOfficerClaimPermission(this.selectedColony.getColonyId());
                    NetworkHandler.sendToServer(new UpdateTaxPermissionPacket(this.selectedColony.getColonyId(), newPermission));
                    return true;
                }
                if (this.officerToggleButtons != null) {
                    for (Map.Entry<Integer, Rectangle> entry : this.officerToggleButtons.entrySet()) {
                        int displayIndex;
                        int actualOfficerIndex;
                        Rectangle toggleButton = entry.getValue();
                        if (!(mouseX >= (double)toggleButton.x) || !(mouseX < (double)(toggleButton.x + toggleButton.width)) || !(mouseY >= (double)toggleButton.y) || !(mouseY < (double)(toggleButton.y + toggleButton.height)) || (actualOfficerIndex = (displayIndex = entry.getKey().intValue()) + this.scrollOffset) >= this.officerData.size()) continue;
                        OfficerData officer = this.officerData.get(actualOfficerIndex);
                        boolean newPermission = TaxPermissionManager.togglePlayerClaimPermission(this.selectedColony.getColonyId(), officer.getPlayerId(), true);
                        NetworkHandler.sendToServer(new UpdatePlayerTaxPermissionPacket(this.selectedColony.getColonyId(), officer.getPlayerId(), newPermission));
                        return true;
                    }
                }
                break block12;
            }
            int startY = guiTop + 50;
            int entryHeight = 35;
            for (int i = 0; i < Math.min(5, this.colonies.size() - this.scrollOffset); ++i) {
                ColonyTaxData colony = this.colonies.get(i + this.scrollOffset);
                int entryY = startY + i * entryHeight;
                if (colony.isClaimButtonClicked(mouseX, mouseY)) {
                    if (!colony.hasDebt() && colony.getTaxBalance() > 0 && colony.canClaimTax()) {
                        NetworkHandler.CHANNEL.sendToServer((Object)new ClaimTaxPacket(colony.getColonyId(), -1));
                    }
                    this.requestColonyData();
                    return true;
                }
                int contentMargin = 50;
                int contentX = guiLeft + contentMargin;
                int contentWidth = 360 - contentMargin * 2;
                if (!(mouseX >= (double)contentX) || !(mouseX < (double)(contentX + contentWidth)) || !(mouseY >= (double)entryY) || !(mouseY < (double)(entryY + entryHeight - 2))) continue;
                if (this.selectedColony != null && this.selectedColony.getColonyId() == colony.getColonyId()) {
                    this.selectedColony = null;
                    this.officerData.clear();
                } else {
                    this.selectedColony = colony;
                    if (this.showingPermissions) {
                        NetworkHandler.sendToServer(new RequestOfficerDataPacket(this.selectedColony.getColonyId()));
                    }
                }
                this.updateButtonVisibility();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void updateColonyData(List<ColonyTaxData> newData) {
        this.colonies.clear();
        this.colonies.addAll(newData);
        this.colonies.sort((a, b) -> {
            if (a.isOwner() && !b.isOwner()) {
                return -1;
            }
            if (!a.isOwner() && b.isOwner()) {
                return 1;
            }
            return a.getColonyName().compareToIgnoreCase(b.getColonyName());
        });
        this.scrollOffset = 0;
        this.selectedColony = null;
        this.updateButtonVisibility();
    }

    public void updateVassalData(List<VassalIncomeData> newVassalData) {
        this.vassalData.clear();
        this.vassalData.addAll(newVassalData);
        this.vassalScrollOffset = 0;
    }

    public void updateOfficerData(List<OfficerData> newOfficerData, int colonyId) {
        this.officerData.clear();
        this.officerData.addAll(newOfficerData);
    }

    private void updateButtonVisibility() {
        if (this.claimSelectedButton != null && this.payDebtButton != null && this.endVassalButton != null) {
            boolean hasSelection = this.selectedColony != null;
            boolean isColonyView = !this.showingVassals && !this.showingPermissions;
            this.claimSelectedButton.f_93624_ = isColonyView && hasSelection && this.selectedColony.canClaimTax() && !this.selectedColony.isVassal();
            this.payDebtButton.f_93624_ = isColonyView && hasSelection && this.selectedColony.getDebtAmount() > 0;
            boolean bl = this.endVassalButton.f_93624_ = isColonyView && hasSelection && this.selectedColony.isVassal();
            if (!isColonyView) {
                this.claimSelectedButton.f_93624_ = false;
                this.payDebtButton.f_93624_ = false;
                this.endVassalButton.f_93624_ = false;
            }
        }
    }

    private void renderPermissionsManagement(GuiGraphics guiGraphics, int guiLeft, int guiTop, int mouseX, int mouseY) {
        if (this.selectedColony == null) {
            guiGraphics.m_280137_(this.f_96547_, "No colony selected.", guiLeft + 180, guiTop + 60, 16007990);
            return;
        }
        int contentMargin = 50;
        int contentX = guiLeft + contentMargin;
        int contentWidth = 360 - contentMargin * 2;
        int currentY = guiTop + 50;
        String colonyName = this.selectedColony.getColonyName();
        String colonyInfo = String.format("%s (ID: %d)", colonyName, this.selectedColony.getColonyId());
        int maxColonyWidth = contentWidth - 10;
        if (this.f_96547_.m_92895_(colonyInfo) > maxColonyWidth) {
            String shortName = colonyName;
            while (this.f_96547_.m_92895_(String.format("%s... (ID: %d)", shortName, this.selectedColony.getColonyId())) > maxColonyWidth && shortName.length() > 3) {
                shortName = shortName.substring(0, shortName.length() - 1);
            }
            colonyInfo = String.format("%s... (ID: %d)", shortName, this.selectedColony.getColonyId());
        }
        guiGraphics.m_280488_(this.f_96547_, colonyInfo, contentX, currentY, 0xFFFFFF);
        boolean isOwner = this.selectedColony.isOwner();
        boolean officersCanClaim = TaxPermissionManager.canOfficersClaim(this.selectedColony.getColonyId());
        String permText = "Default: " + (officersCanClaim ? "ALLOW" : "BLOCK");
        int permColor = officersCanClaim ? 5025616 : 16007990;
        guiGraphics.m_280488_(this.f_96547_, permText, contentX, currentY += 18, permColor);
        if (isOwner) {
            int buttonX = contentX + contentWidth - 45;
            int buttonY = currentY - 2;
            int buttonWidth = 35;
            int buttonHeight = 12;
            this.permissionToggleButton = new Rectangle(buttonX, buttonY, buttonWidth, buttonHeight);
            int buttonColor = officersCanClaim ? -16751104 : -10092544;
            guiGraphics.m_280509_(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, buttonColor);
            guiGraphics.m_280137_(this.f_96547_, "EDIT", buttonX + buttonWidth / 2, buttonY + 2, 0xFFFFFF);
        } else {
            String ownerOnlyText = "(Owner only)";
            int textX = contentX + contentWidth - this.f_96547_.m_92895_(ownerOnlyText);
            guiGraphics.m_280488_(this.f_96547_, ownerOnlyText, textX, currentY, 0x9E9E9E);
        }
        currentY += 18;
        if (isOwner) {
            guiGraphics.m_280488_(this.f_96547_, "Individual settings override default", contentX, currentY, 0x9E9E9E);
            currentY += 15;
        }
        guiGraphics.m_280488_(this.f_96547_, "Officers:", contentX, currentY, 0xE0E0E0);
        currentY += 15;
        if (this.officerData.isEmpty()) {
            String message = this.selectedColony != null ? "Loading officers..." : "No officers found";
            guiGraphics.m_280488_(this.f_96547_, message, contentX, currentY, 0x9E9E9E);
        } else {
            this.renderOfficersList(guiGraphics, contentX, currentY, mouseX, mouseY, isOwner, contentWidth);
        }
    }

    private void renderOfficersList(GuiGraphics guiGraphics, int contentX, int startY, int mouseX, int mouseY, boolean isOwner, int contentWidth) {
        int maxOfficersVisible = 8;
        int officerHeight = 16;
        int totalOfficers = this.officerData.size();
        if (this.officerToggleButtons != null) {
            this.officerToggleButtons.clear();
        }
        int startIndex = Math.max(0, this.scrollOffset);
        int endIndex = Math.min(totalOfficers, startIndex + maxOfficersVisible);
        for (int i = startIndex; i < endIndex; ++i) {
            OfficerData officer = this.officerData.get(i);
            int displayIndex = i - startIndex;
            int officerY = startY + displayIndex * (officerHeight + 2);
            this.renderOfficerEntry(guiGraphics, contentX, officerY, mouseX, mouseY, officer, i, isOwner, contentWidth);
        }
        if (totalOfficers > maxOfficersVisible) {
            this.drawScrollIndicators(guiGraphics, contentX, startY, maxOfficersVisible * (officerHeight + 2), totalOfficers, maxOfficersVisible, contentWidth);
        }
    }

    private void renderOfficerEntry(GuiGraphics guiGraphics, int contentX, int officerY, int mouseX, int mouseY, OfficerData officer, int officerIndex, boolean isOwner, int contentWidth) {
        boolean entryHovered;
        int entryHeight = 16;
        boolean bl = entryHovered = mouseX >= contentX && mouseX < contentX + contentWidth && mouseY >= officerY - 1 && mouseY < officerY + entryHeight - 1;
        if (entryHovered) {
            guiGraphics.m_280509_(contentX, officerY - 1, contentX + contentWidth, officerY + entryHeight - 1, 0x22333333);
        }
        String officerText = officer.getPlayerName() + " [" + officer.getRank() + "]";
        int maxTextWidth = contentWidth - 50;
        if (this.f_96547_.m_92895_(officerText) > maxTextWidth) {
            String playerName = officer.getPlayerName();
            String rank = officer.getRank();
            while (this.f_96547_.m_92895_(playerName + " [" + rank + "]") > maxTextWidth && playerName.length() > 3) {
                playerName = playerName.substring(0, playerName.length() - 1);
            }
            officerText = playerName + "... [" + rank + "]";
        }
        guiGraphics.m_280488_(this.f_96547_, officerText, contentX + 5, officerY, officer.getRankColor());
        if (officer.getRank().equals("Owner")) {
            String ownerText = "OWNER";
            int ownerTextX = contentX + contentWidth - this.f_96547_.m_92895_(ownerText) - 5;
            guiGraphics.m_280488_(this.f_96547_, ownerText, ownerTextX, officerY, 5025616);
        } else if (isOwner) {
            boolean canClaim = TaxPermissionManager.canPlayerClaimTax(this.selectedColony.getColonyId(), officer.getPlayerId(), false, true);
            int toggleX = contentX + contentWidth - 40;
            int toggleY = officerY - 1;
            int toggleWidth = 35;
            int toggleHeight = 12;
            if (this.officerToggleButtons == null) {
                this.officerToggleButtons = new HashMap<Integer, Rectangle>();
            }
            int displayIndex = officerIndex - this.scrollOffset;
            this.officerToggleButtons.put(displayIndex, new Rectangle(toggleX, toggleY, toggleWidth, toggleHeight));
            int toggleColor = canClaim ? -16751104 : -10092544;
            guiGraphics.m_280509_(toggleX, toggleY, toggleX + toggleWidth, toggleY + toggleHeight, toggleColor);
            String toggleText = canClaim ? "ON" : "OFF";
            guiGraphics.m_280137_(this.f_96547_, toggleText, toggleX + toggleWidth / 2, toggleY + 2, 0xFFFFFF);
        } else {
            boolean canClaim = TaxPermissionManager.canPlayerClaimTax(this.selectedColony.getColonyId(), officer.getPlayerId(), false, true);
            String permissionText = canClaim ? "ON" : "OFF";
            int statusColor = canClaim ? 5025616 : 16007990;
            int permTextX = contentX + contentWidth - this.f_96547_.m_92895_(permissionText) - 5;
            guiGraphics.m_280488_(this.f_96547_, permissionText, permTextX, officerY, statusColor);
        }
    }

    private void drawScrollIndicators(GuiGraphics guiGraphics, int contentX, int startY, int listHeight, int totalItems, int visibleItems, int contentWidth) {
        if (totalItems <= visibleItems) {
            return;
        }
        int scrollBarX = contentX + contentWidth - 8;
        int scrollBarY = startY;
        int scrollBarHeight = listHeight;
        guiGraphics.m_280509_(scrollBarX, scrollBarY, scrollBarX + 6, scrollBarY + scrollBarHeight, 0x44333333);
        float scrollPercentage = (float)this.scrollOffset / (float)Math.max(1, totalItems - visibleItems);
        int thumbHeight = Math.max(10, scrollBarHeight * visibleItems / totalItems);
        int thumbY = scrollBarY + (int)((float)(scrollBarHeight - thumbHeight) * scrollPercentage);
        guiGraphics.m_280509_(scrollBarX + 1, thumbY, scrollBarX + 5, thumbY + thumbHeight, -2002081110);
        if (this.scrollOffset > 0) {
            guiGraphics.m_280488_(this.f_96547_, "\u2191", scrollBarX, startY - 12, 0xFFFFFF);
        }
        if (this.scrollOffset < totalItems - visibleItems) {
            guiGraphics.m_280488_(this.f_96547_, "\u2193", scrollBarX, startY + listHeight + 2, 0xFFFFFF);
        }
    }
}

