/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.gui.data;

public class ColonyTaxData {
    private final int colonyId;
    private final String colonyName;
    private final int taxBalance;
    private final int maxTaxRevenue;
    private final int buildingCount;
    private final int guardCount;
    private final int guardTowerCount;
    private final boolean canClaimTax;
    private final boolean isAtWar;
    private final boolean isBeingRaided;
    private final boolean isVassal;
    private final int vassalTributeRate;
    private final boolean hasVassals;
    private final int vassalCount;
    private final long lastTaxGeneration;
    private final int debtAmount;
    private final int approximateRevenuePerInterval;
    private final boolean isOwner;
    private int claimButtonX;
    private int claimButtonY;
    private int claimButtonWidth;
    private int claimButtonHeight;
    private int permissionButtonX;
    private int permissionButtonY;
    private int permissionButtonWidth;
    private int permissionButtonHeight;

    public ColonyTaxData(int colonyId, String colonyName, int taxBalance, int maxTaxRevenue, int buildingCount, int guardCount, int guardTowerCount, boolean canClaimTax, boolean isAtWar, boolean isBeingRaided, boolean isVassal, int vassalTributeRate, boolean hasVassals, int vassalCount, long lastTaxGeneration, int debtAmount, int approximateRevenuePerInterval, boolean isOwner) {
        this.colonyId = colonyId;
        this.colonyName = colonyName;
        this.taxBalance = taxBalance;
        this.maxTaxRevenue = maxTaxRevenue;
        this.buildingCount = buildingCount;
        this.guardCount = guardCount;
        this.guardTowerCount = guardTowerCount;
        this.canClaimTax = canClaimTax;
        this.isAtWar = isAtWar;
        this.isBeingRaided = isBeingRaided;
        this.isVassal = isVassal;
        this.vassalTributeRate = vassalTributeRate;
        this.hasVassals = hasVassals;
        this.vassalCount = vassalCount;
        this.lastTaxGeneration = lastTaxGeneration;
        this.debtAmount = debtAmount;
        this.approximateRevenuePerInterval = approximateRevenuePerInterval;
        this.isOwner = isOwner;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    public String getColonyName() {
        return this.colonyName;
    }

    public int getTaxBalance() {
        return this.taxBalance;
    }

    public int getMaxTaxRevenue() {
        return this.maxTaxRevenue;
    }

    public int getBuildingCount() {
        return this.buildingCount;
    }

    public int getGuardCount() {
        return this.guardCount;
    }

    public int getGuardTowerCount() {
        return this.guardTowerCount;
    }

    public boolean canClaimTax() {
        return this.canClaimTax;
    }

    public boolean isAtWar() {
        return this.isAtWar;
    }

    public boolean isBeingRaided() {
        return this.isBeingRaided;
    }

    public boolean isVassal() {
        return this.isVassal;
    }

    public int getVassalTributeRate() {
        return this.vassalTributeRate;
    }

    public boolean hasVassals() {
        return this.hasVassals;
    }

    public int getVassalCount() {
        return this.vassalCount;
    }

    public long getLastTaxGeneration() {
        return this.lastTaxGeneration;
    }

    public void setClaimButtonBounds(int x, int y, int width, int height) {
        this.claimButtonX = x;
        this.claimButtonY = y;
        this.claimButtonWidth = width;
        this.claimButtonHeight = height;
    }

    public boolean isClaimButtonClicked(double mouseX, double mouseY) {
        return mouseX >= (double)this.claimButtonX && mouseX < (double)(this.claimButtonX + this.claimButtonWidth) && mouseY >= (double)this.claimButtonY && mouseY < (double)(this.claimButtonY + this.claimButtonHeight);
    }

    public void setPermissionButtonBounds(int x, int y, int width, int height) {
        this.permissionButtonX = x;
        this.permissionButtonY = y;
        this.permissionButtonWidth = width;
        this.permissionButtonHeight = height;
    }

    public boolean isPermissionButtonClicked(double mouseX, double mouseY) {
        return mouseX >= (double)this.permissionButtonX && mouseX < (double)(this.permissionButtonX + this.permissionButtonWidth) && mouseY >= (double)this.permissionButtonY && mouseY < (double)(this.permissionButtonY + this.permissionButtonHeight);
    }

    public double getTaxFillPercentage() {
        if (this.maxTaxRevenue <= 0) {
            return 0.0;
        }
        return Math.max(0.0, Math.min(1.0, (double)this.taxBalance / (double)this.maxTaxRevenue));
    }

    public long getMinutesSinceLastGeneration() {
        return (System.currentTimeMillis() - this.lastTaxGeneration) / 60000L;
    }

    public boolean hasGuardTowerBoost(int requiredTowers) {
        return this.guardTowerCount >= requiredTowers;
    }

    public int getDebtAmount() {
        return this.debtAmount;
    }

    public int getApproximateRevenuePerInterval() {
        return this.approximateRevenuePerInterval;
    }

    public boolean isOwner() {
        return this.isOwner;
    }

    public boolean hasDebt() {
        return this.taxBalance < 0;
    }
}

