/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.gui.data;

import java.util.UUID;

public class OfficerData {
    private final UUID playerId;
    private final String playerName;
    private final String rank;
    private final boolean canClaimTax;
    private final boolean isOnline;
    private final long lastSeen;

    public OfficerData(UUID playerId, String playerName, String rank, boolean canClaimTax, boolean isOnline, long lastSeen) {
        this.playerId = playerId;
        this.playerName = playerName;
        this.rank = rank;
        this.canClaimTax = canClaimTax;
        this.isOnline = isOnline;
        this.lastSeen = lastSeen;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getRank() {
        return this.rank;
    }

    public boolean canClaimTax() {
        return this.canClaimTax;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public String getLastSeenText() {
        if (this.isOnline) {
            return "Online";
        }
        long diff = System.currentTimeMillis() - this.lastSeen;
        long minutes = diff / 60000L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "d ago";
        }
        if (hours > 0L) {
            return hours + "h ago";
        }
        if (minutes > 0L) {
            return minutes + "m ago";
        }
        return "Just now";
    }

    public int getStatusColor() {
        if (this.isOnline) {
            return this.canClaimTax ? 65280 : 0xFFFF00;
        }
        return 0x808080;
    }

    public int getRankColor() {
        switch (this.rank.toLowerCase()) {
            case "owner": {
                return 16766720;
            }
            case "officer": {
                return 49151;
            }
            case "friend": {
                return 3329330;
            }
            case "neutral": {
                return 0xC0C0C0;
            }
        }
        return 0xFFFFFF;
    }
}

