/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.gui.data;

public class VassalIncomeData {
    private final int vassalColonyId;
    private final String vassalColonyName;
    private final int tributeRate;
    private final int tributeOwed;
    private final int lastTribute;
    private final long lastPayment;
    private final boolean canClaim;
    private int claimButtonX;
    private int claimButtonY;
    private int claimButtonWidth;
    private int claimButtonHeight;

    public VassalIncomeData(int vassalColonyId, String vassalColonyName, int tributeRate, int tributeOwed, int lastTribute, long lastPayment, boolean canClaim) {
        this.vassalColonyId = vassalColonyId;
        this.vassalColonyName = vassalColonyName;
        this.tributeRate = tributeRate;
        this.tributeOwed = tributeOwed;
        this.lastTribute = lastTribute;
        this.lastPayment = lastPayment;
        this.canClaim = canClaim;
    }

    public int getVassalColonyId() {
        return this.vassalColonyId;
    }

    public String getVassalColonyName() {
        return this.vassalColonyName;
    }

    public int getTributeRate() {
        return this.tributeRate;
    }

    public int getTributeOwed() {
        return this.tributeOwed;
    }

    public int getLastTribute() {
        return this.lastTribute;
    }

    public long getLastPayment() {
        return this.lastPayment;
    }

    public boolean canClaim() {
        return this.canClaim;
    }

    public void setClaimButtonBounds(int x, int y, int width, int height) {
        this.claimButtonX = x;
        this.claimButtonY = y;
        this.claimButtonWidth = width;
        this.claimButtonHeight = height;
    }

    public boolean isClaimButtonClicked(double mouseX, double mouseY) {
        return mouseX >= (double)this.claimButtonX && mouseX < (double)(this.claimButtonX + this.claimButtonWidth) && mouseY >= (double)this.claimButtonY && mouseY < (double)(this.claimButtonY + this.claimButtonHeight);
    }

    public String getFormattedLastPayment() {
        if (this.lastPayment == 0L) {
            return "Never";
        }
        long minutes = (System.currentTimeMillis() - this.lastPayment) / 60000L;
        if (minutes < 60L) {
            return minutes + "m ago";
        }
        if (minutes < 1440L) {
            return minutes / 60L + "h ago";
        }
        return minutes / 1440L + "d ago";
    }
}

